//using library from https://github.com/acrandal/RevEng_PAJ7620 to read gestures
//search for RevEng_PAJ7620 in Library manager; tested with v1.5.0
#include "RevEng_PAJ7620.h"
RevEng_PAJ7620 sensor = RevEng_PAJ7620();

#define USB_PIN A0
#define LED_PIN 13

void setup() {
  Serial.begin(115200);
  pinMode(USB_PIN,OUTPUT);
  digitalWrite(USB_PIN,LOW);
  pinMode(LED_PIN,OUTPUT);
  digitalWrite(LED_PIN,HIGH);
  while((millis()<2000)&&(!Serial)){} //wait 2s or for serial port
  Serial.println("Starting sensor");
  if(!sensor.begin()){  //returns 0 on success
    Serial.println("PAJ7620 I2C error - halting");
    while(true){  //blink onboard LED if error
      digitalWrite(LED_PIN,HIGH);
      delay(100);
      digitalWrite(LED_PIN,LOW);
      delay(100);
    }
  }
  digitalWrite(LED_PIN,LOW);
  Serial.println("Sensor started OK");
}

/*these are the gestures:
  GES_NONE
  GES_UP,GES_DOWN,GES_LEFT,GES_RIGHT,
  GES_FORWARD,GES_BACKWARD,
  GES_CLOCKWISE,GES_ANTICLOCKWISE,GES_WAVE  */

void loop() {
  Gesture gesture;
  gesture = sensor.readGesture();
  if(gesture==GES_UP){
    digitalWrite(LED_PIN,HIGH);
    digitalWrite(USB_PIN,HIGH);
    Serial.println("ON command received");
    delay(100); 
  }
  if(gesture==GES_DOWN){
    digitalWrite(LED_PIN,LOW);
    digitalWrite(USB_PIN,LOW);
    Serial.println("OFF command received");
    delay(100); 
  }
}
