' *****************************************************************************
' * Project       : Dot Matrix Scrolling Sign with Selectable Messages

' * Date          : 10/08/2019

' * Target Device : ATMEGA8A , Frequency: 8MHz
' * Program code  : BASCOM-AVR IDE [2.0.7.5]
' * Flash used    :3648 Bytes
' * Author        : Mahmood Alimohammadi

' * Description   : Displays messages that scroll from right to left.
                   'The messages and scrolling speed are selectable.
' *****************************************************************************

$regfile = "m8adef.dat"
$crystal = 8000000

Dim Character As Word
Dim Pointer As Word
Dim Messagechar As Byte
Dim Length As Word
Dim Count As Byte

Dim X As Word
Dim Onecharacter As String * 1
Dim Matrix(638) As Byte
Dim Message As String * 70
Dim Messagelength As Byte

Dim Columnlength As Word
Dim Scrollspeed As Byte
Dim Speed As Byte
Dim Selector As Byte
Dim Scrollset As Byte

Dim Eepselector As Eram Byte
Dim Eepscrollspeed As Eram Byte

Dim Fahrenheit As Word
Dim Celsius As Word
Dim Tempcelsius As String * 3
Dim Tempfahrenheit As String * 3


Config Adc = Single , Prescaler = Auto

Config Portb.0 = Output : Shiftleft Alias Portb.0
Config Portb.1 = Output : Clockpulse Alias Portb.1

Config Portb.2 = Input : Portb.2 = 1 : Selectkey Alias Pinb.2
Config Portb.3 = Input : Portb.3 = 1 : Speedkey Alias Pinb.3

Config Portd = Output : Columns Alias Portd

Config Clock = Soft
Config Date = Dmy , Separator = /

Enable Interrupts

Time$ = "23:58:00"

Date$ = "29-08-19"

Start Adc

Tempcelsius = Str(0)
Tempfahrenheit = Str(0)

'*************************************************************

Gosub Check_matrix

Main:
Do
   Gosub Selectmessage
   Gosub Getcharacter
   Gosub Setscroll
   Gosub Scroll
   Gosub Temperature

Loop

End
'*************************************************************

Check_matrix:

Do
   'Feed data serially into shift register.
   Set Shiftleft

   'Shift register clock pulse
   Set Clockpulse

   Reset Shiftleft
   Reset Clockpulse

   Columns = 255
   Waitms 50

   Incr Count
Loop Until Count = 16
Count = 0

Return

'*************************************************************

Selectmessage:

If Selectkey = 0 Then

   Selector = Selector + 1

   If Selector > 10 Then Selector = 1

   'Store in EEPROM.
   Eepselector = Selector

   Waitms 50

   'Stop the program.
   Stop

End If

'Read from EEPROM.
Selector = Eepselector

If Eepselector > 10 Then Selector = 1

'Select one of the messages stored in the string "Message".
Select Case Selector


   Case 1 : Message = " " + Time$ + " " + Date$ + " " + Tempcelsius + Chr(31) + "C" + " " + Tempfahrenheit + Chr(31) + "F"

   Case 2 : Message = " Hello World"

   Case 3 : Message = " Dot Matrix Scrolling Sign with Selectable Messages"

   Case 4 : Message = " Good Luck"

   Case 5 : Message = " Happy New Year"

   Case 6 : Message = " Welcome to BASCOM AVR Projects"

   Case 7 : Message = " Happy Birthday"

   Case 8 : Message = " Press the Scrolling Speed Button to change the speed."

   Case 9 : Message = " The 'Message String' should not be more than 70 characters long."

   Case 10 : Message = " You should type your favorite text messages within quotation marks."

   Case 11 : Selector = 1

End Select

Return

'*************************************************************

Getcharacter:

Pointer = 1

Do
   Incr Messagechar

   'Get a character
   Onecharacter = Mid(message , Messagechar , 1)

   'Get ASCII value for each character
   Character = Asc(onecharacter)

   'Do not use the first 31 ASCII codes
   Character = Character - 31

   Character = Character * 8

   'For 8 bytes of the character get the font data.
   For Count = 1 To 8

      Matrix(pointer) = Lookup(character , Table)
      Incr Character
      Incr Pointer
   Next Count

   Incr Pointer

   Messagelength = Len(message)

   If Messagechar = Messagelength Then

      Messagechar = 0

      Exit Do

   End If

Loop

Return

'*************************************************************

'Sub Set Scroll
Setscroll:

If Speedkey = 0 Then
   Speed = Speed + 1

   If Speed > 3 Then Speed = 1

   'Store into EEPROM
   Eepscrollspeed = Scrollspeed
End If

'Read from EEPROM.
Scrollspeed = Eepscrollspeed

'Initially store 10 into Scrollspeed.
If Eepscrollspeed > 10 Then Scrollspeed = 10

Select Case Speed

Case 1
Scrollspeed = 3 : Eepscrollspeed = Scrollspeed

Case 2
Scrollspeed = 5 : Eepscrollspeed = Scrollspeed

Case 3
Scrollspeed = 10 : Eepscrollspeed = Scrollspeed

Case 4 : Speed = 1
End Select

Return

'*************************************************************

Scroll:

Do
   Pointer = 1

   For Count = 1 To Scrollspeed

      'Feed data serially into shift register
      Set Shiftleft

      'Shift register clock pulse
      Set Clockpulse

      Reset Shiftleft
      Reset Clockpulse

      Character = Pointer + Length

      'Put data into columns.
      Columns = Matrix(character)
      Waitms 1
      Incr Pointer

      Do
         'Shift register clock pulse
         Set Clockpulse
         Reset Clockpulse

         Character = Pointer + Length

         'Put data into Columns.
         Columns = Matrix(character)
         Waitms 1

         Incr Pointer

         Incr X

         If X > 15 Then
            X = 0
            Exit Do
         End If
      Loop
      Pointer = 1

   Next Count

  Incr Length
  Columnlength = Messagelength * 9

  Loop Until Length = Columnlength
  Length = 0
Return

'*************************************************************

Temperature:

'Temperature input data at ADCO(PIN 23)
Celsius = Getadc(0)
Celsius = Celsius / 2

Tempcelsius = Str(celsius)

Fahrenheit = Celsius * 18
Fahrenheit = Fahrenheit / 10
Fahrenheit = Fahrenheit + 32

Tempfahrenheit = Str(fahrenheit)
Return
'*************************************************************

Table:

Data 0 , 0 , 0 , 6 , 9 , 9 , 6 , 0                          'o
Data 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0                          'space
Data 0 , 0 , 0 , 191 , 0 , 0 , 0 , 0                        '!
Data 0 , 7 , 0 , 7 , 0 , 0 , 0 , 0                          '''
Data 0 , 36 , 255 , 36 , 36 , 255 , 36 , 0                  '#

Data 68 , 74 , 74 , 255 , 74 , 74 , 50 , 0                  '$
Data 131 , 67 , 32 , 16 , 8 , 196 , 194 , 0                 '%
Data 54 , 73 , 86 , 32 , 80 , 0 , 0 , 0                     '&
Data 0 , 0 , 11 , 7 , 0 , 0 , 0 , 0                         ''
Data 0 , 0 , 60 , 66 , 129 , 0 , 0 , 0                      ' (

Data 0 , 0 , 0 , 129 , 66 , 60 , 0 , 0                      ')
Data 42 , 28 , 127 , 28 , 42 , 0 , 0 , 0                    '*
Data 16 , 16 , 16 , 254 , 16 , 16 , 16 , 0                  '+
Data 0 , 88 , 56 , 0 , 0 , 0 , 0 , 0                        ',
Data 16 , 16 , 16 , 16 , 16 , 16 , 16 , 0                   '-

Data 0 , 96 , 96 , 0 , 0 , 0 , 0 , 0                        '.
Data 128 , 64 , 32 , 16 , 8 , 4 , 2 , 0                     '/
Data 126 , 193 , 161 , 145 , 137 , 133 , 126 , 0            '0
Data 0 , 0 , 130 , 255 , 128 , 0 , 0 , 0                    '1
Data 226 , 145 , 145 , 145 , 145 , 145 , 142 , 0            '2

Data 65 , 129 , 129 , 137 , 141 , 139 , 113 , 0             '3
Data 48 , 40 , 36 , 34 , 33 , 255 , 32 , 0                  '4
Data 79 , 137 , 137 , 137 , 137 , 137 , 113 , 0             '5
Data 126 , 137 , 137 , 137 , 137 , 137 , 113 , 0            '6
Data 1 , 1 , 241 , 9 , 5 , 5 , 3 , 0                        '7

Data 118 , 137 , 137 , 137 , 137 , 137 , 118 , 0            '8
Data 142 , 145 , 145 , 145 , 145 , 145 , 126 , 0            '9
Data 0 , 54 , 54 , 0 , 0 , 0 , 0 , 0                        ':
Data 0 , 91 , 59 , 0 , 0 , 0 , 0 , 0                        ';
Data 8 , 20 , 34 , 65 , 0 , 0 , 0 , 0                       '<

Data 40 , 40 , 40 , 40 , 40 , 40 , 40 , , 0                 '=
Data 65 , 34 , 20 , 8 , 0 , 0 , 0 , 0                       '>
Data 0 , 2 , 1 , 1 , 177 , 9 , 6 , 0                        '?
Data 50 , 73 , 121 , 65 , 62 , 0 , 0 , 0                    '@
Data 254 , 33 , 33 , 33 , 33 , 33 , 254 , 0                 'A

Data 255 , 145 , 145 , 145 , 145 , 145 , 110 , 0            'B
Data 126 , 129 , 129 , 129 , 129 , 129 , 66 , 0             'C
Data 255 , 129 , 129 , 129 , 129 , 66 , 60 , 0              'D
Data 255 , 145 , 145 , 145 , 145 , 129 , 129 , 0            'E
Data 255 , 9 , 9 , 9 , 9 , 1 , 1 , 0                        'F

Data 126 , 129 , 129 , 137 , 137 , 137 , 114 , 0            'G
Data 255 , 16 , 16 , 16 , 16 , 16 , 255 , 0                 'H
Data 0 , 0 , 129 , 255 , 129 , 0 , 0 , 0                    'I
Data 64 , 128 , 129 , 127 , 1 , 0 , 0 , 0                   'J
Data 255 , 24 , 24 , 36 , 66 , 129 , 0 , 0                  'K

Data 255 , 128 , 128 , 128 , 128 , 128 , 128 , 0            'L
Data 255 , 1 , 2 , 14 , 2 , 1 , 255 , 0                     'M
Data 255 , 2 , 4 , 8 , 16 , 32 , 255 , 0                    'N
Data 126 , 129 , 129 , 129 , 129 , 129 , 126 , 0            'O
Data 255 , 17 , 17 , 17 , 17 , 17 , 14 , 0                  'P

Data 126 , 129 , 129 , 129 , 161 , 193 , 254 , 0            'Q
Data 255 , 9 , 9 , 25 , 41 , 73 , 134 , 0                   'R
Data 134 , 137 , 137 , 137 , 137 , 137 , 113 , 0            'S
Data 1 , 1 , 1 , 255 , 1 , 1 , 1 , 0                        'T
Data 127 , 128 , 128 , 128 , 128 , 128 , 127 , 0            'U

Data 31 , 32 , 64 , 128 , 64 , 32 , 31 , 0                  'V
Data 127 , 128 , 128 , 96 , 128 , 128 , 127 , 0             'W
Data 193 , 34 , 20 , 8 , 20 , 34 , 193 , 0                  'X
Data 3 , 4 , 8 , 240 , 8 , 4 , 3 , 0                        'Y
Data 193 , 161 , 145 , 137 , 133 , 131 , 129 , 0            'Z

Data 0 , 127 , 65 , 65 , 0 , 0 , 0 , 0                      '[
Data 2 , 4 , 8 , 16 , 32 , 0 , 0 , 0                        '\
Data 0 , 65 , 65 , 127 , 0 , 0 , 0 , 0                      ']
Data 4 , 2 , 1 , 2 , 4 , 0 , 0 , 0                          '^
Data 64 , 64 , 64 , 64 , 64 , 0 , 0 , 0                     '_

Data 0 , 0 , 7 , 11 , 0 , 0 , 0 , 0                         ''
Data 96 , 148 , 148 , 148 , 148 , 148 , 120 , 0             'a
Data 255 , 144 , 136 , 132 , 132 , 132 , 120 , 0            'b
Data 120 , 132 , 132 , 132 , 132 , 132 , 72 , 0             'c
Data 120 , 132 , 132 , 132 , 132 , 136 , 255 , 0            'd

Data 120 , 148 , 148 , 148 , 148 , 148 , 136 , 0            'e
Data 0 , 8 , 254 , 9 , 1 , 2 , 0 , 0                        'f
Data 24 , 164 , 164 , 164 , 164 , 164 , 124 , 0             'g
Data 255 , 16 , 8 , 4 , 4 , 8 , 240 , 0                     'h
Data 0 , 0 , 132 , 253 , 128 , 0 , 0 , 0                    'i

Data 64 , 128 , 132 , 125 , 0 , 0 , 0 , 0                   'j
Data 255 , 16 , 40 , 68 , 130 , 0 , 0 , 0                   'k
Data 0 , 0 , 129 , 255 , 128 , 0 , 0 , 0                    'l
Data 252 , 4 , 4 , 24 , 4 , 4 , 248 , 0                     'm
Data 252 , 8 , 4 , 4 , 4 , 4 , 248 , 0                      'n

Data 120 , 132 , 132 , 132 , 132 , 132 , 120 , 0            'o
Data 252 , 36 , 36 , 36 , 36 , 36 , 24 , 0                  'p
Data 24 , 36 , 36 , 36 , 36 , 24 , 254 , 0                  'q
Data 252 , 8 , 4 , 4 , 4 , 8 , 0 , 0                        'r
Data 152 , 164 , 164 , 164 , 164 , 164 , 68 , 0             's

Data 0 , 8 , 127 , 136 , 128 , 64 , 0 , 0                   't
Data 60 , 64 , 128 , 128 , 128 , 64 , 252 , 0               'u
Data 28 , 32 , 64 , 128 , 64 , 32 , 28 , 0                  'v
Data 124 , 128 , 128 , 96 , 128 , 128 , 124 , 0             'w
Data 132 , 72 , 48 , 48 , 72 , 132 , 0 , 0                  'x

Data 28 , 160 , 160 , 160 , 160 , 124 , 0 ,                 'y
Data 0 , 132 , 196 , 164 , 148 , 140 , 132 , 0              'z
Data 0 , 8 , 54 , 65 , 0 , 0 , 0 , 0                        '{
Data 0 , 0 , 119 , 0 , 0 , 0 , 0 , 0                        '|
Data 0 , 65 , 54 , 8 , 0 , 0 , 0 , 0                        '}

Data 2 , 1 , 2 , 4 , 2 , 0 , 0 , 0                          '~
Data 42 , 85 , 42 , 85 , 42 , 0 , 0 , 0                     '
'******************************************************
'End of Program