//Tim Blythman 12/6/2019
//interface for HD44780 LCD using 4 bit mode
#include "hd44780.h"

void LCD_init(void){
    //set up pins and do LCD initialisation
    LCD_EN=0;
    LCD_RW=0;           //default to writes
    LCD_RS=0;           //default to commands for init
    __delay_ms(10);        //powerup delay
    LCD_D7=0;
    LCD_D6=0;
    LCD_D5=1;
    LCD_D4=0;   //0=> 4-bit mode
    LCD_EN=1;
    LCD_EN=0;   //clock
    __delay_ms(1);
    LCD_RS=1;           //default to data
    LCD_cmd(0b00000001);         //clear
    LCD_cmd(0b00000110);         //increment on write, no shift
    LCD_cmd(0b00001100);         //display on, cursor off
    LCD_cmd(0b00101000);         //4 bit mode, 2-line font
}

void LCD_data(unsigned char d){
    LCD_D7=(d&128)?1:0;
    LCD_D6=(d&64)?1:0;
    LCD_D5=(d&32)?1:0;
    LCD_D4=(d&16)?1:0;
    LCD_EN=1;
    LCD_EN=0;   //clock
    LCD_D7=(d&8)?1:0;
    LCD_D6=(d&4)?1:0;
    LCD_D5=(d&2)?1:0;
    LCD_D4=(d&1)?1:0;   //needs 4 bytes less than the obvious (d&1)
    LCD_EN=1;
    LCD_EN=0;   //clock    
    __delay_ms(1);      //all commands/data take max 37us except return home (0x2)    
    //__delay_us(250);      //all commands/data take max 37us except return home (0x2)    
}

void LCD_cmd(unsigned char c){
    LCD_RS=0;           //clear for command
    LCD_data(c);
    LCD_RS=1;           //default to data    
}

void LCD_print(const char *c){
    while(*c){
        LCD_data(*c++);
    }    
}