//Tim Blythman 12/6/2019
// ADC for LCD panel meter
#include "io.h"

void ioinit(void){
    //five analog channels on A4, C0, C1, C3,C2
    //LATB=0;         //power on defaults
    //LATC=0;
    ANSELA=0b00010000;
    ANSELC=0b00001111;
    TRISA=0b00010000;
    TRISB=0;
    TRISC=0b00001111;
    
    
    /*
    
    ANSELCbits.ANSC2=0; //D7 ADC disable
    ANSELBbits.ANSB4=0; //D6 ADC disable
    ANSELBbits.ANSB5=0; //D5 ADC disable
    //ANSELBbits.ANSB6=0; //D4 ADC disable
    //ANSELBbits.ANSB7=0; //EN ADC disable
    ANSELCbits.ANSC7=0; //RW ADC disable
    ANSELCbits.ANSC6=0; //RS ADC disable
    TRISCbits.TRISC2=0; //D7
    TRISBbits.TRISB4=0; //D6
    TRISBbits.TRISB5=0; //D5
    TRISBbits.TRISB6=0; //D4
    TRISBbits.TRISB7=0; //EN
    TRISCbits.TRISC7=0; //RW
    TRISCbits.TRISC6=0; //RS    

    ANSELAbits.ANSA4=1;
    ANSELCbits.ANSC0=1;
    ANSELCbits.ANSC1=1;
    ANSELCbits.ANSC3=1;
    ANSELCbits.ANSC2=1;
    TRISAbits.TRISA4=1;
    TRISCbits.TRISC0=1;
    TRISCbits.TRISC1=1;
    TRISCbits.TRISC3=1;
    TRISCbits.TRISC2=1;
    */
    FVRCONbits.ADFVR=3;     //ADC ref is 4.096V
    FVRCONbits.FVREN=1;     //FVR ON
    //ADCON1=0b11010000;      //11010000 =  Right justified, FOSC/16, VREF is VDD
    ADCON1=0b11010011;       //11010011 =  Right justified, FOSC/16, VREF is FVR
    ADCON0=0b00000001;      //ADC on, no conversion yet
}

int getADC(char channel){           //get ADC result from channel
    ADCON0=(channel<<2)|1;          //set channel, ADC on
    ADCON0bits.ADGO=1;              //start
    while(ADCON0bits.ADGO){}        //wait till done
    return ((ADRESH&3)<<8)|(ADRESL);//10 bit result
}


