#include <Wire.h>
#define ADDRESS 0x40
#define PCA9685ALL (0xFA)
#define PCA9685LEDS(x) (x*4+6)

int entry=0;
int p=0;
int params[9];

void setup() {
  Wire.begin();
  Serial.begin(115200);
  PCA9685init(ADDRESS);
  PCA9685setLeds(ADDRESS,PCA9685ALL,0,0);   //all off
  PCA9685setF(ADDRESS,200);
  params[0]=200;   //frequency, the rest are start/duration values
  showParams();
  dumpRegs();
}

void loop() {
  int d,r,i;
  if(Serial.available()){
    d=Serial.read();
    if((d>='A')&&(d<='I')){p=d-'A';}
    if((d>='a')&&(d<='i')){p=d-'a';}
    if(inputScan(d,&entry)){
      Serial.println(entry);
      params[p]=entry;
      r=(p-1)/2;
      if(p==0){
        PCA9685setF(ADDRESS,entry);
      }else{
        PCA9685setLeds(ADDRESS,PCA9685LEDS(r),params[r*2+1],params[r*2+2]);
      }
      showParams();
      dumpRegs();
    }
  }
}

void showParams(){
  Serial.print(params[0]);
  Serial.println(F("Hz             \tUse A to change"));
  Serial.print(params[1]);
  Serial.println(F(" LED1 start    \tUse B to change"));
  Serial.print(params[2]);
  Serial.println(F(" LED1 duration \tUse C to change"));
  Serial.print(params[3]);
  Serial.println(F(" LED2 start    \tUse D to change"));
  Serial.print(params[4]);
  Serial.println(F(" LED2 duration \tUse E to change"));
  Serial.print(params[5]);
  Serial.println(F(" LED3 start    \tUse F to change"));
  Serial.print(params[6]);
  Serial.println(F(" LED3 duration \tUse G to change"));
  Serial.print(params[7]);
  Serial.println(F(" LED4 start    \tUse H to change"));
  Serial.print(params[8]);
  Serial.println(F(" LED4 duration \tUse I to change"));  
}

void dumpRegs(){
  int i;
  for(i=0;i<256;i++){
    Serial.print(i,HEX);
    Serial.print(":0x");
    Serial.print(PCA9685read(ADDRESS,i),HEX);
    if((i&0xF)==0xF){Serial.println();}else{Serial.print("\t");}
  }  
}

int inputScan(int d, int *n){     //call with inputScan(data, &anInt), returns 1 when scan complete and entry is in an Int
  static int v=0;
  if((d>='0')&&(d<='9')){v=v*10+d-'0';}
  if(d==13){*n=v;v=0;return 1;}
  return 0;
}

int PCA9685setLeds(byte add, byte reg, int start, int duration){    //sets all four regs starting at reg
  int end;  
  if(duration<1){
    PCA9685write(ADDRESS,reg,0x00);     //special setting that ensures pulse is off
    PCA9685write(ADDRESS,reg+1,0x00);
    PCA9685write(ADDRESS,reg+2,0x00);
    PCA9685write(ADDRESS,reg+3,0x10);
    return 0;
  }
  if(duration>4095){
    PCA9685write(ADDRESS,reg,0x00);     //special setting that ensures pulse is on 100%
    PCA9685write(ADDRESS,reg+1,0x10);
    PCA9685write(ADDRESS,reg+2,0x00);
    PCA9685write(ADDRESS,reg+3,0x00);
    return 4096;
  }
  start=start&0xFFF;                    //crop to 12 bits
  end=start+duration;
  end=end&0xFFF;                        //crop to 12 bits
  PCA9685write(ADDRESS,reg,start&0xFF);
  PCA9685write(ADDRESS,reg+1,start>>8);
  PCA9685write(ADDRESS,reg+2,end&0xFF);
  PCA9685write(ADDRESS,reg+3,end>>8);
  return duration;
}

int PCA9685write(byte add, byte reg, byte data){
  Wire.beginTransmission(add);  
  Wire.write(reg);
  Wire.write(data);
  return Wire.endTransmission();
}

int PCA9685read(byte add, byte reg){
  Wire.beginTransmission(add);  
  Wire.write(reg);
  Wire.endTransmission(false);
  Wire.requestFrom(add,1,true);
  return Wire.read();
}

int PCA9685init(byte add){
  int r,b;
  b=PCA9685read(add,0);
  r=PCA9685write(add,0,b&(~0x10));   //clear sleep bit
  if(r!=0){return r;}
  //r=PCA9685write(add,1,0x14);   //totem pole driver, inverted
  r=PCA9685write(add,1,0x4);   //totem pole driver, not inverted
  delay(1);
  return r;
}

int PCA9685setPS(byte add, byte data){    //set prescaler value; 3-255 are valid, hardware will clamp values below 3
  int r,b;                                  //255 => 24Hz, 3   => 1526Hz
  b=PCA9685read(add,0);
  r=PCA9685write(add,0,b|0x10);      //set sleep bit
  if(r!=0){return r;}
  r=PCA9685write(add,0xFE,data);          
  if(r!=0){return r;}
  b=PCA9685read(add,0);
  r=PCA9685write(add,0,b&(~0x10));   //clear sleep bit
  return r;
}

int PCA9685setF(byte add, int freq){
  int ps;
  int magic=24414;      //25Mhz/4096 steps times four to get a little more resolution for rounding
  if(freq<24){freq=24;}
  if(freq>1526){freq=1526;}
  ps=((magic/freq)+2)/4;
  freq=((magic/ps)+2)/4;   //calculate actual effective frequency to nearest Hz
  ps=ps-1;                 //zero based
  Serial.print("PRESCALER:");
  Serial.println(ps);
  if(PCA9685setPS(add,ps)==0){
    return freq;    //actual freq
  }else{
    return -1;      //fail
  }
}

