//use for MCP23017 (32-39 depending on address pins)
//default is 32 with all address lines pulled low
#define ADDRESS 32

//register names (assuming IOCON.BANK=0, POR)
#define IODIRA (0)
#define GPPUA (12)
#define GPIOA (18)
#define OLATA (20)
#define IODIRB (1)
#define GPPUB (13)
#define GPIOB (19)
#define OLATB (21)

#include <Wire.h>

byte pin=9;

void setup() {
  Serial.begin (115200);
  Wire.begin();   //no other setup needed, all pins default to inputs at reset
  MCP23017pinMode(pin,OUTPUT);
}

void loop() {
  MCP23017digitalWrite(pin,HIGH);
  delay(1000);
  Serial.println(MCP23017digitalRead(pin));
  MCP23017digitalWrite(pin,LOW);
  delay(1000);
  Serial.println(MCP23017digitalRead(pin));
}

int MCP23017digitalRead(byte pin){
  byte mask = 1<<(pin&7);       //bit mask
  if((pin>=0)&&(pin<=7)){   //PORT A
    if(MCP23017readData(ADDRESS,GPIOA)&mask){
      return true;
    }else{
      return false;
    }
  }
  if((pin>=8)&&(pin<=15)){   //PORT B
    if(MCP23017readData(ADDRESS,GPIOB)&mask){
      return true;
    }else{
      return false;
    }
  }
  return -1;
}

void MCP23017digitalWrite(byte pin,byte data){
  static byte lata=0,latb=0;    //keep states in between writes, default to POR value
  byte mask = 1<<(pin&7);       //bit mask
  if((pin>=0)&&(pin<=7)){   //PORT A
    if(data){
      lata=lata|mask;       //set bit   
    }else{
      lata=lata&(~mask);    //clear bit
    }
    MCP23017writeData(ADDRESS,OLATA,lata);
  }
  if((pin>=8)&&(pin<=15)){   //PORT B
    if(data){
      latb=latb|mask;       //set bit   
    }else{
      latb=latb&(~mask);    //clear bit
    }
    MCP23017writeData(ADDRESS,OLATB,latb);
  }
}

void MCP23017pinMode(byte pin,byte data){
  static byte iodira=255,iodirb=255;    //keep states in between writes, default to POR value
  static byte gppua=0,gppub=0;          //keep states in between writes, default to POR value
  byte mask = 1<<(pin&7);       //bit mask
  if((pin>=0)&&(pin<=7)){   //PORT A
    switch(data){           //using inbuilt mnemonics (see https://github.com/esp8266/Arduino/blob/master/cores/esp8266/Arduino.h)
      case INPUT:          iodira=iodira|mask; gppua=gppua&(~mask);  break;    //set iodir, clear gppu
      case INPUT_PULLUP:   iodira=iodira|mask; gppua=gppua|mask;  break;       //set iodir, set gppu
      case OUTPUT:         iodira=iodira&(~mask); gppua=gppua&(~mask);  break; //clear iodir and gppu
    }
    MCP23017writeData(ADDRESS,IODIRA,iodira);
    MCP23017writeData(ADDRESS,GPPUA,gppua);
  }  
  if((pin>=8)&&(pin<=15)){  //PORT B
    switch(data){           //using inbuilt mnemonics (see https://github.com/esp8266/Arduino/blob/master/cores/esp8266/Arduino.h)
      case INPUT:          iodirb=iodirb|mask; gppub=gppub&(~mask);  break;    //set iodir, clear gppu
      case INPUT_PULLUP:   iodirb=iodirb|mask; gppub=gppub|mask;  break;       //set iodir, set gppu
      case OUTPUT:         iodirb=iodirb&(~mask); gppub=gppub&(~mask);  break; //clear iodir and gppu
    }
    MCP23017writeData(ADDRESS,IODIRB,iodirb);
    MCP23017writeData(ADDRESS,GPPUB,gppub);
  }     
}

int MCP23017writeData(byte address, byte reg, byte data){
  Wire.beginTransmission(address);  
  Wire.write(reg);
  Wire.write(data);
  return Wire.endTransmission ();//return result of transmit
}


int MCP23017readData(byte address, byte reg){
  Wire.beginTransmission(address);  
  Wire.write(reg);
  Wire.endTransmission(false);
  Wire.requestFrom(address,1,true);
  if(Wire.available()<1){return -1;}
  return Wire.read();
}

