//use for PCF8574
#define ADDRESS 32
//use for PCF8574A
//#define ADDRESS 56

#include <Wire.h>

byte outState=0;

void setup() {
  Serial.begin (115200);
  Wire.begin();
  //no init needed
  debug();
}

void loop() {
  int d;
  if(Serial.available()){
    d=Serial.read();
    if((d>='0')&&(d<='7')){
      outState=outState^(1<<(d-'0')); //toggle typed bit
      PCF8574writeData(ADDRESS,outState);
      debug();
    }
    if((d=='r')||(d=='R')){debug();}
  }
}

void debug(){
  int i;
  byte d;
  Serial.println();
  Serial.println("Use 0-7 to toggle a bit or 'R' to read");  
  Serial.print("Output state:");
  for(i=128;i>0;i=i>>1){
    if(outState&i){
      Serial.write('1');
    }else{
      Serial.write('0');      
    }
  }
  Serial.println();
  Serial.print("Input state: ");
  d=PCF8574readData(ADDRESS);
  if(d<0){Serial.println("Read fail");return;}
  for(i=128;i>0;i=i>>1){
    if(d&i){
      Serial.write('1');
    }else{
      Serial.write('0');      
    }
  }
  Serial.println();  
}

int PCF8574writeData(byte address, byte data){
  Wire.beginTransmission(address);  
  Wire.write(data);
  return Wire.endTransmission ();//return result of transmit
}


int PCF8574readData(byte address){
  Wire.requestFrom(address,1,true);
  if(Wire.available()<1){return -1;}
  return Wire.read();
}

