// I2C Scanner
// Written by Nick Gammon
// Date: 20th April 2011
// retrieved from: http://www.gammon.com.au/i2c
// edits added 28/3/2018:
// display 7bit and 8bit addresses

#include <Wire.h>

void setup() {
  Serial.begin (115200);

  // Leonardo: wait for serial port to connect
  while (!Serial) 
    {
    }

  Serial.println ();
  Serial.println ("I2C scanner. Scanning ...");

  
  Wire.begin();
  Wire.setClock(400000);
  //Wire.setClock(100000);
}  // end of setup

void loop() {
    byte count = 0;
  for (byte i = 8; i < 120; i++)
  {
    Wire.beginTransmission (i);
    if (Wire.endTransmission () == 0)
      {
      Serial.print ("Found 7 bit address: ");
      Serial.print (i, DEC);
      Serial.print (" (0x");
      Serial.print (i, HEX);
      Serial.println (")");

      Serial.print ("      8 bit write address: ");
      Serial.print (i*2, DEC);
      Serial.print (" (0x");
      Serial.print (i*2, HEX);
      Serial.println (")");

      Serial.print ("      8 bit read address: ");
      Serial.print (i*2+1, DEC);
      Serial.print (" (0x");
      Serial.print (i*2+1, HEX);
      Serial.println (")");
      count++;
      delay (1);  // maybe unneeded?
      } // end of good response
  } // end of for loop
  Serial.println ("Done.");
  Serial.print ("Found ");
  Serial.print (count, DEC);
  Serial.println (" device(s).");
  delay(5000);
  }
