#include <OneWire.h>
#include <DallasTemperature.h>
#include <Wire.h> // must be included here so that Arduino library object file references work
#define sendbutton 5
#include <RtcDS3231.h>
RtcDS3231<TwoWire> Rtc(Wire);
#define countof(a) (sizeof(a) / sizeof(a[0]))

#define ONE_WIRE_BUS 13
OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);
DeviceAddress Thermometer;

int deviceCount = 0;
float tempC,tempF;
unsigned long tempcent;
String temp[8];
char datadate[16];
char datatime[8];
char tempdata[50];  
String dataString="";
uint8_t data1[30];
uint8_t data2[50];
#define gap 19    //<20
String s1="";
String s2="";

uint8_t hh,mm,ss;  //containers for current time
String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0


DeviceAddress addsensor[]={  
{0x28, 0xFF, 0x34, 0x89, 0x88, 0x16, 0x03, 0x7A},
{0x28, 0xFF, 0x4C, 0x1A, 0x88, 0x16, 0x03, 0x40},
{0x28, 0xFF, 0x12, 0x1E, 0x91, 0x16, 0x04, 0x3E},
{0x28, 0xFF, 0xB2, 0x2A, 0x88, 0x16, 0x03, 0x0C},
{0x28, 0xFF, 0xFA, 0x3C, 0x88, 0x16, 0x03, 0xEA},
{0x28, 0xFF, 0x7E, 0x19, 0x88, 0x16, 0x03, 0xCF},
{0x28, 0xFF, 0xA1, 0x48, 0x88, 0x16, 0x03, 0xA9},
{0x28, 0xFF, 0xFB, 0x1D, 0x91, 0x16, 0x04, 0x9F}
};

//DeviceAddress add2[]={256,264,272,280,288,296,304,312};
#define RXD2 16    
#define TXD2 17    //3 serial2=16,17

#define RXD1 1    //1 serial1=1,3
#define TXD1 3    

void setup(void){
Serial.begin(115200);
  delay(2000);
  Rtc.Begin();
    RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
//    printDateTime(compiled);
    Serial.println();

    if (!Rtc.IsDateTimeValid()) {
        // Common Cuases:
        //    1) first time you ran and the device wasn't running yet
        //    2) the battery on the device is low or even missing
        Serial.println("RTC lost confidence in the DateTime!");
        // following line sets the RTC to the date & time this sketch was compiled
        // it will also reset the valid flag internally unless the Rtc device is
        // having an issue
        Rtc.SetDateTime(compiled);
    }

    if (!Rtc.GetIsRunning())  {
        Serial.println("RTC was not actively running,  now");
        Rtc.SetIsRunning(true);   //starting
    }
    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled) {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled) {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }

    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 

for(int i=0;i<=7;i++) { 
  sensors.setResolution(addsensor[i], 12);  //resolution 9,10,11,12
      }

  sensors.requestTemperaturesByAddress(addsensor[7]); // Send the command to get temperatures
//  Serial.println(sensors.getTempC(addsensor[7]),4);

  Serial2.begin(9600, SERIAL_8N1, RXD2, TXD2);
  Serial.println("Serial Txd is on pin: "+String(TXD2));
  Serial.println("Serial Rxd is on pin: "+String(RXD2));

pinMode(sendbutton,OUTPUT);
digitalWrite(sendbutton,LOW);


}

void loop(void){
RtcDateTime t = Rtc.GetDateTime();  
RtcTemperature tmp = Rtc.GetTemperature();
//int tmp1 = 100*tmp.AsFloat();
//Serial.print(tmp);
//Serial.println("c");
sprintf((char*)datadate, "%02d/%02d/%02d", t.Day(),t.Month(),t.Year()-2000);
sprintf((char*)data1, "%02d/%02d/%02d,%02d:%02d:%02d,%5d,",t.Day(),t.Month(),t.Year()-2000,t.Hour(),t.Minute(),t.Second(),tmp);
//Serial.print((char*)data1);
 

  
 for(int j=0;j<=7;j++){
  sensors.requestTemperaturesByAddress(addsensor[j]); // Send the command to get temperatures
  tempC = sensors.getTempC(addsensor[j]);
  tempF = DallasTemperature::toFahrenheit(tempC);
/*
  Serial.print(j+1);
  Serial.print(" ");
 //  Serial.print(int(addsensor[j]),HEX);
  Serial.print(int(addsensor[j]));
  Serial.print(" Temp C: ");
  Serial.print(tempC,4);  // The four just increases the resolution that is printed
  Serial.print(" Temp F: ");
  Serial.println(tempF,4);
*/   
  tempcent=int(tempC*10000);
  if(tempcent<990000)  temp[j]=String(tempcent);
//  delay(500); 
    
}
s1=String((char*)data1)+" 1:"+temp[0]+",2:"+temp[1]+",3:"+temp[2]+",4:"+temp[3]+",5:"+temp[4]+",6:"+temp[5]+",7:"+temp[6]+",8:"+temp[7]+"#"; 
Serial.println(s1);  
Serial2.println(s1);
//Serial.println("#");
delay(gap);
}
