/*
 * Hardware Initialization
 *
 * This file may be used by anyone for any purpose and may be used as a
 * starting point making your own application using M-Stack.
 *
 * It is worth noting that M-Stack itself is not under the same license as
 * this file.
 *
 * M-Stack is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  For details, see sections 7, 8, and 9
 * of the Apache License, version 2.0 which apply to this file.  If you have
 * purchased a commercial license for this software from Signal 11 Software,
 * your commerical license superceeds the information in this header.
 *
 * Alan Ott
 * Signal 11 Software
 * 2016-05-02
 */

#ifndef HARDWARE_H__
#define HARDWARE_H__

#define PIN_ON  1
#define PIN_OFF 0
#define PIN_INPUT  1
#define PIN_OUTPUT 0
#define BUTTON_PRESSED      0
#define BUTTON_NOT_PRESSED  1

#define UART_ENABLE   RCSTAbits.SPEN
#define UART_TRISTx   TRISCbits.TRISC4
#define UART_TRISRx   TRISCbits.TRISC5
#define UART_Tx       PORTCbits.RC4
#define UART_Rx       PORTCbits.RC5


#define mDataRdyUSART() PIR1bits.RCIF
#define mTxRdyUSART()   TXSTAbits.TRMT

//void hardware_init(void);
//void USART_Initialize(unsigned char, unsigned char);
//void USART_putcUSART(char);
//void timer_init(void);
//unsigned char USART_getcUSART(void);
//extern volatile unsigned char ledpoke;
#endif /* HARDWARE_H__ */
