/*
 *
 * This file may be used by anyone for any purpose and may be used as a
 * starting point making your own application using M-Stack.
 *
 * It is worth noting that M-Stack itself is not under the same license as
 * this file.
 *
 * M-Stack is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  For details, see sections 7, 8, and 9
 * of the Apache License, version 2.0 which apply to this file.  If you have
 * purchased a commercial license for this software from Signal 11 Software,
 * your commerical license superceeds the information in this header.
 *
 * Alan Ott
 * Signal 11 Software
 * 2016-05-02
 */

#include <xc.h>
#include <stdint.h>
#include "usb_config.h"
#include "hardware.h"

// ONFIG1
#pragma config FCMEN = 0            // Fail-Safe Clock Monitor Enable - disabled
#pragma config IESO = 0             // Internal External Switchover - disabled
#pragma config CLKOUTEN = 1         // Clock Out Enable - disabled
#pragma config BOREN = 0            // Brown-out Reset - disabled
#pragma config CP = 1               // Code Protection - disabled
#pragma config MCLRE = 0            // MCLR/VPP pin function is digital input
#pragma config PWRTE = 1            // Power-Up Timer - disabled
#pragma config WDTE = NSLEEP        // WDT enabled while running and disabled in Sleep
#pragma config FOSC = INTOSC        // Oscillator Selection - INTOSC oscillator: I/O function on OSC1 pin

// CONFIG2
#pragma config LVP = 0              // High-voltage on MCLR must be used for programming
#pragma config DEBUG = 1            // Managed by the debug tool
#pragma config LPBOR = 1            // Low-Power Brown-out Reset is disabled
#pragma config BORV = LO            // Brown-out Reset Voltage Selection
#pragma config STVREN = ON          // Stack Overflow or Underflow will cause a Reset
#pragma config PLLEN = ENABLED      // PLL is enabled
#pragma config PLLMULT = 3x         // PLL Multiplier Selection
#pragma config USBLSCLK = 48MHz     // USB Clock divide-by 8 (48 MHz system input clock expected)
#pragma config CPUDIV = NOCLKDIV    // No CPU system clock divide
#pragma config WRT = OFF            // Flash Memory Self-Write Protection


//void hardware_init(void) {
////#endif
//}
//
//void timer_init() {
//}