#define _SUPPRESS_PLIB_WARNING
#include <plib.h>
#include "cfunctions.h"
#define BACKPACK_CS LATBbits.LATB2
#define BACKPACK_DC LATAbits.LATA0
#define BACKPACK_RST LATBbits.LATB12
#define BACKPACK_TOUCHCS LATBbits.LATB3
#define BACKPACK_BACKLIGHT LATBbits.LATB15
#define DELAY(x) {long n,t;t=x*6000;for(n=0;n<t;++n){Nop();}}
#define LCD_DATA(x) {while(SPI1STATbits.SPIBUSY){};SPI1BUF=x;}
#define LCD_CMD(x) {while(SPI1STATbits.SPIBUSY){};BACKPACK_DC=0;SPI1BUF=x;BACKPACK_DC=1;}

void delay(long x){
    long n,t;
    t=x*6000;
    for(n=0;n<t;++n){Nop();}    
}

void lcd_data(unsigned char x){
    while(SPI1STATbits.SPIBUSY){};
    SPI1BUF=x;
}

void lcd_cmd(unsigned char x){
    while(SPI1STATbits.SPIBUSY){};
    BACKPACK_DC=0;
    SPI1BUF=x;
    while(SPI1STATbits.SPIBUSY){};
    BACKPACK_DC=1;    
}

void lcd_rotation(long long x){
    int * p;        //persistent RAM block
    if (StartOfCFuncRam){
        p=(void *)(unsigned int)StartOfCFuncRam;
    }else{
        //Get some persistent memory
        p = GetMemory(256);
        //Save the address for other functions
        StartOfCFuncRam=(unsigned int)p;
    }
    BACKPACK_CS=0;
    if(x==1){
        lcd_cmd(0x36);           //Memory Access Control 
        lcd_data(0x58);              //1=top is 12 o'clock
        p[0]=1;
        p[1]=320;
        p[2]=480;
    }
    if(x==2){
        lcd_cmd(0x36);           //Memory Access Control 
        lcd_data(0x38);              //2=top is 3 o'clock
        p[0]=2;
        p[1]=480;
        p[2]=320;
    }
    if(x==3){
        lcd_cmd(0x36);           //Memory Access Control 
        lcd_data(0x98);              //3=top is 6 o'clock
        p[0]=3;
        p[1]=320;
        p[2]=480;
    }
    if(x==4){
        lcd_cmd(0x36);           //Memory Access Control 
        lcd_data(0xF8);              //4=top is 9 o'clock
        p[0]=2;
        p[1]=480;
        p[2]=320;
    }
    BACKPACK_CS=1;
}

void lcd_init(){
    BACKPACK_RST=0;
    BACKPACK_BACKLIGHT=1;
    delay(100);
    BACKPACK_RST=1;
    delay(40);
    BACKPACK_CS=0;
    lcd_cmd(0x1);    //sw reset
    delay(120);
    lcd_cmd(0x11);   //Sleep out
    delay(120);
    lcd_cmd(0x13);   //normal
    lcd_cmd(0x20);   //no inversion
    lcd_cmd(0x28);   //display off
    lcd_cmd(0x38);   //idle mode off
    lcd_cmd(0xC0);   //power control 1
    lcd_data(0x17);
    lcd_data(0x15);
    lcd_cmd(0xC1);   //power control 2
    lcd_data(0x41);
    lcd_cmd(0xC5);   //VCOM control
    lcd_data(0x0e);
    lcd_data(0x0e);
    lcd_cmd(0x36);   //Memory Access control
    lcd_data(88);    //suits rotation 0
    lcd_cmd(0x3A);   //Pixel interface format
    lcd_data(0x66);
    lcd_cmd(0xB4);   //inversion control
    lcd_data(0x2);
    lcd_cmd(0xB6);   //Function control
    lcd_data(0x2);
    lcd_data(0x2);
    lcd_data(0x3B);
    lcd_cmd(0x29);   //display on
    lcd_cmd(0x2A);   //set column
    lcd_data(0x0);
    lcd_data(0x0);
    lcd_data(0x1);
    lcd_data(0x3F);
    lcd_cmd(0x2B);   //set row
    lcd_data(0x0);
    lcd_data(0x0);
    lcd_data(0x1);
    lcd_data(0xDF);
    lcd_cmd(0x36);           //Memory Access Control //rotate=1
    lcd_data(0x58);              //1=top is 12 o'clock
    BACKPACK_CS=1;
    lcd_rotation((char)1);        //set to known value and init persistent RAM  
}

long long lcd_getwidth(){
    int * p;        //persistent RAM block
    if (StartOfCFuncRam){
        p=(void *)(unsigned int)StartOfCFuncRam;
        return p[1];
    }else{
        return -1;      //not inited
    }    
}

long long lcd_getheight(){
    int * p;        //persistent RAM block
    if (StartOfCFuncRam){
        p=(void *)(unsigned int)StartOfCFuncRam;
        return p[2];
    }else{
        return -1;      //not inited
    }    
}

long long lcd_getrotation(){
    int * p;        //persistent RAM block
    if (StartOfCFuncRam){
        p=(void *)(unsigned int)StartOfCFuncRam;
        return p[0];
    }else{
        return -1;      //not inited
    }    
}

void lcd_setarea(int x1,int y1,int x2,int y2){
    if(x2<x1){int i=x1;x1=x2;x2=i;}   //sort x
    if(y2<y1){int i=y1;y1=y2;y2=i;}   //sort y
    BACKPACK_CS=0;
    lcd_cmd(42);               //set x bounds  
    lcd_data((x1)>>8);
    lcd_data(x1);
    lcd_data((x2)>>8);
    lcd_data(x2);
    lcd_cmd(43);               //set y bounds
    lcd_data((y1)>>8);
    lcd_data(y1);
    lcd_data((y2)>>8);
    lcd_data(y2);
    lcd_cmd(44);               //drawing data to follow
    BACKPACK_CS=1;
}

void lcd_box(int x1,int y1,int x2,int y2, long c){
    if(x2<x1){int i=x1;x1=x2;x2=i;}   //sort x
    if(y2<y1){int i=y1;y1=y2;y2=i;}   //sort y
    lcd_setarea(x1,y1,x2,y2);
    long n,i;
    n=(x2-x1+1)*(y1-y1+1);
    BACKPACK_CS=0;
    for(i=0;i<n;i++){
        lcd_data(c>>16);                
        lcd_data(c>>8);                
        lcd_data(c);                
    }
    BACKPACK_CS=1;    
}

void lcd_clear(long c){
    int * p;        //persistent RAM block
    if (StartOfCFuncRam){
        p=(void *)(unsigned int)StartOfCFuncRam;
        lcd_setarea(0,0,p[1]-1,p[2]-1);
        long n,i;
        n=p[1]*p[2];
        BACKPACK_CS=0;
        for(i=0;i<n;i++){
            lcd_data(c>>16);                
            lcd_data(c>>8);                
            lcd_data(c);                
        }
        BACKPACK_CS=1;    
    }    
}

long long main(long long *mode, long long *x1,long long *y1,long long *x2,long long *y2,long long *f,long long *b){

    if((*mode)==0){lcd_init();}
    if((*mode)==1){lcd_rotation(*x1);}
    if((*mode)==2){lcd_clear(*x1);}
    if((*mode)==3){lcd_setarea(*x1,*y1,*x2,*y2);}
    if((*mode)==4){lcd_box(*x1,*y1,*x2,*y2,*f);}
    if((*mode)==7){return lcd_getwidth();}
    if((*mode)==8){return lcd_getheight();}
    if((*mode)==9){return lcd_getrotation();}
}




