'
'                    KNIGHT RIDER - PICAXE 20M2
'                      (knight_rider_20m2.bas)

set_micro:' ----------- initalise the microprocessor -----------
b0 = 0: b1 = 0: b2 = 0: b3 = 0: b4 = 80: b5 = 0 
let dirsB = %11111100: let dirsC = %00111111
let pinsB = %00000000: let pinsC = %00000000
pullup %0100000000000010
'goto set_mode

set_mode:'------------- VR1 selects 1 of 6 chaser types ----------
readadc C.7,b1
if b1 > 212 and b1 < 255 then: let b2 = 6: endif'   (1x12-1LED)
if b1 > 170 and b1 < 212 then: let b2 = 5: endif'   (2x6-1LED)
if b1 > 128 and b1 < 170 then: let b2 = 4: endif'   (3x4-1LED)
if b1 >  86 and b1 < 128 then: let b2 = 3: endif'   (1x12-2LED)
if b1 >  44 and b1 <  86 then: let b2 = 2: endif'   (2x6-2LED)
if b1 >   1 and b1 <  44 then: let b2 = 1: endif'   (3x4-2LED)
'goto drive_display

drive_display:'-------- drive the selected chaser display ----------
if pinC.6 = 0 then: goto chaser_6: endif
if pinB.1 = 0 then: goto chaser_3: endif
if b2 = 6 then: goto chaser_6: endif
if b2 = 5 then: goto chaser_5: endif
if b2 = 4 then: goto chaser_4: endif 
if b2 = 3 then: goto chaser_3: endif
if b2 = 2 then: goto chaser_2: endif
if b2 = 1 then: goto chaser_1: endif
goto set_mode

set_speed:'------------ VR2 selects various chaser speeds ---------
readadc B.0,b3
let b4 = b3 MAX 200 + 5
for b5 = 1 to b4
pause 1
next b5
return

chaser_6:'---------- 1 LED - 1 x 12 way knight rider ---------
for b0 = 1 to 2
pinsC = %00100000: pinsB = %00000000: gosub set_speed
pinsC = %00010000: pinsB = %00000000: gosub set_speed
pinsC = %00001000: pinsB = %00000000: gosub set_speed
pinsC = %00000100: pinsB = %00000000: gosub set_speed
pinsC = %00000010: pinsB = %00000000: gosub set_speed
pinsC = %00000001: pinsB = %00000000: gosub set_speed
pinsC = %00000000: pinsB = %10000000: gosub set_speed
pinsC = %00000000: pinsB = %01000000: gosub set_speed
pinsC = %00000000: pinsB = %00100000: gosub set_speed
pinsC = %00000000: pinsB = %00010000: gosub set_speed
pinsC = %00000000: pinsB = %00001000: gosub set_speed
pinsC = %00000000: pinsB = %00000100: gosub set_speed
pinsC = %00000000: pinsB = %00001000: gosub set_speed
pinsC = %00000000: pinsB = %00010000: gosub set_speed
pinsC = %00000000: pinsB = %00100000: gosub set_speed
pinsC = %00000000: pinsB = %01000000: gosub set_speed
pinsC = %00000000: pinsB = %10000000: gosub set_speed
pinsC = %00000001: pinsB = %00000000: gosub set_speed
pinsC = %00000010: pinsB = %00000000: gosub set_speed
pinsC = %00000100: pinsB = %00000000: gosub set_speed
pinsC = %00001000: pinsB = %00000000: gosub set_speed
pinsC = %00010000: pinsB = %00000000: gosub set_speed
next b0
if pinC.6 = 0 then: goto chaser_5: endif
goto set_mode

chaser_5:'---------- 1 LED - 2 x 6 way knight rider --------
for b0 = 1 to 3
pinsC = %00100000: pinsB = %10000000: gosub set_speed
pinsC = %00010000: pinsB = %01000000: gosub set_speed
pinsC = %00001000: pinsB = %00100000: gosub set_speed
pinsC = %00000100: pinsB = %00010000: gosub set_speed
pinsC = %00000010: pinsB = %00001000: gosub set_speed
pinsC = %00000001: pinsB = %00000100: gosub set_speed
pinsC = %00000001: pinsB = %00000100: gosub set_speed
pinsC = %00000010: pinsB = %00001000: gosub set_speed
pinsC = %00000100: pinsB = %00010000: gosub set_speed
pinsC = %00001000: pinsB = %00100000: gosub set_speed
pinsC = %00010000: pinsB = %01000000: gosub set_speed
pinsC = %00100000: pinsB = %10000000: gosub set_speed
next b0
if pinC.6 = 0 then: goto chaser_4: endif
goto set_mode

chaser_4:'---------- 1 LED - 3 x 4 way knight rider ---------
for b0 = 1 to 5
pinsC = %00100010: pinsB = %00100000: gosub set_speed
pinsC = %00010001: pinsB = %00010000: gosub set_speed
pinsC = %00001000: pinsB = %10001000: gosub set_speed
pinsC = %00000100: pinsB = %01000100: gosub set_speed
pinsC = %00000100: pinsB = %01000100: gosub set_speed
pinsC = %00001000: pinsB = %10001000: gosub set_speed
pinsC = %00010001: pinsB = %00010000: gosub set_speed
pinsC = %00100010: pinsB = %00100000: gosub set_speed
next b0
if pinC.6 = 0 then: goto chaser_6: endif
goto set_mode

chaser_3:'---------- 2 LED - 1 x 12 way knight rider ---------
for b0 = 1 to 2
pinsC = %00110000: pinsB = %00000000: gosub set_speed
pinsC = %00011000: pinsB = %00000000: gosub set_speed
pinsC = %00001100: pinsB = %00000000: gosub set_speed
pinsC = %00000110: pinsB = %00000000: gosub set_speed
pinsC = %00000011: pinsB = %00000000: gosub set_speed
pinsC = %00000001: pinsB = %10000000: gosub set_speed
pinsC = %00000000: pinsB = %11000000: gosub set_speed
pinsC = %00000000: pinsB = %01100000: gosub set_speed
pinsC = %00000000: pinsB = %00110000: gosub set_speed
pinsC = %00000000: pinsB = %00011000: gosub set_speed
pinsC = %00000000: pinsB = %00001100: gosub set_speed
pinsC = %00000000: pinsB = %00001100: gosub set_speed
pinsC = %00000000: pinsB = %00011000: gosub set_speed
pinsC = %00000000: pinsB = %00110000: gosub set_speed
pinsC = %00000000: pinsB = %01100000: gosub set_speed
pinsC = %00000001: pinsB = %10000000: gosub set_speed
pinsC = %00000011: pinsB = %00000000: gosub set_speed
pinsC = %00000110: pinsB = %00000000: gosub set_speed
pinsC = %00001100: pinsB = %00000000: gosub set_speed
pinsC = %00011000: pinsB = %00000000: gosub set_speed
pinsC = %00110000: pinsB = %00000000: gosub set_speed
next b0
if pinB.1 = 0 then: goto chaser_2: endif
goto set_mode

chaser_2:'---------- 2 LED - 2 x 6 way knight rider ---------
for b0 = 1 to 3
pinsC = %00110000: pinsB = %11000000: gosub set_speed
pinsC = %00011000: pinsB = %01100000: gosub set_speed
pinsC = %00001100: pinsB = %00110000: gosub set_speed
pinsC = %00000110: pinsB = %00011000: gosub set_speed
pinsC = %00000011: pinsB = %00001100: gosub set_speed
pinsC = %00000011: pinsB = %00001100: gosub set_speed
pinsC = %00000110: pinsB = %00011000: gosub set_speed
pinsC = %00001100: pinsB = %00110000: gosub set_speed
pinsC = %00011000: pinsB = %01100000: gosub set_speed
pinsC = %00110000: pinsB = %11000000: gosub set_speed
next b0
if pinB.1 = 0 then: goto chaser_1: endif
goto set_mode

chaser_1:'---------- 2 LED - 3 x 4 way knight rider ---------
for b0 = 1 to 5
pinsC = %00110011: pinsB = %00110000: gosub set_speed
pinsC = %00011001: pinsB = %10011000: gosub set_speed
pinsC = %00011001: pinsB = %10011000: gosub set_speed
pinsC = %00001100: pinsB = %11001100: gosub set_speed
pinsC = %00001100: pinsB = %11001100: gosub set_speed
pinsC = %00011001: pinsB = %10011000: gosub set_speed
pinsC = %00011001: pinsB = %10011000: gosub set_speed
pinsC = %00110011: pinsB = %00110000: gosub set_speed
next b0
if pinC.6 = 0 then: goto chaser_6: endif
goto set_mode

'               Definition of variables
'----------------------------------------------------------------
' b0 = for/next loop
' b1 = read VR1         
' b2 = select mode 
' b3 = read VR2
' b4 = select speed
' b5 = for/next loop
'------------------------------------------------------------------