;Title: LOGIC IC TESTER
;Author: Noel A. Rios
;Processor: DS5000T
;Crystal Frequency: 8Mhz
;Assembler:  Metalink Cross Assembler
;Date Started: 1/15/02
;Date Finished:

$MOD52

TimerValue20ms equ 65535-13333


LCDPORT equ P3
RSpin   equ P3.0
R_WPin  equ P3.1
Epin    equ P2.7
KEYPADPort equ P3
PIN_DRIVER3  equ P0.0    ;See Schematic Diagram
PIN_DRIVER4  equ P0.1
PIN_DRIVER5  equ P0.2
PIN_DRIVER6  equ P0.3
PIN_DRIVER7  equ P0.4
PIN_DRIVER8  equ P0.5
PIN_DRIVER9  equ P0.6
PIN_DRIVER10 equ P0.7
PIN_DRIVER11 equ P1.0
PIN_DRIVER13 equ P1.1
PIN_DRIVER14 equ P1.2
PIN_DRIVER15 equ P1.3
PIN_DRIVER16 equ P1.4
PIN_DRIVER17 equ P1.5
PIN_DRIVER18 equ P1.6
PIN_DRIVER19 equ P1.7
PIN_DRIVER20 equ P2.0
PIN_DRIVER21 equ P2.1
SWITCH1      EQU P2.4
SWITCH2      EQU P2.5
SWITCH3      EQU P2.6
DETECT       EQU P2.3



BSEG AT 20h
FLAG:  dBIT 1
FLAG2: dBIT 1
FLAG3: dBIT 1
FLAG4: dBIT 1


DSEG at 30h

Index: ds 1
delaycounter1: ds 1
delaycounter2: ds 1
delaycounter3: ds 1
temp:          ds 1
input:         ds 3
COUNTER:       DS 1
SHIFTREG:      DS 1
COUNTER2:      DS 1

CSEG at 0h

ORG 0H
LJMP BEGIN      ;RESET VECTOR
ORG 03H
LJMP ie0vec     ;IE0 EXTERNAL INTERRUPT 0
ORG 0BH
LJMP t0vec      ;TIMER 0 INTERRUPT
ORG 13H
LJMP ie1vec     ;IE1 EXTERNAL INTERRUPT 1
ORG 1BH
LJMP t1vec      ;TIMER 1 INTERRUPT
ORG 23H
LJMP servec     ;RI & TI SERIAL PORT INT

;                    0123456789ABCDEF
ICTESTER_MSG:    db 'Logic IC Tester ',0
ICTESTER_VER:    DB '  Version 1.0   ',0
INPUT_MSG:       db 'Enter IC No.?',0
INVALID_MSG:     DB 'Invalid Input   ',0
NOT_LIBRARY_MSG: DB 'Not in Library  ',0
PASS_MSG:        DB 'Device Passed   ',0
FAIL_MSG:        db 'Device Failed   ',0
INSERT_MSG:      db 'Insert in Socket',0
OVERCURRENT_MSG: DB 'Overcurrent!    ',0
PROCEED_MSG:     db 'Press * to go on',0
COL_1: db 1,4,7,11
COL_2: db 2,5,8,0
COL_3: db 3,6,9,12


BEGIN:

mov SP,#7
clr EA

clr R_WPin
clr EPin

LCALL DELAY

LCALL CONFIG_LCD       ;CONFIGURE LCD
LCALL DISPLAY_CONFIG
LCALL ENTRY_MODE_SET
LCALL CURSOR_SET



START:

LCALL HOME                ;Display Firmware Version
LCALL CLEAR
MOV DPTR,#ICTESTER_MSG
LCALL DISPLAY_STRING

LCALL SECOND_LINE
MOV DPTR,#ICTESTER_VER
LCALL DISPLAY_STRING

LCALL DELAY



LOOP:
setb switch1
setb switch2
setb switch3
LCALL GET_INPUT
LCALL PROCESS_INPUT
jmp LOOP

;=============ROUTINES=================================
GET_INPUT:              ;MINIMUM OF TWO DIGITS OF INPUT
                        ;OUTPUT IN INPUT VARIABLE


LCALL HOME
LCALL CLEAR
MOV DPTR,#INPUT_MSG     ;DISPLAY INPUT IC NUMBER PROMPT
LCALL DISPLAY_STRING

LCALL SCANKEYPAD
MOV INPUT,A
CJNE A,#12,CHECK_MODE1
JMP INVALID_INPUT      ;CHECK FOR INVALID INPUT
CHECK_MODE1:
CJNE A,#11,PROCEED1
JMP INVALID_INPUT      ;CHECK FOR INVALID INPUT

INVALID_INPUT:
LCALL HOME
LCALL CLEAR
MOV DPTR,#INVALID_MSG
LCALL DISPLAY_STRING
LCALL DELAY
JMP GET_INPUT          ;GET ENTRY AGAIN IF MODE KEY IS PRESSED

PROCEED1:
LCALL BINASC           ;PROCESS AND DISPLAY PRESSED KEY
MOV A,R2
LCALL WRITE_LCD

LCALL SCANKEYPAD
MOV INPUT+1,A
CJNE A,#12,CHECK_MODE2
JMP INVALID_INPUT      ;CHECK FOR INVALID INPUT
CHECK_MODE2:
CJNE A,#11,PROCEED2
JMP INVALID_INPUT      ;CHECK FOR INVALID INPUT

PROCEED2:
LCALL BINASC           ;PROCESS AND DISPLAY PRESSED KEY
MOV A,R2
LCALL WRITE_LCD

LCALL SCANKEYPAD       ;SCAN FOR THIRD KEYPRESS
MOV INPUT+2,A
CJNE A,#11,CHECK_ENTER3
JMP INVALID_INPUT      ;CHECK FOR INVALID INPUT
CHECK_ENTER3:
CJNE A,#12,PROCESS_2_DIGIT
RET                    ;ENTER KEY IN 3RD INPUT VARIABLE


PROCESS_2_DIGIT:
RET                    ;THREE IC NUMBER IN  INPUT VARIABLE

;-------------------------------------------------------
PROCESS_INPUT:

MOV A,INPUT+2           ;CHECK THIRD VARIABLE
CJNE A,#12,THREE_DIGIT  ;CHECK FOR ENTER KEY
JMP SELECT_TWO_DIGIT
THREE_DIGIT:
JMP SELECT_THREE_DIGIT

SELECT_TWO_DIGIT:
MOV A,INPUT             ;PROCESS FIRST DIGIT
CJNE A,#0,NOT_0
MOV A,INPUT+1           ;ZERO FIRST DIGIT
CJNE A,#0,NOT_00
LCALL N7400              ;RUN 7400 TEST
RET
NOT_00:
CJNE A,#1,NOT_01
LCALL N7401              ;RUN 7401 TEST
RET
NOT_01:
CJNE A,#2,NOT_02
LCALL N7402              ;RUN 7402 TEST
RET
NOT_02:
CJNE A,#3,NOT_03
LCALL N7403              ;RUN 7403 TEST
RET
NOT_03:
CJNE A,#4,NOT_04
LCALL N7404              ;RUN 7404 TEST
RET
NOT_04:
CJNE A,#5,NOT_05
LCALL N7405              ;RUN 7405 TEST
RET
NOT_05:
CJNE A,#6,NOT_06
LCALL N7406              ;RUN 7406 TEST
RET
NOT_06:
CJNE A,#7,NOT_07
LCALL N7407              ;RUN 7407 TEST
RET
NOT_07:
CJNE A,#8,NOT_08
LCALL N7408              ;RUN 7408 TEST
RET
NOT_08:
CJNE A,#9,NOT_09
LCALL N7409              ;RUN 7409 TEST
RET
NOT_09:
JMP NOT_IN_LIBRARY
NOT_0:
CJNE A,#1,NOT_1
MOV A,INPUT+1           ;1 FIRST DIGIT
CJNE A,#0,NOT_10
LCALL N7410              ;RUN 7410 TEST
RET
NOT_10:
CJNE A,#1,NOT_11
JMP NOT_IN_LIBRARY ;LCALL N7411              ;RUN 7411 TEST
NOT_11:
CJNE A,#3,NOT_13
LCALL N7413              ;RUN 7413 TEST
RET
NOT_13:
CJNE A,#4,NOT_14
LCALL N7414              ;RUN 7414 TEST
RET
NOT_14:
CJNE A,#6,NOT_16
LCALL N7406              ;RUN 7416 TEST   RUN 7406 TEST
RET
NOT_16:
CJNE A,#7,NOT_17
LCALL N7417              ;RUN 7417 TEST
RET
NOT_17:
JMP NOT_IN_LIBRARY
NOT_1:
CJNE A,#2,NOT_2
MOV A,INPUT+1           ;2 FIRST DIGIT
CJNE A,#0,NOT_20
LCALL N7420              ;RUN 7420 TEST
RET
NOT_20:
CJNE A,#1,NOT_21
LCALL N7421              ;RUN 7420 TEST
RET
NOT_21:
CJNE A,#5,NOT_25
LCALL N7425              ;RUN 7425 TEST
RET
NOT_25:
CJNE A,#6,NOT_26
LCALL N7426              ;RUN 7426 TEST
RET
NOT_26:
CJNE A,#7,NOT_27
LCALL N7427              ;RUN 7427 TEST
RET
NOT_27:
JMP NOT_IN_LIBRARY
NOT_2:
CJNE A,#3,NOT_3
MOV A,INPUT+1           ;3 FIRST DIGIT
CJNE A,#0,NOT_30
LCALL N7430              ;RUN 7430 TEST
RET
NOT_30:
CJNE A,#2,NOT_32
LCALL N7432              ;RUN 7432 TEST
RET
NOT_32:
CJNE A,#7,NOT_37
LCALL N7437              ;RUN 7437 TEST
RET
NOT_37:
CJNE A,#8,NOT_38
LCALL N7438              ;RUN 7438 TEST
RET
NOT_38:
JMP NOT_IN_LIBRARY
NOT_3:
CJNE A,#4,NOT_4
MOV A,INPUT+1           ;4 FIRST DIGIT
CJNE A,#0,NOT_40
LCALL N7440              ;RUN 7440 TEST
RET
NOT_40:
CJNE A,#2,NOT_42
LCALL N7442              ;RUN 7442 TEST
RET
NOT_42:
CJNE A,#5,NOT_45
LCALL N7445              ;RUN 7445 TEST
RET
NOT_45:
CJNE A,#6,NOT_46
LCALL N7446              ;RUN 7446 TEST
RET
NOT_46:
CJNE A,#7,NOT_47
LCALL N7446              ;RUN 7447 TEST
RET
NOT_47:
JMP NOT_IN_LIBRARY
NOT_4:
CJNE A,#5,NOT_5
MOV A,INPUT+1           ;5 FIRST DIGIT
CJNE A,#1,NOT_51
LCALL N7451              ;RUN 7451 TEST
RET
NOT_51:
CJNE A,#4,NOT_54
LCALL N7454              ;RUN 7454 TEST
RET
NOT_54:
JMP NOT_IN_LIBRARY
NOT_5:
CJNE A,#6,NOT_6
MOV A,INPUT+1           ;6 FIRST DIGIT
JMP NOT_IN_LIBRARY
NOT_6:
CJNE A,#7,NOT_7
MOV A,INPUT+1           ;7 FIRST DIGIT
CJNE A,#2,NOT_72
LCALL N7472              ;RUN 7472 TEST
RET
NOT_72:
CJNE A,#3,NOT_73
;LCALL N7473              ;RUN 7473 TEST
JMP NOT_IN_LIBRARY
RET
NOT_73:
CJNE A,#4,NOT_74
LCALL N7474              ;RUN 7474 TEST
RET
NOT_74:
CJNE A,#5,NOT_75
;LCALL N7475             ;RUN 7475 TEST
JMP NOT_IN_LIBRARY
RET
NOT_75:
CJNE A,#6,NOT_76
;LCALL N7476              ;RUN 7476 TEST
JMP NOT_IN_LIBRARY
RET
NOT_76:
JMP NOT_IN_LIBRARY
NOT_7:
CJNE A,#8,NOT_8
MOV A,INPUT+1           ;8 FIRST DIGIT
CJNE A,#5,NOT_85
LCALL N7485              ;RUN 7485 TEST
RET
NOT_85:
CJNE A,#6,NOT_86
LCALL N7486              ;RUN 7486 TEST
RET
NOT_86:
JMP NOT_IN_LIBRARY
NOT_8:
CJNE A,#9,NOT_9
MOV A,INPUT+1           ;9 FIRST DIGIT
CJNE A,#0,NOT_90
;LCALL N7490              ;RUN 7490 TEST
JMP NOT_IN_LIBRARY
RET
NOT_90:
CJNE A,#5,NOT_95
LCALL N7495              ;RUN 7495 TEST
RET
NOT_95:
JMP NOT_IN_LIBRARY
NOT_9:
JMP NOT_IN_LIBRARY

SELECT_THREE_DIGIT:
MOV A,INPUT            ;CHECK FIRST DIGIT
CJNE A,#0,NOT_0_FIRST
JMP NOT_IN_LIBRARY     ;0 FIRST DIGIT
NOT_0_FIRST:
CJNE A,#1,NOT_ONE_FIRST
JMP FIRST_1
NOT_ONE_FIRST:
JMP NOT_1_FIRST
FIRST_1:
MOV A,INPUT+1          ;1 FIRST DIGIT
CJNE A,#0,NOT_10_SECOND
MOV A,INPUT+2          ;0 SECOND DIGIT
CJNE A,#7,NOT_107_THIRD
LCALL N74107            ;RUN 74107 TEST
RET
NOT_107_THIRD:
CJNE A,#9,NOT_109_THIRD
LCALL N74109            ;RUN 74109 TEST
RET
NOT_109_THIRD:
JMP NOT_IN_LIBRARY
NOT_10_SECOND:
CJNE A,#2,NOT_12_SECOND
MOV A,INPUT+2         ;2 SECOND DIGIT
CJNE A,#5,NOT_125_THIRD
LCALL N74125           ;RUN 74125 TEST
RET
NOT_125_THIRD:
JMP NOT_IN_LIBRARY
NOT_12_SECOND:
CJNE A,#3,NOT_13_SECOND
MOV A,INPUT+2         ;3 SECOND DIGIT
CJNE A,#2,NOT_132_THIRD
LCALL N74132           ;RUN 74132 TEST
RET
NOT_132_THIRD:
JMP NOT_IN_LIBRARY
NOT_13_SECOND:
CJNE A,#4,NOT_14_SECOND
MOV A,INPUT+2         ;4 SECOND DIGIT
CJNE A,#5,NOT_145_THIRD
LCALL N74145           ;RUN 74145 TEST
RET
NOT_145_THIRD:
CJNE A,#8,NOT_148_THIRD
LCALL N74148           ;RUN 74148 TEST
RET
NOT_148_THIRD:
JMP NOT_IN_LIBRARY
NOT_14_SECOND:
CJNE A,#5,NOT_15_SECOND
MOV A,INPUT+2         ;5 SECOND DIGIT
CJNE A,#1,NOT_151_THIRD
LCALL N74151           ;RUN 74151 TEST
RET
NOT_151_THIRD:
CJNE A,#3,NOT_153_THIRD
LCALL N74153             ;RUN 74153 TEST
RET
NOT_153_THIRD:
CJNE A,#5,NOT_155_THIRD
LCALL N74155             ;RUN 74155 TEST
RET
NOT_155_THIRD:
CJNE A,#6,NOT_156_THIRD
LCALL N74156             ;RUN 74156 TEST
RET
NOT_156_THIRD:
CJNE A,#7,NOT_157_THIRD
LCALL N74157             ;RUN 74157 TEST
RET
NOT_157_THIRD:
JMP NOT_IN_LIBRARY
NOT_15_SECOND:
CJNE A,#6,NOT_16_SECOND
MOV A,INPUT+2         ;6 SECOND DIGIT
CJNE A,#1,NOT_161_THIRD
LCALL N74161           ;RUN 74161 TEST
RET
NOT_161_THIRD:
CJNE A,#2,NOT_162_THIRD
LCALL N74162           ;RUN 74162 TEST
RET
NOT_162_THIRD:
CJNE A,#3,NOT_163_THIRD
LCALL N74163           ;RUN 74163 TEST
RET
NOT_163_THIRD:
CJNE A,#4,NOT_164_THIRD
LCALL N74164           ;RUN 74164 TEST
RET
NOT_164_THIRD:
CJNE A,#5,NOT_165_THIRD
LCALL N74165           ;RUN 74165 TEST
RET
NOT_165_THIRD:
CJNE A,#6,NOT_166_THIRD
LCALL N74166           ;RUN 74166 TEST
RET
NOT_166_THIRD:
JMP NOT_IN_LIBRARY
NOT_16_SECOND:
CJNE A,#7,NOT_17_SECOND
MOV A,INPUT+2           ;7 SECOND DIGIT
CJNE A,#0,NOT_170_THIRD
JMP NOT_IN_LIBRARY ;LCALL N74170           ;RUN 74170 TEST
NOT_170_THIRD:
CJNE A,#3,NOT_173_THIRD
LCALL N74173           ;RUN 74173 TEST
RET
NOT_173_THIRD:
CJNE A,#4,NOT_174_THIRD
LCALL N74174           ;RUN 74174 TEST
RET
NOT_174_THIRD:
CJNE A,#5,NOT_175_THIRD
LCALL N74175           ;RUN 74175 TEST
RET
NOT_175_THIRD:
CJNE A,#6,NOT_176_THIRD
JMP NOT_IN_LIBRARY ;LCALL N74176           ;RUN 74176 TEST
NOT_176_THIRD:
JMP NOT_IN_LIBRARY
NOT_17_SECOND:
CJNE A,#8,NOT_18_SECOND
MOV A,INPUT+2           ;8 SECOND DIGIT
CJNE A,#0,NOT_180_THIRD
;LCALL N74180           ;RUN 74180 TEST
JMP NOT_IN_LIBRARY
RET
NOT_180_THIRD:
JMP NOT_IN_LIBRARY
NOT_18_SECOND:
CJNE A,#9,NOT_19_SECOND
MOV A,INPUT+2           ;9 SECOND DIGIT
CJNE A,#0,NOT_190_THIRD
;LCALL N74190            ;RUN 74190 TEST
JMP NOT_IN_LIBRARY
RET
NOT_190_THIRD:
CJNE A,#1,NOT_191_THIRD
LCALL N74191            ;RUN 74191 TEST
RET
NOT_191_THIRD:
CJNE A,#3,NOT_193_THIRD
LCALL N74193            ;RUN 74193 TEST
RET
NOT_193_THIRD:
CJNE A,#4,NOT_194_THIRD
LCALL N74194            ;RUN 74194 TEST
RET
NOT_194_THIRD:
CJNE A,#7,NOT_197_THIRD
LCALL N74197            ;RUN 74197 TEST
RET
NOT_197_THIRD:
JMP NOT_IN_LIBRARY
NOT_19_SECOND:
JMP NOT_IN_LIBRARY
NOT_1_FIRST:
CJNE A,#2,NOT_2_FIRST
MOV A,INPUT+1          ;2 FIRST DIGIT, CHECK SECOND
CJNE A,#4,NOT_24_SECOND
MOV A,INPUT+2          ;4 SECOND DIGIT, CHECK THIRD
CJNE A,#5,NOT_245_THIRD
LCALL N74245           ;RUN 74245 TEST
RET
NOT_245_THIRD:
JMP NOT_IN_LIBRARY
NOT_24_SECOND:
CJNE A,#5,NOT_25_SECOND
MOV A,INPUT+2          ;5 SECOND DIGIT, CHECK THIRD
CJNE A,#1,NOT_251_THIRD
LCALL N74251            ;RUN 74251 TEST
RET
NOT_251_THIRD:
JMP NOT_IN_LIBRARY
NOT_25_SECOND:
CJNE A,#7,NOT_27_SECOND
MOV A,INPUT+2          ;7 SECOND DIGIT, CHECK THIRD
CJNE A,#9,NOT_279_THIRD
LCALL N74279            ;RUN 74279 TEST
RET
NOT_279_THIRD:
JMP NOT_IN_LIBRARY
NOT_27_SECOND:
CJNE A,#9,NOT_29_SECOND
MOV A,INPUT+2           ;9 SECOND DIGIT, CHECK THIRD
CJNE A,#8,NOT_298_THIRD
LCALL N74298            ;RUN 74298 TEST
RET
NOT_298_THIRD:
JMP NOT_IN_LIBRARY
NOT_29_SECOND:
JMP NOT_IN_LIBRARY

NOT_2_FIRST:
CJNE A,#3,NOT_3_FIRST
MOV A,INPUT+1           ;3 FIRST DIGIT, CHECK SECOND
CJNE A,#6,NOT_36_SECOND
MOV A,INPUT+2           ;6 SECOND DIGIT, CHECK THIRD
CJNE A,#5,NOT_365_THIRD
LCALL N74365            ;RUN 74365 TEST
RET
NOT_365_THIRD:
CJNE A,#6,NOT_366_THIRD
LCALL N74366            ;RUN 74366 TEST
RET
NOT_366_THIRD:
CJNE A,#7,NOT_367_THIRD
LCALL N74367            ;RUN 74367 TEST
RET
NOT_367_THIRD:
CJNE A,#8,NOT_368_THIRD
LCALL N74368            ;RUN 74368 TEST
RET
NOT_368_THIRD:
JMP NOT_IN_LIBRARY
NOT_36_SECOND:
MOV A,INPUT+1
CJNE A,#7,NOT_37_SECOND
MOV A,INPUT+2           ;7 SECOND DIGIT, CHECK THIRD
CJNE A,#3,NOT_373_THIRD
LCALL N74373            ;RUN 74373 TEST
RET
NOT_373_THIRD:
CJNE A,#4,NOT_374_THIRD
LCALL N74374
RET                     ;RUN 74374 TEST
NOT_374_THIRD:
JMP NOT_IN_LIBRARY
NOT_37_SECOND:
JMP NOT_IN_LIBRARY
NOT_3_FIRST:
JMP NOT_IN_LIBRARY



NOT_IN_LIBRARY:
LCALL HOME                ;Display NOT IN LIBRARY
LCALL CLEAR
MOV DPTR,#NOT_LIBRARY_MSG
LCALL DISPLAY_STRING
LCALL DELAY
RET



;-------------------------------------------------------
;---------------------------------;
; DISPLAY CLEAR     LCD           ;
;---------------------------------;
CLEAR:

clr R_WPin
MOV A,LCDPORT
ANL A,#00001111B        ; DB7=0
                        ; DB6=0
                        ; DB5=0
                        ; DB4=0
MOV LCDPORT,A
SETB Epin               ;ENABLE HI
CLR RSPin               ; RS LOW
LCALL WAIT_LCD
CLR Epin


SETB Epin
MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#00010000B
MOV LCDPORT,ACC
                        ; DB7=0
                        ; DB6=0
                        ; DB5=0
                        ; DB4=1
LCALL WAIT_LCD
CLR Epin
SETB RSpin

RET

;---------------------------------;
; RETURN HOME                     ;
;---------------------------------;

HOME:
clr R_WPin
ANL LCDPORT,#00001111B  ; DB7=0
                        ; DB6=0
                        ; DB5=0
                        ; DB4=0
SETB Epin               ;E HI
CLR RSpin               ;RS LOW
ACALL WAIT_LCD
CLR Epin



MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#00100000B
MOV LCDPORT,ACC

                        ; DB7=0
                        ; DB6=0
                        ; DB5=1
                        ; DB4=0
SETB Epin
ACALL WAIT_LCD
CLR Epin
SETB RSpin
RET

;-----------------------------------;
; SHIFT DISPLAY DIRECTION           ;
;-----------------------------------;
SHIFT_DIRECTION:
clr R_WPin
ANL LCDPORT,#00011111B    ; BIT 3=> 1=DISPLAY SHIFT,   0=CURSOR MOVE
                          ; BIT 2=> 1=RIGHT   SHIFT,   0=LEFT SHIFT

SETB EPin                 ; WRITE MODE
CLR RSPin
ACALL WAIT_LCD
CLR EPin


MOV A,LCDPORT
ANL A,#00001111B
ORL A,#00000000B

MOV LCDPORT,A
SETB EPin
ACALL WAIT_LCD
CLR EPin
SETB RSPin
RET

;---------------------------------------------------------;
; CONFIG_LCD                                              ;
; SET CONFIGURATION EITHER 8 OR 4 BIT                     ;
; 2 OR 1 LINE , 5X10 OR 5X7                               ;
;---------------------------------------------------------;
CONFIG_LCD:
clr R_WPin
CLR  RSpin              ; LOW RS

MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#00100000B
MOV LCDPORT,ACC         ; DB7=0
                        ; DB6=0
                        ; DB5=1
                        ; DB4=0
SETB EPin               ;Enable
ACALL WAIT_LCD
CLR Epin

                        ; BIT 4=> 1=8 BIT  0=4BIT
                        ; BIT 3=> 1=2 LINE 0=1 LINE
                        ; BIT 2=> 1=5X10   0=5X7

; CONFIGURATION SET 4 BIT, 2 LINE & 5X7 DOTS


MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#00100000B
MOV LCDPORT,ACC
                        ; DB7=0
                        ; DB6=0
                        ; DB5=1
                        ; DB4=0

SETB EPIN
ACALL WAIT_LCD
CLR Epin

MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#10000000B
MOV LCDPORT,ACC
                        ; DB7=1     NO. OF LINES
                        ; DB6=0     FONT
                        ; DB5=0
                        ; DB4=0
SETB EPin
ACALL WAIT_LCD
CLR Epin                ;ENABLE  LOW
SETB RSpin              ;HIGH RS
RET
;-----------------------------------------------------------
;DISPLAY ON/OFF CURSOR BLINK
;-----------------------------------------------------------
DISPLAY_CONFIG:
clr R_WPin
MOV A,LCDPORT
ANL A,#00001111B        ; DB7=0     DISPLAY ON
                        ; DB6=0
                        ; DB5=0
                        ; DB4=0
                        ; BIT2=> 1=DISPLAY ON    0=DISPLAY OFF
                        ; BIT1=> 1=CURSOR ON     0=CURSOR OFF
                        ; BIT0=> 1=BLINK         0=NO BLINK
MOV LCDPORT,A
SETB Epin
CLR RSpin                ;LOW RS
ACALL WAIT_LCD
CLR Epin


MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#11100000B
MOV LCDPORT,ACC
SETB Epin
                        ; DB7=1
                        ; DB6=1
                        ; DB5=1
                        ; DB4=0
ACALL WAIT_LCD
CLR Epin                ;LOW E
SETB RSpin              ;HI RS
RET
;-----------------------------------------------------------------
;ENTRY_MODE_SET
                        ; BIT 1=> 0=CURSOR DEC,        1=CURSOR INC
                        ; BIT 0=> 1=DISPLAY SHIFT,     0=NO SHIFT
;-----------------------------------------------------------------
ENTRY_MODE_SET:

clr R_WPin
MOV A,LCDPORT
ANL A,#00001111B        ; DB7=0     ENTRY MODE SET
                        ; DB6=0
                        ; DB5=0
                        ; DB4=0

MOV LCDPORT,A
SETB Epin               ; ENABLE HI
CLR RSpin               ; LOW RS
ACALL WAIT_LCD
CLR Epin



MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#01100000B
MOV LCDPORT,ACC
SETB Epin
                        ; DB7=0
                        ; DB6=1       ;Always 1
                        ; DB5=1       ;1=increment 0=dec
                        ; DB4=0       ;1=display is shifted 0=not shifted
ACALL WAIT_LCD
CLR Epin                ;ENABLE
SETB RSpin              ;HIGH RS
RET


;-----------------------------------------------------------
;CURSOR_SET
;-----------------------------------------------------------
CURSOR_SET:

clr R_WPin
MOV A,LCDPORT
ANL ACC,#00001111B      ; DB7=0     DISPLAY ON
ORL ACC,#00010000B      ; DB6=0
                        ; DB5=0
                        ; DB4=1
                        ; BIT3=> 1=S             0=C
                        ; BIT2=> 1=RIGHT         0=LEFT
                        ; BIT1=> *
                        ; BIT0=> *
MOV LCDPORT,A
SETB Epin
CLR RSpin                ;LOW RS
ACALL WAIT_LCD
CLR Epin



MOV ACC,LCDPORT
ANL ACC,#00001111B
ORL ACC,#01000000B
SETB Epin
MOV LCDPORT,ACC
                        ; DB7=0
                        ; DB6=1
                        ; DB5=0
                        ; DB4=0
ACALL WAIT_LCD
CLR Epin                ;LOW E
SETB RSpin              ;HI RS
RET



;-------------------------------------;
; SET CG RAM ADDRESS                  ;
; CORESPONDS TO CURSOR ADDRESS        ;
; CALL WITH NUMBER IN ACCUMULATOR     ;
; RANGE IS 0 TO 63                    ;
; PUT ADDRESS IN ACCUMULATOR          ;
;-------------------------------------;
clr R_WPin
ORL A,#40H                ; SET BIT 6

ANL LCDPORT,A
SETB Epin                 ; WRITE MODE
ACALL WAIT_LCD
CLR EPIN
RET

;-------------------------------------;
; SET DD RAM ADDRESS                  ;
; CORESPONDS TO CURSOR ADDRESS        ;
; CALL WITH NUMBER IN ACCUMULATOR     ;
; RANGE IS 0 TO 127                   ;
; PUT ADDRESS IN ACCUMULATOR          ;
;-------------------------------------;
SET_DD_RAM:

clr R_WPin
MOV TEMP,A              ;SAVE NUMBER IN TEMP
ANL A,#11110000B        ;ZERO LOW NIBBLE
MOV R0,A                ;SAVE ACCU IN R0
MOV A,TEMP
SWAP A                  ;Swap Nibble
ANL A,#11110000B        ;ZERO LOW NIBBLE
MOV R1,A

MOV A,LCDPORT
ANL A,#00001111B
ADD A,R0
MOV LCDPORT,A
ORL LCDPORT,#10000000B  ; DB7=1
                        ; DB6=0
                        ; DB5=0
                        ; DB4=0
SETB Epin
CLR RSpin               ;LOW RS
ACALL WAIT_LCD
CLR Epin


MOV ACC,LCDPORT
ANL ACC,#00001111B
ADD A,R1
MOV LCDPORT,ACC        ;R1=ADDRESS in high nibble
SETB Epin
ACALL WAIT_LCD
CLR Epin                ;LOW E
SETB RSpin              ;HI RS
RET
;---------------------------------|
SECOND_LINE:     ;                |
;---------------------------------|
MOV A,#40h              ;Second Line
LCALL SET_DD_RAM
RET

;-------------------------------------------------------------

;---------------------------------;
;WAIT FOR BUSY FLAG               ;
;---------------------------------;

WAIT_LCD:
PUSH B
PUSH ACC
MOV A,#12
LOOP_DELAY22:
MOV B,#255
LOOP_DELAY11:
NOP
NOP
NOP
NOP
NOP
NOP
NOP
NOP
NOP
DJNZ B,LOOP_DELAY11
DJNZ ACC,LOOP_DELAY22

POP ACC
POP B
RET

;-----------------------------------;
; READ DATA                         ;
; DATA OUTPUT IS PLACED IN          ;
; ACCUMULATOR A                     ;
; ----------------------------------;


MOV LCDPORT,#0FFH              ;PREPARE PORT 0 FOR READ
SETB Epin                 ;ENABLE,WRITE,RS HIGH
SETB RSPin
MOV ACC,LCDPORT                ;READ PORT
ACALL WAIT_LCD
CLR Epin
CLR RSPin
RET
;------------------------------------------
;-------------------------;
;DISPLAY_STRING           ;
;FIRST POINT DPTR TO START;
; OF STRING AND STRING    ;
; MUST TERMINATE WITH 0   ;
;-------------------------;
DISPLAY_STRING:
MOV A,#0

LOOP_STRING:
PUSH ACC
MOVC A,@A+DPTR
CJNE A,#0,DISPLAY_MSG   ;CHECK IF CHARACTER = 0
JMP DISPLAY_END
DISPLAY_MSG:
LCALL WRITE_LCD
POP ACC
INC ACC
SJMP LOOP_STRING
DISPLAY_END:
POP ACC
RET
;-------------------------------------------
;----------------------|-
;WRITE SINGLE CHARACTER|
;IN LCD USING 4 BIT    |
;INTERFACE             |
;----------------------|-


WRITE_LCD:              ;CHARACTER IN ACCUMULATOR
clr R_WPin

MOV R0,A                ;SAVE CHARACTER IN R0
ANL A,#11110000B        ;ZERO LOW NIBBLE
MOV R1,A                ;Save in R1


MOV A,LCDPORT
ANL A,#00001111B
ADD A,R1                ;Strobe High Nibble
MOV LCDPORT,A
SETB Epin               ;E HI
SETB RSpin               ;RS HIGH
ACALL WAIT_LCD
CLR Epin                ;E LOW
CLR RSpin               ;RS LOW

MOV A,R0
ANL A,#00001111B        ;ZERO HI NIBBLE
SWAP A                  ;Swap Nibbles
MOV R1,A


MOV A,LCDPORT
ANL A,#00001111B
ADD A,R1                ;
MOV LCDPORT,A
SETB Epin               ;E HI
SETB RSpin              ;RS HIGH
ACALL WAIT_LCD
CLR Epin                ;E LOW
CLR RSpin               ;RS LOW

RET

;--------------------------------------------------------------
;BCD2BIN     ROUTINE TO CONVERT BCD NO. TO BINARY
; PUT NO. IN ACCUMULATOR --RESULT IN ACCUMULATOR
;--------------------------------------------------------------
BCD2BIN:


MOV R1,A         ;SAVE NUMBER IN R1
ANL A,#11110000B ;ZERO LOWER NIBBLE

MOV R0,#4
BCD2BIN_LOOP:
RR A
DJNZ R0,BCD2BIN_LOOP

MOV B,#10
MUL AB
MOV R0,A        ;SAVE PRODUCT

MOV A,R1        ;RECALL NUMBER
ANL A,#00001111B
ADD A,R0


RET

;===============================================================
; subroutine BINASC
; binasc takes the contents of the accumulator and converts it
; into two ascii hex numbers.  the result is returned in the
; accumulator and R2.
;===============================================================
BINASC:
   mov   r2, a            ; save in r2
   anl   a,  #0fh         ; convert least sig digit.
   add   a,  #0f6h        ; adjust it
   jnc   noadj1           ; if a-f then readjust
   add   a,  #07h
NOADJ1:
   add   a,  #3ah         ; make ascii
   xch   a,  r2           ; put result in reg 2
   swap  a                ; convert most sig digit
   anl   a,  #0fh         ; look at least sig half of acc
   add   a,  #0f6h        ; adjust it
   jnc   noadj2           ; if a-f then re-adjust
   add   a,  #07h
NOADJ2:
   add   a,  #3ah         ; make ascii
   ret

;===============================================================
; subroutine ASCBIN
; this routine takes the ascii character passed to it in the
; acc and converts it to a 4 bit binary number which is returned
; in the acc.
;===============================================================
ASCBIN:
 ;  clr   errorf
   add   a,  #0d0h        ; if chr < 30 then error
   jnc   notnum
   clr   c                ; check if chr is 0-9
   add   a,  #0f6h        ; adjust it
   jc    hextry           ; jmp if chr not 0-9
   add   a,  #0ah         ; if it is then adjust it
   ret
HEXTRY:
   clr   acc.5            ; convert to upper
   clr   c                ; check if chr is a-f
   add   a,  #0f9h        ; adjust it
   jnc   notnum           ; if not a-f then error
   clr   c                ; see if char is 46 or less.
   add   a,  #0fah        ; adjust acc
   jc    notnum           ; if carry then not hex
   anl   a,  #0fh         ; clear unused bits
   ret
NOTNUM:
ret
;   setb  errorf           ; if not a valid digit
;   ljmp  endloop

;=========================
SCANKEYPAD:                 ;Keypressed In Accumulator
CLR EPin
mov KEYPADPort, #00001111b  ;Make COL 1,2,3 =LOW
KEY_UP:                     ;P3.0-3.3 as Input
LCALL DELAY_20MS
MOV a,KEYPADPORT
ANL a,#0Fh
CJNE a,#0Fh,KEY_DOWN
JMP KEY_UP
KEY_DOWN:
LCALL DELAY_20MS
MOV KEYPADPort,#11101111b  ;Make Column 1 = LOW
MOV A,KEYPADPort
ANL A,#0Fh
CJNE A,#0Fh,COLUMN_1
MOV KEYPADPort,#11011111b  ;Make Column 2 = LOW
MOV A,KEYPADPort
ANL A,#0Fh
CJNE A,#0Fh,COLUMN_2
MOV KEYPADPort,#10111111b  ;Make Column 3 = LOW
MOV A,KEYPADPort
ANL A,#0Fh
CJNE A,#0Fh,COLUMN_3
JMP KEY_UP
COLUMN_1:
SETB C
MOV Index,#0
ROTATE_COL_1:
RRC A
JNC CODE_COL_1
INC Index
jmp ROTATE_COL_1
CODE_COL_1:
MOV DPTR,#COL_1
MOV a,Index
MOVC A,@A+DPTR
jmp EXIT_KEY
COLUMN_2:
SETB C
MOV Index,#0
ROTATE_COL_2:
RRC A
JNC CODE_COL_2
INC Index
jmp ROTATE_COL_2
CODE_COL_2:
MOV DPTR,#COL_2
MOV a,Index
MOVC A,@A+DPTR
jmp EXIT_KEY

COLUMN_3:
SETB C
MOV Index,#0
ROTATE_COL_3:
RRC A
JNC CODE_COL_3
INC Index
jmp ROTATE_COL_3
CODE_COL_3:
MOV DPTR,#COL_3
MOV a,Index
MOVC A,@A+DPTR

EXIT_KEY:
PUSH ACC
WAIT_KEY_UP:
MOV A,KEYPADPort
ANL A,#0FH
CJNE A,#0Fh,WAIT_KEY_UP
POP ACC
RET

;----------------------------------------------------------------
DELAY_20MS:
                ;set up Timer 1
MOV TMOD,#10h
MOV TH1,#High(TimerValue20ms)
MOV TL1,#LOW(TimerValue20ms)
CLR TF1
CLR PT1                ;LOW Priority
CLR ET1                ;Disable Timer Int.

setb TR1               ;Run Timer 1

jnb TF1,$
ret
;--------------------------------------------
ie0vec:
reti

ie1vec:
reti

t1vec:
reti

t0vec:
reti

servec:
reti

;--------------------------------------
DELAY:

mov DELAYCOUNTER3,#14
LOOP3:
mov DELAYCOUNTER2,#255
LOOP2:
mov DELAYCOUNTER1,#255
LOOP1:
djnz DELAYCOUNTER1,LOOP1
djnz DELAYCOUNTER2,LOOP2
djnz DELAYCOUNTER3,LOOP3

ret
;---------TEST ROUTINES--------------------
N7400:

                ;Setup Test Conditions
MOV P0,#00100000B       ;SET PIN AS INPUT   00
MOV P1,#00010011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT00         ;CHECK IF OVERCURRENT
MOV A,P0
ANL A,#00100000B
CJNE A,#00100000B,DEVICE00_FAIL
MOV A,P1
ANL A,#10010011B
CJNE A,#10010011B,DEVICE00_FAIL
MOV P0,#10110000B      ; 01

MOV P1,#11011011B      ; 01
MOV A,P0
ANL A,#00100000B
CJNE A,#00100000B,DEVICE00_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00010011B,DEVICE00_FAIL
MOV P0,#01101000B      ;10
MOV P1,#10110111B      ;10
MOV A,P0
ANL A,#00100000B
CJNE A,#00100000B,DEVICE00_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00010011B,DEVICE00_FAIL
MOV P0,#11111000B      ;11
MOV P1,#11111111B      ;11
MOV A,P0
ANL A,#00100000B
CJNE A,#00000000B,DEVICE00_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00000000B,DEVICE00_FAIL
LCALL PASSED
SETB SWITCH3
RET

DEVICE00_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT00:
LCALL OVERCURRENT
RET

;------------------------------------------
N7401:
                ;Setup Test Conditions
MOV P0,#01001000B       ;SET PIN AS INPUT   00
MOV P1,#01001000B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT01         ;CHECK IF OVERCURRENT
MOV A,P0
ANL A,#01001000B
CJNE A,#01001000B,DEVICE01_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#01001000B,DEVICE01_FAIL
MOV P0,#01101000B      ; 01
MOV P1,#11101101B      ; 01
MOV A,P0
ANL A,#01001000B
CJNE A,#01001000B,DEVICE01_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#01001000B,DEVICE01_FAIL
MOV P0,#11011000B      ;10
MOV P1,#11011010B      ;10
MOV A,P0
ANL A,#01001000B
CJNE A,#01001000B,DEVICE01_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#01001000B,DEVICE01_FAIL
MOV P0,#11111000B      ;11
MOV P1,#11111111B      ;11
MOV A,P0
ANL A,#01001000B
CJNE A,#00000000B,DEVICE01_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#00000000B,DEVICE01_FAIL
LCALL PASSED
SETB SWITCH3
RET
DEVICE01_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT01:
LCALL OVERCURRENT
RET
;------------------------------------------
N7402:
                ;Setup Test Conditions
MOV P0,#01001000B       ;SET  PIN AS INPUT   00
MOV P1,#01001000B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT02         ;CHECK IF OVERCURRENT
MOV A,P0
ANL A,#01001000B
CJNE A,#01001000B,DEVICE02_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#01001000B,DEVICE02_FAIL
MOV P0,#01101000B      ; 01
MOV P1,#11101101B      ; 01
MOV A,P0
ANL A,#01001000B
CJNE A,#00000000B,DEVICE02_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#00000000B,DEVICE02_FAIL
MOV P0,#11011000B      ;10
MOV P1,#11011010B      ;10
MOV A,P0
ANL A,#01001000B
CJNE A,#00000000B,DEVICE02_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#00000000B,DEVICE02_FAIL
MOV P0,#11111000B      ;11
MOV P1,#11111111B      ;11
MOV A,P0
ANL A,#01001000B
CJNE A,#00000000B,DEVICE02_FAIL
MOV A,P1
ANL A,#01001000B
CJNE A,#00000000B,DEVICE02_FAIL
LCALL PASSED
SETB SWITCH3
RET
DEVICE02_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT02:
LCALL OVERCURRENT
RET
;------------------------------------------
N7403:
LCALL N7400
RET
;------------------------------------------
N7404:
                        ;Setup Test Conditions
MOV P0,#01010000B       ;SET AS INPUT   0
MOV P1,#00101011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT04         ;CHECK IF OVERCURRENT
MOV A,P0
ANL A,#01010000B
CJNE A,#01010000B,DEVICE04_FAIL
MOV A,P1
ANL A,#00101011B
CJNE A,#00101011B,DEVICE04_FAIL
MOV P0,#11111000B       ;SET ONE PIN AS INPUT   1
MOV P1,#11111111B       ;SET CORRESPONDING PIN
MOV A,P0
ANL A,#01010000B
CJNE A,#00000000B,DEVICE04_FAIL
MOV A,P1
ANL A,#00101011B
CJNE A,#00000000B,DEVICE04_FAIL
LCALL PASSED
SETB SWITCH3
RET
DEVICE04_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT04:
LCALL OVERCURRENT
RET
;------------------------------------------
N7405:
LCALL N7404
RET
;------------------------------------------
N7406:
LCALL N7404
RET
;------------------------------------------
N7407:
                        ;Setup Test Conditions
MOV P0,#01010000B       ;SET AS INPUT   0
MOV P1,#00101011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT07         ;CHECK IF OVERCURRENT
MOV A,P0
ANL A,#01010000B
CJNE A,#00000000B,DEVICE07_FAIL
MOV A,P1
ANL A,#00101011B
CJNE A,#00000000B,DEVICE07_FAIL
MOV P0,#11111000B       ;SET ONE PIN AS INPUT   1
MOV P1,#11111111B       ;SET CORRESPONDING PIN
MOV A,P0
ANL A,#01010000B
CJNE A,#01010000B,DEVICE07_FAIL
MOV A,P1
ANL A,#00101011B
CJNE A,#00101011B,DEVICE07_FAIL
LCALL PASSED
SETB SWITCH3
RET
DEVICE07_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT07:
LCALL OVERCURRENT
RET
;------------------------------------------
N7408:
                ;Setup Test Conditions
MOV P0,#00100000B       ;SET  PIN AS INPUT   00
MOV P1,#00010011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT08         ;CHECK IF OVERCURRENT
MOV A,P0
ANL A,#00100000B
CJNE A,#00000000B,DEVICE08_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00000000B,DEVICE08_FAIL

MOV P0,#10110000B      ; 01
MOV P1,#11011011B      ; 01
MOV A,P0
ANL A,#00100000B
CJNE A,#00000000B,DEVICE08_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00000000B,DEVICE08_FAIL

MOV P0,#01101000B      ;10
MOV P1,#10110111B      ;10
MOV A,P0
ANL A,#00100000B
CJNE A,#00000000B,DEVICE08_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00000000B,DEVICE08_FAIL

MOV P0,#11111000B      ;11
MOV P1,#11111111B      ;11
MOV A,P0
ANL A,#00100000B
CJNE A,#00100000B,DEVICE08_FAIL
MOV A,P1
ANL A,#10010011B
CJNE A,#10010011B,DEVICE08_FAIL
LCALL PASSED
SETB SWITCH3
RET
DEVICE08_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT08:
LCALL OVERCURRENT
RET
;------------------------------------------
N7409:
LCALL N7408
RET
;------------------------------------------
N7410:
                ;Setup Test Conditions
MOV P0,#00000000B       ;SET PIN AS INPUT  000
MOV P1,#00100011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT10 ;CHECK IF OVERCURRENT
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE10NEAR_FAIL

MOV P0,#10000000B       ;SET PIN AS INPUT  001
MOV P1,#11110011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE10NEAR_FAIL

JMP PROCEED10

DEVICE10NEAR_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT10:
LCALL OVERCURRENT
RET

PROCEED10:


MOV P0,#01010000B       ;SET PIN AS INPUT  010
MOV P1,#10101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE10_FAIL

MOV P0,#11010000B       ;SET PIN AS INPUT  011
MOV P1,#11111011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE10_FAIL

MOV P0,#00101000B       ;SET PIN AS INPUT  100
MOV P1,#10100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE10_FAIL

MOV P0,#10101000B       ;SET PIN AS INPUT  101
MOV P1,#11110111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE10_FAIL

MOV P0,#01111000B       ;SET PIN AS INPUT  110
MOV P1,#10101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE10_FAIL

MOV P0,#11111000B       ;SET PIN AS INPUT  111
MOV P1,#11111111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE10_FAIL

LCALL PASSED
SETB SWITCH3
RET
DEVICE10_FAIL:
LCALL FAILED
SETB SWITCH3
RET
;------------------------------------------
N7413:
                ;Setup Test Conditions
MOV P0,#00000000B       ;SET PIN AS INPUT  0000
MOV P1,#00000011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT13 ;CHECK IF OVERCURRENT

JMP PROCEED13

OVERCURRENT13:
LCALL OVERCURRENT
RET

PROCEED13:

MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_NEAR_FAIL

MOV P0,#10000000B       ;SET PIN AS INPUT  0001
MOV P1,#11000011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_NEAR_FAIL

MOV P0,#01000000B       ;SET PIN AS INPUT  0010
MOV P1,#10100011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_NEAR_FAIL

MOV P0,#11000000B       ;SET PIN AS INPUT  0011
MOV P1,#11100011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_NEAR_FAIL

MOV P0,#00010000B       ;SET PIN AS INPUT  0100
MOV P1,#10001011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_NEAR_FAIL

MOV P0,#10010000B       ;SET PIN AS INPUT  0101
MOV P1,#11001011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_NEAR_FAIL

JMP PROCEED13_NEAR

DEVICE13_NEAR_FAIL:
LCALL FAILED
SETB SWITCH3
RET

PROCEED13_NEAR:


MOV P0,#01010000B       ;SET PIN AS INPUT  0110
MOV P1,#10101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#11010000B       ;SET PIN AS INPUT  0111
MOV P1,#11101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#00001000B       ;SET PIN AS INPUT  1000
MOV P1,#10000111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#10001000B       ;SET PIN AS INPUT  1001
MOV P1,#11000111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#01001000B       ;SET PIN AS INPUT  1010
MOV P1,#10100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#11001000B       ;SET PIN AS INPUT  1011
MOV P1,#11100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#00011000B       ;SET PIN AS INPUT  1100
MOV P1,#10001111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#10011000B       ;SET PIN AS INPUT  1101
MOV P1,#11001111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#01011000B       ;SET PIN AS INPUT  1110
MOV P1,#10101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE13_FAIL

MOV P0,#11011000B       ;SET PIN AS INPUT  1111
MOV P1,#11101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE13_FAIL

LCALL PASSED
SETB SWITCH3
RET
DEVICE13_FAIL:
LCALL FAILED
SETB SWITCH3
RET

;------------------------------------------
N7414:
LCALL N7404
RET
;------------------------------------------
N7416:
LCALL N7404
RET
;------------------------------------------
N7417:
LCALL N7404
RET
;------------------------------------------
N7420:
LCALL N7413
RET
;------------------------------------------
N7421:
                ;Setup Test Conditions
MOV P0,#00000000B       ;SET PIN AS INPUT  0000
MOV P1,#00000011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT21 ;CHECK IF OVERCURRENT

JMP PROCEED21

OVERCURRENT21:
LCALL OVERCURRENT
RET

PROCEED21:

MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_NEAR_FAIL

MOV P0,#10000000B       ;SET PIN AS INPUT  0001
MOV P1,#11000011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_NEAR_FAIL

MOV P0,#01000000B       ;SET PIN AS INPUT  0010
MOV P1,#10100011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_NEAR_FAIL

MOV P0,#11000000B       ;SET PIN AS INPUT  0011
MOV P1,#11100011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_NEAR_FAIL

MOV P0,#00010000B       ;SET PIN AS INPUT  0100
MOV P1,#10001011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_NEAR_FAIL

MOV P0,#10010000B       ;SET PIN AS INPUT  0101
MOV P1,#11001011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_NEAR_FAIL

JMP PROCEED21_NEAR

DEVICE21_NEAR_FAIL:
LCALL FAILED
SETB SWITCH3
RET

PROCEED21_NEAR:


MOV P0,#01010000B       ;SET PIN AS INPUT  0110
MOV P1,#10101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#11010000B       ;SET PIN AS INPUT  0111
MOV P1,#11101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL
MOV P0,#00001000B       ;SET PIN AS INPUT  1000
MOV P1,#10000111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#10001000B       ;SET PIN AS INPUT  1001
MOV P1,#11000111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#01001000B       ;SET PIN AS INPUT  1010
MOV P1,#10100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#11001000B       ;SET PIN AS INPUT  1011
MOV P1,#11100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#00011000B       ;SET PIN AS INPUT  1100
MOV P1,#10001111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#10011000B       ;SET PIN AS INPUT  1101
MOV P1,#11001111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#01011000B       ;SET PIN AS INPUT  1110
MOV P1,#10101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE21_FAIL

MOV P0,#11011000B       ;SET PIN AS INPUT  1111
MOV P1,#11101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE21_FAIL

LCALL PASSED
SETB SWITCH3
RET
DEVICE21_FAIL:
LCALL FAILED
SETB SWITCH3
RET
;------------------------------------------
N7425:
                ;Setup Test Conditions
MOV P0,#00000000B       ;SET PIN AS INPUT  0000 G0
MOV P1,#00000011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT25 ;CHECK IF OVERCURRENT

JMP PROCEED25

OVERCURRENT25:
LCALL OVERCURRENT
RET

PROCEED25:

MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_NEAR_FAIL_G0

MOV P0,#10000000B       ;SET PIN AS INPUT  0001 G0
MOV P1,#11000011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_NEAR_FAIL_G0

MOV P0,#01000000B       ;SET PIN AS INPUT  0010
MOV P1,#10100011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_NEAR_FAIL_G0

MOV P0,#11000000B       ;SET PIN AS INPUT  0011
MOV P1,#11100011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_NEAR_FAIL_G0

MOV P0,#00010000B       ;SET PIN AS INPUT  0100
MOV P1,#10001011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_NEAR_FAIL_G0

MOV P0,#10010000B       ;SET PIN AS INPUT  0101
MOV P1,#11001011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_NEAR_FAIL_G0

JMP PROCEED25_NEAR_G0

DEVICE25_NEAR_FAIL_G0:
LCALL FAILED
SETB SWITCH3
RET

PROCEED25_NEAR_G0:


MOV P0,#01010000B       ;SET PIN AS INPUT  0110
MOV P1,#10101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#11010000B       ;SET PIN AS INPUT  0111
MOV P1,#11101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#00001000B       ;SET PIN AS INPUT  1000
MOV P1,#10000111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#10001000B       ;SET PIN AS INPUT  1001
MOV P1,#11000111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#01001000B       ;SET PIN AS INPUT  1010
MOV P1,#10100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#11001000B       ;SET PIN AS INPUT  1011
MOV P1,#11100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#00011000B       ;SET PIN AS INPUT  1100
MOV P1,#10001111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#10011000B       ;SET PIN AS INPUT  1101
MOV P1,#11001111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#01011000B       ;SET PIN AS INPUT  1110
MOV P1,#10101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

MOV P0,#11011000B       ;SET PIN AS INPUT  1111
MOV P1,#11101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_FAIL_G0

JMP PROCEED25_G1

DEVICE25_FAIL_G0:
LCALL FAILED
SETB SWITCH3
RET

PROCEED25_G1:

MOV P0,#00100000B       ;SET PIN AS INPUT  0000
MOV P1,#10010011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000011B,DEVICE25_NEAR_FAIL_G1

MOV P0,#10100000B       ;SET PIN AS INPUT  0001
MOV P1,#11010011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_NEAR_FAIL_G1

MOV P0,#01100000B       ;SET PIN AS INPUT  0010
MOV P1,#10110011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_NEAR_FAIL_G1

MOV P0,#11100000B       ;SET PIN AS INPUT  0011
MOV P1,#11110011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_NEAR_FAIL_G1

MOV P0,#00110000B       ;SET PIN AS INPUT  0100
MOV P1,#10011011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_NEAR_FAIL_G1

MOV P0,#10110000B       ;SET PIN AS INPUT  0101
MOV P1,#11011011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_NEAR_FAIL_G1

JMP PROCEED25_NEAR_G1

DEVICE25_NEAR_FAIL_G1:
LCALL FAILED
SETB SWITCH3
RET

PROCEED25_NEAR_G1:

MOV P0,#01110000B       ;SET PIN AS INPUT  0110
MOV P1,#10111011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#11110000B       ;SET PIN AS INPUT  0111
MOV P1,#11111011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1
MOV P0,#00101000B       ;SET PIN AS INPUT  1000
MOV P1,#10010111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#10101000B       ;SET PIN AS INPUT  1001
MOV P1,#11010111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#01101000B       ;SET PIN AS INPUT  1010
MOV P1,#10110111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#11101000B       ;SET PIN AS INPUT  1011
MOV P1,#11110111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#00111000B       ;SET PIN AS INPUT  1100
MOV P1,#10011111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#10111000B       ;SET PIN AS INPUT  1101
MOV P1,#11011111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#01111000B       ;SET PIN AS INPUT  1110
MOV P1,#10111111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

MOV P0,#11111000B       ;SET PIN AS INPUT  1111
MOV P1,#11111111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00000011B
CJNE A,#00000000B,DEVICE25_FAIL_G1

LCALL PASSED
SETB SWITCH3
RET
DEVICE25_FAIL_G1:
LCALL FAILED
SETB SWITCH3
RET

;------------------------------------------
N7426:
LCALL N7400
RET
;------------------------------------------
N7427:
                ;Setup Test Conditions
MOV P0,#00000000B       ;SET PIN AS INPUT  000
MOV P1,#00100011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT27 ;CHECK IF OVERCURRENT
MOV A,P1
ANL A,#00100011B
CJNE A,#00100011B,DEVICE27NEAR_FAIL

MOV P0,#10000000B       ;SET PIN AS INPUT  001
MOV P1,#11110011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE27NEAR_FAIL

JMP PROCEED27

DEVICE27NEAR_FAIL:
LCALL FAILED
SETB SWITCH3
RET
OVERCURRENT27:
LCALL OVERCURRENT
RET

PROCEED27:


MOV P0,#01010000B       ;SET PIN AS INPUT  010
MOV P1,#10101011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE27_FAIL

MOV P0,#11010000B       ;SET PIN AS INPUT  011
MOV P1,#11111011B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE27_FAIL

MOV P0,#00101000B       ;SET PIN AS INPUT  100
MOV P1,#10100111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE27_FAIL

MOV P0,#10101000B       ;SET PIN AS INPUT  101
MOV P1,#11110111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE27_FAIL

MOV P0,#01111000B       ;SET PIN AS INPUT  110
MOV P1,#10101111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE27_FAIL

MOV P0,#11111000B       ;SET PIN AS INPUT  111
MOV P1,#11111111B       ;SET CORRESPONDING PIN
MOV A,P1
ANL A,#00100011B
CJNE A,#00000000B,DEVICE27_FAIL

LCALL PASSED
SETB SWITCH3
RET
DEVICE27_FAIL:
LCALL FAILED
SETB SWITCH3
RET
;------------------------------------------
N7430:
                       ;Setup Test Conditions


MOV COUNTER,#0
LCALL FORMAT_30
LCALL INSERT
SETB P1.7               ;TURN ON W/ Vcc
CLR SWITCH3             ;TURN ON VCC
JNB DETECT,OK_30        ;CHECK IF OVERCURRENT
LCALL OVERCURRENT
RET

OK_30:

LOOP_30:
LCALL FORMAT_30
JNB P1.1,DEVICE_FAIL_30
INC COUNTER
MOV A,COUNTER
CJNE A,#254,LOOP_30

INC COUNTER
LCALL FORMAT_30
JB P1.1,DEVICE_FAIL_30
LCALL PASSED
RET

DEVICE_FAIL_30:
LCALL FAILED
RET

FORMAT_30:
MOV A,COUNTER
MOV C,ACC.7
MOV P0.3,C
MOV C,ACC.6
MOV P0.4,C
MOV C,ACC.5
MOV P0.5,C
MOV C,ACC.4
MOV P0.6,C
MOV C,ACC.3
MOV P0.7,C
MOV C,ACC.2
MOV P1.0,C
MOV C,ACC.1
MOV P1.4,C
MOV C,ACC.0
MOV P1.5,C
RET
;------------------------------------------
N7432:

                ;Setup Test Conditions
MOV P0,#00100000B       ;SET ONE PIN AS INPUT   00
MOV P1,#00010011B       ;SET CORRESPONDING PIN
LCALL INSERT
setb P1.7
CLR SWITCH3             ;TURN ON VCC
JB DETECT,OVERCURRENT32         ;CHECK IF OVERCURRENT
MOV A,P0
ANL A,#0010000B
CJNE A,#00000000B,DEVICE32_FAIL
MOV A,P1
ANL A,#10010011B
CJNE A,#10000000B,DEVICE32_FAIL
MOV P0,#10110000B      ; 01
MOV P1,#11011011B      ; 01
MOV A,P0
ANL A,#00100000B
CJNE A,#00100000B,DEVICE32_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00010011B,DEVICE32_FAIL
MOV P0,#01101000B      ;10
MOV P1,#10110111B      ;10
MOV A,P0
ANL A,#00100000B
CJNE A,#00100000B,DEVICE32_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00010011B,DEVICE32_FAIL
MOV P0,#11111000B      ;11
MOV P1,#11111111B      ;11
MOV A,P0
ANL A,#00100000B
CJNE A,#00100000B,DEVICE32_FAIL
MOV A,P1
ANL A,#00010011B
CJNE A,#00010011B,DEVICE32_FAIL
LCALL PASSED
SETB SWITCH1
RET
DEVICE32_FAIL:
LCALL FAILED
SETB SWITCH1
RET
OVERCURRENT32:
LCALL OVERCURRENT
RET
;------------------------------------------
N7437:
LCALL N7400
RET
;------------------------------------------
N7438:
LCALL N7400
RET
;------------------------------------------
N7440:
                       ;Setup Test Conditions

MOV COUNTER,#0
LCALL FORMAT_40
LCALL INSERT
SETB P1.7               ;TURN ON W/ Vcc
CLR SWITCH3             ;TURN ON VCC
JNB DETECT,OK_40        ;CHECK IF OVERCURRENT
LCALL OVERCURRENT
RET

OK_40:

LOOP_40:
LCALL FORMAT_40
JNB P1.1,DEVICE_FAIL_40
JNB P1.0,DEVICE_FAIL_40
INC COUNTER
MOV A,COUNTER
CJNE A,#14,LOOP_40

INC COUNTER
LCALL FORMAT_40
JB P1.1,DEVICE_FAIL_40
JB P1.0,DEVICE_FAIL_40
LCALL PASSED
RET

DEVICE_FAIL_40:
LCALL FAILED
RET

FORMAT_40:
MOV A,COUNTER
MOV C,ACC.3
MOV P0.3,C
MOV P1.2,C
MOV C,ACC.2
MOV P0.4,C
MOV P1.3,C
MOV C,ACC.1
MOV P0.6,C
MOV P1.5,C
MOV C,ACC.0
MOV P0.7,C
MOV P1.6,C
RET

;------------------------------------------
N7442:
                       ;Setup Test Conditions

MOV P0,#0FFh
MOV P1,#0FFh
MOV SHIFTREG,#11111011B

MOV COUNTER,#0
LCALL FORMAT_42
LCALL INSERT
SETB P2.0               ;TURN ON W/ Vcc
CLR SWITCH2             ;TURN ON VCC
JNB DETECT,OK_42        ;CHECK IF OVERCURRENT
LCALL OVERCURRENT
RET

OK_42:

MOV A,P0
CJNE A,SHIFTREG,DEVICE_FAIL_42
INC COUNTER
LCALL FORMAT_42
MOV A,SHIFTREG
RL A
MOV SHIFTREG,A
MOV A,COUNTER
CJNE A,#5,OK_42

MOV SHIFTREG,#11111110B
INC COUNTER
LCALL FORMAT_42

LOOP_42:

MOV A,P1
ORL A,#11110000B
CJNE A,SHIFTREG,DEVICE_FAIL_42
INC COUNTER
LCALL FORMAT_42
MOV A,SHIFTREG
RL A
MOV SHIFTREG,A
MOV A,COUNTER
CJNE A,#9,LOOP_42

LCALL PASSED
RET

DEVICE_FAIL_42:
LCALL FAILED
RET


FORMAT_42:
MOV A,COUNTER
MOV C,ACC.3
MOV P1.4,C
MOV C,ACC.2
MOV P1.5,C
MOV C,ACC.1
MOV P1.6,C
MOV C,ACC.0
MOV P1.7,C
RET
;------------------------------------------
N7445:
LCALL N7442
RET
;------------------------------------------
N7451:

SETB P1.0               ;SET AS INPUT
SETB P1.1               ;SET AS INPUT
MOV COUNTER,#0
MOV COUNTER2,#0
LCALL FORMAT51_1        ;ADJUST PINS TO CORRECT LOGIC LEVEL
LCALL FORMAT51_2

LCALL INSERT
SETB P1.7               ;TURN ON W/ Vcc
CLR SWITCH3             ;TURN ON VCC
JNB DETECT,OK_51        ;CHECK IF OVERCURRENT
LCALL OVERCURRENT
RET

OK_51:

JNB P1.1,DEVICE_FAIL_51
INC COUNTER
LCALL FORMAT51_1
MOV A,COUNTER
CJNE A,#6,OK_51

INC COUNTER
LCALL FORMAT51_1
JB P1.1,DEVICE_FAIL_51

LOOP_51:

JNB P1.0,DEVICE_FAIL_51
INC COUNTER2
LCALL FORMAT51_2
MOV A,COUNTER2
CJNE A,#2,LOOP_51

INC COUNTER2
LCALL FORMAT51_2
JB P1.0,DEVICE_FAIL_51
LCALL PASSED
RET

DEVICE_FAIL_51:
LCALL FAILED
RET


FORMAT51_1:
MOV A,COUNTER
MOV C,ACC.2
MOV P0.3,C
MOV P1.2,C
MOV C,ACC.1
MOV P1.5,C
MOV P1.3,C
MOV C,ACC.0
MOV P1.6,C
MOV P1.4,C
RET

FORMAT51_2:
MOV A,COUNTER2
MOV C,ACC.1
MOV P0.6,C
MOV P0.4,C
MOV C,ACC.0
MOV P0.5,C
MOV P0.7,C
RET
;------------------------------------------
N7454:

SETB P1.0               ;SET AS INPUT
CLR C
MOV COUNTER,#0
MOV COUNTER2,#0
LCALL FORMAT54        ;ADJUST PINS TO CORRECT LOGIC LEVEL

LCALL INSERT
SETB P1.7               ;TURN ON W/ Vcc
CLR SWITCH3             ;TURN ON VCC
JNB DETECT,OK_54        ;CHECK IF OVERCURRENT
LCALL OVERCURRENT
RET

OK_54:
SETB C
ANL C,P0.3
ANL C,P0.4
JNC CHECK54_0_0
JB P1.0,DEVICE_FAIL_54

CHECK54_0_0:
SETB C
ANL C,P0.5
ANL C,P0.6
ANL C,P0.7
JNC CHECK54_0_1
JB P1.0,DEVICE_FAIL_54

CHECK54_0_1:
SETB C
ANL C,P1.2
ANL C,P1.3
ANL C,P1.4
JNC CHECK54_0_2
JB P1.0,DEVICE_FAIL_54
CHECK54_0_2:
SETB C
ANL C,P1.5
ANL C,P1.6
JNC CHECK54_0_3
JB P1.0,DEVICE_FAIL_54
CHECK54_0_3:

SETB C
ANL C,P0.3
ANL C,P0.4
JC EXIT_54

SETB C
ANL C,P0.5
ANL C,P0.6
ANL C,P0.7
JC EXIT_54

SETB C
ANL C,P1.2
ANL C,P1.3
ANL C,P1.4
JC EXIT_54
SETB C
ANL C,P1.5
ANL C,P1.6
JC EXIT_54
JNB P1.0,DEVICE_FAIL_54
EXIT_54:
MOV A,COUNTER
LCALL FORMAT54
INC COUNTER
MOV A,COUNTER
CJNE A,#255,OK_54

INC_COUNTER2:
INC COUNTER2
MOV A,COUNTER2
CJNE A,#00000010B,OK_54

INC COUNTER2
LCALL FORMAT54
JB P1.0,DEVICE_FAIL_54
LCALL PASSED
RET

DEVICE_FAIL_54:
LCALL FAILED
RET


FORMAT54:
MOV A,COUNTER
MOV C,ACC.0
MOV P0.3,C
MOV C,ACC.1
MOV P0.4,C
MOV C,ACC.2
MOV P0.5,C
MOV C,ACC.3
MOV P0.6,C
MOV C,ACC.4
MOV P0.7,C
MOV C,ACC.5
MOV P1.2,C
MOV C,ACC.6
MOV P1.3,C
MOV C,ACC.7
MOV P1.4,C
MOV A,COUNTER2
MOV C,ACC.0
MOV P1.5,C
MOV C,ACC.1
MOV P1.6,C
RET
;------------------------------------------
N7472:

CLR  P1.5               ;LOW CLOCK
CLR P0.4                ;/CLR
CLR P1.6                ;/PRESET
MOV COUNTER,#0
LCALL FORMAT_72
LCALL INSERT
SETB P1.7
CLR SWITCH3             ;TURN ON VCC
JNB DETECT,OK_72        ;CHECK IF OVERCURRENT
LCALL OVERCURRENT
RET

OK_72:
JNB P1.0,DEVICE_FAIL_72_NEAR
JNB P1.1,DEVICE_FAIL_72_NEAR

CLR P1.6                ;LOW /PRESET
SETB P0.4               ;HIGH /CLR

JB P1.0,DEVICE_FAIL_72_NEAR
JNB P1.1,DEVICE_FAIL_72_NEAR

SETB P1.6               ;HIGH /PRESET
CLR  P0.4               ;LOW  /CLR

JNB P1.0,DEVICE_FAIL_72_NEAR
JB P1.1,DEVICE_FAIL_72_NEAR

JMP PROCEED_72

DEVICE_FAIL_72_NEAR:
LCALL FAILED
RET

PROCEED_72:

SETB P1.6               ;HIGH /PRESET
SETB P0.4               ;HIGH /CLR


LOOP_72:

INC COUNTER
LCALL FORMAT_72

SETB C
ANL C,P0.7
ANL C,P0.6
ANL C,P0.5
JC JHIGH
                        ;J LOW
SETB C
ANL C,P1.4
ANL C,P1.3
ANL C,P1.2
JC JLOW_KHIGH           ;K LOW

JLOW_KLOW:              ;SAVE PREVIOUS STATE  (HOLD)
MOV C,P1.0              ;/Q
MOV FLAG,C
MOV C,P1.1              ; Q
MOV FLAG2,C

SETB P1.5               ;ONE CLOCK PULSE
CLR  P1.5
                        ;XOR = /a*b  + a*/b
CPL FLAG
MOV C,P1.0
ANL C,FLAG
MOV FLAG3,C             ;SAVE STATE

MOV C,P1.0
CPL C
CPL FLAG
ANL C,FLAG

ORL C,FLAG3             ;XOR FCN
JC DEVICE_FAIL_72

CPL FLAG2
MOV C,P1.1
ANL C,FLAG2
MOV FLAG3,C             ;SAVE STATE

MOV C,P1.1
CPL C
CPL FLAG2
ANL C,FLAG2

ORL C,FLAG3             ;XOR FCN
JC DEVICE_FAIL_72

JMP EXIT_72

JHIGH:
SETB C
ANL C,P1.4
ANL C,P1.3
ANL C,P1.2
JC JHIGH_KHIGH          ;K LOW

JHIGH_KLOW:             ;(SET)
SETB P1.5               ;ONE CLOCK PULSE
CLR  P1.5
JNB P1.1,DEVICE_FAIL_72
JB  P1.0,DEVICE_FAIL_72

JMP EXIT_72

JLOW_KHIGH:             ;(RESET)
SETB P1.5               ;ONE CLOCK PULSE
CLR  P1.5
JB P1.1,DEVICE_FAIL_72
JNB  P1.0,DEVICE_FAIL_72

JMP EXIT_72

JHIGH_KHIGH:            ;(TOGGLE)
MOV C,P1.0              ;/Q
MOV FLAG,C
MOV C,P1.1              ; Q
MOV FLAG2,C

SETB P1.5               ;ONE CLOCK PULSE
CLR  P1.5
                        ;XOR = /a*b  + a*/b
CPL FLAG
MOV C,P1.0
ANL C,FLAG
MOV FLAG3,C             ;SAVE STATE

MOV C,P1.0
CPL C
CPL FLAG
ANL C,FLAG

ORL C,FLAG3             ;XOR FCN
JNC DEVICE_FAIL_72

CPL FLAG2
MOV C,P1.1
ANL C,FLAG2
MOV FLAG3,C             ;SAVE STATE

MOV C,P1.1
CPL C
CPL FLAG2
ANL C,FLAG2

ORL C,FLAG3             ;XOR FCN
JNC DEVICE_FAIL_72

EXIT_72:

MOV A,COUNTER
CJNE A,#63,GOLOOP_72
JMP PASSED_72

GOLOOP_72:
JMP LOOP_72

PASSED_72:
LCALL PASSED
RET

DEVICE_FAIL_72:
LCALL FAILED
RET

FORMAT_72:
MOV A,COUNTER
MOV C,ACC.5
MOV P1.4,C
MOV C,ACC.4
MOV P1.3,C
MOV C,ACC.3
MOV P1.2,C
MOV C,ACC.2
MOV P0.7,C
MOV C,ACC.1
MOV P0.6,C
MOV C,ACC.0
MOV P0.5,C
RET
;------------------------------------------
N7473:          ;Pinout different as expected
RET
;------------------------------------------
N7474:

SETB P0.7       ;1Q
SETB P1.0       ;1/Q
SETB P1.1       ;2/Q
SETB P1.2       ;2Q
CLR  P0.3       ;LOW /1CLR
CLR  P0.6       ;LOW /1PRESET
CLR  P1.6       ;LOW /2CLR
CLR  P1.3       ;LOW /2PRESET
SETB P0.5       ;HIGH CLOCK
SETB P1.4       ;HIGH CLOCK
LCALL INSERT
SETB P1.7       ;SET AS HIGH W/ Vcc
CLR SWITCH3
JNB DETECT,OK_74
LCALL OVERCURRENT
RET

OK_74:
JNB P0.7,DEVICE_FAIL_74_NEAR
JNB P1.0,DEVICE_FAIL_74_NEAR
JNB P1.1,DEVICE_FAIL_74_NEAR
JNB P1.2,DEVICE_FAIL_74_NEAR

SETB  P0.3       ;HIGH /1CLR    (PRESET)
CLR   P0.6       ;LOW /1PRESET
SETB  P1.6       ;HIGH /2CLR
CLR   P1.3       ;LOW /2PRESET
SETB   P0.5      ;HI CLOCK
SETB   P1.4      ;HI CLOCK

JNB P0.7,DEVICE_FAIL_74_NEAR   ;1Q
JB P1.0,DEVICE_FAIL_74_NEAR   ;/1Q
JB P1.1,DEVICE_FAIL_74_NEAR   ;/2Q
JNB P1.2,DEVICE_FAIL_74_NEAR   ;2Q

CLR   P0.3       ;HIGH /1CLR    (CLEAR)
SETB  P0.6       ;LOW /1PRESET
CLR   P1.6       ;HIGH /2CLR
SETB  P1.3       ;LOW /2PRESET
SETB  P0.5       ;HI CLOCK
SETB  P1.4       ;HI CLOCK

JB P0.7,DEVICE_FAIL_74_NEAR    ;1Q
JNB P1.0,DEVICE_FAIL_74_NEAR   ;/1Q
JNB P1.1,DEVICE_FAIL_74_NEAR   ;/2Q
JB P1.2,DEVICE_FAIL_74_NEAR    ;2Q

JMP PROCEED_74

DEVICE_FAIL_74_NEAR:
LCALL FAILED
RET

PROCEED_74:

SETB   P0.3       ;HIGH /1CLR    (LOW D)
SETB  P0.6        ;HI /1PRESET
SETB   P1.6       ;HIGH /2CLR
SETB  P1.3        ;HI /2PRESET
CLR   P0.4        ;LOW 1D
CLR   P1.5        ;LOW 2D

SETB  P0.5       ;HI CLOCK
CLR   P0.5       ;LOW CLK
SETB  P0.5       ;HI CLK
SETB  P1.4       ;HI CLOCK
CLR   P1.4       ;LO CLOCK
SETB  P1.4       ;HI CLOCK


JB P0.7,DEVICE_FAIL_74    ;1Q
JNB P1.0,DEVICE_FAIL_74   ;/1Q
JNB P1.1,DEVICE_FAIL_74   ;/2Q
JB P1.2,DEVICE_FAIL_74    ;2Q

SETB   P0.3       ;HIGH /1CLR    (HIGH D)
SETB  P0.6        ;HI /1PRESET
SETB   P1.6       ;HIGH /2CLR
SETB  P1.3        ;HI /2PRESET
SETB  P0.4        ;HI 1D
SETB  P1.5        ;HI 2D

SETB  P0.5       ;HI CLOCK
CLR   P0.5       ;LOW CLK
SETB  P0.5       ;HI CLK
SETB  P1.4       ;HI CLOCK
CLR   P1.4       ;LO CLOCK
SETB  P1.4       ;HI CLOCK


JNB P0.7,DEVICE_FAIL_74    ;1Q
JB P1.0,DEVICE_FAIL_74   ;/1Q
JB P1.1,DEVICE_FAIL_74   ;/2Q
JNB P1.2,DEVICE_FAIL_74    ;2Q

SETB   P0.3       ;HIGH /1CLR    (HOLD)
SETB  P0.6        ;HI /1PRESET
SETB   P1.6       ;HIGH /2CLR
SETB  P1.3        ;HI /2PRESET
SETB  P0.4        ;HI 1D
SETB  P1.5        ;HI 2D

CLR   P0.5       ;LOW CLK
CLR   P1.4       ;LO CLOCK


JNB P0.7,DEVICE_FAIL_74    ;1Q
JB P1.0,DEVICE_FAIL_74   ;/1Q
JB P1.1,DEVICE_FAIL_74   ;/2Q
JNB P1.2,DEVICE_FAIL_74    ;2Q

LCALL PASSED
RET

DEVICE_FAIL_74:
LCALL FAILED
RET

;------------------------------------------
N7475:   ;DIFFERENT PINOUT OF Vcc
RET
;------------------------------------------
N7476:   ;DIFFRENT PINOUT OF Vcc
RET
;------------------------------------------
N7485:
;See Data sheet for test conditions

setb P0.6       ;\
setb P0.7       ; set inputs high
setb P1.0       ;/
setb P1.7       ;First test Condition
clr  P0.2

LCALL INSERT
setb P2.0       ;High w/ Vcc
CLR SWITCH2     ;Turn ON Vcc
JNB DETECT,OK_85
LCALL OVERCURRENT
RET

OK_85:
                ;Check Results
JNB P0.6,DEVICE_FAIL_85_2
JB  P1.0,DEVICE_FAIL_85_2
JB  P0.7,DEVICE_FAIL_85_2

CLR  P1.7        ;SECOND TEST CONDITION
SETB P0.2
                ;Check Results
JB  P0.6,DEVICE_FAIL_85_2
JNB P1.0,DEVICE_FAIL_85_2
JB  P0.7,DEVICE_FAIL_85_2

CLR P1.7        ;3RD TEST CONDITION
CLR P0.2
SETB P1.5
CLR  P1.6

JNB P0.6,DEVICE_FAIL_85_2
JB  P1.0,DEVICE_FAIL_85_2
JB  P0.7,DEVICE_FAIL_85_2

CLR  P1.7       ;4TH TEST CONDITION
CLR  P0.2
CLR  P1.5
SETB P1.6

JB  P0.6,DEVICE_FAIL_85_2
JNB P1.0,DEVICE_FAIL_85_2
JB  P0.7,DEVICE_FAIL_85_2

JMP PROCEED_85_1

DEVICE_FAIL_85_2:
LCALL FAILED
RET

PROCEED_85_1:

CLR P1.7        ;5TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
SETB P1.4
CLR  P1.3

JNB P0.6,DEVICE_FAIL_85_1
JB  P1.0,DEVICE_FAIL_85_1
JB  P0.7,DEVICE_FAIL_85_1

CLR P1.7        ;6TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR  P1.4
SETB P1.3

JB  P0.6,DEVICE_FAIL_85_1
JNB P1.0,DEVICE_FAIL_85_1
JB  P0.7,DEVICE_FAIL_85_1

CLR P1.7        ;7TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR P1.4
CLR P1.3
SETB P1.2
CLR P1.1

JNB  P0.6,DEVICE_FAIL_85_1
JB P1.0,DEVICE_FAIL_85_1
JB  P0.7,DEVICE_FAIL_85_1

CLR P1.7        ;8TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR P1.4
CLR P1.3
CLR P1.2
SETB P1.1

JB  P0.6,DEVICE_FAIL_85_1
JNB P1.0,DEVICE_FAIL_85_1
JB  P0.7,DEVICE_FAIL_85_1

CLR P1.7        ;9TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR P1.4
CLR P1.3
SETB P1.2
SETB P1.1
SETB P0.5
CLR P0.3
CLR P0.4

JNB  P0.6,DEVICE_FAIL_85_1
JB P1.0,DEVICE_FAIL_85_1
JB  P0.7,DEVICE_FAIL_85_1


JMP PROCEED_85_2

DEVICE_FAIL_85_1:
LCALL FAILED
RET

PROCEED_85_2:


CLR P1.7        ;10TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR P1.4
CLR P1.3
SETB P1.2
SETB P1.1
CLR P0.5
SETB P0.3
CLR P0.4

JB  P0.6,DEVICE_FAIL_85
JNB P1.0,DEVICE_FAIL_85
JB  P0.7,DEVICE_FAIL_85

CLR P1.7        ;11TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR P1.4
CLR P1.3
SETB P1.2
SETB P1.1
CLR P0.5
CLR P0.3
SETB P0.4

JB  P0.6,DEVICE_FAIL_85
JB P1.0,DEVICE_FAIL_85
JNB  P0.7,DEVICE_FAIL_85

CLR P1.7        ;12TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR P1.4
CLR P1.3
SETB P1.2
SETB P1.1
SETB P0.5
SETB P0.3
CLR P0.4

JB  P0.6,DEVICE_FAIL_85
JB P1.0,DEVICE_FAIL_85
JB  P0.7,DEVICE_FAIL_85

CLR P1.7        ;13TH TEST CONDITION
CLR P0.2
SETB P1.5
SETB P1.6
CLR P1.4
CLR P1.3
SETB P1.2
SETB P1.1
CLR P0.5
CLR P0.3
CLR P0.4

JNB  P0.6,DEVICE_FAIL_85
JNB P1.0,DEVICE_FAIL_85
JB  P0.7,DEVICE_FAIL_85

LCALL PASSED
RET


DEVICE_FAIL_85:
LCALL FAILED
RET



;------------------------------------------
N7486:

SETB P0.5       ;SET INPUTS HIGH
SETB P1.0       ;SET INPUTS HIGH
SETB P1.1       ;SET INPUTS HIGH
SETB P1.4       ;SET INPUTS HIGH
MOV COUNTER,#0
LCALL FORMAT_86

LCALL INSERT     ;INSERT IN SOCKET
SETB P1.7       ;SET HIGH W/ Vcc
CLR SWITCH3      ;TURN ON Vcc
JNB DETECT,OK_86 ;CHECK IF OVERCURRENT

LCALL OVERCURRENT
RET

OK_86:
LCALL FORMAT_86

                ;PERFORM XOR CHECK
                ; A/B+/AB
MOV C,ACC.0
CPL C
ANL C,ACC.1
MOV FLAG,C     ;SAVE PARTIAL ANSWER
MOV C,ACC.1
CPL C
ANL C,ACC.0
ORL C,FLAG      ;XOR FUNCTION FROM TEST CONDITION
MOV FLAG,C      ;SAVE ANSWER

MOV C,FLAG
CPL C
ANL C,P0.5
MOV FLAG2,C    ;SAVE PARTIAL ANSWER
MOV C,P0.5
CPL C
ANL C,FLAG
ORL C,FLAG2    ;XOR FUNCTION FROM IC

JC DEVICE_FAIL_86

MOV C,FLAG
CPL C
ANL C,P1.0
MOV FLAG2,C    ;SAVE PARTIAL ANSWER
MOV C,P1.0
CPL C
ANL C,FLAG
ORL C,FLAG2    ;XOR FUNCTION FROM IC

JC DEVICE_FAIL_86

MOV C,FLAG
CPL C
ANL C,P1.1
MOV FLAG2,C    ;SAVE PARTIAL ANSWER
MOV C,P1.1
CPL C
ANL C,FLAG
ORL C,FLAG2    ;XOR FUNCTION FROM IC

JC DEVICE_FAIL_86

MOV C,FLAG
CPL C
ANL C,P1.4
MOV FLAG2,C    ;SAVE PARTIAL ANSWER
MOV C,P1.4
CPL C
ANL C,FLAG
ORL C,FLAG2    ;XOR FUNCTION FROM IC

JC DEVICE_FAIL_86

INC COUNTER
MOV A,COUNTER
CJNE A,#4,OK_86

LCALL PASSED
RET

DEVICE_FAIL_86:
LCALL FAILED
RET

FORMAT_86:
MOV A,COUNTER
MOV C,ACC.0
MOV P0.4,C
MOV P0.7,C
MOV P1.3,C
MOV P1.6,C
MOV C,ACC.1
MOV P0.3,C
MOV P0.6,C
MOV P1.2,C
MOV P1.5,C
RET
;------------------------------------------
N7490:          ;DIFFERENT Vcc PINOUT
RET
;------------------------------------------
N7495:

SETB P1.6       ;SET AS INPUT
SETB P1.5       ; INPUT
SETB P1.4       ; INPUT
SETB P1.3       ; INPUT

LCALL INSERT
SETB P1.7       ;HIGH W/ Vcc
CLR SWITCH3     ;Turn ON Vcc
JNB DETECT,OK_95
LCALL OVERCURRENT
RET

OK_95:

                ;LOAD DATA
SETB P1.0       ;MODE CONTROL
SETB P0.4       ;A
SETB P0.5       ;B
SETB P0.6       ;C
SETB P0.7       ;D
SETB P1.1       ;HIGH TO LOW TRANSITION (CLK)
CLR  P1.1
SETB P1.1
MOV A,P1
ANL A,#01111000B
CJNE A,#01111000B,DEVICE_95_FAIL_NEAR1

                ;LOAD DATA
SETB P1.0       ;MODE CONTROL
CLR  P0.4       ;A
CLR  P0.5       ;B
CLR  P0.6       ;C
CLR  P0.7       ;D
SETB P1.1       ;HIGH TO LOW TRANSITION (CLK)
CLR  P1.1
SETB P1.1
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL_NEAR1

SETB P1.0       ;MODE CONTROL
SETB P1.1       ;CLOCK 2
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL_NEAR1

CLR P1.0        ;MODE CONTROL
CLR P1.1        ;CLOCK 2
SETB P1.2       ;CLOCK 1
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL_NEAR1

JMP SKIP95_FAIL1

DEVICE_95_FAIL_NEAR1:
LCALL FAILED
RET

SKIP95_FAIL1:


CLR P1.0        ;MODE CONTROL
SETB P0.3       ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#01000000B,DEVICE_95_FAIL_NEAR2

CLR P1.0        ;MODE CONTROL
SETB P0.3       ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#01100000B,DEVICE_95_FAIL_NEAR2

CLR P1.0        ;MODE CONTROL
SETB P0.3       ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#01110000B,DEVICE_95_FAIL_NEAR2

CLR P1.0        ;MODE CONTROL
SETB P0.3       ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#01111000B,DEVICE_95_FAIL_NEAR2

CLR P1.0        ;MODE CONTROL
CLR P0.3        ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#00111000B,DEVICE_95_FAIL_NEAR2

JMP SKIP95_FAIL2

DEVICE_95_FAIL_NEAR2:
LCALL FAILED
RET

SKIP95_FAIL2:


CLR P1.0        ;MODE CONTROL
CLR P0.3        ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#00011000B,DEVICE_95_FAIL

CLR P1.0        ;MODE CONTROL
CLR P0.3        ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#00001000B,DEVICE_95_FAIL

CLR P1.0        ;MODE CONTROL
CLR P0.3        ;SERIAL INPUT
SETB P1.2       ;HIGH TO LOW (CLOCK)
CLR P1.2
SETB P1.2
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL


CLR P1.1         ;CLOCK 2
CLR P1.2         ;CLOCK 1
CLR P1.0        ;MODE CONTROL
SETB P1.0       ;LOW TO HIGH
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL

CLR P1.1         ;CLOCK 2
CLR P1.2         ;CLOCK 1
SETB P1.0        ;MODE CONTROL
CLR P1.0         ;HIGH TO LOW
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL

CLR  P1.1         ;CLOCK 2
SETB P1.2         ;CLOCK 1
SETB P1.0        ;MODE CONTROL
CLR P1.0         ;HIGH TO LOW
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL

SETB  P1.1         ;CLOCK 2
CLR   P1.2         ;CLOCK 1
CLR  P1.0        ;MODE CONTROL
SETB P1.0         ;HIGH TO LOW
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL

SETB  P1.1         ;CLOCK 2
SETB  P1.2         ;CLOCK 1
CLR  P1.0        ;MODE CONTROL
SETB P1.0         ;HIGH TO LOW
MOV A,P1
ANL A,#01111000B
CJNE A,#00000000B,DEVICE_95_FAIL

LCALL PASSED
RET

DEVICE_95_FAIL:
LCALL FAILED
RET


RET
;------------------------------------------
N74107:

SETB P0.4       ;SET AS INPUTS
SETB P0.5       ;INPUT
SETB P0.7       ;INPUT
SETB P1.0       ;INPUT

CLR P1.6        ;/CLR
CLR P1.3        ;/CLR


LCALL INSERT
SETB P1.7       ;HIGH W/ Vcc
CLR SWITCH3     ;Turn ON Vcc
JNB DETECT,OK_107
LCALL OVERCURRENT
RET

OK_107:
JB P0.5,DEVICE_FAIL_107_NEAR
JNB P0.4,DEVICE_FAIL_107_NEAR
JB P0.7,DEVICE_FAIL_107_NEAR
JNB P1.0,DEVICE_FAIL_107_NEAR

JMP SKIP_107

DEVICE_FAIL_107_NEAR:
LCALL FAILED
RET

SKIP_107:


CLR P0.3        ;1J
CLR P0.6        ;1K
CLR P1.1        ;2J
CLR P1.4        ;2K

SETB P1.6       ;/CLR
SETB P1.3       ;/CLR

CLR P1.5        ;1CLK \
SETB P1.5       ;1CLK  CLOCK PULSE
CLR P1.5        ;1CLK /

CLR P1.2        ;1CLK \
SETB P1.2       ;1CLK  CLOCK PULSE
CLR P1.2        ;1CLK /

JB P0.5,DEVICE_FAIL_107
JNB P0.4,DEVICE_FAIL_107
JB P0.7,DEVICE_FAIL_107
JNB P1.0,DEVICE_FAIL_107

SETB P0.3       ;1J
CLR P0.6        ;1K
SETB P1.1        ;2J
CLR P1.4        ;2K

SETB P1.6       ;/CLR
SETB P1.3       ;/CLR

CLR P1.5        ;1CLK \
SETB P1.5       ;1CLK  CLOCK PULSE
CLR P1.5        ;1CLK /

CLR P1.2        ;1CLK \
SETB P1.2       ;1CLK  CLOCK PULSE
CLR P1.2        ;1CLK /

JNB P0.5,DEVICE_FAIL_107  ;1Q
JB P0.4,DEVICE_FAIL_107 ;1/Q
JNB P0.7,DEVICE_FAIL_107  ;2Q
JB P1.0,DEVICE_FAIL_107 ;2/Q

CLR P0.3       ;1J
SETB P0.6        ;1K
CLR P1.1        ;2J
SETB P1.4        ;2K

SETB P1.6       ;/CLR
SETB P1.3       ;/CLR

CLR P1.5        ;1CLK \
SETB P1.5       ;1CLK  CLOCK PULSE
CLR P1.5        ;1CLK /

CLR P1.2        ;1CLK \
SETB P1.2       ;1CLK  CLOCK PULSE
CLR P1.2        ;1CLK /

JB P0.5,DEVICE_FAIL_107  ;1Q
JNB P0.4,DEVICE_FAIL_107 ;1/Q
JB P0.7,DEVICE_FAIL_107  ;2Q
JNB P1.0,DEVICE_FAIL_107 ;2/Q

SETB P0.3       ;1J
SETB P0.6       ;1K
SETB P1.1       ;2J
SETB P1.4       ;2K

SETB P1.6       ;/CLR
SETB P1.3       ;/CLR

CLR P1.5        ;1CLK \
SETB P1.5       ;1CLK  CLOCK PULSE
CLR P1.5        ;1CLK /

CLR P1.2        ;1CLK \
SETB P1.2       ;1CLK  CLOCK PULSE
CLR P1.2        ;1CLK /

JNB P0.5,DEVICE_FAIL_107  ;1Q
JB P0.4,DEVICE_FAIL_107 ;1/Q
JNB P0.7,DEVICE_FAIL_107  ;2Q
JB P1.0,DEVICE_FAIL_107 ;2/Q

LCALL PASSED
RET

DEVICE_FAIL_107:
LCALL FAILED
RET

RET
;------------------------------------------
N74109:

SETB P0.7       ;SET AS INPUT
SETB P1.0       ;INPUT
SETB P1.2       ;INPUT
SETB P1.1       ;INPUT

CLR P0.6        ;1/PRE
CLR P1.3        ;2/PRE
SETB P0.2       ;1/CLR
SETB P1.7       ;2/CLR

LCALL INSERT
SETB P2.0       ;SET HIGH W/ Vcc
CLR SWITCH2     ;Turn ON Vcc
JNB DETECT,OK_109
LCALL OVERCURRENT
RET

OK_109:
JNB P0.7,DEVICE_FAIL_109_NEAR ;1Q
JB  P1.0,DEVICE_FAIL_109_NEAR   ;1/Q
JNB P1.2,DEVICE_FAIL_109_NEAR ;2Q
JB  P1.1,DEVICE_FAIL_109_NEAR   ;2/Q

SETB P0.3       ;1J
SETB P0.4       ;1/K
SETB P1.6       ;2J
SETB P1.5       ;2/K

SETB P0.6       ;1/PRE
SETB P1.3       ;2/PRE
SETB P0.2       ;1/CLR
SETB P1.7       ;2/CLR

SETB P0.5       ;1CLK\
CLR  P0.5       ;1CLK ONE CLOCK PULSE
SETB P0.5       ;1CLK/

SETB P1.4       ;2CLK\
CLR  P1.4       ;2CLK ONE CLOCK PULSE
SETB P1.4       ;2CLK/

JNB P0.7,DEVICE_FAIL_109_NEAR ;1Q
JB  P1.0,DEVICE_FAIL_109_NEAR   ;1/Q
JNB P1.2,DEVICE_FAIL_109_NEAR ;2Q
JB  P1.1,DEVICE_FAIL_109_NEAR   ;2/Q

SETB P0.6       ;1/PRE
SETB P1.3       ;2/PRE
CLR  P0.2       ;1/CLR
CLR  P1.7       ;2/CLR

JB P0.7,DEVICE_FAIL_109_NEAR ;1Q
JNB P1.0,DEVICE_FAIL_109_NEAR   ;1/Q
JB P1.2,DEVICE_FAIL_109_NEAR ;2Q
JNB P1.1,DEVICE_FAIL_109_NEAR   ;2/Q

CLR  P0.6       ;1/PRE
CLR  P1.3       ;2/PRE
CLR  P0.2       ;1/CLR
CLR  P1.7       ;2/CLR

JNB P0.7,DEVICE_FAIL_109_NEAR ;1Q
JNB P1.0,DEVICE_FAIL_109_NEAR   ;1/Q
JNB P1.2,DEVICE_FAIL_109_NEAR ;2Q
JNB P1.1,DEVICE_FAIL_109_NEAR   ;2/Q

JMP SKIP_109

DEVICE_FAIL_109_NEAR:
LCALL FAILED
RET

SKIP_109:

SETB  P0.6       ;1/PRE
SETB  P1.3       ;2/PRE
SETB  P0.2       ;1/CLR
SETB  P1.7       ;2/CLR

CLR P0.3       ;1J
CLR P0.4       ;1/K
CLR P1.6       ;2J
CLR P1.5       ;2/K

SETB P0.5       ;1CLK\
CLR  P0.5       ;1CLK ONE CLOCK PULSE
SETB P0.5       ;1CLK/

SETB P1.4       ;2CLK\
CLR  P1.4       ;2CLK ONE CLOCK PULSE
SETB P1.4       ;2CLK/

JB P0.7,DEVICE_FAIL_109 ;1Q
JNB P1.0,DEVICE_FAIL_109   ;1/Q
JB P1.2,DEVICE_FAIL_109 ;2Q
JNB P1.1,DEVICE_FAIL_109   ;2/Q

SETB  P0.6       ;1/PRE
SETB  P1.3       ;2/PRE
SETB  P0.2       ;1/CLR
SETB  P1.7       ;2/CLR

SETB P0.3       ;1J
CLR  P0.4       ;1/K
SETB P1.6       ;2J
CLR  P1.5       ;2/K

SETB P0.5       ;1CLK\
CLR  P0.5       ;1CLK ONE CLOCK PULSE
SETB P0.5       ;1CLK/

SETB P1.4       ;2CLK\
CLR  P1.4       ;2CLK ONE CLOCK PULSE
SETB P1.4       ;2CLK/

JNB P0.7,DEVICE_FAIL_109 ;1Q
JB  P1.0,DEVICE_FAIL_109   ;1/Q
JNB P1.2,DEVICE_FAIL_109 ;2Q
JB  P1.1,DEVICE_FAIL_109   ;2/Q

SETB  P0.6       ;1/PRE
SETB  P1.3       ;2/PRE
SETB  P0.2       ;1/CLR
SETB  P1.7       ;2/CLR

CLR   P0.3       ;1J
SETB  P0.4       ;1/K
CLR   P1.6       ;2J
SETB  P1.5       ;2/K

SETB P0.5       ;1CLK\
CLR  P0.5       ;1CLK ONE CLOCK PULSE
SETB P0.5       ;1CLK/

SETB P1.4       ;2CLK\
CLR  P1.4       ;2CLK ONE CLOCK PULSE
SETB P1.4       ;2CLK/

JNB P0.7,DEVICE_FAIL_109 ;1Q
JB P1.0,DEVICE_FAIL_109   ;1/Q
JNB P1.2,DEVICE_FAIL_109 ;2Q
JB P1.1,DEVICE_FAIL_109   ;2/Q

SETB  P0.6       ;1/PRE
SETB  P1.3       ;2/PRE
SETB  P0.2       ;1/CLR
SETB  P1.7       ;2/CLR

CLR P0.5       ;1CLK\
CLR P1.4       ;2CLK\

JNB P0.7,DEVICE_FAIL_109 ;1Q
JB  P1.0,DEVICE_FAIL_109   ;1/Q
JNB P1.2,DEVICE_FAIL_109 ;2Q
JB  P1.1,DEVICE_FAIL_109   ;2/Q

LCALL PASSED
RET

DEVICE_FAIL_109:
LCALL FAILED
RET



;------------------------------------------
N74125:

SETB P1.4       ;SET AS INPUT
SETB P1.1       ;INPUT
SETB P1.0       ;INPUT
SETB P0.5       ;INPUT

CLR P0.4        ;1A LOW INPUTS
CLR P0.7        ;2A
CLR P1.2        ;3A
CLR P1.5        ;4A

CLR P0.3        ;1/G ENABLE
CLR P0.6        ;2/G
CLR P1.3        ;3/G
CLR P1.6        ;4/G

LCALL INSERT
SETB P1.7       ;SET W/ Vcc
CLR SWITCH3     ;Turn ON Vcc
JNB DETECT,OK_125
LCALL OVERCURRENT
RET

OK_125:
JB P0.5,DEVICE_FAIL_125
JB P1.0,DEVICE_FAIL_125
JB P1.1,DEVICE_FAIL_125
JB p1.4,DEVICE_FAIL_125

SETB P0.4        ;1A HIGH INPUTS
SETB P0.7        ;2A
SETB P1.2        ;3A
SETB P1.5        ;4A

JNB P0.5,DEVICE_FAIL_125
JNB P1.0,DEVICE_FAIL_125
JNB P1.1,DEVICE_FAIL_125
JNB p1.4,DEVICE_FAIL_125

SETB P0.3        ;1/G DISABLE
SETB P0.6        ;2/G
SETB P1.3        ;3/G
SETB P1.6        ;4/G

JNB P0.5,DEVICE_FAIL_125
JNB P1.0,DEVICE_FAIL_125
JNB P1.1,DEVICE_FAIL_125
JNB p1.4,DEVICE_FAIL_125

LCALL PASSED
RET

DEVICE_FAIL_125:
LCALL FAILED
RET

;------------------------------------------
N74132:
lcall N7400
RET
;------------------------------------------
N74145:

MOV P0,#0FFH    ;SET AS INPUTS
MOV P1,#0FFH    ;SET AS INPUTS

MOV COUNTER,#0
LCALL FORMAT_145
LCALL INSERT
SETB P2.0       ;SET HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_145
LCALL OVERCURRENT



OK_145:
MOV SHIFTREG,#11111011B

LOOP_145_1:
LCALL FORMAT_145
MOV A,P1
ANL A,#00001111B
CJNE A,#0FH,DEVICE_FAIL_145
SETB P0.0
SETB P0.1
MOV A,P0
CJNE A,SHIFTREG,DEVICE_FAIL_145
MOV A,SHIFTREG
RL A
MOV SHIFTREG,A
INC COUNTER
MOV A,COUNTER
CJNE A,#6,LOOP_145_1

MOV SHIFTREG,#00001110B


OK_145_2:
LCALL FORMAT_145
SETB P0.0
SETB P0.1
MOV A,P0
CJNE A,#0FFH,DEVICE_FAIL_145

MOV A,P1
ANL A,#00001111B
CJNE A,SHIFTREG,DEVICE_FAIL_145
MOV A,SHIFTREG
SETB C
RLC A
ANL A,#00001111B
MOV SHIFTREG,A
INC COUNTER
MOV A,COUNTER
CJNE A,#10,OK_145_2

LCALL PASSED
RET


DEVICE_FAIL_145:
LCALL FAILED
RET

FORMAT_145:
MOV A,COUNTER
MOV C,ACC.0
MOV P1.7,C
MOV C,ACC.1
MOV P1.6,C
MOV C,ACC.2
MOV P1.5,C
MOV C,ACC.3
MOV P1.4,C
RET
;------------------------------------------
N74148:

SETB P0.7       ;SET AS INPUT
SETB P1.0       ;INPUT
SETB P1.1       ;INPUT
SETB P1.6       ;INPUT
SETB P1.7       ;INPUT
SETB P0.6       ;EI INPUT


LCALL INSERT
SETB P2.0       ;SET HI W/ Vcc
CLR SWITCH2     ;TURN ON Vcc
JNB DETECT,OK_148
LCALL OVERCURRENT

OK_148:
                                ;TEST 1
JNB P0.7,DEVICE_FAIL_148_2        ;A2 OUTPUT
JNB P1.0,DEVICE_FAIL_148_2        ;A1 OUTPUT
JNB P1.1,DEVICE_FAIL_148_2        ;A0 OUTPUT
JNB P1.6,DEVICE_FAIL_148_2        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148_2        ;EO OUTPUT

                                ;TEST 2

MOV P0,#11111111B                ;ALL SET TO 1
CLR P0.6                        ;EI INPUT

MOV P1,#11111111B                ;ALL SET TO 1

JNB P0.7,DEVICE_FAIL_148_2        ;A2 OUTPUT
JNB P1.0,DEVICE_FAIL_148_2        ;A1 OUTPUT
JNB P1.1,DEVICE_FAIL_148_2        ;A0 OUTPUT
JNB P1.6,DEVICE_FAIL_148_2        ;GS OUTPUT
JB  P1.7,DEVICE_FAIL_148_2        ;EO OUTPUT

JMP SKIP_148_2

DEVICE_FAIL_148_2:
LCALL FAILED
RET

SKIP_148_2:

                                ;TEST 3

MOV P0,#11111111B                ;ALL SET TO 1
CLR P0.5
CLR P0.6                        ;EI INPUT

MOV P1,#11111111B                ;ALL SET TO 1

JB  P0.7,DEVICE_FAIL_148_1        ;A2 OUTPUT
JB  P1.0,DEVICE_FAIL_148_1        ;A1 OUTPUT
JB  P1.1,DEVICE_FAIL_148_1        ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148_1        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148_1        ;EO OUTPUT

                                ;TEST 4

MOV P0,#11111111B                ;ALL SET TO 1
CLR P0.4
CLR P0.6                        ;EI INPUT

MOV P1,#11111111B                ;ALL SET TO 1

JB  P0.7,DEVICE_FAIL_148_1        ;A2 OUTPUT
JB  P1.0,DEVICE_FAIL_148_1        ;A1 OUTPUT
JNB  P1.1,DEVICE_FAIL_148_1       ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148_1        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148_1        ;EO OUTPUT

                                ;TEST 5
MOV P0,#11111111B                ;ALL SET TO 1
CLR P0.3
CLR P0.6                        ;EI INPUT

MOV P1,#11111111B                ;ALL SET TO 1

JB  P0.7,DEVICE_FAIL_148_1        ;A2 OUTPUT
JNB  P1.0,DEVICE_FAIL_148_1        ;A1 OUTPUT
JB  P1.1,DEVICE_FAIL_148_1       ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148_1        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148_1        ;EO OUTPUT

                               ;TEST 6

MOV P0,#11111111B               ;ALL SET TO 1
CLR P0.2
CLR P0.6                       ;EI INPUT

MOV P1,#11111111B               ;ALL SET TO 1

JB  P0.7,DEVICE_FAIL_148_1       ;A2 OUTPUT
JNB  P1.0,DEVICE_FAIL_148_1      ;A1 OUTPUT
JNB  P1.1,DEVICE_FAIL_148_1       ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148_1        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148_1        ;EO OUTPUT


JMP SKIP_148_1

DEVICE_FAIL_148_1:
LCALL FAILED
RET

SKIP_148_1:

                               ;TEST 7

MOV P0,#11111111B               ;ALL SET TO 1
CLR P0.6                       ;EI INPUT
MOV P1,#11111111B               ;ALL SET TO 1
CLR P1.5

JNB  P0.7,DEVICE_FAIL_148       ;A2 OUTPUT
JB  P1.0,DEVICE_FAIL_148      ;A1 OUTPUT
JB  P1.1,DEVICE_FAIL_148       ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148        ;EO OUTPUT

                              ;TEST 8

MOV P0,#11111111B               ;ALL SET TO 1
CLR P0.6                       ;EI INPUT

MOV P1,#11111111B               ;ALL SET TO 1
CLR P1.4

JNB  P0.7,DEVICE_FAIL_148       ;A2 OUTPUT
JB  P1.0,DEVICE_FAIL_148      ;A1 OUTPUT
JNB  P1.1,DEVICE_FAIL_148       ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148        ;EO OUTPUT

                              ;TEST 9

MOV P0,#11111111B               ;ALL SET TO 1
CLR P0.6                       ;EI INPUT

MOV P1,#11111111B               ;ALL SET TO 1
CLR P1.3

JNB  P0.7,DEVICE_FAIL_148       ;A2 OUTPUT
JNB  P1.0,DEVICE_FAIL_148      ;A1 OUTPUT
JB  P1.1,DEVICE_FAIL_148       ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148        ;EO OUTPUT

                              ;TEST 10

MOV P0,#11111111B               ;ALL SET TO 1
CLR P0.6                       ;EI INPUT

MOV P1,#11111111B               ;ALL SET TO 1
CLR P1.2

JNB  P0.7,DEVICE_FAIL_148       ;A2 OUTPUT
JNB  P1.0,DEVICE_FAIL_148      ;A1 OUTPUT
JNB  P1.1,DEVICE_FAIL_148       ;A0 OUTPUT
JB  P1.6,DEVICE_FAIL_148        ;GS OUTPUT
JNB P1.7,DEVICE_FAIL_148        ;EO OUTPUT

LCALL PASSED
RET

DEVICE_FAIL_148:
LCALL FAILED
RET

;------------------------------------------
N74151:

MOV P0,#0FFH            ;SET AS INPUT
MOV P1,#0FFH            ;SET AS INPUT
LCALL INSERT
SETB P2.0               ;SET HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_151
LCALL OVERCURRENT
RET

OK_151:
JNB P0.7,DEVICE_FAIL_151_NEAR
JB P0.6,DEVICE_FAIL_151_NEAR

MOV P0,#11111111B     ;SET I/O
MOV P1,#11110000B     ;SET I/O

JB P0.7,DEVICE_FAIL_151_NEAR
JNB P0.6,DEVICE_FAIL_151_NEAR

MOV P0,#11111111B     ;SET I/O
MOV P1,#11110010B     ;SET I/O

JB P0.7,DEVICE_FAIL_151_NEAR
JNB P0.6,DEVICE_FAIL_151_NEAR

MOV P0,#11111111B     ;SET I/O
MOV P1,#11110100B     ;SET I/O

JB P0.7,DEVICE_FAIL_151_NEAR
JNB P0.6,DEVICE_FAIL_151_NEAR

MOV P0,#11111111B     ;SET I/O
MOV P1,#11110110B     ;SET I/O

JB P0.7,DEVICE_FAIL_151_NEAR
JNB P0.6,DEVICE_FAIL_151_NEAR

MOV P0,#11111111B     ;SET I/O
MOV P1,#11111000B     ;SET I/O

JB P0.7,DEVICE_FAIL_151_NEAR
JNB P0.6,DEVICE_FAIL_151_NEAR

JMP SKIP_151_FAIL

DEVICE_FAIL_151_NEAR:
LCALL FAILED
RET

SKIP_151_FAIL:

MOV P0,#11111111B     ;SET I/O
MOV P1,#11111010B     ;SET I/O

JB P0.7,DEVICE_FAIL_151
JNB P0.6,DEVICE_FAIL_151

MOV P0,#11111111B     ;SET I/O
MOV P1,#11111100B     ;SET I/O

JB P0.7,DEVICE_FAIL_151
JNB P0.6,DEVICE_FAIL_151

MOV P0,#11111111B     ;SET I/O
MOV P1,#11111110B     ;SET I/O

JB P0.7,DEVICE_FAIL_151
JNB P0.6,DEVICE_FAIL_151
;----------------------------------INPUT 0
MOV P0,#11000000B     ;SET I/O
MOV P1,#00000000B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

MOV P0,#11000000B     ;SET I/O
MOV P1,#0000010B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

MOV P0,#11000000B     ;SET I/O
MOV P1,#00000100B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

MOV P0,#11000000B     ;SET I/O
MOV P1,#0000110B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

MOV P0,#11000000B     ;SET I/O
MOV P1,#00001000B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

MOV P0,#11000000B     ;SET I/O
MOV P1,#00001010B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

MOV P0,#11000000B     ;SET I/O
MOV P1,#00001100B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

MOV P0,#11000000B     ;SET I/O
MOV P1,#00001110B     ;SET I/O

JNB P0.7,DEVICE_FAIL_151
JB P0.6,DEVICE_FAIL_151

LCALL PASSED
RET

DEVICE_FAIL_151:
LCALL FAILED
RET

;------------------------------------------
N74153:

SETB P0.2              ;SET STROBE HI
SETB P1.7               ;SET STROBE HI

LCALL INSERT
SETB P2.0              ;SET HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_153
LCALL OVERCURRENT
RET

OK_153:
JB P1.0,DEVICE_FAIL_153
JB P1.1,DEVICE_FAIL_153

MOV P0,#00000000B
MOV P1,#00000011B

JB P1.0,DEVICE_FAIL_153
JB P1.1,DEVICE_FAIL_153

MOV P0,#00000000B
MOV P1,#01000011B

JB P1.0,DEVICE_FAIL_153
JB P1.1,DEVICE_FAIL_153

MOV P0,#00001000B
MOV P1,#00000011B

JB P1.0,DEVICE_FAIL_153
JB P1.1,DEVICE_FAIL_153

MOV P0,#00001000B
MOV P1,#01000011B

JB P1.0,DEVICE_FAIL_153
JB P1.1,DEVICE_FAIL_153
;--------------------------SET INPUT HI

MOV P0,#11110000B
MOV P1,#00111111B

JNB P1.0,DEVICE_FAIL_153
JNB P1.1,DEVICE_FAIL_153

MOV P0,#11110000B
MOV P1,#01111111B

JNB P1.0,DEVICE_FAIL_153
JNB P1.1,DEVICE_FAIL_153

MOV P0,#11111000B
MOV P1,#00111111B

JNB P1.0,DEVICE_FAIL_153
JNB P1.1,DEVICE_FAIL_153

MOV P0,#11111000B
MOV P1,#01111111B

JNB P1.0,DEVICE_FAIL_153
JNB P1.1,DEVICE_FAIL_153

LCALL PASSED
RET

DEVICE_FAIL_153:
LCALL FAILED
RET


;------------------------------------------
N74155:

SETB P0.3               ;SET STROBE HIGH
SETB P1.6               ;SET STROBE HIGH

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_155
LCALL OVERCURRENT
RET

OK_155:
JNB P1.0,DEVICE_FAIL_155_NEAR        ;OUTPUT
JNB P0.7,DEVICE_FAIL_155_NEAR        ;OUTPUT
JNB P0.6,DEVICE_FAIL_155_NEAR        ; -DO-
JNB P0.5,DEVICE_FAIL_155_NEAR        ; -DO-

JNB P1.1,DEVICE_FAIL_155_NEAR        ;OUTPUTS
JNB P1.2,DEVICE_FAIL_155_NEAR
JNB P1.3,DEVICE_FAIL_155_NEAR
JNB P1.4,DEVICE_FAIL_155_NEAR

CLR P0.4        ;B
CLR P1.5        ;A
CLR P0.3        ;LOW STROBE
SETB P0.2       ;DATA
CLR P1.6        ;LOW STROBE
CLR P1.7        ;DATA

JB P1.0,DEVICE_FAIL_155_NEAR        ;OUTPUT
JNB P0.7,DEVICE_FAIL_155_NEAR        ;OUTPUT
JNB P0.6,DEVICE_FAIL_155_NEAR        ; -DO-
JNB P0.5,DEVICE_FAIL_155_NEAR        ; -DO-

JMP SKIP_155


DEVICE_FAIL_155_NEAR:
LCALL FAILED
RET

SKIP_155:


JB P1.1,DEVICE_FAIL_155        ;OUTPUTS
JNB P1.2,DEVICE_FAIL_155
JNB P1.3,DEVICE_FAIL_155
JNB P1.4,DEVICE_FAIL_155

CLR    P0.4       ;B
SETB   P1.5       ;A

JNB P1.0,DEVICE_FAIL_155        ;OUTPUT
JB P0.7,DEVICE_FAIL_155        ;OUTPUT
JNB P0.6,DEVICE_FAIL_155        ; -DO-
JNB P0.5,DEVICE_FAIL_155        ; -DO-

JNB P1.1,DEVICE_FAIL_155        ;OUTPUTS
JB P1.2,DEVICE_FAIL_155
JNB P1.3,DEVICE_FAIL_155
JNB P1.4,DEVICE_FAIL_155

SETB P0.4       ;B
CLR  P1.5       ;A

JNB P1.0,DEVICE_FAIL_155        ;OUTPUT
JNB P0.7,DEVICE_FAIL_155        ;OUTPUT
JB P0.6,DEVICE_FAIL_155        ; -DO-
JNB P0.5,DEVICE_FAIL_155        ; -DO-

JNB P1.1,DEVICE_FAIL_155        ;OUTPUTS
JNB P1.2,DEVICE_FAIL_155
JB P1.3,DEVICE_FAIL_155
JNB P1.4,DEVICE_FAIL_155

SETB P0.4       ;B
SETB P1.5       ;A

JNB P1.0,DEVICE_FAIL_155        ;OUTPUT
JNB P0.7,DEVICE_FAIL_155        ;OUTPUT
JNB P0.6,DEVICE_FAIL_155        ; -DO-
JB P0.5,DEVICE_FAIL_155        ; -DO-

JNB P1.1,DEVICE_FAIL_155        ;OUTPUTS
JNB P1.2,DEVICE_FAIL_155
JNB P1.3,DEVICE_FAIL_155
JB P1.4,DEVICE_FAIL_155

CLR P0.2        ;DATA
SETB P1.7       ;DATA

JNB P1.0,DEVICE_FAIL_155        ;OUTPUT
JNB P0.7,DEVICE_FAIL_155        ;OUTPUT
JNB P0.6,DEVICE_FAIL_155        ; -DO-
JNB P0.5,DEVICE_FAIL_155        ; -DO-

JNB P1.1,DEVICE_FAIL_155        ;OUTPUTS
JNB P1.2,DEVICE_FAIL_155
JNB P1.3,DEVICE_FAIL_155
JNB P1.4,DEVICE_FAIL_155

LCALL PASSED
RET

DEVICE_FAIL_155:
LCALL FAILED
RET

;------------------------------------------
N74156:
LCALL N74155
RET
;------------------------------------------
N74157:

SETB P1.7               ;STROBE HI
LCALL INSERT
SETB P2.0               ;SET HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_157
LCALL OVERCURRENT
RET

OK_157:
JB P0.5,DEVICE_FAIL_157
JB P1.0,DEVICE_FAIL_157
JB P1.1,DEVICE_FAIL_157
JB P1.4,DEVICE_FAIL_157

CLR P1.7                ;STROBE LO
CLR P0.2                ;/A|B
CLR P0.3                ;A
CLR P0.6                ;A
CLR P1.3                ;A
CLR P1.6                ;A

JB P0.5,DEVICE_FAIL_157
JB P1.0,DEVICE_FAIL_157
JB P1.1,DEVICE_FAIL_157
JB P1.4,DEVICE_FAIL_157

SETB P0.3                ;A
SETB P0.6                ;A
SETB P1.3                ;A
SETB P1.6                ;A

JNB P0.5,DEVICE_FAIL_157
JNB P1.0,DEVICE_FAIL_157
JNB P1.1,DEVICE_FAIL_157
JNB P1.4,DEVICE_FAIL_157

SETB P0.2               ;/A|B

CLR P0.4                ;B
CLR P0.7                ;B
CLR P1.2                ;B
CLR P1.5                ;B

JB P0.5,DEVICE_FAIL_157
JB P1.0,DEVICE_FAIL_157
JB P1.1,DEVICE_FAIL_157
JB P1.4,DEVICE_FAIL_157

SETB P0.4                ;B
SETB P0.7                ;B
SETB P1.2                ;B
SETB P1.5                ;B

JNB P0.5,DEVICE_FAIL_157
JNB P1.0,DEVICE_FAIL_157
JNB P1.1,DEVICE_FAIL_157
JNB P1.4,DEVICE_FAIL_157

LCALL PASSED
RET

DEVICE_FAIL_157:
LCALL FAILED
RET
;------------------------------------------
N74161:

CLR P0.2                ;ASYNC CLEAR
SETB P1.3               ;SET AS INPUTS
SETB P1.4               ;
SETB P1.5               ;INPUTS
SETB P1.6               ;
setb p1.7

LCALL INSERT
SETB P2.0               ;SET HIGH W/Vcc
CLR SWITCH2
JNB DETECT,OK_161
LCALL OVERCURRENT
RET

OK_161:                 ;TEST CLEAR
JB P1.3,DEVICE_FAIL_161_NEAR
JB P1.4,DEVICE_FAIL_161_NEAR
JB P1.5,DEVICE_FAIL_161_NEAR
JB P1.6,DEVICE_FAIL_161_NEAR

JMP SKIP_161

DEVICE_FAIL_161_NEAR:
LCALL FAILED
RET

SKIP_161:

SETB P0.2               ;CLR HIGH


                        ;TEST LOAD LOW

CLR P0.7                ;D
CLR P0.6                ;C
CLR P0.5                ;B
CLR P0.4                ;A

CLR P1.1                ;/LOAD


SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P1.1               ;/LOAD


JB P1.3,DEVICE_FAIL_161  ;CHECK IF LOW
JB P1.4,DEVICE_FAIL_161
JB P1.5,DEVICE_FAIL_161
JB P1.6,DEVICE_FAIL_161

                        ;TEST LOAD HIGH

SETB P0.7                ;D
SETB P0.6                ;C
SETB P0.5                ;B
SETB P0.4                ;A

CLR P1.1                ;/LOAD

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P1.1               ;/LOAD


JNB P1.3,DEVICE_FAIL_161  ;CHECK IF HI
JNB P1.4,DEVICE_FAIL_161
JNB P1.5,DEVICE_FAIL_161
JNB P1.6,DEVICE_FAIL_161

CLR P0.2                ;CLEAR
SETB P0.2               ;HI CLEAR

SETB P1.0                ;ENP
SETB P1.2                ;ENT

MOV COUNTER,#15         ;COUNT TO 15

COUNT_161:
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

DJNZ COUNTER,COUNT_161

JNB P1.3,DEVICE_FAIL_161  ;CHECK IF HI
JNB P1.4,DEVICE_FAIL_161
JNB P1.5,DEVICE_FAIL_161
JNB P1.6,DEVICE_FAIL_161


JNB P1.7,DEVICE_FAIL_161


CLR P1.0                ;ENP
CLR P1.2                ;ENT
CLR P0.2                ;SYNC CLEAR
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK
SETB P0.2

MOV COUNTER,#15         ;COUNT TO 15

COUNT2_161:
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

DJNZ COUNTER,COUNT2_161

JB P1.3,DEVICE_FAIL_161  ;CHECK IF LOW
JB P1.4,DEVICE_FAIL_161
JB P1.5,DEVICE_FAIL_161
JB P1.6,DEVICE_FAIL_161


LCALL PASSED
RET

DEVICE_FAIL_161:
LCALL FAILED
RET

;------------------------------------------
N74162:


SETB P1.3               ;SET AS INPUTS
SETB P1.4               ;
SETB P1.5               ;INPUTS
SETB P1.6               ;

setb P1.7


CLR P1.0                ;ENP
CLR P1.2                ;ENT

LCALL INSERT
SETB P2.0               ;SET HIGH W/Vcc
CLR SWITCH2
JNB DETECT,OK_162
LCALL OVERCURRENT
RET

CLR P0.2                ;SYNC CLEAR

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P0.2


OK_162:                 ;TEST CLEAR
JB P1.3,DEVICE_FAIL_162_NEAR
JB P1.4,DEVICE_FAIL_162_NEAR
JB P1.5,DEVICE_FAIL_162_NEAR
JB P1.6,DEVICE_FAIL_162_NEAR

JMP SKIP_162

DEVICE_FAIL_162_NEAR:
LCALL FAILED
RET

SKIP_162:

CLR P1.0                ;ENP
CLR P1.2                ;ENT

                        ;TEST LOAD LOW

CLR P0.7                ;D
CLR P0.6                ;C
CLR P0.5                ;B
CLR P0.4                ;A

CLR P1.1                ;/LOAD


SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P1.1               ;/LOAD

JB P1.3,DEVICE_FAIL_162_near  ;CHECK IF LOW
JB P1.4,DEVICE_FAIL_162
JB P1.5,DEVICE_FAIL_162
JB P1.6,DEVICE_FAIL_162

                        ;TEST LOAD HIGH

SETB P0.7               ;D
clr P0.6                ;C
clr P0.5                ;B
SETB P0.4               ;A

CLR P1.1                ;/LOAD

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P1.1               ;/LOAD


JNB P1.3,DEVICE_FAIL_162  ;CHECK IF HI
JB P1.4,DEVICE_FAIL_162
JB P1.5,DEVICE_FAIL_162
JNB P1.6,DEVICE_FAIL_162

CLR P0.2                ;CLEAR

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P0.2               ;HI CLEAR

SETB P1.0                ;ENP
SETB P1.2                ;ENT

MOV COUNTER,#9         ;COUNT TO 9

COUNT1_162:
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
setb P0.3

DJNZ COUNTER,COUNT1_162

JNB P1.3,DEVICE_FAIL_162  ; D
JB P1.4,DEVICE_FAIL_162   ; C
JB P1.5,DEVICE_FAIL_162   ; B
JNB P1.6,DEVICE_FAIL_162  ; A


clr P1.0                ;ENP
clr P1.2                ;ENT

CLR P0.2                ;SYNC CLEAR

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P0.2

setb P1.0                ;ENP
setb P1.2                ;ENT

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

MOV COUNTER,#9 ;COUNT TO 9

COUNT2_162:
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

DJNZ COUNTER,COUNT2_162

JB P1.3,DEVICE_FAIL_162  ;CHECK IF LOW
JB P1.4,DEVICE_FAIL_162
JB P1.5,DEVICE_FAIL_162
JB P1.6,DEVICE_FAIL_162


LCALL PASSED
RET

DEVICE_FAIL_162:
LCALL FAILED
RET
;------------------------------------------
N74163:

CLR P0.2                ;ASYNC CLEAR
SETB P1.3               ;SET AS INPUTS
SETB P1.4               ;
SETB P1.5               ;INPUTS
SETB P1.6               ;
setb p1.7

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P0.2




LCALL INSERT
SETB P2.0               ;SET HIGH W/Vcc
CLR SWITCH2
JNB DETECT,OK_163
LCALL OVERCURRENT
RET

OK_163:                 ;TEST CLEAR
JB P1.3,DEVICE_FAIL_163_NEAR
JB P1.4,DEVICE_FAIL_163_NEAR
JB P1.5,DEVICE_FAIL_163_NEAR
JB P1.6,DEVICE_FAIL_163_NEAR

JMP SKIP_163

DEVICE_FAIL_163_NEAR:
LCALL FAILED
RET

SKIP_163:

SETB P0.2               ;CLR HIGH


                        ;TEST LOAD LOW

CLR P0.7                ;D
CLR P0.6                ;C
CLR P0.5                ;B
CLR P0.4                ;A

CLR P1.1                ;/LOAD


SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P1.1               ;/LOAD


JB P1.3,DEVICE_FAIL_163  ;CHECK IF LOW
JB P1.4,DEVICE_FAIL_163
JB P1.5,DEVICE_FAIL_163
JB P1.6,DEVICE_FAIL_163

                        ;TEST LOAD HIGH

SETB P0.7                ;D
SETB P0.6                ;C
SETB P0.5                ;B
SETB P0.4                ;A

CLR P1.1                ;/LOAD

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P1.1               ;/LOAD


JNB P1.3,DEVICE_FAIL_163  ;CHECK IF HI
JNB P1.4,DEVICE_FAIL_163
JNB P1.5,DEVICE_FAIL_163
JNB P1.6,DEVICE_FAIL_163

CLR P0.2                ;CLEAR

SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

SETB P0.2               ;HI CLEAR

SETB P1.0                ;ENP
SETB P1.2                ;ENT

MOV COUNTER,#15         ;COUNT TO 15

COUNT_163:
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

DJNZ COUNTER,COUNT_163

JNB P1.3,DEVICE_FAIL_163  ;CHECK IF HI
JNB P1.4,DEVICE_FAIL_163
JNB P1.5,DEVICE_FAIL_163
JNB P1.6,DEVICE_FAIL_163


JNB P1.7,DEVICE_FAIL_163


CLR P1.0                ;ENP
CLR P1.2                ;ENT
CLR P0.2                ;SYNC CLEAR
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK
SETB P0.2

MOV COUNTER,#15         ;COUNT TO 15

COUNT2_163:
SETB P0.3               ;CLOCK PULSE
CLR  P0.3               ;CLOCK
SETB P0.3               ;CLOCK

DJNZ COUNTER,COUNT2_163

JB P1.3,DEVICE_FAIL_163  ;CHECK IF LOW
JB P1.4,DEVICE_FAIL_163
JB P1.5,DEVICE_FAIL_163
JB P1.6,DEVICE_FAIL_163


LCALL PASSED
RET

DEVICE_FAIL_163:
LCALL FAILED
RET



N7446:


SETB P1.5               ;A
SETB P1.4               ;B
SETB P1.3               ;C
SETB P1.2               ;D  SET AS INPUTS
SETB P1.1               ;E
SETB P1.7               ;F
SETB P1.6               ;G

LCALL INSERT
SETB P2.0               ;SET HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_46
LCALL OVERCURRENT
RET

OK_46:

SETB P0.4               ;/LT HI
SETB P0.6               ;/RBI
SETB P0.5               ;/BI|/RBO

CLR P0.7                ;D
CLR P0.3                ;C
CLR P0.2                ;B
CLR P1.0                ;A

JB P1.5,DEVICE_FAIL_46_NEAR_2 ;A     0
JB P1.4,DEVICE_FAIL_46_NEAR_2 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_2 ;C
JB P1.2,DEVICE_FAIL_46_NEAR_2 ;D
JB P1.1,DEVICE_FAIL_46_NEAR_2 ;E
JB P1.7,DEVICE_FAIL_46_NEAR_2 ;F
JNB  P1.6,DEVICE_FAIL_46_NEAR_2 ;G

CLR P0.7                ;D
CLR P0.3                ;C
CLR P0.2                ;B
SETB P1.0                ;A

JNB P1.5,DEVICE_FAIL_46_NEAR_2 ;A      1
JB P1.4,DEVICE_FAIL_46_NEAR_2 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_2 ;C
JNB P1.2,DEVICE_FAIL_46_NEAR_2 ;D
JNB P1.1,DEVICE_FAIL_46_NEAR_2 ;E
JNB P1.7,DEVICE_FAIL_46_NEAR_2 ;F
JNB  P1.6,DEVICE_FAIL_46_NEAR_2 ;G

CLR P0.7                ;D
CLR P0.3                ;C
SETB P0.2                ;B
CLR P1.0                ;A

JB P1.5,DEVICE_FAIL_46_NEAR_2 ;A     2
JB P1.4,DEVICE_FAIL_46_NEAR_2 ;B
JNB P1.3,DEVICE_FAIL_46_NEAR_2 ;C
JB P1.2,DEVICE_FAIL_46_NEAR_2 ;D
JB P1.1,DEVICE_FAIL_46_NEAR_2 ;E
JNB P1.7,DEVICE_FAIL_46_NEAR_2 ;F
JB  P1.6,DEVICE_FAIL_46_NEAR_2 ;G


JMP SKIP_46_2
DEVICE_FAIL_46_NEAR_2:
LCALL FAILED
RET

SKIP_46_2:


CLR P0.7                ;D
CLR P0.3                ;C
SETB P0.2                ;B
SETB P1.0                ;A

JB P1.5,DEVICE_FAIL_46_NEAR_2 ;A   3
JB P1.4,DEVICE_FAIL_46_NEAR_2 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_2 ;C
JB P1.2,DEVICE_FAIL_46_NEAR_2 ;D
JNB P1.1,DEVICE_FAIL_46_NEAR_2 ;E
JNB P1.7,DEVICE_FAIL_46_NEAR_2 ;F
JB  P1.6,DEVICE_FAIL_46_NEAR_2 ;G

CLR P0.7                ;D
SETB P0.3                ;C
CLR P0.2                ;B
CLR P1.0                ;A

JNB P1.5,DEVICE_FAIL_46_NEAR_2 ;A    4
JB P1.4,DEVICE_FAIL_46_NEAR_2 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_2 ;C
JNB P1.2,DEVICE_FAIL_46_NEAR_2 ;D
JNB P1.1,DEVICE_FAIL_46_NEAR_2 ;E
JB P1.7,DEVICE_FAIL_46_NEAR_2 ;F
JB  P1.6,DEVICE_FAIL_46_NEAR_2 ;G

CLR P0.7                ;D
SETB P0.3                ;C
CLR P0.2                ;B
SETB P1.0                ;A

JB P1.5,DEVICE_FAIL_46_NEAR_1 ;A    5
JNB P1.4,DEVICE_FAIL_46_NEAR_1 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_1 ;C
JB P1.2,DEVICE_FAIL_46_NEAR_1 ;D
JNB P1.1,DEVICE_FAIL_46_NEAR_1 ;E
JB P1.7,DEVICE_FAIL_46_NEAR_1 ;F
JB  P1.6,DEVICE_FAIL_46_NEAR_1 ;G

CLR P0.7                ;D
SETB P0.3                ;C
SETB P0.2                ;B
CLR P1.0                ;A

JNB P1.5,DEVICE_FAIL_46_NEAR_1 ;A    6
JNB P1.4,DEVICE_FAIL_46_NEAR_1 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_1 ;C
JB P1.2,DEVICE_FAIL_46_NEAR_1 ;D
JB P1.1,DEVICE_FAIL_46_NEAR_1 ;E
JB P1.7,DEVICE_FAIL_46_NEAR_1 ;F
JB  P1.6,DEVICE_FAIL_46_NEAR_1 ;G

CLR P0.7                ;D
SETB P0.3                ;C
SETB P0.2                ;B
SETB P1.0                ;A



JB P1.5,DEVICE_FAIL_46_NEAR_1 ;A    7
JB P1.4,DEVICE_FAIL_46_NEAR_1 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_1 ;C
JNB P1.2,DEVICE_FAIL_46_NEAR_1 ;D
JNB P1.1,DEVICE_FAIL_46_NEAR_1 ;E
JNB P1.7,DEVICE_FAIL_46_NEAR_1 ;F
JNB  P1.6,DEVICE_FAIL_46_NEAR_1 ;G

SETB P0.7                ;D
CLR P0.3                ;C
CLR P0.2                ;B
CLR P1.0                ;A

JB P1.5,DEVICE_FAIL_46_NEAR_1 ;A    8
JB P1.4,DEVICE_FAIL_46_NEAR_1 ;B
JB P1.3,DEVICE_FAIL_46_NEAR_1 ;C
JB P1.2,DEVICE_FAIL_46_NEAR_1 ;D
JB P1.1,DEVICE_FAIL_46_NEAR_1 ;E
JB P1.7,DEVICE_FAIL_46_NEAR_1 ;F
JB P1.6,DEVICE_FAIL_46_NEAR_1 ;G

JMP SKIP_46_1
DEVICE_FAIL_46_NEAR_1:
LCALL FAILED
RET

SKIP_46_1:


SETB P0.7                ;D
CLR P0.3                ;C
CLR P0.2                ;B
SETB P1.0                ;A

JB P1.5,DEVICE_FAIL_46 ;A    9
JB P1.4,DEVICE_FAIL_46 ;B
JB P1.3,DEVICE_FAIL_46 ;C
JNB P1.2,DEVICE_FAIL_46 ;D
JNB P1.1,DEVICE_FAIL_46 ;E
JB P1.7,DEVICE_FAIL_46 ;F
JB P1.6,DEVICE_FAIL_46 ;G

CLR P0.5                ;/BI|/RBO

JNB P1.5,DEVICE_FAIL_46 ;A
JNB P1.4,DEVICE_FAIL_46 ;B
JNB P1.3,DEVICE_FAIL_46 ;C
JNB P1.2,DEVICE_FAIL_46 ;D
JNB P1.1,DEVICE_FAIL_46 ;E
JNB P1.7,DEVICE_FAIL_46 ;F
JNB P1.6,DEVICE_FAIL_46 ;G

SETB P0.4               ;/LT
CLR P0.6                ;/RBI
CLR P0.5                ;/BI|/RBO

CLR P0.7                ;D
CLR P0.3                ;C
CLR P0.2                ;B
CLR P1.0                ;A

JNB P1.5,DEVICE_FAIL_46 ;A
JNB P1.4,DEVICE_FAIL_46 ;B
JNB P1.3,DEVICE_FAIL_46 ;C
JNB P1.2,DEVICE_FAIL_46 ;D
JNB P1.1,DEVICE_FAIL_46 ;E
JNB P1.7,DEVICE_FAIL_46 ;F
JNB P1.6,DEVICE_FAIL_46 ;G

CLR P0.4                ;/LT
SETB P0.5               ;/BI|/RBO

JB P1.5,DEVICE_FAIL_46 ;A
JB P1.4,DEVICE_FAIL_46 ;B
JB P1.3,DEVICE_FAIL_46 ;C
JB P1.2,DEVICE_FAIL_46 ;D
JB P1.1,DEVICE_FAIL_46 ;E
JB P1.7,DEVICE_FAIL_46 ;F
JB P1.6,DEVICE_FAIL_46 ;G

LCALL PASSED
RET

DEVICE_FAIL_46:
LCALL FAILED
RET

;------------------------------------------
N74164:

CLR P1.2                ;LOW /CLR
SETB P1.2               ;HI /CLR

LCALL INSERT
SETB P1.7               ;SET HI W/ Vcc
CLR SWITCH3
JNB DETECT,OK_164
LCALL OVERCURRENT
RET

OK_164:
JB P0.5,DEVICE_FAIL_164_NEAR2
JB P0.6,DEVICE_FAIL_164_NEAR2
JB P0.7,DEVICE_FAIL_164_NEAR2
JB P1.0,DEVICE_FAIL_164_NEAR2
JB P1.3,DEVICE_FAIL_164_NEAR2
JB P1.4,DEVICE_FAIL_164_NEAR2
JB P1.5,DEVICE_FAIL_164_NEAR2
JB P1.6,DEVICE_FAIL_164_NEAR2


JMP SKIP_164_2


DEVICE_FAIL_164_NEAR2:
LCALL FAILED
RET

SKIP_164_2:


SETB P0.3       ;A
SETB P0.4       ;B

SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JNB P0.5,DEVICE_FAIL_164_NEAR
JB P0.6,DEVICE_FAIL_164_NEAR
JB P0.7,DEVICE_FAIL_164_NEAR
JB P1.0,DEVICE_FAIL_164_NEAR
JB P1.3,DEVICE_FAIL_164_NEAR
JB P1.4,DEVICE_FAIL_164_NEAR
JB P1.5,DEVICE_FAIL_164_NEAR
JB P1.6,DEVICE_FAIL_164_NEAR

CLR P0.3       ;A
SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JB P0.5,DEVICE_FAIL_164_NEAR
JNB P0.6,DEVICE_FAIL_164_NEAR
JB P0.7,DEVICE_FAIL_164_NEAR
JB P1.0,DEVICE_FAIL_164_NEAR
JB P1.3,DEVICE_FAIL_164_NEAR
JB P1.4,DEVICE_FAIL_164_NEAR
JB P1.5,DEVICE_FAIL_164_NEAR
JB P1.6,DEVICE_FAIL_164_NEAR

CLR P0.3       ;A
SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JB P0.5,DEVICE_FAIL_164_NEAR
JB P0.6,DEVICE_FAIL_164_NEAR
JNB P0.7,DEVICE_FAIL_164_NEAR
JB P1.0,DEVICE_FAIL_164_NEAR
JB P1.3,DEVICE_FAIL_164_NEAR
JB P1.4,DEVICE_FAIL_164_NEAR
JB P1.5,DEVICE_FAIL_164_NEAR
JB P1.6,DEVICE_FAIL_164_NEAR

CLR P0.3       ;A
SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JB P0.5,DEVICE_FAIL_164_NEAR
JB P0.6,DEVICE_FAIL_164_NEAR
JB P0.7,DEVICE_FAIL_164_NEAR
JNB P1.0,DEVICE_FAIL_164_NEAR
JB P1.3,DEVICE_FAIL_164_NEAR
JB P1.4,DEVICE_FAIL_164_NEAR
JB P1.5,DEVICE_FAIL_164_NEAR
JB P1.6,DEVICE_FAIL_164_NEAR


JMP SKIP_164

DEVICE_FAIL_164_NEAR:
LCALL FAILED
RET

SKIP_164:



CLR P0.3       ;A
SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JB P0.5,DEVICE_FAIL_164
JB P0.6,DEVICE_FAIL_164
JB P0.7,DEVICE_FAIL_164
JB P1.0,DEVICE_FAIL_164
JNB P1.3,DEVICE_FAIL_164
JB P1.4,DEVICE_FAIL_164
JB P1.5,DEVICE_FAIL_164
JB P1.6,DEVICE_FAIL_164

CLR P0.3       ;A
SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JB P0.5,DEVICE_FAIL_164
JB P0.6,DEVICE_FAIL_164
JB P0.7,DEVICE_FAIL_164
JB P1.0,DEVICE_FAIL_164
JB P1.3,DEVICE_FAIL_164
JNB P1.4,DEVICE_FAIL_164
JB P1.5,DEVICE_FAIL_164
JB P1.6,DEVICE_FAIL_164

CLR P0.3       ;A
SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JB P0.5,DEVICE_FAIL_164
JB P0.6,DEVICE_FAIL_164
JB P0.7,DEVICE_FAIL_164
JB P1.0,DEVICE_FAIL_164
JB P1.3,DEVICE_FAIL_164
JB P1.4,DEVICE_FAIL_164
JNB P1.5,DEVICE_FAIL_164
JB P1.6,DEVICE_FAIL_164

CLR P0.3       ;A
SETB P1.1       ;ONE
CLR P1.1        ;CLOCK
SETB P1.1       ;PULSE

JB P0.5,DEVICE_FAIL_164
JB P0.6,DEVICE_FAIL_164
JB P0.7,DEVICE_FAIL_164
JB P1.0,DEVICE_FAIL_164
JB P1.3,DEVICE_FAIL_164
JB P1.4,DEVICE_FAIL_164
JB P1.5,DEVICE_FAIL_164
JNB P1.6,DEVICE_FAIL_164

LCALL PASSED
RET

DEVICE_FAIL_164:
LCALL FAILED
RET
;------------------------------------------
N74165:

SETB P1.1               ;Qh  SET AS INPUT
SETB P1.0               ;/Qh SET AS INPUT
CLR P1.2                ;LO SER INPUT



SETB P1.3               ;HI A
CLR P1.4                ;LO B
SETB P1.5               ;HI C
CLR P1.6                ;LO D
SETB P0.4               ;HI E
CLR P0.5                ;LO F
SETB P0.6               ;HI G
CLR P0.7                ;LO H

LCALL INSERT
SETB P2.0               ;SET HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_165
LCALL OVERCURRENT
RET

OK_165:

SETB P0.2               ;HI SHIFT|/LOAD
CLR P0.2                ;LO SHIFT|/LOAD
SETB P0.2               ;HI SHIFT|/LOAD

JB P1.1,DEVICE_FAIL_165_NEAR
JNB P1.0,DEVICE_FAIL_165_NEAR


CLR P0.3                ;LO CLK
CLR P1.7                ;LO CLK INH

JB P1.1,DEVICE_FAIL_165_NEAR
JNB P1.0,DEVICE_FAIL_165_NEAR



CLR P1.7                ;LO CLK INH

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JNB P1.1,DEVICE_FAIL_165_NEAR     ;A
JB P1.0,DEVICE_FAIL_165_NEAR

;DEBUG_LOOP:      ;DEBUG
;CPL P0.0         ;
;JMP DEBUG_LOOP   ;


JMP SKIP_165
DEVICE_FAIL_165_NEAR:
LCALL FAILED
RET

SKIP_165:

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JB P1.1,DEVICE_FAIL_165     ;B
JNB P1.0,DEVICE_FAIL_165

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JNB P1.1,DEVICE_FAIL_165     ;C
JB P1.0,DEVICE_FAIL_165

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JB P1.1,DEVICE_FAIL_165     ;D
JNB P1.0,DEVICE_FAIL_165

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JNB P1.1,DEVICE_FAIL_165     ;E
JB P1.0,DEVICE_FAIL_165

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JB P1.1,DEVICE_FAIL_165     ;F
JNB P1.0,DEVICE_FAIL_165

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JNB P1.1,DEVICE_FAIL_165     ;G
JB P1.0,DEVICE_FAIL_165

CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK

JB P1.1,DEVICE_FAIL_165     ;H
JNB P1.0,DEVICE_FAIL_165



MOV COUNTER,#8
SETB P1.2               ;HI SER INPUT
LOOP_CLOCK_165:
CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK
DJNZ COUNTER,LOOP_CLOCK_165

JNB P1.1,DEVICE_FAIL_165     ;SER AT 8 HI
JB P1.0,DEVICE_FAIL_165
MOV COUNTER,#8
CLR P1.2               ;LO SER INPUT
LOOP_CLOCK_165_2:
CLR P0.3                ;LO CLK
SETB P0.3               ;HI CLK   LOW TO HI TRANSITION
CLR P0.3                ;LO CLK
DJNZ COUNTER,LOOP_CLOCK_165_2

JB P1.1,DEVICE_FAIL_165     ;SER AT 8 LO
JNB P1.0,DEVICE_FAIL_165

LCALL PASSED
RET

DEVICE_FAIL_165:
LCALL FAILED
RET

;------------------------------------------
N74166:

SETB P1.5               ;Qh  SET AS INPUT
CLR P0.2                ;LO SER INPUT
SETB P1.1               ;HI CLR


SETB P0.3               ;HI A
CLR P0.4                ;LO B
SETB P0.5               ;HI C
CLR P0.6                ;LO D
SETB P1.2               ;HI E
CLR P1.3                ;LO F
SETB P1.4               ;HI G
CLR P1.6                ;LO H

LCALL INSERT
SETB P2.0               ;SET HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_166
LCALL OVERCURRENT
RET

OK_166:

CLR P0.7                ;LO CLK INH

SETB P1.7               ;HI SHIFT|/LOAD
CLR P1.7                ;LO SHIFT|/LOAD


CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

SETB P1.7               ;HI SHIFT|/LOAD

JB P1.5,DEVICE_FAIL_166_NEAR



CLR P1.0                ;LO CLK
CLR P0.7                ;LO CLK INH

JB P1.5,DEVICE_FAIL_166_NEAR





CLR P0.7                ;LO CLK INH

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JNB P1.5,DEVICE_FAIL_166_NEAR     ;A

;DEBUG_LOOP:      ;DEBUG
;CPL P0.0         ;
;JMP DEBUG_LOOP   ;


JMP SKIP_166
DEVICE_FAIL_166_NEAR:
LCALL FAILED
RET

SKIP_166:

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JB P1.5,DEVICE_FAIL_166     ;B

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JNB P1.5,DEVICE_FAIL_166     ;C

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JB P1.5,DEVICE_FAIL_166     ;D

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JNB P1.5,DEVICE_FAIL_166     ;E

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JB P1.5,DEVICE_FAIL_166     ;F

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JNB P1.5,DEVICE_FAIL_166     ;G

CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK

JB P1.5,DEVICE_FAIL_166     ;H



MOV COUNTER,#8
SETB P0.2               ;HI SER INPUT
LOOP_CLOCK_166:
CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK
DJNZ COUNTER,LOOP_CLOCK_166

JNB P1.5,DEVICE_FAIL_166     ;SER AT 8 HI

MOV COUNTER,#8
CLR P0.2               ;LO SER INPUT
LOOP_CLOCK_166_2:
CLR P1.0                ;LO CLK
SETB P1.0               ;HI CLK   LOW TO HI TRANSITION
CLR P1.0                ;LO CLK
DJNZ COUNTER,LOOP_CLOCK_166_2

JB P1.5,DEVICE_FAIL_166     ;SER AT 8 LO

CLR P1.1                    ;LO CLR
JB P1.5,DEVICE_FAIL_166     ;ALL CLEAR


LCALL PASSED
RET

DEVICE_FAIL_166:
LCALL FAILED
RET
;------------------------------------------
N74173:

SETB P0.7               ;4Q
SETB P0.6               ;3Q
SETB P0.5               ;2Q
SETB P0.4               ;1Q

LCALL INSERT
SETB P2.0               ;HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_173
LCALL OVERCURRENT
RET

OK_173:

SETB P1.7               ;HI CLR
CLR P0.2                ;M
CLR P0.3                ;N

JB P0.4,DEVICE_FAIL_173_NEAR
JB P0.5,DEVICE_FAIL_173_NEAR
JB P0.6,DEVICE_FAIL_173_NEAR
JB P0.7,DEVICE_FAIL_173_NEAR

CLR P1.7                ;LO CLR
CLR P1.0                ;LO CLK

JB P0.4,DEVICE_FAIL_173_NEAR
JB P0.5,DEVICE_FAIL_173_NEAR
JB P0.6,DEVICE_FAIL_173_NEAR
JB P0.7,DEVICE_FAIL_173_NEAR

JMP SKIP_173


DEVICE_FAIL_173_NEAR:
LCALL FAILED
RET

SKIP_173:


SETB P1.1               ;/G1
SETB P1.0
CLR  P1.0               ;CLOCK PULSE LOW TO HIGH
SETB P1.0

JB P0.4,DEVICE_FAIL_173
JB P0.5,DEVICE_FAIL_173
JB P0.6,DEVICE_FAIL_173
JB P0.7,DEVICE_FAIL_173

SETB P1.2               ;/G2
SETB P1.0
CLR  P1.0               ;CLOCK PULSE LOW TO HIGH
SETB P1.0

JB P0.4,DEVICE_FAIL_173
JB P0.5,DEVICE_FAIL_173
JB P0.6,DEVICE_FAIL_173
JB P0.7,DEVICE_FAIL_173

CLR P1.1                ;LO /G1
CLR P1.2                ;LO /G2



SETB P1.3               ;4D
SETB P1.4               ;3D
SETB P1.5               ;2D
SETB P1.6               ;1D

SETB P1.0
CLR  P1.0               ;CLOCK PULSE LOW TO HIGH
SETB P1.0

JNB P0.4,DEVICE_FAIL_173
JNB P0.5,DEVICE_FAIL_173
JNB P0.6,DEVICE_FAIL_173
JNB P0.7,DEVICE_FAIL_173

CLR P1.3               ;4D
CLR P1.4               ;3D
CLR P1.5               ;2D
CLR P1.6               ;1D

SETB P1.0
CLR  P1.0               ;CLOCK PULSE LOW TO HIGH
SETB P1.0

JB P0.4,DEVICE_FAIL_173
JB P0.5,DEVICE_FAIL_173
JB P0.6,DEVICE_FAIL_173
JB P0.7,DEVICE_FAIL_173

SETB P0.2                ;HI M

JNB P0.4,DEVICE_FAIL_173
JNB P0.5,DEVICE_FAIL_173
JNB P0.6,DEVICE_FAIL_173
JNB P0.7,DEVICE_FAIL_173

SETB P0.3               ;HI N
JNB P0.4,DEVICE_FAIL_173
JNB P0.5,DEVICE_FAIL_173
JNB P0.6,DEVICE_FAIL_173
JNB P0.7,DEVICE_FAIL_173

LCALL PASSED
RET

DEVICE_FAIL_173:
LCALL FAILED
RET

;------------------------------------------
N74174:

SETB P0.3               ;1Q \
SETB P0.6               ;2Q  \
SETB P1.0               ;3Q SET AS INPUTS
SETB P1.2               ;4Q   /
SETB P1.4               ;5Q  /
SETB P1.7               ;6Q/
CLR P0.2                ;LO CLR

LCALL INSERT
SETB P2.0               ;HIGH W/ Vcc
CLR SWITCH2
JNB DETECT,OK_174
LCALL OVERCURRENT
RET
OK_174:
JB P0.3,DEVICE_FAIL_174
JB P0.6,DEVICE_FAIL_174
JB P1.0,DEVICE_FAIL_174
JB P1.2,DEVICE_FAIL_174
JB P1.4,DEVICE_FAIL_174
JB P1.7,DEVICE_FAIL_174

SETB P0.2               ;HI CLR

CLR P0.4                ;1D LO
CLR P0.5                ;2D LO
CLR P0.7                ;3D LO
CLR P1.3                ;4D LO
CLR P1.5                ;5D LO
CLR P1.6                ;6D LO

SETB P1.1
CLR  P1.1                ;ONE CLOCK PULSE
SETB P1.1

JB P0.3,DEVICE_FAIL_174
JB P0.6,DEVICE_FAIL_174
JB P1.0,DEVICE_FAIL_174
JB P1.2,DEVICE_FAIL_174
JB P1.4,DEVICE_FAIL_174
JB P1.7,DEVICE_FAIL_174

SETB P0.4                ;1D HI
SETB P0.5                ;2D HI
SETB P0.7                ;3D HI
SETB P1.3                ;4D HI
SETB P1.5                ;5D HI
SETB P1.6                ;6D HI

SETB P1.1
CLR  P1.1                ;ONE CLOCK PULSE
SETB P1.1

JNB P0.3,DEVICE_FAIL_174
JNB P0.6,DEVICE_FAIL_174
JNB P1.0,DEVICE_FAIL_174
JNB P1.2,DEVICE_FAIL_174
JNB P1.4,DEVICE_FAIL_174
JNB P1.7,DEVICE_FAIL_174

CLR P1.1                ;LO CLOCK

JNB P0.3,DEVICE_FAIL_174
JNB P0.6,DEVICE_FAIL_174
JNB P1.0,DEVICE_FAIL_174
JNB P1.2,DEVICE_FAIL_174
JNB P1.4,DEVICE_FAIL_174
JNB P1.7,DEVICE_FAIL_174

LCALL PASSED
RET

DEVICE_FAIL_174:
LCALL FAILED
RET
;------------------------------------------
N74175:

SETB P0.3               ;1Q
SETB P1.0               ;2Q
SETB P1.2               ;3Q
SETB P1.7               ;4Q
SETB P0.4               ;1/Q
SETB P0.7               ;2/Q
SETB P1.3               ;3/Q
SETB P1.6               ;4/Q

CLR P0.2                ;LO CLR

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_175
LCALL OVERCURRENT
RET

OK_175:

JB P0.3,DEVICE_FAIL_175_NEAR                ;1Q

JMP SKIP_175
DEVICE_FAIL_175_NEAR:
LCALL FAILED
RET

SKIP_175:

JB P1.0,DEVICE_FAIL_175                ;2Q
JB P1.2,DEVICE_FAIL_175                ;3Q
JB P1.7,DEVICE_FAIL_175                ;4Q
JNB P0.4,DEVICE_FAIL_175               ;1/Q
JNB P0.7,DEVICE_FAIL_175               ;2/Q
JNB P1.3,DEVICE_FAIL_175               ;3/Q
JNB P1.6,DEVICE_FAIL_175               ;4/Q

SETB P0.2               ;HI CLR
CLR P0.5                ;1D
CLR P0.6                ;2D
CLR P1.4                ;3D
CLR P1.5                ;4D

SETB P1.1               ;CLOCK
CLR P1.1
SETB P1.1               ;LOW TO HI

JB P0.3,DEVICE_FAIL_175                ;1Q
JB P1.0,DEVICE_FAIL_175                ;2Q
JB P1.2,DEVICE_FAIL_175                ;3Q
JB P1.7,DEVICE_FAIL_175                ;4Q
JNB P0.4,DEVICE_FAIL_175               ;1/Q
JNB P0.7,DEVICE_FAIL_175               ;2/Q
JNB P1.3,DEVICE_FAIL_175               ;3/Q
JNB P1.6,DEVICE_FAIL_175               ;4/Q

SETB P0.5                ;1D
SETB P0.6                ;2D
SETB P1.4                ;3D
SETB P1.5                ;4D

SETB P1.1               ;CLOCK
CLR P1.1
SETB P1.1               ;LOW TO HI

JNB P0.3,DEVICE_FAIL_175                ;1Q
JNB P1.0,DEVICE_FAIL_175                ;2Q
JNB P1.2,DEVICE_FAIL_175                ;3Q
JNB P1.7,DEVICE_FAIL_175                ;4Q
JB P0.4,DEVICE_FAIL_175               ;1/Q
JB P0.7,DEVICE_FAIL_175               ;2/Q
JB P1.3,DEVICE_FAIL_175               ;3/Q
JB P1.6,DEVICE_FAIL_175               ;4/Q

CLR P1.1                ;LO CLOCK

JNB P0.3,DEVICE_FAIL_175                ;1Q
JNB P1.0,DEVICE_FAIL_175                ;2Q
JNB P1.2,DEVICE_FAIL_175                ;3Q
JNB P1.7,DEVICE_FAIL_175                ;4Q
JB P0.4,DEVICE_FAIL_175               ;1/Q
JB P0.7,DEVICE_FAIL_175               ;2/Q
JB P1.3,DEVICE_FAIL_175               ;3/Q
JB P1.6,DEVICE_FAIL_175               ;4/Q

LCALL PASSED
RET

DEVICE_FAIL_175:
LCALL FAILED
RET

;------------------------------------------
N74180:
;NO STOCK
RET
;------------------------------------------
N74190:
;NO STOCK
RET
;------------------------------------------
N74191:

SETB P0.4               ;QA
SETB P0.3               ;QB
SETB P0.7               ;QC
SETB P1.0               ;QD

SETB P1.4               ;MAX/MIN
SETB P1.5               ;/RCO
SETB P1.6               ;CLOCK HI
SETB P1.3               ;LOAD HI

CLR P1.7                ;A
CLR P0.2                ;B
CLR P1.2                ;C
CLR P1.1                ;D

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_191
LCALL OVERCURRENT
RET

OK_191:

SETB P1.3               ;LOAD HI
CLR  P1.3               ;LOAD LO
SETB P1.3               ;LOAD HI

JB  P0.4,DEVICE_FAIL_191               ;QA
JB  P0.3,DEVICE_FAIL_191               ;QB
JB  P0.7,DEVICE_FAIL_191               ;QC
JB  P1.0,DEVICE_FAIL_191               ;QD

;COUNT UP

CLR P0.5                ;/CTEN LO
CLR P0.6                ;D|/U

MOV COUNTER,#16
COUNT_UP_191:
SETB P1.6               ;CLOCK HI
CLR  P1.6               ;CLOCK LO
DJNZ COUNTER,COUNT_UP_191

JNB  P0.4,DEVICE_FAIL_191               ;QA
JNB  P0.3,DEVICE_FAIL_191               ;QB
JNB  P0.7,DEVICE_FAIL_191               ;QC
JNB  P1.0,DEVICE_FAIL_191               ;QD

JNB P1.4,DEVICE_FAIL_191        ;MAX|/MIN
JB  P1.5,DEVICE_FAIL_191         ;/RCO
SETB P1.6               ;CLOCK HI

;COUNT DOWN

SETB P1.7                ;A
SETB P0.2                ;B
SETB P1.2                ;C
SETB P1.1                ;D

SETB P1.3               ;LOAD HI
CLR  P1.3               ;LOAD LO
SETB P1.3               ;LOAD HI


CLR P0.5                ;/CTEN LO
SETB P0.6               ;D|/U

MOV COUNTER,#16
COUNT_DOWN_191:
SETB P1.6               ;CLOCK HI
CLR  P1.6               ;CLOCK LO
DJNZ COUNTER,COUNT_DOWN_191

JB  P0.4,DEVICE_FAIL_191               ;QA
JB  P0.3,DEVICE_FAIL_191               ;QB
JB  P0.7,DEVICE_FAIL_191               ;QC
JB  P1.0,DEVICE_FAIL_191               ;QD

JNB P1.4,DEVICE_FAIL_191        ;MAX|/MIN
JB  P1.5,DEVICE_FAIL_191         ;/RCO
SETB P1.6               ;CLOCK HI

LCALL PASSED
RET

DEVICE_FAIL_191:
LCALL FAILED
RET
;------------------------------------------
N74193:

SETB P0.4               ;Qa
SETB P0.3               ;Qb
SETB P0.7               ;Qc
SETB P1.0               ;Qd

SETB P1.4               ;/CO
SETB P1.5               ;/RCO
SETB P0.5               ;CLOCK HI DOWN
SETB P0.6               ;CLOCK HI UP

SETB P1.3               ;/LOAD HI
CLR P1.6                ;LO CLR

CLR P1.7                ;A
CLR P0.2                ;B
CLR P1.2                ;C
CLR P1.1                ;D

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_193
LCALL OVERCURRENT
RET

OK_193:

CLR P1.6
SETB P1.6
CLR P1.6

JB  P0.4,DEVICE_FAIL_193               ;QA
JB  P0.3,DEVICE_FAIL_193               ;QB
JB  P0.7,DEVICE_FAIL_193               ;QC
JB  P1.0,DEVICE_FAIL_193               ;QD

SETB P1.3               ;LOAD HI
CLR  P1.3               ;LOAD LO
SETB P1.3               ;LOAD HI

MOV B,#255
LOOP_193:
NOP
DJNZ B,LOOP_193




JB  P0.4,DEVICE_FAIL_193               ;QA
JB  P0.3,DEVICE_FAIL_193               ;QB
JB  P0.7,DEVICE_FAIL_193               ;QC
JB  P1.0,DEVICE_FAIL_193               ;QD

;COUNT UP


;DEBUG_LOOP:      ;DEBUG
;CPL P0.0         ;
;JMP DEBUG_LOOP   ;

MOV COUNTER,#16
COUNT_UP_193:
SETB P0.6               ;CLOCK HI
CLR  P0.6               ;CLOCK LO
DJNZ COUNTER,COUNT_UP_193

JNB  P0.4,DEVICE_FAIL_191               ;QA
JNB  P0.3,DEVICE_FAIL_191               ;QB
JNB  P0.7,DEVICE_FAIL_191               ;QC
JNB  P1.0,DEVICE_FAIL_191               ;QD

JB P1.4,DEVICE_FAIL_191        ;/CO
JNB P1.5,DEVICE_FAIL_191        ;/BO
SETB P0.6               ;CLOCK HI

;COUNT DOWN

SETB P1.7                ;A
SETB P0.2                ;B
SETB P1.2                ;C
SETB P1.1                ;D

SETB P1.3               ;LOAD HI
CLR  P1.3               ;LOAD LO
SETB P1.3               ;LOAD HI



MOV COUNTER,#16
COUNT_DOWN_193:
SETB P0.5               ;CLOCK HI
CLR  P0.5               ;CLOCK LO
DJNZ COUNTER,COUNT_DOWN_193

JB  P0.4,DEVICE_FAIL_193               ;QA
JB  P0.3,DEVICE_FAIL_193               ;QB
JB  P0.7,DEVICE_FAIL_193               ;QC
JB  P1.0,DEVICE_FAIL_193               ;QD

JNB P1.4,DEVICE_FAIL_193        ;/CO
JB  P1.5,DEVICE_FAIL_193      ;/BO
SETB P0.5               ;CLOCK HI

LCALL PASSED
RET

DEVICE_FAIL_193:
LCALL FAILED
RET


;------------------------------------------
N74194:

SETB P1.7               ;QA
SETB P1.6               ;QB
SETB P1.5               ;QC
SETB P1.4               ;QD

CLR P0.2                ;/CLR  LO

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_194
LCALL OVERCURRENT
RET

OK_194:

JB P1.7,DEVICE_FAIL_194_NEAR               ;QA
JB P1.6,DEVICE_FAIL_194_NEAR               ;QB
JB P1.5,DEVICE_FAIL_194_NEAR               ;QC
JB P1.4,DEVICE_FAIL_194_NEAR               ;QD

SETB P0.2               ;HI /CLR
CLR P1.3                ;LO CLK

JB P1.7,DEVICE_FAIL_194_NEAR               ;QA
JB P1.6,DEVICE_FAIL_194_NEAR               ;QB
JB P1.5,DEVICE_FAIL_194_NEAR               ;QC
JB P1.4,DEVICE_FAIL_194_NEAR               ;QD

SETB P1.1               ;HI S0
SETB P1.2               ;HI S1

CLR P0.4                ;LO A
CLR P0.5                ;LO B
CLR P0.6                ;LO C
CLR P0.7                ;LO D

SETB P1.3               ;HI CLK
CLR  P1.3               ;LO CLK
SETB P1.3               ;HI CLK

JB P1.7,DEVICE_FAIL_194_NEAR               ;QA
JB P1.6,DEVICE_FAIL_194_NEAR               ;QB
JB P1.5,DEVICE_FAIL_194_NEAR               ;QC
JB P1.4,DEVICE_FAIL_194_NEAR               ;QD

SETB P0.4                ;HI A
SETB P0.5                ;HI B
SETB P0.6                ;HI C
SETB P0.7                ;HI D

SETB P1.3               ;HI CLK
CLR  P1.3               ;LO CLK
SETB P1.3               ;HI CLK

JNB P1.7,DEVICE_FAIL_194_NEAR               ;QA
JNB P1.6,DEVICE_FAIL_194_NEAR               ;QB
JNB P1.5,DEVICE_FAIL_194_NEAR               ;QC
JNB P1.4,DEVICE_FAIL_194_NEAR               ;QD


JMP SKIP_194

DEVICE_FAIL_194_NEAR:
LCALL FAILED
RET

SKIP_194:


SETB P1.1               ;HI S0
CLR  P1.2               ;LO S1

CLR P0.3                ;SR SER

MOV COUNTER,#4
SHIFT_RIGHT_LOW:
SETB P1.3               ;HI CLK
CLR  P1.3               ;LO CLK
SETB P1.3               ;HI CLK
DJNZ COUNTER,SHIFT_RIGHT_LOW

JB P1.7,DEVICE_FAIL_194               ;QA
JB P1.6,DEVICE_FAIL_194               ;QB
JB P1.5,DEVICE_FAIL_194               ;QC
JB P1.4,DEVICE_FAIL_194               ;QD

SETB P0.3                ;SR SER HI

MOV COUNTER,#4
SHIFT_RIGHT_HI:
SETB P1.3               ;HI CLK
CLR  P1.3               ;LO CLK
SETB P1.3               ;HI CLK
DJNZ COUNTER,SHIFT_RIGHT_HI

JNB P1.7,DEVICE_FAIL_194               ;QA
JNB P1.6,DEVICE_FAIL_194               ;QB
JNB P1.5,DEVICE_FAIL_194               ;QC
JNB P1.4,DEVICE_FAIL_194               ;QD

CLR P1.1               ;HI S0
SETB P1.2             ;LO S1

CLR P1.0                ;SL SER

MOV COUNTER,#4
SHIFT_LEFT_LOW:
SETB P1.3               ;HI CLK
CLR  P1.3               ;LO CLK
SETB P1.3               ;HI CLK
DJNZ COUNTER,SHIFT_LEFT_LOW

JB P1.7,DEVICE_FAIL_194               ;QA
JB P1.6,DEVICE_FAIL_194               ;QB
JB P1.5,DEVICE_FAIL_194               ;QC
JB P1.4,DEVICE_FAIL_194               ;QD

SETB P1.0                ;SL SER HI

MOV COUNTER,#4
SHIFT_LEFT_HI:
SETB P1.3               ;HI CLK
CLR  P1.3               ;LO CLK
SETB P1.3               ;HI CLK
DJNZ COUNTER,SHIFT_LEFT_HI

JNB P1.7,DEVICE_FAIL_194               ;QA
JNB P1.6,DEVICE_FAIL_194               ;QB
JNB P1.5,DEVICE_FAIL_194               ;QC
JNB P1.4,DEVICE_FAIL_194               ;QD

CLR P1.1               ;HI S0
CLR P1.2               ;LO S1

JNB P1.7,DEVICE_FAIL_194               ;QA
JNB P1.6,DEVICE_FAIL_194               ;QB
JNB P1.5,DEVICE_FAIL_194               ;QC
JNB P1.4,DEVICE_FAIL_194               ;QD
LCALL PASSED
RET

DEVICE_FAIL_194:
LCALL FAILED
RET

;------------------------------------------
N74197:

SETB P0.7               ;QA
SETB P1.2               ;QB
SETB P0.4               ;QC
SETB P1.5               ;QD

CLR P0.6                ;A
CLR P1.3                ;B
CLR P0.5                ;C
CLR P1.4                ;D

LCALL INSERT
SETB P1.7               ;SET HI W/ Vcc
CLR SWITCH3
JNB DETECT,OK_197
LCALL OVERCURRENT
RET

OK_197:

CLR P0.3               ;LO /LOAD

JB P0.7,DEVICE_FAIL_197               ;QA
JB P1.2,DEVICE_FAIL_197               ;QB
JB P0.4,DEVICE_FAIL_197               ;QC
JB P1.5,DEVICE_FAIL_197               ;QD

CLR P1.6                ;LO /CLR

JB P0.7,DEVICE_FAIL_197               ;QA
JB P1.2,DEVICE_FAIL_197               ;QB
JB P0.4,DEVICE_FAIL_197               ;QC
JB P1.5,DEVICE_FAIL_197               ;QD

SETB P1.6               ;HI CLR
SETB P0.3               ;HI /LOAD

SETB P1.1               ;CLOCK1 HI
CLR  P1.1               ;CLOCK1 LO
SETB P1.1               ;CLOCK1 HI

JNB P0.7,DEVICE_FAIL_197               ;QA

SETB P1.1               ;CLOCK1 HI
CLR  P1.1               ;CLOCK1 LO
SETB P1.1               ;CLOCK1 HI

JB P0.7,DEVICE_FAIL_197               ;QA

MOV COUNTER,#7
LOOP_197:
SETB P1.0               ;CLOCK1 HI
CLR  P1.0               ;CLOCK1 LO
SETB P1.0               ;CLOCK1 HI
DJNZ COUNTER,LOOP_197

JNB P1.2,DEVICE_FAIL_197               ;QB
JNB P0.4,DEVICE_FAIL_197               ;QC
JNB P1.5,DEVICE_FAIL_197               ;QD


LCALL PASSED
RET

DEVICE_FAIL_197:
LCALL FAILED
RET

;------------------------------------------
N74245:

SETB P2.1
MOV P0,#0FFH
MOV P1,#0FFH

LCALL INSERT
SETB P2.0
CLR SWITCH1
JNB DETECT,OK_245
LCALL OVERCURRENT
RET

OK_245:

MOV P1,#00000001B       ;HIGH A8

CLR P2.0                ;LO B1
MOV P0,#11111110B       ;DIR LOW    B TO A
CLR P2.1                ;ENABLE /G

MOV A,P0
CJNE A,#0,DEVICE_FAIL_245
JB P1.0,DEVICE_FAIL_245

MOV P1,#11111111B       ;HIGH A8
SETB P2.0               ;HIGH B1
MOV A,P0
CJNE A,#11111110B,DEVICE_FAIL_245   ;LOW DIR
JNB P1.0,DEVICE_FAIL_245

CLR P1.0                ;LOW A8
SETB P2.0
MOV P0,#00000001B       ;HI DIR    ;A TO B
MOV P1,#11111110B


MOV A,P1
CJNE A,#0,DEVICE_FAIL_245
JB P2.0,DEVICE_FAIL_245 ;LOW B1

SETB P1.0
SETB P2.0
MOV P0,#11111111B

MOV A,P1
CJNE A,#11111111B,DEVICE_FAIL_245
JNB P2.0,DEVICE_FAIL_245

SETB P2.1               ;ENABLE /G HI

MOV P1,#00000001B       ;HIGH A8

CLR P2.0                ;LO B1
MOV P0,#11111110B       ;DIR LOW    B TO A

MOV A,P0
CJNE A,#11111110B,DEVICE_FAIL_245   ;LOW DIR
JNB P1.0,DEVICE_FAIL_245

CLR P1.0                ;LOW A8
SETB P2.0
MOV P0,#00000001B       ;HI DIR    A TO B
MOV P1,#11111110B

MOV A,P1
CJNE A,#11111110B,DEVICE_FAIL_245
JNB P2.0,DEVICE_FAIL_245


LCALL PASSED
RET

DEVICE_FAIL_245:
LCALL FAILED
RET

;------------------------------------------
N74251:

SETB P1.0                       ;ENABLE HI
setb P0.6
setb P0.7
LCALL INSERT
SETB P2.0                       ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_251
LCALL OVERCURRENT
RET

OK_251:

JNB P0.6,DEVICE_FAIL_251_NEAR        ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

CLR P1.0                        ;ENABLE /G LO
CLR P0.5                        ;D0
CLR P0.4                        ;D1
CLR P0.3                        ;D2
CLR P0.2                        ;D3
CLR P1.7                        ;D4
CLR P1.6                        ;D5
CLR P1.5                        ;D6
CLR P1.4                        ;D7

CLR P1.3                        ;A
CLR P1.2                        ;B
CLR P1.1                        ;C

JB P0.6,DEVICE_FAIL_251_NEAR         ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

SETB P1.3                        ;A
CLR P1.2                        ;B
CLR P1.1                        ;C

JB P0.6,DEVICE_FAIL_251_NEAR         ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

CLR P1.3                        ;A
SETB P1.2                        ;B
CLR P1.1                        ;C

JB P0.6,DEVICE_FAIL_251_NEAR         ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

SETB P1.3                        ;A
SETB P1.2                        ;B
CLR P1.1                        ;C

JB P0.6,DEVICE_FAIL_251_NEAR         ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

CLR P1.3                        ;A
CLR P1.2                        ;B
SETB P1.1                        ;C

JB P0.6,DEVICE_FAIL_251_NEAR         ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

SETB P1.3                        ;A
CLR P1.2                        ;B
SETB P1.1                        ;C

JB P0.6,DEVICE_FAIL_251_NEAR         ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

CLR P1.3                        ;A
SETB P1.2                        ;B
SETB P1.1                        ;C

JB P0.6,DEVICE_FAIL_251_NEAR         ;Y
JNB P0.7,DEVICE_FAIL_251_NEAR        ;W

JMP SKIP_251

DEVICE_FAIL_251_NEAR:
LCALL FAILED
RET

SKIP_251:

SETB P1.3                        ;A
SETB P1.2                        ;B
SETB P1.1                        ;C

JB P0.6,DEVICE_FAIL_251         ;Y
JNB P0.7,DEVICE_FAIL_251        ;W

SETB P0.5                        ;D0
SETB P0.4                        ;D1
SETB P0.3                        ;D2
SETB P0.2                        ;D3
SETB P1.7                        ;D4
SETB P1.6                        ;D5
SETB P1.5                        ;D6
SETB P1.4                        ;D7

CLR P1.3                        ;A
CLR P1.2                        ;B
CLR P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W

SETB P1.3                        ;A
CLR P1.2                        ;B
CLR P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W

CLR P1.3                        ;A
SETB P1.2                        ;B
CLR P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W

SETB P1.3                        ;A
SETB P1.2                        ;B
CLR P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W

CLR P1.3                        ;A
CLR P1.2                        ;B
SETB P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W

SETB P1.3                        ;A
CLR P1.2                        ;B
SETB P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W

CLR P1.3                        ;A
SETB P1.2                        ;B
SETB P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W

SETB P1.3                        ;A
SETB P1.2                        ;B
SETB P1.1                        ;C

JNB P0.6,DEVICE_FAIL_251         ;Y
JB P0.7,DEVICE_FAIL_251        ;W


LCALL PASSED
RET

DEVICE_FAIL_251:
LCALL FAILED
RET

;------------------------------------------
N74279:

SETB P0.5               ;1Q
SETB P1.0               ;2Q
SETB P1.1               ;3Q
SETB P1.5               ;4Q

SETB P0.3               ;1/S1
SETB P0.4               ;1/S2
CLR  P0.2               ;1/R

CLR  P0.6               ;2/R
SETB P0.7               ;2/S

CLR  P1.2               ;3/R
SETB P1.3               ;3/S1
SETB P1.4               ;3/S2

CLR P1.6                ;4/R
SETB P1.7               ;4/S

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_279
LCALL OVERCURRENT
RET

OK_279:

JB P0.5,DEVICE_FAIL_279
JB P1.0,DEVICE_FAIL_279
JB P1.1,DEVICE_FAIL_279
JB P1.5,DEVICE_FAIL_279

CLR P0.3               ;1/S1
CLR P0.4               ;1/S2
SETB P0.2              ;1/R

SETB  P0.6               ;2/R
CLR P0.7               ;2/S

SETB  P1.2               ;3/R
CLR P1.3               ;3/S1
CLR P1.4               ;3/S2

SETB P1.6                ;4/R
CLR P1.7               ;4/S

JNB P0.5,DEVICE_FAIL_279
JNB P1.0,DEVICE_FAIL_279
JNB P1.1,DEVICE_FAIL_279
JNB P1.5,DEVICE_FAIL_279

SETB P0.3               ;1/S1
SETB P0.4               ;1/S2
SETB P0.2              ;1/R

SETB  P0.6               ;2/R
SETB P0.7               ;2/S

SETB  P1.2               ;3/R
SETB P1.3               ;3/S1
SETB P1.4               ;3/S2

SETB P1.6                ;4/R
SETB P1.7               ;4/S

JNB P0.5,DEVICE_FAIL_279
JNB P1.0,DEVICE_FAIL_279
JNB P1.1,DEVICE_FAIL_279
JNB P1.5,DEVICE_FAIL_279

LCALL PASSED
RET

DEVICE_FAIL_279:
LCALL FAILED
RET

;------------------------------------------
N74298:

SETB P1.7               ;QA
SETB P1.6               ;QB
SETB P1.5               ;QC
SETB P1.4               ;QD

CLR P0.4                ;A1
CLR P0.5                ;B1
CLR P1.1                ;C1
CLR P1.0                ;D1

CLR P0.3                ;A2
CLR P0.2                ;B2
CLR P0.6                ;C2
CLR P0.7                ;D2

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_298
LCALL OVERCURRENT
RET

OK_298:
CLR P1.2                ;WS WORD SELECT LO

SETB P1.3               ;CLOCK HI
CLR  P1.3               ;CLOCK LO
SETB P1.3               ;CLOCK HI

JB P1.7,DEVICE_FAIL_298
JB P1.6,DEVICE_FAIL_298
JB P1.5,DEVICE_FAIL_298
JB P1.4,DEVICE_FAIL_298

SETB P1.2               ;WS WORD SELECT  HI

SETB P1.3               ;CLOCK HI
CLR  P1.3               ;CLOCK LO
SETB P1.3               ;CLOCK HI

JB P1.7,DEVICE_FAIL_298
JB P1.6,DEVICE_FAIL_298
JB P1.5,DEVICE_FAIL_298
JB P1.4,DEVICE_FAIL_298

SETB P0.4                ;A1
SETB P0.5                ;B1
SETB P1.1                ;C1
SETB P1.0                ;D1

SETB P0.3                ;A2
SETB P0.2                ;B2
SETB P0.6                ;C2
SETB P0.7                ;D2

CLR P1.2                ;WS WORD SELECT LO

SETB P1.3               ;CLOCK HI
CLR  P1.3               ;CLOCK LO
SETB P1.3               ;CLOCK HI

JNB P1.7,DEVICE_FAIL_298
JNB P1.6,DEVICE_FAIL_298
JNB P1.5,DEVICE_FAIL_298
JNB P1.4,DEVICE_FAIL_298

SETB P1.2               ;WS WORD SELECT  HI

SETB P1.3               ;CLOCK HI
CLR  P1.3               ;CLOCK LO
SETB P1.3               ;CLOCK HI

JNB P1.7,DEVICE_FAIL_298
JNB P1.6,DEVICE_FAIL_298
JNB P1.5,DEVICE_FAIL_298
JNB P1.4,DEVICE_FAIL_298

LCALL PASSED
RET

DEVICE_FAIL_298:
LCALL FAILED
RET

;------------------------------------------
N74365:

SETB P0.2               ;HI /G1
SETB P1.7               ;HI /G2

setb P0.4            ;Y1
setb P0.6            ;Y2
setb P1.0            ;Y3
setb P1.1            ;Y4
setb P1.3            ;Y5
setb P1.5




LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_365
LCALL OVERCURRENT
RET

OK_365:

SETB P0.3               ;A1
SETB P0.5               ;A2
SETB P0.7               ;A3
SETB P1.2               ;A4
SETB P1.4               ;A5
SETB P1.6               ;A6

CLR P0.2                ;LO /G1
CLR P1.7                ;LO /G2

JNB P0.4,DEVICE_FAIL_365                ;Y1
JNB P0.6,DEVICE_FAIL_365                ;Y2
JNB P1.0,DEVICE_FAIL_365                ;Y3
JNB P1.1,DEVICE_FAIL_365                ;Y4
JNB P1.3,DEVICE_FAIL_365                ;Y5
JNB P1.5,DEVICE_FAIL_365                ;Y6

CLR P0.3               ;A1
CLR P0.5               ;A2
CLR P0.7               ;A3
CLR P1.2               ;A4
CLR P1.4               ;A5
CLR P1.6               ;A6

JB P0.4,DEVICE_FAIL_365                ;Y1
JB P0.6,DEVICE_FAIL_365                ;Y2
JB P1.0,DEVICE_FAIL_365                ;Y3
JB P1.1,DEVICE_FAIL_365                ;Y4
JB P1.3,DEVICE_FAIL_365                ;Y5
JB P1.5,DEVICE_FAIL_365                ;Y6

SETB P0.2               ;HI /G1
SETB P1.7               ;HI /G2

JNB P0.4,DEVICE_FAIL_365                ;Y1
JNB P0.6,DEVICE_FAIL_365                ;Y2
JNB P1.0,DEVICE_FAIL_365                ;Y3
JNB P1.1,DEVICE_FAIL_365                ;Y4
JNB P1.3,DEVICE_FAIL_365                ;Y5
JNB P1.5,DEVICE_FAIL_365                ;Y6

LCALL PASSED
RET

DEVICE_FAIL_365:
LCALL FAILED
RET
;------------------------------------------
N74366:

SETB P0.2               ;HI /G1
SETB P1.7               ;HI /G2

setb P0.4               ;Y1
setb P0.6               ;Y2
setb P1.0               ;Y3
setb P1.1               ;Y4
setb P1.3               ;Y5
setb P1.5               ;Y6

LCALL INSERT
SETB P2.0               ;SET HI W/ Vcc
CLR SWITCH2
JNB DETECT,OK_366
LCALL OVERCURRENT
RET

OK_366:

CLR P0.3               ;A1
CLR P0.5               ;A2
CLR P0.7               ;A3
CLR P1.2               ;A4
CLR P1.4               ;A5
CLR P1.6               ;A6



CLR P0.2                ;LO /G1
CLR P1.7                ;LO /G2

JNB P0.4,DEVICE_FAIL_366                ;Y1
JNB P0.6,DEVICE_FAIL_366                ;Y2
JNB P1.0,DEVICE_FAIL_366                ;Y3
JNB P1.1,DEVICE_FAIL_366                ;Y4
JNB P1.3,DEVICE_FAIL_366                ;Y5
JNB P1.5,DEVICE_FAIL_366                ;Y6


SETB P0.3               ;A1
SETB P0.5               ;A2
SETB P0.7               ;A3
SETB P1.2               ;A4
SETB P1.4               ;A5
SETB P1.6               ;A6

JB P0.4,DEVICE_FAIL_366                ;Y1
JB P0.6,DEVICE_FAIL_366                ;Y2
JB P1.0,DEVICE_FAIL_366                ;Y3
JB P1.1,DEVICE_FAIL_366                ;Y4
JB P1.3,DEVICE_FAIL_366                ;Y5
JB P1.5,DEVICE_FAIL_366                ;Y6

SETB P0.2               ;HI /G1
SETB P1.7               ;HI /G2

JNB P0.4,DEVICE_FAIL_366                ;Y1
JNB P0.6,DEVICE_FAIL_366                ;Y2
JNB P1.0,DEVICE_FAIL_366                ;Y3
JNB P1.1,DEVICE_FAIL_366                ;Y4
JNB P1.3,DEVICE_FAIL_366                ;Y5
JNB P1.5,DEVICE_FAIL_366                ;Y6

LCALL PASSED
RET

DEVICE_FAIL_366:
LCALL FAILED
RET
;------------------------------------------
N74367:
LCALL N74365
RET
;------------------------------------------
N74368:
LCALL N74366
RET
;------------------------------------------
N74373:
SETB P0.1               ;1Q
SETB P0.4               ;2Q
SETB P0.5               ;3Q
SETB P1.0               ;4Q
SETB P1.2               ;5Q
SETB P1.5               ;6Q
SETB P1.6               ;7Q
SETB P2.1               ;8Q

clr P0.0               ;/OE
LCALL INSERT
CLR SWITCH1
JNB DETECT,OK_373
LCALL OVERCURRENT
RET

OK_373:

SETB P0.2               ;1D
SETB P0.3               ;2D
SETB P0.6               ;3D
SETB P0.7               ;4D
SETB P1.3               ;5D
SETB P1.4               ;6D
SETB P1.7               ;7D
SETB P2.0               ;8D

CLR P0.0                ;/OE
SETB P1.1               ;ENABLE LATCH


call delay_20ms
JNB P0.1,DEVICE_FAIL_373_NEAR               ;1Q
JNB P0.4,DEVICE_FAIL_373_NEAR               ;2Q
JNB P0.5,DEVICE_FAIL_373_NEAR               ;3Q
JNB P1.0,DEVICE_FAIL_373_NEAR               ;4Q
JNB P1.2,DEVICE_FAIL_373_NEAR               ;5Q
JNB P1.5,DEVICE_FAIL_373_NEAR               ;6Q
JNB P1.6,DEVICE_FAIL_373_NEAR               ;7Q
JNB P2.1,DEVICE_FAIL_373_NEAR               ;8Q

JMP SKIP_373
DEVICE_FAIL_373_NEAR:
LCALL FAILED
RET

SKIP_373:

CLR P1.1                ;ENABLE LATCH

call delay_20ms
JNB P0.1,DEVICE_FAIL_373_NEAR               ;1Q
JNB P0.4,DEVICE_FAIL_373_near               ;2Q
JNB P0.5,DEVICE_FAIL_373               ;3Q
JNB P1.0,DEVICE_FAIL_373               ;4Q
JNB P1.2,DEVICE_FAIL_373               ;5Q
JNB P1.5,DEVICE_FAIL_373               ;6Q
JNB P1.6,DEVICE_FAIL_373               ;7Q
JNB P2.1,DEVICE_FAIL_373               ;8Q


SETB P1.1               ;ENABLE LATCH
setb p0.0

CLR P0.2               ;1D
CLR P0.3               ;2D
CLR P0.6               ;3D
CLR P0.7               ;4D
CLR P1.3               ;5D
CLR P1.4               ;6D
CLR P1.7               ;7D
CLR P2.0               ;8D

CLR P0.0                ;/OE


call delay_20ms
JB P0.1,DEVICE_FAIL_373               ;1Q
JB P0.4,DEVICE_FAIL_373               ;2Q
JB P0.5,DEVICE_FAIL_373               ;3Q
JB P1.0,DEVICE_FAIL_373               ;4Q
JB P1.2,DEVICE_FAIL_373               ;5Q
JB P1.5,DEVICE_FAIL_373               ;6Q
JB P1.6,DEVICE_FAIL_373               ;7Q
JB P2.1,DEVICE_FAIL_373               ;8Q

CLR P1.1                ;ENABLE LATCH

call delay_20ms
JB P0.1,DEVICE_FAIL_373               ;1Q
JB P0.4,DEVICE_FAIL_373               ;2Q
JB P0.5,DEVICE_FAIL_373               ;3Q
JB P1.0,DEVICE_FAIL_373               ;4Q
JB P1.2,DEVICE_FAIL_373               ;5Q
JB P1.5,DEVICE_FAIL_373               ;6Q
JB P1.6,DEVICE_FAIL_373               ;7Q
JB P2.1,DEVICE_FAIL_373               ;8Q

SETB P0.0               ;/OE


call delay_20ms
JNB P0.1,DEVICE_FAIL_373               ;1Q
JNB P0.4,DEVICE_FAIL_373               ;2Q
JNB P0.5,DEVICE_FAIL_373               ;3Q
JNB P1.0,DEVICE_FAIL_373               ;4Q
JNB P1.2,DEVICE_FAIL_373               ;5Q
JNB P1.5,DEVICE_FAIL_373               ;6Q
JNB P1.6,DEVICE_FAIL_373               ;7Q
JNB P2.1,DEVICE_FAIL_373               ;8Q

LCALL PASSED
RET

DEVICE_FAIL_373:
LCALL FAILED
RET
;------------------------------------------
N74374:
SETB P0.1               ;1Q
SETB P0.4               ;2Q
SETB P0.5               ;3Q
SETB P1.0               ;4Q
SETB P1.2               ;5Q
SETB P1.5               ;6Q
SETB P1.6               ;7Q
SETB P2.1               ;8Q

clr P0.0               ;/OE
LCALL INSERT
CLR SWITCH1
JNB DETECT,OK_374
LCALL OVERCURRENT
RET

OK_374:

SETB P0.2               ;1D
SETB P0.3               ;2D
SETB P0.6               ;3D
SETB P0.7               ;4D
SETB P1.3               ;5D
SETB P1.4               ;6D
SETB P1.7               ;7D
SETB P2.0               ;8D

CLR P0.0                ;/OE
SETB P1.1               ;ENABLE LATCH
CLR  P1.1
SETB P1.1               ;LOW TO HIGH

JNB P0.1,DEVICE_FAIL_374_NEAR               ;1Q
JNB P0.4,DEVICE_FAIL_374_NEAR               ;2Q
JNB P0.5,DEVICE_FAIL_374_NEAR               ;3Q
JNB P1.0,DEVICE_FAIL_374_NEAR               ;4Q
JNB P1.2,DEVICE_FAIL_374_NEAR               ;5Q
JNB P1.5,DEVICE_FAIL_374_NEAR               ;6Q
JNB P1.6,DEVICE_FAIL_374_NEAR               ;7Q
JNB P2.1,DEVICE_FAIL_374_NEAR               ;8Q

JMP SKIP_374
DEVICE_FAIL_374_NEAR:
LCALL FAILED
RET

SKIP_374:

CLR P1.1                ;ENABLE LATCH

JNB P0.1,DEVICE_FAIL_374               ;1Q
JNB P0.4,DEVICE_FAIL_374               ;2Q
JNB P0.5,DEVICE_FAIL_374               ;3Q
JNB P1.0,DEVICE_FAIL_374               ;4Q
JNB P1.2,DEVICE_FAIL_374               ;5Q
JNB P1.5,DEVICE_FAIL_374               ;6Q
JNB P1.6,DEVICE_FAIL_374               ;7Q
JNB P2.1,DEVICE_FAIL_374               ;8Q

CLR P0.2               ;1D
CLR P0.3               ;2D
CLR P0.6               ;3D
CLR P0.7               ;4D
CLR P1.3               ;5D
CLR P1.4               ;6D
CLR P1.7               ;7D
CLR P2.0               ;8D

CLR P0.0                ;/OE
SETB P1.1               ;ENABLE LATCH
CLR  P1.1
SETB P1.1               ;LOW TO HIGH

JB P0.1,DEVICE_FAIL_374               ;1Q
JB P0.4,DEVICE_FAIL_374               ;2Q
JB P0.5,DEVICE_FAIL_374               ;3Q
JB P1.0,DEVICE_FAIL_374               ;4Q
JB P1.2,DEVICE_FAIL_374               ;5Q
JB P1.5,DEVICE_FAIL_374               ;6Q
JB P1.6,DEVICE_FAIL_374               ;7Q
JB P2.1,DEVICE_FAIL_374               ;8Q

CLR P1.1                ;ENABLE LATCH

JB P0.1,DEVICE_FAIL_374               ;1Q
JB P0.4,DEVICE_FAIL_374               ;2Q
JB P0.5,DEVICE_FAIL_374               ;3Q
JB P1.0,DEVICE_FAIL_374               ;4Q
JB P1.2,DEVICE_FAIL_374               ;5Q
JB P1.5,DEVICE_FAIL_374               ;6Q
JB P1.6,DEVICE_FAIL_374               ;7Q
JB P2.1,DEVICE_FAIL_374               ;8Q

SETB P0.0               ;/OE

JNB P0.1,DEVICE_FAIL_374               ;1Q
JNB P0.4,DEVICE_FAIL_374               ;2Q
JNB P0.5,DEVICE_FAIL_374               ;3Q
JNB P1.0,DEVICE_FAIL_374               ;4Q
JNB P1.2,DEVICE_FAIL_374               ;5Q
JNB P1.5,DEVICE_FAIL_374               ;6Q
JNB P1.6,DEVICE_FAIL_374               ;7Q
JNB P2.1,DEVICE_FAIL_374               ;8Q

LCALL PASSED
RET

DEVICE_FAIL_374:
LCALL FAILED

RET
;------------------------------------------
INSERT:
LCALL HOME
LCALL CLEAR
MOV DPTR,#INSERT_MSG
LCALL DISPLAY_STRING

LCALL SECOND_LINE
MOV DPTR,#PROCEED_MSG
LCALL DISPLAY_STRING
LCALL SCANKEYPAD

CJNE A,#11,INSERT

RET
;------------------------------------------
;------------------------------------------
PASSED:
SETB SWITCH1      ;TURN OFF VCC
SETB SWITCH2
SETB SWITCH3

setb P2.0          ;shutdown power
setb P1.7


LCALL HOME
LCALL CLEAR
MOV DPTR,#PASS_MSG
LCALL DISPLAY_STRING

LCALL SECOND_LINE
MOV DPTR,#PROCEED_MSG
LCALL DISPLAY_STRING
LCALL SCANKEYPAD

CJNE A,#11,PASSED

RET
;------------------------------------------
;------------------------------------------
FAILED:
SETB SWITCH1      ;TURN OFF VCC
SETB SWITCH2
SETB SWITCH3

setb P2.0         ;shutdown power
setb P1.7


LCALL HOME
LCALL CLEAR
MOV DPTR,#FAIL_MSG
LCALL DISPLAY_STRING

LCALL SECOND_LINE
MOV DPTR,#PROCEED_MSG
LCALL DISPLAY_STRING
LCALL SCANKEYPAD

CJNE A,#11,FAILED


RET
;------------------------------------------
OVERCURRENT:
CALL HOME
LCALL CLEAR
MOV DPTR,#OVERCURRENT_MSG
LCALL DISPLAY_STRING
SETB SWITCH1      ;TURN OFF VCC
SETB SWITCH2
SETB SWITCH3

setb P2.0         ;shutdown power
setb P1.7



LCALL SECOND_LINE
MOV DPTR,#PROCEED_MSG
LCALL DISPLAY_STRING
LCALL SCANKEYPAD

CJNE A,#11,OVERCURRENT



RET
;------------------------------------------



END
