#include <Wire.h> // must be included here so that Arduino library object file references work
#include <RtcDS3231.h>
RtcDS3231<TwoWire> Rtc(Wire);

#define countof(a) (sizeof(a) / sizeof(a[0]))
String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0

//-------To convert clock into single number
unsigned long ntm;
unsigned long th;
unsigned long tm;
unsigned long ts;

// ---- Enter on times ------ 
// enter last entry first ---
/*
int on_hour[]={23,4, 7, 10,14,17,20 };
int on_min[] ={13,30,10,30,10,20,30 };
int on_sec[] ={7,1, 2, 3, 4, 0, 6  };

//----- Enter off times ----------
int off_hour[]={1,6,9,12,16,19,22};  
int off_min[]={10,15,15,44,30,30,30};
int off_sec[]={43,3,54,55,56,30,45};
*/

int on_hour[]={23,3,5,  7,10,13,  17,19,21  };
int on_min[] ={13,5,10, 5,5,30,   20,30,30 };
int on_sec[] ={7,1, 2,  3,4,0,  6,14,55  };

//----- Enter off times ----------
int off_hour[]={1,4,6,   8,12,15,  18,21,22};  
int off_min[]={10,10,10, 30,40,45,  6,9,50};
int off_sec[]={43,3,54,  55,56,30, 45,26,27};

unsigned long on_Time;
unsigned long off_Time;

byte onhour;                 
byte onmin;                   
byte onsec;

byte offhour;
byte offmin;
byte offsec;

int relay1=3;
int relay2=4;
void setup () {
    pinMode(relay1,OUTPUT);
    digitalWrite(relay1,0);
 
    pinMode(relay2,OUTPUT);
    digitalWrite(relay2,0);
     
    Serial.begin(115200);
    Serial.print("Computer compiled: ");
    Serial.print(__DATE__);
    Serial.println(__TIME__);

    //--------RTC SETUP ------------
    // if you are using ESP-01 then uncomment the line below to reset the pins to
    // the available pins for SDA, SCL
    // Wire.begin(0, 2); // due to limited pins, use pin 0 and 2 for SDA, SCL
    
    Rtc.Begin();

    RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
    printDateTime(compiled);
    Serial.println();

    if (!Rtc.IsDateTimeValid()) {
        // Common Cuases:
        //    1) first time you ran and the device wasn't running yet
        //    2) the battery on the device is low or even missing

        Serial.println("RTC lost confidence in the DateTime!");

        // following line sets the RTC to the date & time this sketch was compiled
        // it will also reset the valid flag internally unless the Rtc device is
        // having an issue

        Rtc.SetDateTime(compiled);
    }

    if (!Rtc.GetIsRunning())    {
        Serial.println("RTC was not actively running, starting now");
        Rtc.SetIsRunning(true);
    }

    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled) 
    {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled) 
    {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }

    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 
}

void loop () {
  
    if (!Rtc.IsDateTimeValid())     {
        // Common Cuases:
        //    1) the battery on the device is low or even missing and the power line was disconnected
        Serial.println("RTC lost confidence in the DateTime!");
    }
RtcDateTime now = Rtc.GetDateTime();
RtcTemperature temp = Rtc.GetTemperature();
th = now.Hour();
tm = now.Minute();
ts = now.Second();
ntm = th*10000+tm*100+ts*1;


    printDateTime(now);
    Serial.print(" ");
    Serial.print(temp.AsFloat());
    Serial.println("C");
   
delay(1000); 


for(int i=1;i<=9;i++){

//for(int i=1;i<=7;i++){  
onhour=on_hour[i-1];                  
onmin=on_min[i-1];                   
onsec=on_sec[i-1];

offhour=off_hour[i-1];
offmin=off_min[i-1];
offsec=off_sec[i-1];

on_Time=onhour*10000UL+onmin*100+onsec;
off_Time=offhour*10000UL + offmin*100 + offsec;

/*
Serial.print("on_time:");
Serial.print(on_Time);
Serial.print(" ");
Serial.print("off_time:");
Serial.print(off_Time);
Serial.print(" ");
Serial.print("time:");
Serial.print(ntm);
Serial.println(" ");
*/

switch(i) {
  
case 1:
if(i==1)  timer();
break;


case 2:
if(i==2)  timer();
break;

case 3:
if(i==3)  timer();
break;

case 4:
if(i==4)  timer();
break;

case 5:
if(i==5)  timer();
break;

case 6:
if(i==6)  timer();
break;

case 7:
if(i==7)  timer();
break;

case 8:
if(i==8)  timer();
break;

case 9:
if(i==9)  timer();
break;

default:
for(int k=1;k<=9;k++) {
  digitalWrite(relay1, LOW); 
  digitalWrite(relay2, LOW); 
}
    }
  }
}

void timer() {    
if(onhour == offhour && onmin==offmin && onsec==offsec){
   digitalWrite(relay1, LOW);
   digitalWrite(relay2, LOW);
}
    
if(on_Time < off_Time and ntm>=off_Time){
   digitalWrite(relay1, LOW);
   digitalWrite(relay2, LOW);
}

if(on_Time < off_Time){
             if(ntm >= on_Time && ntm < off_Time){  //Start
             digitalWrite(relay1, HIGH);
             digitalWrite(relay2, HIGH);

              }
             else if(ntm >= off_Time) {
             digitalWrite(relay1, LOW);
             digitalWrite(relay2, LOW);
             }
}
if (on_Time > off_Time){
            if(ntm >= on_Time && ntm <= 235959){     //Start
            digitalWrite(relay1, HIGH);  
            digitalWrite(relay2, HIGH);

            
            }
            else if(ntm < off_Time ){
            digitalWrite(relay1, HIGH);
            digitalWrite(relay2, HIGH);

            }
            else if(ntm >= off_Time && ntm < on_Time){
            digitalWrite(relay1, LOW);  
            digitalWrite(relay2, LOW);

            }
    }

}


void printDateTime(const RtcDateTime& dt){
    char datestring[20];
    snprintf_P(datestring, 
            countof(datestring),
            PSTR("%02u/%02u/%04u %02u:%02u:%02u"),
            dt.Day(),
            dt.Month(),
            dt.Year(),
            dt.Hour(),
            dt.Minute(),
            dt.Second() );
    Serial.print(datestring);
   
}
