//Soft I2C implementation for 16F1455

#ifndef PIC16F1455_SOFTI2C_H
#define PIC16F1455_SOFTI2C_H
#include <xc.h>

//pin primitives
//may need to set ANSEL too
#define SDAHI {TRISCbits.TRISC2=1;NOP();}
#define SDALO {LATCbits.LATC2=0;TRISCbits.TRISC2=0;}
#define SCLHI {TRISCbits.TRISC3=1;NOP();}
#define SCLLO {LATCbits.LATC3=0;TRISCbits.TRISC3=0;}
#define SDAREAD (PORTCbits.RC2)

//functions
unsigned char I2Cbit(unsigned char n);
unsigned int I2Cbyte(unsigned char n);
void I2Cstart(void);
void I2Cstop(void);

#endif  //PIC16F1455_SOFTI2C_H

