#include "softi2c.h"

unsigned char I2Cbit(unsigned char n){      //send one bit, return bit
    unsigned char b=0;
    if(n!=0){
        SDAHI
    }else{
        SDALO
    }
    NOP();
    NOP();
    SCLHI
    NOP();
    NOP();
    b=SDAREAD;        //read bit
    SCLLO
    return b;
}

unsigned int I2Cbyte(unsigned char n){     //send byte,return read byte + ACK
    unsigned int b=0;
    b=(I2Cbit(n&128)<<7);
    b=b+(I2Cbit(n&64)<<6);
    b=b+(I2Cbit(n&32)<<5);
    b=b+(I2Cbit(n&16)<<4);
    b=b+(I2Cbit(n&8)<<3);
    b=b+(I2Cbit(n&4)<<2);
    b=b+(I2Cbit(n&2)<<1);
    b=b+(I2Cbit(n&1));
    if(I2Cbit(1)){b=b|0x100;}       //set ack bit
    return b;
}

void I2Cstart(void){                 //send start condition
    SDAHI          //allow repeated start
    NOP();
    SDALO
    NOP();
    SCLLO
}

void I2Cstop(void){                  //send stop condition
    SDALO
    NOP();
    SCLHI
    NOP();
    SDAHI
}
