//SSD1306/SH1106 OLED implementation for 16F1455

#include "oled.h"
#include "softi2c.h"

//for startup delay
#define _XTAL_FREQ 48000000

void OLEDsendCommand(unsigned char c){
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x80); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDsendData(unsigned char c){     //not used only does a single byte
    I2Cstart();
    I2Cbyte(OLED_ADDRESS); //write
    I2Cbyte(0x40); //write
    I2Cbyte(c); //write
    I2Cstop();
}

void OLEDinit(void){
    __delay_ms(200);        //startup delay for display
    OLEDsendCommand(0x20);  //set addressing mode
    OLEDsendCommand(0x02);  //set page addressing mode (SH1106 only supports page mode)
    OLEDsendCommand(0x8D);  //Charge pump setting
    OLEDsendCommand(0x14);  //Enable Charge pump
    OLEDsendCommand(0xA1);  //column reverse
    //OLEDsendCommand(0xA0);  //column normal
    OLEDsendCommand(0xC8);  //row reverse
    //OLEDsendCommand(0xC0);  //row normal
    OLEDsendCommand(0xAF);  //display on
    OLEDclear();
}

void OLEDclear(void){
    unsigned char i,j;
    for(i=0;i<8;i++){
        OLEDsendCommand(0xB0+i); //cycle through pages
        OLEDsendCommand(OLED_X_OFFSET);   //column=0 (lower nybble)     
        OLEDsendCommand(0x10);   //column=0 (upper nybble)
        I2Cstart();
        I2Cbyte(OLED_ADDRESS); //write
        I2Cbyte(0x40); //write data
        for(j=0;j<128;j++){
            I2Cbyte(0x00);
        }
        I2Cstop();
    }
}

void OLEDsetpage(unsigned char p){
    //p=7-p;      //flipped
    OLEDsendCommand(0xB0 + (p&7));      //set page address    
}

void OLEDsetcolumn(unsigned char c){
    //c=127-c;     //flipped
    c=c+OLED_X_OFFSET;
    OLEDsendCommand(0x00 + (c & 0x0F));  //set column lower address
    OLEDsendCommand(0x10 + ((c>>4)&0x0F));   //set column higher address    
}

void OLEDchar(char c){
    int i,j;
    if(c<32){return;}
    if(c>127){return;}
    i=(((int)c)-32)*6;
    I2Cstart();
    I2Cbyte(OLED_ADDRESS);  //write
    I2Cbyte(0x40);          //write data
    for(j=i;j<i+6;j++){     //6 font columns
        I2Cbyte(font[j]);
    }
    I2Cstop();
}

void OLEDchararray(char* c){
    while(*c){
        OLEDchar(*c++);
    }
}

void OLEDbigchar(char c,unsigned char x){       //need to know x because we write over multiple pages
    unsigned int i,j;
    if(c<0){return;}
    if(c>14){return;}       //0-9+ space kph, mph, kts
    for(i=0;i<3;i++){       //change 1 to 0 to overwrite bottom row
        OLEDsetpage(i*2);
        OLEDsetcolumn(x);
        I2Cstart();
        I2Cbyte(OLED_ADDRESS);  //write
        I2Cbyte(0x40);          //write data
        for(j=0;j<16;j++){
            I2Cbyte(fontdouble[bigfont[(int)c*48+i*16+j]&0xF]);
            I2Cbyte(fontdouble[bigfont[(int)c*48+i*16+j]&0xF]);
        }
        I2Cstop();
        OLEDsetpage(i*2+1);
        OLEDsetcolumn(x);
        I2Cstart();
        I2Cbyte(OLED_ADDRESS);  //write
        I2Cbyte(0x40);          //write data
        for(j=0;j<16;j++){
            I2Cbyte(fontdouble[(bigfont[(int)c*48+i*16+j]>>4)&0xF]);
            I2Cbyte(fontdouble[(bigfont[(int)c*48+i*16+j]>>4)&0xF]);
        }
        I2Cstop();
    }
}

void OLEDsetcontrast(unsigned char c){
    OLEDsendCommand(0x81);
    OLEDsendCommand(c);    
}
