#include "config.h"
#define _XTAL_FREQ 48000000
#include <xc.h>
#include "io.h"
#include "uart.h"
#include "softi2c.h"
#include "oled.h"
#include "font.h"
#include "gps.h"
#include "timer1.h"
#include "flash.h"
#include <stdlib.h>     //for atof

#define KNOTS_MPH (1.15078) 
#define KNOTS_KPH (1.852)
//bar graph elements (bitmaps; LSB at top)
#define BAR_END (126)
#define BAR_ON (90)
#define BAR_OFF (66)

enum cursor {home, topspeed, topvol, bottomspeed, bottomvol, units, timezone,savetoflash} currentcursor=home;
unsigned char counter=0;
unsigned char gpsdata=0;
unsigned char gpsstate=0;
extern unsigned char flashshadow[FLASHPAGESIZE];
enum units {units_kph=1, units_mph, units_kts} currentunits=units_kph;      //null as undefined
double speed_kts;
double speed_adjusted;
int speed;
unsigned char sw1count, sw2count, sw3count;
unsigned char sw1press, sw2press, sw3press;
unsigned int curvolume=128, targetvolume=128;       //128 is boot value of MCP4251, set as target for now before we get fix
unsigned char savetoflashdone=0;
unsigned char currentcontrast=128;
unsigned char targetcontrast=128;
//flashshadow array contains:
//32 bytes available
//[0]=top speed
//[1]=top volume
//[2]=bottom speed
//[3]=bottom volume
//[4]=units
//[5]=time zone (signed, in multiples of 15mins relative to UTC)

void OLEDnum(unsigned char n){      //helper for displaying 8 bit numbers (3 chars)
    if(n>99){OLEDchar(((n/100U)%10U)+'0');}else{OLEDchar(' ');}
    if(n>9){OLEDchar(((n/10U)%10U)+'0');}else{OLEDchar(' ');}
    OLEDchar((n%10U)+'0');
}

int main(void){    
    int tz;
    unsigned char a,i;
    unsigned long speedknots;               
    int minutes;          //used to convert UTC to local
    OSCCONbits.IRCF = 0b1111; //use 16MHz HFINTOSC
    ioinit();
    uart_init();
    I2Cstop();          //this sets up I2C to idle state
    OLEDinit();         //does clear
    timer1init();
    readflash(255);     //load from flash
    if((flashshadow[4]<units_kph)||(flashshadow[4]>units_kts)){     //flash settings invalid
        flashshadow[0]=80;      //top speed
        flashshadow[1]=192;     //top vol
        flashshadow[2]=30;      //bottom speed
        flashshadow[3]=128;     //bottom vol
        flashshadow[4]=units_kph;
        flashshadow[5]=40;          //AEST
    }
    while (1) {
        while(uart_available()){
            a=uart_receive();
            gps_feed(a);
            gpsdata=50;             //if we don't see serial data for more than a second, there's a problem
        }
        gpsstate=((vfields[2][0]=='A')?4:0)+((gpsvalid)?2:0)+((gpsdata)?1:0);      //7=> data 'A' 3=> cx ok, 1=> no fix, 0=> no data
        if(gpsstate==7){        //update volume any time GPS is valid
            speed_kts=atof(&vfields[7][0]);
            speed_adjusted=0;   //sensible default if units error
            if(flashshadow[4]==units_kph){speed_adjusted=speed_kts*KNOTS_KPH;}
            if(flashshadow[4]==units_mph){speed_adjusted=speed_kts*KNOTS_MPH;}
            if(flashshadow[4]==units_kts){speed_adjusted=speed_kts;}
            if(speed_adjusted<0){speed_adjusted=0;}
            if(speed_adjusted>999){speed_adjusted=999;}
            if((flashshadow[0]<=flashshadow[2])||(speed<=flashshadow[2])){//if speeds inverted/identical or below min speed use bottom volume to avoid /0
                targetvolume=flashshadow[3];    
            }else if(speed>=flashshadow[0]){        //if greater than top speed, use top volume
                targetvolume=flashshadow[1];    
            }else{                                  //otherwise interpolate
                targetvolume=(speed-flashshadow[2])*((int)flashshadow[1]-(int)flashshadow[3])/((int)flashshadow[0]-(int)flashshadow[2])+(int)flashshadow[3];
            }
        }
        setDigipot(curvolume);      //update volume
        //get ADC and set contrast
        targetcontrast=getADC();
        OLEDsetcontrast(currentcontrast);
        
        //handle buttons
        if(sw1press){
            currentcursor++;
            if(currentcursor>savetoflash){currentcursor=home;}
            sw1press=0;
            savetoflashdone=0;      //clear write flag
        }
        switch(currentcursor){      //process buttons
            case topspeed:
                if(sw2press){sw2press=0;if(flashshadow[0]>0){flashshadow[0]--;}}
                if(sw3press){sw3press=0;if(flashshadow[0]<255){flashshadow[0]++;}}
                break;
            case topvol:
                if(sw2press){sw2press=0;if(flashshadow[1]>0){flashshadow[1]--;}}
                if(sw3press){sw3press=0;if(flashshadow[1]<255){flashshadow[1]++;}}
                break;
            case bottomspeed:
                if(sw2press){sw2press=0;if(flashshadow[2]>0){flashshadow[2]--;}}
                if(sw3press){sw3press=0;if(flashshadow[2]<255){flashshadow[2]++;}}
                break;
            case bottomvol:
                if(sw2press){sw2press=0;if(flashshadow[3]>0){flashshadow[3]--;}}
                if(sw3press){sw3press=0;if(flashshadow[3]<255){flashshadow[3]++;}}
                break;
            case units:
                if(sw2press){sw2press=0;if(flashshadow[4]>units_kph){flashshadow[4]--;}}
                if(sw3press){sw3press=0;if(flashshadow[4]<units_kts){flashshadow[4]++;}}
                break;
            case timezone:
                if(sw2press){sw2press=0;flashshadow[5]--;}      //need to be able to loop around as it is signed stored in unsigned
                if(sw3press){sw3press=0;flashshadow[5]++;}
                break;
            case savetoflash:
                if(sw3press&&(savetoflashdone==0)){
                    eraseflash(255);
                    writeflash(255);
                    savetoflashdone=1;              //flag so we don't keep trying to rewrite
                }
                break;
        }        
        //common code for both screens
        tz=(flashshadow[5]>127)?flashshadow[5]-256:flashshadow[5];
        tz=tz*15;
        switch(currentcursor){      //process display
            case home:                
                //units display
                if(flashshadow[4]==units_kph){OLEDbigchar(11,96);}
                if(flashshadow[4]==units_mph){OLEDbigchar(12,96);}
                if(flashshadow[4]==units_kts){OLEDbigchar(13,96);}
                //Volume bar
                OLEDsetpage((char)6);
                OLEDsetcolumn(0);
                I2Cstart();
                I2Cbyte(OLED_ADDRESS);  //write
                I2Cbyte(0x40);          //write data
                I2Cbyte(BAR_END);
                for(i=4;i<250;i=i+2){   //don't quite go to ends
                    if(i<curvolume){
                        I2Cbyte(BAR_ON);
                    }else{
                        I2Cbyte(BAR_OFF);                        
                    }
                }                
                I2Cbyte(BAR_END);
                I2Cstop();
                if(gpsstate==7){        //only show speed if valid
                    speed=speed_adjusted;       //convert to int
                    if(speed>99){
                        OLEDbigchar((speed/100)%10,0);                        
                    }else{
                        OLEDbigchar(10,0);                        
                    }
                    if(speed>9){
                        OLEDbigchar((speed/10)%10,32);                        
                    }else{
                        OLEDbigchar(10,32);                        
                    }
                    OLEDbigchar((speed)%10,64);                                            
                    //display time
                    OLEDsetpage((char)7);
                    OLEDsetcolumn(78);
                    minutes=(vfields[1][0]-'0')*600+(vfields[1][1]-'0')*60+(vfields[1][2]-'0')*10+(vfields[1][3]-'0');
                    minutes=minutes+tz+2880;        //ensure we are positive
                    while(minutes>1439){minutes=minutes-1440;}      //mod
                    OLEDchar((minutes/600)%10+'0');
                    OLEDchar((minutes/60)%10+'0');
                    OLEDchar(':');
                    minutes=minutes%60;
                    OLEDchar((minutes/10)%10+'0');
                    OLEDchar((minutes)%10+'0');
                    OLEDchar(':');
                    OLEDchar(vfields[1][4]);
                    OLEDchar(vfields[1][5]);
                }else{
                    OLEDbigchar(10,0);                        
                    OLEDbigchar(10,32);                        
                    OLEDbigchar(10,64);                        
                    OLEDsetpage((char)7);
                    OLEDsetcolumn(78);
                    OLEDchararray("--:--:--");
                }
                OLEDsetpage((char)7);
                OLEDsetcolumn(0);
                OLEDchararray("GPS");
                if(gpsstate>0){OLEDchar(')');}else{OLEDchar(' ');}
                if(gpsstate>1){OLEDchar(')');}else{OLEDchar(' ');}
                if(gpsstate>6){OLEDchar(')');}else{OLEDchar(' ');}
                OLEDchararray("       ");
                break;
            default:
                OLEDsetpage((char)0);
                OLEDsetcolumn(0);
                OLEDchararray(" SETTINGS:           ");
                OLEDsetpage((char)1);
                OLEDsetcolumn(0);
                if(currentcursor==topspeed){OLEDchar('>');}else{OLEDchar(' ');}
                OLEDchararray("Top Speed:      ");
                OLEDnum(flashshadow[0]);
                if(currentcursor==topspeed){OLEDchar('<');}else{OLEDchar(' ');}
                OLEDsetpage((char)2);
                OLEDsetcolumn(0);
                if(currentcursor==topvol){OLEDchar('>');}else{OLEDchar(' ');}
                OLEDchararray("Top Volume:     ");
                OLEDnum(flashshadow[1]);
                if(currentcursor==topvol){OLEDchar('<');}else{OLEDchar(' ');}
                OLEDsetpage((char)3);
                OLEDsetcolumn(0);
                if(currentcursor==bottomspeed){OLEDchar('>');}else{OLEDchar(' ');}
                OLEDchararray("Bottom Speed:   ");
                OLEDnum(flashshadow[2]);
                if(currentcursor==bottomspeed){OLEDchar('<');}else{OLEDchar(' ');}
                OLEDsetpage((char)4);
                OLEDsetcolumn(0);
                if(currentcursor==bottomvol){OLEDchar('>');}else{OLEDchar(' ');}
                OLEDchararray("Bottom Volume:  ");
                OLEDnum(flashshadow[3]);
                if(currentcursor==bottomvol){OLEDchar('<');}else{OLEDchar(' ');}
                OLEDsetpage((char)5);
                OLEDsetcolumn(0);
                if(currentcursor==units){OLEDchar('>');}else{OLEDchar(' ');}
                OLEDchararray("Units:          ");
                switch(flashshadow[4]){
                    case units_kph: OLEDchararray("kph"); break;
                    case units_mph: OLEDchararray("mph"); break;
                    case units_kts: OLEDchararray("kts"); break;
                    default: OLEDchararray("???"); break;
                }
                if(currentcursor==units){OLEDchar('<');}else{OLEDchar(' ');}
                OLEDsetpage((char)6);
                OLEDsetcolumn(0);
                if(currentcursor==timezone){OLEDchar('>');}else{OLEDchar(' ');}
                OLEDchararray("Time Zone:   ");
                if(tz<0){OLEDchar('-');tz=-tz;}else{OLEDchar('+');}
                OLEDchar((tz/600)%10+'0');
                OLEDchar((tz/60)%10+'0');
                OLEDchar(':');
                tz=tz%60;
                OLEDchar((tz/10)%10+'0');
                OLEDchar((tz)%10+'0');
                if(currentcursor==timezone){OLEDchar('<');}else{OLEDchar(' ');}
                OLEDsetpage((char)7);
                OLEDsetcolumn(0);
                if(currentcursor==savetoflash){OLEDchar('>');}else{OLEDchar(' ');}
                OLEDchararray("Save to FLASH: ");
                if(savetoflashdone==0){
                    OLEDchararray("(UP)");
                }else{
                    OLEDchararray("DONE");                    
                }
                if(currentcursor==savetoflash){OLEDchar('<');}else{OLEDchar(' ');}
                break;
        }
    }
}

