#include <xc.h>
#include "uart.h"
#include "timer1.h"
#include "io.h"

extern unsigned char gpsvalid;
extern unsigned char gpsdata;
extern unsigned char sw1count, sw2count, sw3count;
extern unsigned char sw1press, sw2press, sw3press;
extern unsigned int curvolume, targetvolume;
extern unsigned char currentcontrast, targetcontrast;

#define BUTTONDELAY 2
#define BUTTONREPEATDELAY 7
#define BUTTONREPEAT 3

void __interrupt() uart_isr(void){
	int  c;
    if(PIR1bits.RCIF){              //RX interrupt flagged
    	if (RCSTAbits.OERR){        //overrun error, need to fix to continue
        	RCSTAbits.CREN = 0;     //reset the port
    		RCREG;
        	RCSTAbits.CREN = 1;     // and keep going.
        }
        c = RCREG;                  //do a read anyway
        if(((uart_rx_buffer_head+1)%UART_BUFFER_SIZE)!=uart_rx_buffer_tail){        //if space available
            uart_rx_buffer[uart_rx_buffer_head]=c;                                  //add to buffer
            uart_rx_buffer_head=(uart_rx_buffer_head+1)%UART_BUFFER_SIZE;           
        }
    }
    if(PIR1bits.TMR1IF){              //Timer1 interrupt
        PIR1bits.TMR1IF=0;            //clear flag
        counter++;
        if(gpsvalid){gpsvalid--;}      //count down, takes about 11s to get from 255
        if(gpsdata){gpsdata--;}      //count down, takes about 11s to get from 255
        if(SW1BUTTON){
            sw1count++;
            if(sw1count==BUTTONDELAY){sw1press=1;}
            if(sw1count>BUTTONREPEATDELAY){sw1press=1;sw1count=sw1count-BUTTONREPEAT;}
        }else{
            sw1count=0;
        }
        if(SW2BUTTON){
            sw2count++;
            if(sw2count==BUTTONDELAY){sw2press=1;}
            if(sw2count>BUTTONREPEATDELAY){sw2press=1;sw2count=sw2count-BUTTONREPEAT;}
        }else{
            sw2count=0;
        }
        if(SW3BUTTON){
            sw3count++;
            if(sw3count==BUTTONDELAY){sw3press=1;}
            if(sw3count>BUTTONREPEATDELAY){sw3press=1;sw3count=sw3count-BUTTONREPEAT;}
        }else{
            sw3count=0;
        }
        if(curvolume<targetvolume){curvolume++;}    //step volume at a rate limited by timer interrupt ~11s for full ramp
        if(curvolume>targetvolume){curvolume--;}
        if(currentcontrast<targetcontrast){currentcontrast++;}    //step contrast at a rate limited by timer interrupt ~11s for full ramp
        if(currentcontrast>targetcontrast){currentcontrast--;}
    }
}
