//basic IO setup and defines

#include "io.h"
/*
 * SW1 RA5
 * SW2 RA0
 * SW3 RA1
 * ADC RA4(AN3)
 * GPSRX RC5
 * DIGIPOT CS RC4
 * DIGIPOT MOSI RC1
 * DIGIPOT SCK RC0
 * OLED SCL RC3
 * OLED SDA RC2
*/

void ioinit(void){
    ANSELA=0x10;        //RA4 only
    ANSELC=0;           //none
    TRISA=0x30;         //RA4 and RA5 are inputs (RA0 and RA1 are input only)
    TRISC=0x20;         //all port C is output expect C5
    WPUA=0x20;          //pullup on RA5 (RA0 and RA1 have hardware pullups)
    ADCON1=0b11010000;  //11010000 =  Right justified, FOSC/16, VREF is VDD
    ADCON0=0b00001101;  //AN3 source, no conversion, ADC enabled
    CSPIN=1;            //CS high
    DATAPIN=0;          //doesn't matter
    CLKPIN=0;           //clock idles low
}

int getADC(void){                   //fixed to RA4/AN3, 8 bit result to suit usage
    ADCON0bits.ADGO=1;              //start
    while(ADCON0bits.ADGO){}        //wait till done
    return (((ADRESH&3)<<8)|(ADRESL))>>2;//result
}

void setDigipot(int v){              //both channels set to same
    sendSPI((0x0000)|(v&0x1FF));     //set wiper A
    sendSPI((0x1000)|(v&0x1FF));     //set wiper B
}

void sendSPI(unsigned int v){   //send a 16 bit value to SPI
    unsigned int i;
    CSPIN=0;
    for(i=32768;i>0;i=i>>1){
        DATAPIN=(v&i)?1:0;
        CLKPIN=1;
        CLKPIN=0;
    }
    CSPIN=1;
}