//basic IO setup and defines

#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
/*
 * SW1 RA5
 * SW2 RA0
 * SW3 RA1
 * ADC RA4
 * GPSRX RC5
 * DIGIPOT CS RC4
 * DIGIPOT MOSI RC1
 * DIGIPOT SCK RC0
 * OLED SCL RC3
 * OLED SDA RC2
*/
#define SW1BUTTON (!PORTAbits.RA5)
#define SW2BUTTON (!PORTAbits.RA0)
#define SW3BUTTON (!PORTAbits.RA1)

#define CSPIN LATCbits.LATC4
#define DATAPIN LATCbits.LATC1
#define CLKPIN LATCbits.LATC0



void ioinit(void);
int getADC(void);       //fixed to RA4
void setDigipot(int v); //both channels set to same
void sendSPI(unsigned int v);   //send a 16 bit value to SPI

#endif	/* IO_H */

