//demo for ILI9488 display with SPI interface on Arduino
//datasheet reports 16bit mode available, but not documented and doesn't appear to work
//this code uses 18bit (sent as 24 bit) mode
//3 bit mode should also work (and be 6 times faster)

// include the SPI library:
#include <SPI.h>

const unsigned int font1216[][12] PROGMEM ={
{0,0,0,0,0,0,0,0,0,0,0,0},           // 
{0,0,0,124,13311,13311,124,0,0,0,0,0},           //!
{0,0,60,60,0,0,60,60,0,0,0,0},           //"
{512,7696,8080,1008,638,7710,8080,1008,638,30,16,0},           //#
{0,1144,3324,3276,16383,16383,3276,4044,1928,0,0,0},           //$
{12288,14392,7224,3640,1792,896,448,14560,14448,14392,28,0},           //%
{0,7936,16312,12796,8646,14306,7742,7196,13824,8704,0,0},           //&
{0,0,0,39,63,31,0,0,0,0,0,0},           //'
{0,0,1008,4092,8190,14343,8193,8193,0,0,0,0},           //(
{0,0,8193,8193,14343,8190,4092,1008,0,0,0,0},           //)
{0,3224,3768,992,4088,4088,992,3768,3224,0,0,0},           //*
{0,384,384,384,4080,4080,384,384,384,0,0,0},           //+
{0,0,0,47104,63488,30720,0,0,0,0,0,0},           //,
{0,384,384,384,384,384,384,384,384,0,0,0},           //-
{0,0,0,14336,14336,14336,0,0,0,0,0,0},           //.
{6144,7168,3584,1792,896,448,224,112,56,28,14,0},           ///
{2040,8190,7686,13059,12675,12483,12387,12339,6174,8190,2040,0},           //0
{0,0,12300,12300,12302,16383,16383,12288,12288,12288,0,0},           //1
{12316,14366,15367,15875,14083,13187,12739,12515,12407,12350,12316,0},           //2
{3084,7182,14343,12483,12483,12483,12483,12483,14823,8062,3644,0},           //3
{960,992,880,824,796,782,775,16383,16383,768,768,0},           //4
{3135,7295,14435,12387,12387,12387,12387,12387,14563,8131,3971,0},           //5
{4032,8176,14840,12508,12494,12487,12483,12483,14787,8064,3840,0},           //6
{3,3,3,12291,15363,3843,963,243,63,15,3,0},           //7
{3840,8124,14846,12519,12483,12483,12483,12519,14846,8124,3840,0},           //8
{60,126,12519,12483,12483,14531,7363,3779,2023,1022,252,0},           //9
{0,0,0,7280,7280,7280,0,0,0,0,0,0},           //:
{0,0,0,40048,64624,31856,0,0,0,0,0,0},           //;
{0,192,480,1008,1848,3612,7182,14343,12291,0,0,0},           //<
{0,1632,1632,1632,1632,1632,1632,1632,1632,1632,0,0},           //=
{0,12291,14343,7182,3612,1848,1008,480,192,0,0,0},           //>
{28,30,7,3,14211,14275,227,119,62,28,0,0},           //?
{4088,8190,6151,13299,14331,13851,14331,14331,13831,1022,504,0},           //@
{14336,16128,2016,1788,1567,1567,1788,2016,16128,14336,0,0},           //A
{16383,16383,12483,12483,12483,12483,12519,14846,8124,3840,0,0},           //B
{1008,4092,7182,14343,12291,12291,12291,14343,7182,3084,0,0},           //C
{16383,16383,12291,12291,12291,12291,14343,7182,4092,1008,0,0},           //D
{16383,16383,12483,12483,12483,12483,12483,12483,12291,12291,0,0},           //E
{16383,16383,195,195,195,195,195,195,3,3,0,0},           //F
{1008,4092,7182,14343,12291,12483,12483,12483,16327,16326,0,0},           //G
{16383,16383,192,192,192,192,192,192,16383,16383,0,0},           //H
{0,0,12291,12291,16383,16383,12291,12291,0,0,0,0},           //I
{3584,7680,14336,12288,12288,12288,12288,14336,8191,2047,0,0},           //J
{16383,16383,192,480,1008,1848,3612,7182,14343,12291,0,0},           //K
{16383,16383,12288,12288,12288,12288,12288,12288,12288,12288,0,0},           //L
{16383,16383,30,120,480,480,120,30,16383,16383,0,0},           //M
{16383,16383,14,56,240,960,1792,7168,16383,16383,0,0},           //N
{1008,4092,7182,14343,12291,12291,14343,7182,4092,1008,0,0},           //O
{16383,16383,387,387,387,387,387,455,254,124,0,0},           //P
{1008,4092,7182,14343,12291,13827,15879,7182,16380,13296,0,0},           //Q
{16383,16383,387,387,899,1923,3971,7623,14590,12412,0,0},           //R
{3132,7294,14567,12483,12483,12483,12483,14791,8078,3852,0,0},           //S
{0,3,3,3,16383,16383,3,3,3,0,0,0},           //T
{2047,8191,14336,12288,12288,12288,12288,14336,8191,2047,0,0},           //U
{7,63,504,4032,15872,15872,4032,504,63,7,0,0},           //V
{16383,16383,7168,1536,896,896,1536,7168,16383,16383,0,0},           //W
{12291,15375,3612,816,480,480,816,3612,15375,12291,0,0},           //X
{3,15,60,240,16320,16320,240,60,15,3,0,0},           //Y
{12291,15363,15875,13059,12739,12515,12339,12319,12303,12291,0,0},           //Z
{0,0,16383,16383,12291,12291,12291,12291,0,0,0,0},           //[
{14,28,56,112,224,448,896,1792,3584,7168,6144,0},           //backslash
{0,0,12291,12291,12291,12291,16383,16383,0,0,0,0},           //]
{96,112,56,28,14,7,14,28,56,112,96,0},           //^
{49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,0},           //_
{0,0,0,0,62,126,78,0,0,0,0,0},           //`
{7168,15936,13152,13152,13152,13152,13152,13152,16352,16320,0,0},           //a
{16383,16383,12480,12384,12384,12384,12384,14560,8128,3968,0,0},           //b
{3968,8128,14560,12384,12384,12384,12384,12384,6336,2176,0,0},           //c
{3968,8128,14560,12384,12384,12384,12512,12480,16383,16383,0,0},           //d
{3968,8128,15328,13152,13152,13152,13152,13152,5056,384,0,0},           //e
{192,192,16380,16382,199,195,195,3,0,0,0,0},           //f
{896,51136,52960,52320,52320,52320,52320,58976,32736,16352,0,0},           //g
{16383,16383,192,96,96,96,224,16320,16256,0,0,0},           //h
{0,0,12288,12384,16364,16364,12288,12288,0,0,0,0},           //i
{0,0,24576,57344,49152,49248,65516,32748,0,0,0,0},           //j
{0,16383,16383,768,1920,4032,7392,14432,12288,0,0,0},           //k
{0,0,12288,12291,16383,16383,12288,12288,0,0,0,0},           //l
{16352,16320,224,224,16320,16320,224,224,16320,16256,0,0},           //m
{0,16352,16352,96,96,96,96,224,16320,16256,0,0},           //n
{3968,8128,14560,12384,12384,12384,12384,14560,8128,3968,0,0},           //o
{65504,65504,3168,6240,6240,6240,6240,7392,4032,1920,0,0},           //p
{1920,4032,7392,6240,6240,6240,6240,3168,65504,65504,0,0},           //q
{0,16352,16352,192,96,96,96,96,224,192,0,0},           //r
{4544,13280,13152,13152,13152,13152,16224,7744,0,0,0,0},           //s
{96,96,8190,16382,12384,12384,12384,12288,0,0,0,0},           //t
{4064,8160,14336,12288,12288,12288,12288,6144,16352,16352,0,0},           //u
{96,480,1920,7680,14336,14336,7680,1920,480,96,0,0},           //v
{2016,8160,14336,7168,4064,4064,7168,14336,8160,2016,0,0},           //w
{12384,14560,7616,3968,1792,3968,7616,14560,12384,0,0,0},           //x
{0,96,33248,59264,32256,7680,1920,480,96,0,0,0},           //y
{12384,14432,15456,13920,13152,12768,12512,12384,12320,0,0,0},           //z
{0,128,448,8188,16254,28679,24579,24579,24579,0,0,0},           //{
{0,0,0,0,16383,16383,0,0,0,0,0,0},           //|
{0,24579,24579,24579,28679,16254,8188,448,128,0,0,0},           //}
{16,24,12,4,12,24,16,24,12,4,0,0},           //~
{256,1792,7680,30720,30720,7680,1920,480,120,28,6,3}           //tick for check box
};

//colours are 24bit/18bit
// the ul is because we need 24 bits to store the colours
#define BLACK 0x000000ul
#define BLUE 0x0000FFul
#define RED 0xFF0000ul
#define GREEN 0x00FF00ul
#define CYAN 0x00FFFFul
#define MAGENTA 0xFF00FFul
#define YELLOW 0xFFFF00ul  
#define WHITE 0xFFFFFFul
#define GREY 0x808080ul

// for AVR R3 breakout
#define RSPIN (9)
#define CSPIN (10)
#define TOUCH_CS_PIN (7)
#define SD_CS_PIN (6)
#define RSTPIN (8)

#define Z_TOUCH_THRESHOLD 20
#define TOUCH_X0 110
#define TOUCH_X1 2001
#define TOUCH_Y0 1993
#define TOUCH_Y1 76
#define TOUCH_OVERSAMPLE 16

//actual touch values are oversampled again
#define OVERSAMPLE 16

int width,height,rotation;
byte r=0;

long touch_x0 = 110;
long touch_x1 = 2001;
long touch_y0 = 1993;
long touch_y1 = 76;

void setup() {
  while(!Serial){}
  Serial.begin(115200);
  displaySetup();
  setrotation(3);  //this mode has the 'default' mapping
  drawbox(0,0,width-1,height-1,BLACK);
  printMenu();
}

void loop() {
  int d;
  if(Serial.available()){
    d=Serial.read();
    if(d=='1'){doCals();}
    if(d=='2'){doTest();}
    if(d=='3'){doDefaults();printMenu();}
  }
}

void printMenu(){
  Serial.println();
  reportDefines();
  Serial.println("Press 1 for calibration");
  Serial.println("      2 for test");  
  Serial.println("      3 for default values");
}

void doCals(){
  long xTest[4],yTest[4],x,y,z;
  int i,c;
  Serial.println("Touch the crosses on the screen with a sharp object");  
  for(i=0;i<4;i++){
    delay(100);
    drawCross(i);
    c=0;
    xTest[i]=0;
    yTest[i]=0;
    while(c<OVERSAMPLE){
      x=touchxraw();
      y=touchyraw();
      z=touchzraw();
      if(z>Z_TOUCH_THRESHOLD){
        x=touchxraw();
        y=touchyraw();
        z=touchzraw();
        if(z>Z_TOUCH_THRESHOLD){
          xTest[i]=xTest[i]+x;
          yTest[i]=yTest[i]+y;
          c++;
        }
      }
    }
    drawbox(0,0,width-1,height-1,BLACK);
    while(touchzraw()>Z_TOUCH_THRESHOLD/2){}     //wait for release    
    Serial.print("Raw Value ");
    Serial.print(i);
    Serial.print(":");    
    Serial.print(xTest[i]/OVERSAMPLE);
    Serial.print(",");
    Serial.println(yTest[i]/OVERSAMPLE);
  }
  touch_x0 = ((xTest[0]+xTest[2])*3-(xTest[1]+xTest[3]))/4/OVERSAMPLE;
  touch_x1 = ((xTest[1]+xTest[3])*3-(xTest[0]+xTest[2]))/4/OVERSAMPLE;
  touch_y0 = ((yTest[2]+yTest[3])*3-(yTest[0]+yTest[1]))/4/OVERSAMPLE;
  touch_y1 = ((yTest[0]+yTest[1])*3-(yTest[2]+yTest[3]))/4/OVERSAMPLE;
  reportDefines();
  printMenu(); 
}

void drawCross(int i){
  int x,y;
  x=(width/4)+(i&1)*(width/2);
  y=(height/4)+(i&2)*(height/4);
  drawbox(x-30,y,x+30,y,WHITE);
  drawbox(x,y-30,x,y+30,WHITE);
}

void doTest(){
  int x,y,z,n;
  delay(10);
  Serial.println("Press anything on serial to exit.");
  while(Serial.available()){Serial.read();}     //remove any extras from buffer that would cause us to return
  while(!Serial.available()){
    if(touchzraw()>Z_TOUCH_THRESHOLD){
      n=touchxraw();
      x=map(n,TOUCH_X0,TOUCH_X1,0,width-1);
      n=touchyraw();
      y=map(n,TOUCH_Y1,TOUCH_Y0,0,height-1);
      if((x>=0)&&(x<width)&&(y>=0)&&(y<height)){
        point(x,y,WHITE);
      }
    }
  }
  drawbox(0,0,width-1,height-1,BLACK);
  delay(10);
  while(Serial.available()){Serial.read();}     //remove any extras from buffer that would cause us to return  
  printMenu(); 
}

void reportDefines(){
  
  Serial.println("// Use the following defines:");
  Serial.print("#define TOUCH_X0 ");
  Serial.println(touch_x0);
  Serial.print("#define TOUCH_X1 ");
  Serial.println(touch_x1);
  Serial.print("#define TOUCH_Y0 ");
  Serial.println(touch_y0);
  Serial.print("#define TOUCH_Y1 ");
  Serial.println(touch_y1);
  Serial.println();
}

void doDefaults(){
  touch_x0 = 110;
  touch_x1 = 2001;
  touch_y0 = 1993;
  touch_y1 = 76;
}

void displaySetup(){
  int i;
  width=320;
  height=480;
  rotation=0;//default
  SPI.begin();
  SPI.beginTransaction(SPISettings(4000000, MSBFIRST, SPI_MODE3));  //assume no-one else is using SPI
  pinMode(RSTPIN,OUTPUT);
  pinMode(CSPIN,OUTPUT);
  pinMode(RSPIN,OUTPUT);
  pinMode(TOUCH_CS_PIN,OUTPUT);  
  digitalWrite(RSTPIN,HIGH);
  digitalWrite(CSPIN,HIGH);
  digitalWrite(RSPIN,HIGH);
  digitalWrite(TOUCH_CS_PIN,HIGH);    
  delay(5);
  digitalWrite(RSTPIN,LOW);
  delay(15);
  digitalWrite(RSTPIN,HIGH);//hard reset
  delay(15);
  digitalWrite(CSPIN,LOW);
  cmd8(0x1);    //sw reset
  delay(120);
  cmd8(0x11);   //Sleep out
  delay(120);
  cmd8(0x13);   //normal
  cmd8(0x20);   //no inversion
  cmd8(0x28);   //display off
  cmd8(0x38);   //idle mode off
  cmd8(0xC0);   //power control 1
  data8(0x17);
  data8(0x15);
  cmd8(0xC1);   //power control 2
  data8(0x41);
  cmd8(0xC5);   //VCOM control
  data8(0x0e);
  data8(0x0e);
  cmd8(0x36);   //Memory Access control
  data8(88);    //suits rotation 0
  cmd8(0x3A);   //Pixel interface format
  data8(0x66);
  cmd8(0xB4);   //inversion control
  data8(0x2);
  cmd8(0xB6);   //Function control
  data8(0x2);
  data8(0x2);
  data8(0x3B);
  cmd8(0x29);   //display on
  cmd8(0x2A);   //set column
  data8(0x0);
  data8(0x0);
  data8(0x1);
  data8(0x3F);
  cmd8(0x2B);   //set row
  data8(0x0);
  data8(0x0);
  data8(0x1);
  data8(0xDF);
  cmd8(0x2C);   //draw
  digitalWrite(CSPIN,HIGH);
}

void setrotation(byte r){
  digitalWrite(CSPIN,LOW);
  switch(r){
    case 0:
      rotation=0;     //portrait 1
      width=320;
      height=480;
      cmd8(0x36);   //Memory access control
      data8(88);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
    case 1:
      rotation=1;     //landscape 1
      width=480;
      height=320;
      cmd8(0x36);   //Memory access control
      data8(56);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
    case 2:
      rotation=2;     //portrait reversed
      width=320;
      height=480;
      cmd8(0x36);   //Memory access control
      data8(152);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
    case 3:
      rotation=3;     //landscape reversed
      width=480;
      height=320;
      cmd8(0x36);   //Memory access control
      data8(248);   //sets orientation/scan direction/flip
      setarea(0,0,width-1,height-1);
      break;
  }
  digitalWrite(CSPIN,HIGH);
}

void drawbox(int x0,int y0,int x1,int y1,unsigned long c){
  int t,x,y;
  if(x1<x0){int t=x0;x0=x1;x1=t;}   //sort x
  if(y1<y0){int t=y0;y0=y1;y1=t;}   //sort y
  setarea(x0,y0,x1,y1);
  x1++;
  y1++;
  digitalWrite(CSPIN,LOW);
  for(y=y0;y<y1;y++){
    for(x=x0;x<x1;x++){
      data8(c>>16);
      data8(c>>8);
      data8(c);      
    }
  }
  digitalWrite(CSPIN,HIGH);
}

void setarea(int x0,int y0,int x1,int y1){
  int t;
  if(x1<x0){int t=x0;x0=x1;x1=t;}   //sort x
  if(y1<y0){int t=y0;y0=y1;y1=t;}   //sort y
  digitalWrite(CSPIN,LOW);
  cmd8(0x2A);   //set column start/end
  data8(x0>>8); 
  data8(x0);    //start
  data8(x1>>8);
  data8(x1);    //end
  cmd8(0x2B);   //set row start/end
  data8(y0>>8);
  data8(y0);    //start
  data8(y1>>8);
  data8(y1);    //end
  cmd8(0x2C);   //draw!
  digitalWrite(CSPIN,HIGH);
}

void clear(unsigned long c){
  int x,y;
  setarea(0,0,width-1,height-1);
  digitalWrite(CSPIN,LOW);
  for(x=0;x<320;x++){
    for(y=0;y<480;y++){
      data8(c>>16);
      data8(c>>8);
      data8(c);
    }
  }
  digitalWrite(CSPIN,HIGH);
}

void data8(byte d){
  SPI.transfer(d);
}

void cmd8(byte d){
  digitalWrite(RSPIN,LOW);
  data8(d);
  digitalWrite(RSPIN,HIGH);  
}

void character(int x, int y, char c, unsigned long f, unsigned long b){
  byte v,u;
  unsigned int d;
  c=c-32;   //array starts at ascii 32
  if(c<0){return;}
  if(c>95){return;}
  setarea(x,y,x+11,y+15);
  digitalWrite(CSPIN,LOW);
  for(v=0;v<16;v++){
    for(u=0;u<12;u++){
      d=pgm_read_word(&font1216[c][u]);
      if((1<<v)&d){
        data8(f>>16);data8(f>>8); data8(f);
      }else{
        data8(b>>16);data8(b>>8); data8(b);        
      }
    }
  }
  digitalWrite(CSPIN,HIGH);
}

void characterarray(int x, int y, char *c, unsigned long f, unsigned long b){
  while(*c){
    character(x,y,*c++,f,b);
    x=x+12;
    if(x>width-12){x=0;y=y+16;}      //wrap around (will probably look ugly, but better than nothing)
  }    
}

void point(int x, int y, unsigned long c){
  setarea(x,y,x,y);
  digitalWrite(CSPIN,LOW);
  data8(c>>16);
  data8(c>>8);
  data8(c);      
  digitalWrite(CSPIN,HIGH);
}


int touchxraw(){ 
  long n=0;
  int k;
  digitalWrite(TOUCH_CS_PIN,LOW);  
  SPI.transfer(0x91);
  n=SPI.transfer16(0x91);   //ignore first
  for(k=0;k<TOUCH_OVERSAMPLE-1;k++){
    n=n+SPI.transfer16(0x91);
  }
  digitalWrite(TOUCH_CS_PIN,HIGH);  
  return (n/TOUCH_OVERSAMPLE)>>4;      //only 12 bits resolution
}

int touchyraw(){
  long n=0;
  int k;
  digitalWrite(TOUCH_CS_PIN,LOW);  
  SPI.transfer(0xD1);
  n=SPI.transfer16(0xD1);   //ignore first
  for(k=0;k<TOUCH_OVERSAMPLE-1;k++){
    n=n+SPI.transfer16(0xD1);
  }
  digitalWrite(TOUCH_CS_PIN,HIGH);  
  return (n/TOUCH_OVERSAMPLE)>>4;      //only 12 bits resolution
}

int touchzraw(){    //needed to validate press
  int n;
  digitalWrite(TOUCH_CS_PIN,LOW);  
  SPI.transfer(0xB1);
  n=SPI.transfer16(0xB1);   //ignore first
  n=SPI.transfer16(0xB1);
  n=SPI.transfer16(0xB0);
  digitalWrite(TOUCH_CS_PIN,HIGH);  
  return n>>4;      //only 12 bits resolution
}

int touchx(){
  int n,p,z;
  z=touchzraw();
  if(z<Z_TOUCH_THRESHOLD){return -1;} //no touch
  switch(rotation){
    case 0:
      n=touchyraw();
      p=map(n,TOUCH_Y1,TOUCH_Y0,0,width-1);
      if(p<0){return -1;}
      if(p>width-1){return -1;}
      return p;
      break;
    case 1:
      n=touchxraw();
      p=map(n,TOUCH_X1,TOUCH_X0,0,width-1);
      if(p<0){return -1;}
      if(p>width-1){return -1;}
      return p;
      break;
    case 2:
      n=touchyraw();
      p=map(n,TOUCH_Y0,TOUCH_Y1,0,width-1);
      if(p<0){return -1;}
      if(p>width-1){return -1;}
      return p;
      break;
    case 3:
      n=touchxraw();
      p=map(n,TOUCH_X0,TOUCH_X1,0,width-1);
      if(p<0){return -1;}
      if(p>width-1){return -1;}
      return p;
      break;
    default:
      return -1;
  }  
}

int touchy(){
  int n,p,z;
  z=touchzraw();
  if(z<Z_TOUCH_THRESHOLD){return -1;} //no touch
  switch(rotation){
    case 0:
      n=touchxraw();
      p=map(n,TOUCH_X1,TOUCH_X0,0,height-1);
      if(p<0){return -1;}
      if(p>height-1){return -1;}
      return p;
      break;
    case 1:
      n=touchyraw();
      p=map(n,TOUCH_Y0,TOUCH_Y1,0,height-1);
      if(p<0){return -1;}
      if(p>height-1){return -1;}
      return p;
      break;
    case 2:
      n=touchxraw();
      p=map(n,TOUCH_X0,TOUCH_X1,0,height-1);
      if(p<0){return -1;}
      if(p>height-1){return -1;}
      return p;
      break;
    case 3:
      n=touchyraw();
      p=map(n,TOUCH_Y1,TOUCH_Y0,0,height-1);
      if(p<0){return -1;}
      if(p>height-1){return -1;}
      return p;
      break;
    default:
      return -1;
  }  
}

void line(int x1,int y1,int x2,int y2, unsigned long c){
  int steps,stepsx,stepsy,xinc,yinc,x,y,d;
  stepsx=abs(x1-x2);
  stepsy=abs(y1-y2);
  steps=max(stepsx,stepsy)+1;   //if start and end are the same, there's still 1 point
  xinc=constrain(x2-x1,-1,1);
  yinc=constrain(y2-y1,-1,1);
  x=x1;
  y=y1;  
  if(stepsx>stepsy){
    d=stepsx/2;
    for(int i=0;i<steps;i++){
      point(x,y,c);
      x=x+xinc;
      d=d+stepsy;
      if(d>stepsx){d=d-stepsx;y=y+yinc;}
    }
  }else{
    d=stepsy/2;
    for(int i=0;i<steps;i++){
      point(x,y,c);
      y=y+yinc;
      d=d+stepsx;
      if(d>stepsy){d=d-stepsy;x=x+xinc;}
    } 
  }  
}

