// All the mcufriend.com UNO shields have the same pinout.
// i.e. control pins A0-A4.  Data D2-D9.  microSD D10-D13.
// Touchscreens are normally A1, A2, D7, D6 but the order varies
//
// This demo should work with most Adafruit TFT libraries
// If you are not using a shield,  use a full Adafruit constructor()
// e.g. Adafruit_TFTLCD tft(LCD_CS, LCD_CD, LCD_WR, LCD_RD, LCD_RESET);

#define LCD_CS A3 // Chip Select goes to Analog 3
#define LCD_CD A2 // Command/Data goes to Analog 2
#define LCD_WR A1 // LCD Write goes to Analog 1
#define LCD_RD A0 // LCD Read goes to Analog 0
#define LCD_RESET A4 // Can alternately just connect to Arduino's reset pin

#include <SPI.h>          // f.k. for Arduino-1.5.2
#include "Adafruit_GFX.h"// Hardware-specific library
#include <MCUFRIEND_kbv.h>
MCUFRIEND_kbv tft;

// Assign human-readable names to some common 16-bit color values:
#define	BLACK   0x0000
#define	BLUE    0x001F
#define	RED     0xF800
#define	GREEN   0x07E0
#define CYAN    0x07FF
#define MAGENTA 0xF81F
#define YELLOW  0xFFE0
#define WHITE   0xFFFF

int r=0;

void setup(void) {
    uint16_t ID = tft.readID(); //
    if (ID == 0xD3D3) ID = 0x9481; // write-only shield
    tft.begin(ID);
    tft.setRotation(r);
}


void loop(void) {
  int i;
  tft.setRotation(r);
  tft.writeFillRect(0, 0, tft.width(), tft.height(), BLUE);
  tft.writeFillRect(0, 0, 100,100, RED);
  tft.setTextSize(2);
  tft.setTextColor(GREEN, BLUE);
  tft.setCursor(5, 5);
  tft.print("WORKING");
  tft.setCursor(20, 50);
  tft.setTextColor(WHITE, BLACK);
  tft.print("ROT:");  
  tft.print(r);  
  for(i=0;i<320;i++){
    tft.drawPixel(i, i, GREEN);
  }
  delay(1000);
  r=r+1;
  if(r>3){r=0;}
}
