
/*
airspectrum.cdnstream1.com:8114/1648_128 #  1 - Easy Hits Florida 128k Y
109.206.96.34:8100                       #  0 - NAXI LOVE RADIO, Belgrade, Serbia
us2.internet-radio.com:8050              #  2 - CLASSIC ROCK MIAMI 256k
airspectrum.cdnstream1.com:8000/1261_192 #  3 - Magic Oldies Florida
airspectrum.cdnstream1.com:8008/1604_128 #  4 - Magic 60s Florida 60s Classic Rock
us1.internet-radio.com:8105              #  5 - Classic Rock Florida - SHE Radio
icecast.omroep.nl:80/radio1-bb-mp3       #  6 - Radio 1, NL
205.164.62.15:10032                      #  7 - 1.FM - GAIA, 64k
skonto.ls.lv:8002/mp3                    #  8 - Skonto 128k
94.23.66.155:8106                        #  9 - *ILR CHILL and GROOVE

 "http://wbgo.streamguys.net/wbgo96",
  "http://wbgo.streamguys.net/thejazzstream",
  "http://stream.srg-ssr.ch/m/rsj/mp3_128",
  "http://37.187.79.93:8368/stream2",
  "http://icecast.omroep.nl/3fm-sb-mp3",
  "http://beatles.purestream.net/beatles.mp3",
  "http://listen.181fm.com/181-beatles_128k.mp3",

VS1053 - connections detail
XRST = EN (D3)
 MISO = D19
 MOSI = D23
 SCLK = D18
 VCC = 5V / 3.3 V
 Gnd = Gnd 
  
*/

// This ESP_VS1053_Library
#include <VS1053.h>

#include <Preferences.h>  //For reading and writing into the ROM memory
Preferences preferences;
unsigned int counter,old_counter,new_counter;

#include "helloMp3.h"
#include <WiFi.h>
#include <HTTPClient.h>
#include <esp_wifi.h>

//OLED 64*32 display headers
#include "SSD1306.h"
SSD1306  display(0x3c, 21,22);

char ssid[] = "bera";    //  your network SSID (name) 
char pass[] = "..........";   // your network password

char *host[7] = {"streaming.shoutcast.com","swr-swr1-bw.cast.addradio.de","/swr/swr1/bw/mp3/64/stream.mp3", "airspectrum.cdnstream1.com","skonto.ls.lv",
"icecast.omroep.nl","beatles.purestream.net"};
char *path[7] = {"/80sPlanet?lang=en-US","/swr/swr1/bw/mp3/64/stream.mp3","/1261_192","/1604_128","/mp3 ",
"/radio1-bb-mp3","/beatles.mp3"};
int   port[7] = {80,80,8000,8008,8002,80,80};

char *sname[7] = {"Southcast-US","addradio.de","swr/swr1/bw","airspectrum-cdn","skonto.ls.lv","icecast-NZ","beatles-bb"};


int change=13;
bool x=true;
int status = WL_IDLE_STATUS;
WiFiClient  client;
uint8_t mp3buff[32];   // vs1053 likes 32 bytes at a time

// Wiring of VS1053 board (SPI connected in a standard way)
#define VS1053_CS    32 //32
#define VS1053_DCS   33  //33
#define VS1053_DREQ  35 //15
#define VOLUME  100 // volume level 0-100
VS1053 player(VS1053_CS, VS1053_DCS, VS1053_DREQ);

void setup () {
//Begin display
display.init();
display.invertDisplay();
display.setFont(ArialMT_Plain_16);
display.normalDisplay();
display.setColor(WHITE);
display.drawString(0,0,"  ESP32 Radio");
display.setFont(ArialMT_Plain_10);
  
   pinMode(change,INPUT_PULLUP);
// initialize SPI
   Serial.begin(115200);
   delay(500);
// initialize SPI bus;
    SPI.begin();

// initialize VS1053 player
    player.begin();
//    player.switchToMp3Mode(); // optional, some boards require this
    player.setVolume(VOLUME);
   
   WiFi.begin(ssid, pass);
   while (WiFi.status() != WL_CONNECTED) {
  //  display.drawString(0,15,"   Connecting..");
    delay(500);
    Serial.print(".");
   }
  Serial.println("WiFi connected");  
  Serial.print("IP address:");  
  Serial.println(WiFi.localIP());
  display.setColor(WHITE);
  String x1="Connected to:"+String(ssid[0])+String(ssid[1])+String(ssid[2])+String(ssid[3]);
  display.drawString(0,15,x1);
  x1="IP:"+WiFi.localIP().toString();
  display.drawString(0,27,x1);
 
preferences.begin("my-app", false);
counter = preferences.getUInt("counter", 0);
old_counter=counter;

String x3="Stn:"+String(counter);
String x4="Playing:"+String(sname[counter]);  //+ String(path[counter])+":"+String(port[counter]);  //.toString();
display.drawString(80,27,x3);
display.drawString(0,37,x4.substring(0,60));
display.display();
x4="";
Serial.printf("Current counter value: %u\n", counter);
delay(100);
player.playChunk(hello2, sizeof(hello2)); //VS1053 is wake up & running
station_connect(counter); 
}

void loop() {
 
      if (client.available() > 0) {
      uint8_t bytesread = client.read(mp3buff, 32);
      player.playChunk(mp3buff, bytesread);
      }
      
    if(digitalRead(change)==0 and x==true){
    x=false;
    counter = counter+1;
    if(counter>6) counter=0;
    preferences.putUInt("counter",counter);
    new_counter=counter;
    Serial.printf("Set counter to new_value: %u\n", counter);
    delay(500); 

    if(old_counter != new_counter) {
  
    player.softReset(); 
    x=true;
    station_connect(new_counter); 
    preferences.putUInt("counter",new_counter); 

String x3="Stn:"+String(counter);
String x4="Playing:"+String(sname[counter]);  //+ String(path[counter])+":"+String(port[counter]);  //.toString();
display.clear();
display.setFont(ArialMT_Plain_16);
display.drawString(0,0,"  ESP32 Radio");
display.setFont(ArialMT_Plain_10);
String x1="Connected to:"+String(ssid[0])+String(ssid[1])+String(ssid[2])+String(ssid[3]);
display.drawString(0,15,x1);
x1="IP:"+WiFi.localIP().toString();
display.drawString(0,27,x1);
display.drawString(80,27,x3);
display.drawString(0,37,x4.substring(0,60));

display.display();
    }
  } 
}

void station_connect (int station_no ) {
    if (client.connect(host[station_no],port[station_no]) ) {
    Serial.println("Connected now");
     }
    Serial.print(host[station_no]);
    Serial.println(path[station_no]);
    client.print(String("GET ") + path[station_no] + " HTTP/1.1\r\n" +
               "Host: " + host[station_no] + "\r\n" + 
               "Connection: close\r\n\r\n");     
  }



