#define DI_PIN 2
#define CK_PIN 4
#define LT_PIN 3
#define EN_PIN 5

//reverse these values if the colours are reversed
#define ON_STATE 0
#define OFF_STATE 1

#define MAX_LEN 10
unsigned int buf[MAX_LEN];

unsigned int nbitmaps[]={
  0,    //  
  8338,    // !
  45,    // "
  24445,    // #
  15838,    // $
  21157,    // %
  30683,    // &
  18,    // '
  8778,    // (
  10530,    // )
  11962,    // *
  1488,    // +
  5120,    // ,
  448,    // -
  8192,    // .
  4772,    // /
  11114,    // 0
  29850,    // 1
  29347,    // 2
  14563,    // 3
  20334,    // 4
  14543,    // 5
  15054,    // 6
  9511,    // 7
  31407,    // 8
  14767,    // 9
  1040,    // :
  5136,    // ;
  17492,    // <
  3640,    // =
  5393,    // >
  4323,    // ?
  25594,    // @
  24426,    // A
  15083,    // B
  25166,    // C
  15211,    // D
  29391,    // E
  5071,    // F
  27470,    // G
  23533,    // H
  29847,    // I
  14628,    // J
  22109,    // K
  29257,    // L
  23549,    // M
  23403,    // N
  11114,    // O
  4843,    // P
  28522,    // Q
  23275,    // R
  14478,    // S
  9367,    // T
  11117,    // U
  9581,    // V
  24557,    // W
  23213,    // X
  9389,    // Y
  29351,    // Z
  12875,    // [
  18569,    // backslash
  26918,    // ]
  42,    // ^
  28672,    // _
  17,    // `
  24426,    // a
  15083,    // b
  25166,    // c
  15211,    // d
  29391,    // e
  5071,    // f
  27470,    // g
  23533,    // h
  29847,    // i
  14628,    // j
  22109,    // k
  29257,    // l
  23549,    // m
  23403,    // n
  11114,    // o
  4843,    // p
  28522,    // q
  23275,    // r
  14478,    // s
  9367,    // t
  11117,    // u
  9581,    // v
  24557,    // w
  23213,    // x
  9389,    // y
  29351,    // z
  25814,    // {
  9362,    // |
  13715,    // }
  30,    // ~
  170    // degrees
};

unsigned int pixels[15][2]={
 {1,65534},
 {2,65533},
 {256,65279},
 {8,65527},
 {4,65531},
 {512,65023},
 {32,65503},
 {2048,63487},
 {1024,64511},
 {16,65519},
 {32768,32767},
 {8192,57343},
 {128,65407},
 {64,65471},
 {16384,49151}
};

unsigned int out[MAX_LEN]={0,0,0,0,0,0,0,0,0,0};
int ptr=0;

void setup() {
  Serial.begin(115200);
  initDisplay();
  setDisplay(out,MAX_LEN);
}

void loop() {
  int d,i;
  if(Serial.available()){
    d=Serial.read();
    if((d>=32)&&(d<=127)){
      Serial.println(d);
      out[ptr]=nbitmaps[d-32];
      ptr++;
      if(ptr>=MAX_LEN-1){
        setDisplay(out,MAX_LEN);
        ptr=0;
        for(i=0;i<MAX_LEN;i++){out[i]=0;}
      }
    }
    if(d==13){
      setDisplay(out,MAX_LEN);
      ptr=0;
      for(i=0;i<MAX_LEN;i++){out[i]=0;}      
    }
  }
}

void initDisplay(){
  pinMode(DI_PIN,OUTPUT);
  digitalWrite(DI_PIN,LOW);
  pinMode(CK_PIN,OUTPUT);
  digitalWrite(CK_PIN,LOW);
  pinMode(LT_PIN,OUTPUT);
  digitalWrite(LT_PIN,LOW);
  pinMode(EN_PIN,OUTPUT);
  digitalWrite(EN_PIN,LOW); 
}

void setDisplay(unsigned int* n,byte c){  //output array at c of length n
  unsigned int b=1;
  char j,k;
  for(j=0;j<15;j++){
    for(k=0;k<c;k++){    
      if(b&n[k]){
        buf[k]=pixels[j][ON_STATE];
      }else{
        buf[k]=pixels[j][OFF_STATE];
      }
    }
  sendPulse(buf,c);
  b=b<<1;
  }
  Serial.println();
  delay(200);
}

void sendPulse(unsigned int* c,byte n){  //output array at c of length n
  int i;
  for(i=n-1;i>-1;i--){
    shiftOut(DI_PIN, CK_PIN, MSBFIRST , (c[i]>>8)&255);
    shiftOut(DI_PIN, CK_PIN, MSBFIRST , (c[i])&255);
  }  
  digitalWrite(LT_PIN,LOW);
  digitalWrite(LT_PIN,HIGH);
  digitalWrite(EN_PIN,HIGH);
  delay(150);
  digitalWrite(EN_PIN,LOW);
  delay(150);
}

