#define DI_PIN 2
#define LT_PIN 3
#define CK_PIN 4
#define EN_PIN 5

//reverse these values if the colours are reversed
#define ON_STATE 0
#define OFF_STATE 1

unsigned int nbitmaps[]={
  11114,    // 0
  29850,    // 1
  29347,    // 2
  14563,    // 3
  20334,    // 4
  14543,    // 5
  15054,    // 6
  9511,    // 7
  31407,    // 8
  14767,    // 9
};

unsigned int pixels[15][2]={
 {1,65534},
 {2,65533},
 {256,65279},
 {8,65527},
 {4,65531},
 {512,65023},
 {32,65503},
 {2048,63487},
 {1024,64511},
 {16,65519},
 {32768,32767},
 {8192,57343},
 {128,65407},
 {64,65471},
 {16384,49151}
};
  
void setup() {
  Serial.begin(115200);
  initDisplay();
  setDisplay(0);    //all blank
}

void loop() {
  static int i=0;
  setDisplay(nbitmaps[i]);
  delay(1000);
  i=i+1;
  if(i>9){i=0;}
}

void initDisplay(){
  pinMode(DI_PIN,OUTPUT);
  digitalWrite(DI_PIN,LOW);
  pinMode(CK_PIN,OUTPUT);
  digitalWrite(CK_PIN,LOW);
  pinMode(LT_PIN,OUTPUT);
  digitalWrite(LT_PIN,LOW);
  pinMode(EN_PIN,OUTPUT);
  digitalWrite(EN_PIN,LOW); 
}

void setDisplay(unsigned int n){
  unsigned int b=1;
  char j;
  Serial.print(n);
  Serial.println(":");
  for(j=0;j<15;j++){
    if(b&n){
      sendPulse(pixels[j][ON_STATE]);
      Serial.print("##");
    }else{
      sendPulse(pixels[j][OFF_STATE]);        
      Serial.print("__");
    }
    if((j%3)==2){Serial.println();}
    b=b<<1;
  }
  Serial.println();
  delay(200);
}

void sendPulse(unsigned int n){
  shiftOut(DI_PIN, CK_PIN, MSBFIRST , (n>>8)&255);
  shiftOut(DI_PIN, CK_PIN, MSBFIRST , n&255);
  digitalWrite(LT_PIN,LOW);
  digitalWrite(LT_PIN,HIGH);
  digitalWrite(EN_PIN,HIGH);
  delay(150);
  digitalWrite(EN_PIN,LOW);
  shiftOut(DI_PIN, CK_PIN, MSBFIRST , 0);//idle off
  shiftOut(DI_PIN, CK_PIN, MSBFIRST , 0);//idle off
  digitalWrite(LT_PIN,LOW);
  digitalWrite(LT_PIN,HIGH);
  delay(150);
}

