//lib for LCD Backpack display
//issues: working OK, touch is poor (not use map?)
//add:  fonts (make loadable/settable?)
//      more drawing primitives
//      ui elements

#ifndef backpack_h
#define backpack_h
#include "Arduino.h"
#include <SPI.h>

//some colours with nice names
#define BLACK 0x0000
#define BLUE 0x001F
#define RED 0xF800
#define GREEN 0x07E0
#define CYAN 0x07FF
#define MAGENTA 0xF81F
#define YELLOW 0xFFE0  
#define WHITE 0xFFFF
#define GREY 0x8410
//unit colours - multiply by 0-31
#define RED_1 0x0800
#define GREEN_1 0x0040
#define BLUE_1 0x0001
/*
#define Z_TOUCH_THRESHOLD 100
#define TOUCH_X0 1984
#define TOUCH_X1 144
#define TOUCH_Y0 0
#define TOUCH_Y1 1896
*/

//touch cals probably need full 'matrix' solution
#define Z_TOUCH_THRESHOLD 100
#define TOUCH_X0 2085
#define TOUCH_X1 145
#define TOUCH_Y0 95
#define TOUCH_Y1 2235

#define TOUCH_OVERSAMPLE 16

class backpack{
  public:
    backpack();
    void init(char dc,char cs,char touchcs);
    void rotate(char a);
    void data(unsigned char d);
    void cmd(unsigned char d);
    void areaset(int x1,int y1,int x2,int y2);    
    void box(int x1,int y1,int x2,int y2,unsigned int c);  
    void clear(unsigned int c);
    void point(int x,int y, unsigned int c);
    void line(int x1,int y1,int x2,int y2, unsigned int c);
    void character(int x,int y,char c, unsigned int f, unsigned int b);
    void chararray(int x,int y,char *c, unsigned int f, unsigned int b);
    void hline(int x1,int y1,int x2,unsigned int c);
    void vline(int x1,int y1,int y2,unsigned int c);
    int touchxraw();  //raw adc
    int touchyraw();
    int touchzraw();
    int width();
    int height();    
    int touchx();     //scaled, rotated, pixel reference
    int touchy();
    int charfont(int x, int y, char c, unsigned int f, unsigned int b, const uint8_t* font);
    void chararrayfont(int x0, int y0, char *c, unsigned int f, unsigned int b, const uint8_t* font);
    void image(int x,int y,const byte img[]);
    void imaget(int x,int y,const byte img[],unsigned int t);
    byte imagewidth(const byte img[]);
    byte imageheight(const byte img[]);    
    void bitmap(int x,int y,const byte img[]);      //draw palettized bitmap from PROGMEM    

  private:

    int _width;
    int _height;
    int _rotation;
    byte _dcpin;
    byte _cspin;
    byte _touchcspin;
};

#endif

