// lib to allow writing (and thus printing) to a char array
// internal pointer doesn't depend on strlen, can have nulls written to it, but saves one spot at the end for null for that it can be printed
// includes read and write functions (inherits from Stream)
// todo 'anonymous' version that uses strlen to allow dynamic usage without constructors

// includes:
// begin(array, size) -uses existing array
// write(byte)
// clear() uses internal pointer, so this needs to be set
// availableForWrite() how many bytes free (1 less than size at most)
// read()- returns -1 on nothing to return
// peek()- returns -1 on nothing to return
// available()

#include "Arduino.h"
#include "awriter.h"

awriter::awriter(){
  //no need to to anything
}

void awriter::begin(char* a,unsigned int s){
  _a=a;  //array to work with
  _s=s;  //size
  _p=0;  //internal pointer
}

size_t awriter::write(uint8_t d){
  if(_p<_s-1){
    _a[_p]=d;
    _p++;
    return 1;
  }else{
    return 0;
  }
}

void awriter::clear(){
  for(int i=0;i<_s;i++){
    _a[i]=0;
  }
  _p=0;
}

int awriter::availableForWrite(){
  return _s-_p-1;         //always one less to allow null terminator to fit
}

int awriter::peek(){        //reads/peeks from start (ie FIFO)
  if(_p>0){
    return _a[0];
  }else{
    return -1;
  }
}

int awriter::available(){  
  return _p;
}

int awriter::read(){        //reads/peeks from start (ie FIFO)
  int b,i;
  if(_p>0){
    b=_a[0];
    for(i=1;i<_p+1;i++){_a[i-1]=_a[i];} //move everything up by one
    _p--;                                //one less available
    return b;
  }else{
    return -1;
  }
}

int awriter::padLeft(char c, int s){   //pad with c on left (moving current chars) up to length s (ie right justify)
  int j,i,n;
  if(_p>=s){return 0;}                   //nothing to do
  n=s-_p;                                //number to add
  if(s>_s-1){n=_s-1-_p;}                 //avoid moving beyond bounds
  for(i=_p-1;i>=0;i--){
    _a[i+n]=_a[i];                       //move existing characters
  }
  for(i=0;i<n;i++){
    _a[i]=c;                             //add padding
  }
  _p=_p+n;                               //adjust pointer
  return n;
}

int awriter::padRight(char c, int s){   //pad with c on right up to length s (ie left justify)
  int n=0;
  while(_p<s){
    if(!write(c)){break;}               //stop if we can't fit any more into space available            
    n++;
  }
  return n;
}

