// for backpack on Diode Tester
#define LCD_RS (5)
#define LCD_CS (7)
#define TOUCH_CS (2)
#define LCD_RESET (6)

#define OVERSAMPLE 16

//backpack library
#include "backpack.h"
backpack bp;

long touch_x0 = 2085;
long touch_x1 = 145;
long touch_y0 = 95;
long touch_y1 = 2235;

void setup() {
  while(!Serial){}
  Serial.begin(115200);
  pinMode(LCD_RESET,OUTPUT);
  digitalWrite(LCD_RESET,LOW);
  delay(10);
  digitalWrite(LCD_RESET,HIGH);
  bp.init(LCD_RS,LCD_CS,TOUCH_CS);
  bp.rotate(4);
  bp.clear(BLACK);
  printMenu();
}

void loop() {
  int d;
  if(Serial.available()){
    d=Serial.read();
    if(d=='1'){doCals();}
    if(d=='2'){doTest();}
    if(d=='3'){doDefaults();printMenu();}
  }
}

void printMenu(){
  Serial.println();
  reportDefines();
  Serial.println("Press 1 for calibration");
  Serial.println("      2 for test");  
  Serial.println("      3 for default values");
}

void doCals(){
  long xTest[4],yTest[4],x,y,z;
  int i,c;
  Serial.println("Touch the crosses on the screen with a sharp object");  
  for(i=0;i<4;i++){
    delay(100);
    drawCross(i);
    c=0;
    xTest[i]=0;
    yTest[i]=0;
    while(c<OVERSAMPLE){
      x=bp.touchxraw();
      y=bp.touchyraw();
      z=bp.touchzraw();
      if(z>Z_TOUCH_THRESHOLD){
        x=bp.touchxraw();
        y=bp.touchyraw();
        z=bp.touchzraw();
        if(z>Z_TOUCH_THRESHOLD){
          xTest[i]=xTest[i]+x;
          yTest[i]=yTest[i]+y;
          c++;
        }
      }
    }
    bp.clear(BLACK);
    while(bp.touchzraw()>Z_TOUCH_THRESHOLD/2){}     //wait for release    
    Serial.print("Raw Value ");
    Serial.print(i);
    Serial.print(":");    
    Serial.print(xTest[i]/OVERSAMPLE);
    Serial.print(",");
    Serial.println(yTest[i]/OVERSAMPLE);
  }
  touch_x0 = ((xTest[0]+xTest[2])*3-(xTest[1]+xTest[3]))/4/OVERSAMPLE;
  touch_x1 = ((xTest[1]+xTest[3])*3-(xTest[0]+xTest[2]))/4/OVERSAMPLE;
  touch_y0 = ((yTest[2]+yTest[3])*3-(yTest[0]+yTest[1]))/4/OVERSAMPLE;
  touch_y1 = ((yTest[0]+yTest[1])*3-(yTest[2]+yTest[3]))/4/OVERSAMPLE;
  reportDefines();
  printMenu(); 
}

void drawCross(int i){
  int x,y;
  x=80+(i&1)*160;
  y=60+(i&2)*60;
  bp.hline(x-30,y,x+30,WHITE);
  bp.vline(x,y-30,y+30,WHITE);
}

void doTest(){
  int x,y,z,n;
  delay(10);
  Serial.println("Press anything on serial to exit.");
  while(Serial.available()){Serial.read();}     //remove any extras from buffer that would cause us to return
  while(!Serial.available()){
    if(bp.touchzraw()>Z_TOUCH_THRESHOLD){
      n=bp.touchxraw();
      x=map(n,TOUCH_X0,TOUCH_X1,0,bp.width()-1);
      n=bp.touchyraw();
      y=map(n,TOUCH_Y1,TOUCH_Y0,0,bp.height()-1);
      if((x>=0)&&(x<bp.width())&&(y>=0)&&(y<bp.height())){
        bp.point(x,y,WHITE);
      }
    }
  }
  bp.clear(BLACK);
  delay(10);
  while(Serial.available()){Serial.read();}     //remove any extras from buffer that would cause us to return  
  printMenu(); 
}

void reportDefines(){
  
  Serial.println("// Use the following defines:");
  Serial.print("#define TOUCH_X0 ");
  Serial.println(touch_x0);
  Serial.print("#define TOUCH_X1 ");
  Serial.println(touch_x1);
  Serial.print("#define TOUCH_Y0 ");
  Serial.println(touch_y0);
  Serial.print("#define TOUCH_Y1 ");
  Serial.println(touch_y1);
  Serial.println();
}

void doDefaults(){
  touch_x0 = 2085;
  touch_x1 = 145;
  touch_y0 = 95;
  touch_y1 = 2235;
}

