//lib for LCD Backpack display
//issues: working OK, touch is poor (not use map?)
//add:  fonts (make loadable/settable?)
//      more drawing primitives
//      ui elements

#ifndef backpack_h
#define backpack_h
#include "Arduino.h"
#include <SPI.h>

//some colours with nice names
#define BLACK 0x0000
#define BLUE 0x001F
#define RED 0xF800
#define GREEN 0x07E0
#define CYAN 0x07FF
#define MAGENTA 0xF81F
#define YELLOW 0xFFE0  
#define WHITE 0xFFFF
#define GREY 0x8410
//unit colours - multiply by 0-31
#define RED_1 0x0800
#define GREEN_1 0x0040
#define BLUE_1 0x0001
/*
#define Z_TOUCH_THRESHOLD 100
#define TOUCH_X0 1984
#define TOUCH_X1 144
#define TOUCH_Y0 0
#define TOUCH_Y1 1896
*/

//touch cals probably need full 'matrix' solution
#define Z_TOUCH_THRESHOLD 100
#define TOUCH_X0 2085
#define TOUCH_X1 145
#define TOUCH_Y0 95
#define TOUCH_Y1 2235

#define TOUCH_OVERSAMPLE 16

class backpack{
  public:
    backpack();
    void init(char dc,char cs,char touchcs);
    void rotate(char a);
    void data(unsigned char d);
    void cmd(unsigned char d);
    void areaset(int x1,int y1,int x2,int y2);    
    void box(int x1,int y1,int x2,int y2,unsigned int c);  
    void clear(unsigned int c);
    void point(int x,int y, unsigned int c);
    void line(int x1,int y1,int x2,int y2, unsigned int c);
    void character(int x,int y,char c, unsigned int f, unsigned int b);
    void chararray(int x,int y,char *c, unsigned int f, unsigned int b);
    void hline(int x1,int y1,int x2,unsigned int c);
    void vline(int x1,int y1,int y2,unsigned int c);
    int touchxraw();  //raw adc
    int touchyraw();
    int touchzraw();
    int width();
    int height();    
    int touchx();     //scaled, rotated, pixel reference
    int touchy();
    int charfont(int x, int y, char c, unsigned int f, unsigned int b, const uint8_t* font);
    void chararrayfont(int x0, int y0, char *c, unsigned int f, unsigned int b, const uint8_t* font);
    void imaget(int x,int y,const byte img[],unsigned int t);
    byte imagewidth(const byte img[]);
    byte imageheight(const byte img[]);    
    
  private:

    int _width;
    int _height;
    int _rotation;
    byte _dcpin;
    byte _cspin;
    byte _touchcspin;
};

const unsigned int font1216[][12] PROGMEM ={    //font is 16x12
{0,0,0,0,0,0,0,0,0,0,0,0},           // 
{0,0,0,124,13311,13311,124,0,0,0,0,0},           //!
{0,0,60,60,0,0,60,60,0,0,0,0},           //"
{512,7696,8080,1008,638,7710,8080,1008,638,30,16,0},           //#
{0,1144,3324,3276,16383,16383,3276,4044,1928,0,0,0},           //$
{12288,14392,7224,3640,1792,896,448,14560,14448,14392,28,0},           //%
{0,7936,16312,12796,8646,14306,7742,7196,13824,8704,0,0},           //&
{0,0,0,39,63,31,0,0,0,0,0,0},           //'
{0,0,1008,4092,8190,14343,8193,8193,0,0,0,0},           //(
{0,0,8193,8193,14343,8190,4092,1008,0,0,0,0},           //)
{0,3224,3768,992,4088,4088,992,3768,3224,0,0,0},           //*
{0,384,384,384,4080,4080,384,384,384,0,0,0},           //+
{0,0,0,47104,63488,30720,0,0,0,0,0,0},           //,
{0,384,384,384,384,384,384,384,384,0,0,0},           //-
{0,0,0,14336,14336,14336,0,0,0,0,0,0},           //.
{6144,7168,3584,1792,896,448,224,112,56,28,14,0},           ///
{2040,8190,7686,13059,12675,12483,12387,12339,6174,8190,2040,0},           //0
{0,0,12300,12300,12302,16383,16383,12288,12288,12288,0,0},           //1
{12316,14366,15367,15875,14083,13187,12739,12515,12407,12350,12316,0},           //2
{3084,7182,14343,12483,12483,12483,12483,12483,14823,8062,3644,0},           //3
{960,992,880,824,796,782,775,16383,16383,768,768,0},           //4
{3135,7295,14435,12387,12387,12387,12387,12387,14563,8131,3971,0},           //5
{4032,8176,14840,12508,12494,12487,12483,12483,14787,8064,3840,0},           //6
{3,3,3,12291,15363,3843,963,243,63,15,3,0},           //7
{3840,8124,14846,12519,12483,12483,12483,12519,14846,8124,3840,0},           //8
{60,126,12519,12483,12483,14531,7363,3779,2023,1022,252,0},           //9
{0,0,0,7280,7280,7280,0,0,0,0,0,0},           //:
{0,0,0,40048,64624,31856,0,0,0,0,0,0},           //;
{0,192,480,1008,1848,3612,7182,14343,12291,0,0,0},           //<
{0,1632,1632,1632,1632,1632,1632,1632,1632,1632,0,0},           //=
{0,12291,14343,7182,3612,1848,1008,480,192,0,0,0},           //>
{28,30,7,3,14211,14275,227,119,62,28,0,0},           //?
{4088,8190,6151,13299,14331,13851,14331,14331,13831,1022,504,0},           //@
{14336,16128,2016,1788,1567,1567,1788,2016,16128,14336,0,0},           //A
{16383,16383,12483,12483,12483,12483,12519,14846,8124,3840,0,0},           //B
{1008,4092,7182,14343,12291,12291,12291,14343,7182,3084,0,0},           //C
{16383,16383,12291,12291,12291,12291,14343,7182,4092,1008,0,0},           //D
{16383,16383,12483,12483,12483,12483,12483,12483,12291,12291,0,0},           //E
{16383,16383,195,195,195,195,195,195,3,3,0,0},           //F
{1008,4092,7182,14343,12291,12483,12483,12483,16327,16326,0,0},           //G
{16383,16383,192,192,192,192,192,192,16383,16383,0,0},           //H
{0,0,12291,12291,16383,16383,12291,12291,0,0,0,0},           //I
{3584,7680,14336,12288,12288,12288,12288,14336,8191,2047,0,0},           //J
{16383,16383,192,480,1008,1848,3612,7182,14343,12291,0,0},           //K
{16383,16383,12288,12288,12288,12288,12288,12288,12288,12288,0,0},           //L
{16383,16383,30,120,480,480,120,30,16383,16383,0,0},           //M
{16383,16383,14,56,240,960,1792,7168,16383,16383,0,0},           //N
{1008,4092,7182,14343,12291,12291,14343,7182,4092,1008,0,0},           //O
{16383,16383,387,387,387,387,387,455,254,124,0,0},           //P
{1008,4092,7182,14343,12291,13827,15879,7182,16380,13296,0,0},           //Q
{16383,16383,387,387,899,1923,3971,7623,14590,12412,0,0},           //R
{3132,7294,14567,12483,12483,12483,12483,14791,8078,3852,0,0},           //S
{0,3,3,3,16383,16383,3,3,3,0,0,0},           //T
{2047,8191,14336,12288,12288,12288,12288,14336,8191,2047,0,0},           //U
{7,63,504,4032,15872,15872,4032,504,63,7,0,0},           //V
{16383,16383,7168,1536,896,896,1536,7168,16383,16383,0,0},           //W
{12291,15375,3612,816,480,480,816,3612,15375,12291,0,0},           //X
{3,15,60,240,16320,16320,240,60,15,3,0,0},           //Y
{12291,15363,15875,13059,12739,12515,12339,12319,12303,12291,0,0},           //Z
{0,0,16383,16383,12291,12291,12291,12291,0,0,0,0},           //[
{14,28,56,112,224,448,896,1792,3584,7168,6144,0},           //backslash
{0,0,12291,12291,12291,12291,16383,16383,0,0,0,0},           //]
{96,112,56,28,14,7,14,28,56,112,96,0},           //^
{49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,49152,0},           //_
{0,0,0,0,62,126,78,0,0,0,0,0},           //`
{7168,15936,13152,13152,13152,13152,13152,13152,16352,16320,0,0},           //a
{16383,16383,12480,12384,12384,12384,12384,14560,8128,3968,0,0},           //b
{3968,8128,14560,12384,12384,12384,12384,12384,6336,2176,0,0},           //c
{3968,8128,14560,12384,12384,12384,12512,12480,16383,16383,0,0},           //d
{3968,8128,15328,13152,13152,13152,13152,13152,5056,384,0,0},           //e
{192,192,16380,16382,199,195,195,3,0,0,0,0},           //f
{896,51136,52960,52320,52320,52320,52320,58976,32736,16352,0,0},           //g
{16383,16383,192,96,96,96,224,16320,16256,0,0,0},           //h
{0,0,12288,12384,16364,16364,12288,12288,0,0,0,0},           //i
{0,0,24576,57344,49152,49248,65516,32748,0,0,0,0},           //j
{0,16383,16383,768,1920,4032,7392,14432,12288,0,0,0},           //k
{0,0,12288,12291,16383,16383,12288,12288,0,0,0,0},           //l
{16352,16320,224,224,16320,16320,224,224,16320,16256,0,0},           //m
{0,16352,16352,96,96,96,96,224,16320,16256,0,0},           //n
{3968,8128,14560,12384,12384,12384,12384,14560,8128,3968,0,0},           //o
{65504,65504,3168,6240,6240,6240,6240,7392,4032,1920,0,0},           //p
{1920,4032,7392,6240,6240,6240,6240,3168,65504,65504,0,0},           //q
{0,16352,16352,192,96,96,96,96,224,192,0,0},           //r
{4544,13280,13152,13152,13152,13152,16224,7744,0,0,0,0},           //s
{96,96,8190,16382,12384,12384,12384,12288,0,0,0,0},           //t
{4064,8160,14336,12288,12288,12288,12288,6144,16352,16352,0,0},           //u
{96,480,1920,7680,14336,14336,7680,1920,480,96,0,0},           //v
{2016,8160,14336,7168,4064,4064,7168,14336,8160,2016,0,0},           //w
{12384,14560,7616,3968,1792,3968,7616,14560,12384,0,0,0},           //x
{0,96,33248,59264,32256,7680,1920,480,96,0,0,0},           //y
{12384,14432,15456,13920,13152,12768,12512,12384,12320,0,0,0},           //z
{0,128,448,8188,16254,28679,24579,24579,24579,0,0,0},           //{
{0,0,0,0,16383,16383,0,0,0,0,0,0},           //|
{0,24579,24579,24579,28679,16254,8188,448,128,0,0,0},           //}
{16,24,12,4,12,24,16,24,12,4,0,0},           //~
{256,1792,7680,30720,30720,7680,1920,480,120,28,6,3}           //tick for check box
};

#endif

