#ifndef guiobjects_h
#define guiobjects_h

#include "Arduino.h"
#include "backpack.h"

//colour scheme
#define GUI_BACKGROUND_COLOUR 12
#define GUI_FOREGROUND_COLOUR WHITE
#define GUI_TEXT_COLOUR WHITE
#define GUI_DISABLE_COLOUR GREY

//font to use
#include "arial.h"
#define GUI_FONT Arial_round_16x24
#define GUI_FONT_WIDTH 16
#define GUI_FONT_HEIGHT 24

//backpack object to use
#define BP_OBJECT bp

extern backpack BP_OBJECT;

enum guiObjectType{
  BUTTON=1
};

struct guiObject{
  int x;
  int y;
  int w;
  int h;
  char* text;
  int value;
  bool pressed;
  bool visible;
  bool enabled;
  guiObjectType type;
};

void guiDraw(guiObject g);
bool checkPress(guiObject g);
#endif
