option explicit
option base 0
option default none
option autorun on
const FmSwitch=0,DabSwitch=1
CPU 120
const SPIrate=10000000
const D=0
const SA=0
const Pv=0
const IrLed=0
const IrBuzz=1
const RtcInstalled=0
const DefaultChannel=666
const AmColour=rgb(0,170,170)
const FmColour=rgb(0,170,50)
const DabColour=rgb(200,170,0)
const NonBandColour=rgb(red)
const ButtonColour=rgb(0,0,144)
const ButtonTextColour=rgb(white)
const BMuteBackgrounddColour=rgb(128,64,0)
const DigitalColour=rgb(blue)
const RCAColour=rgb(brown)
const SpeakerColour=rgb(red)
const OtherGadgetColour=rgb(brown)
const ConsoleOutlineColour=rgb(green)
const ConsoleTextColour=rgb(white)
const CancelTextColour=rgb(80,80,80)
const CancelBackgroundColour=rgb(48,48,48)
const P_SI4689_SMODE=44,P_SI4689_RES=74,P_SI4689_CS=80
const P_Flash_SPI_MISO=88,P_Flash_SPI_MOSI=90,P_Flash_SPI_CLK=91,P_Flash_SPI_CS=92
const P_WM8804_CSB=59,P_WM8804_IFM=60,P_WM8804_RST=61,P_WM8804_SPI_MOSI=72
const P_MUX_0=25,P_MUX_1=24,P_LED_YELLOW=38,P_LED_RED=58
const P_PAM8407_ENAB=68,P_PAM8407_UP=67,P_PAM8407_DN=66
const P_REG=21,P_HEADPHONE=14,P_IR_ACK_LED=35
const P_POWER_ALARM=34
const MODE_AM=0,MODE_FM=1,MODE_DAB=2
const AUDIO_DIG=0,AUDIO_RCA=1,AUDIO_SPKR=2
const AmMIN=522,AmMAX=1710,AmDELTA=9,AmSNR=10,AmMinStren=45,FmMIN=76000
const FmMAX=108000,AFmMIN=87500,FmDELTA=100,FmSNR=6,FmMinStren=25,DabMIN=174928
const DabMAX=239200,ADabMIN=195936,ADabMAX=208064,DabCNR=4,DabMinStren=40
const BWmin=1500,BWmax=10000,BWdef=5000
const Runtuned=0,Rtuned=1,Rselected=2,Rplaying=3
const SnrSettle=40
const FmSlope=&HEDB5,FmIntercept=&H01E3
const DabSlope=&HF8A9,DabIntercept=&H01C6
const MAX_DAB_FREQS=41,MAX_DAB_SERVICES=32
const MAX_PRESETS=90
const MAX_FAVS=6
const MAX_RADIO=30
const NUM_PRESET_ROWS=MAX_RADIO/3
const RADIO_RADIUS=16
const Rad1=111-MAX_RADIO
const MUTE_RELEASE=150
const Xconsole=1,Xstatus=2,Xmain=3,Xedit=4,Xselect=5,Xsetup=6,Xscan=7,XIRTest=8
const Xcap=9,Xdisp=10,XstatusE=11,XmainE=12,XscanE=13,XcapE=14,XdispE=15
const READ_REPLY_BUFSIZE=1028
const MA_MULT!=0.99
const MA_INV_MULT!=1-MA_MULT!
dim string S1,S2,S3
pin(P_WM8804_SPI_MOSI)=1
pin(P_WM8804_RST)=0
pin(P_WM8804_IFM)=1
pin(P_WM8804_CSB)=1
setpin P_WM8804_SPI_MOSI,dout
setpin P_WM8804_RST,dout
setpin P_WM8804_IFM,dout
setpin P_WM8804_CSB,dout
pin(P_SI4689_SMODE)=0
pin(P_SI4689_RES)=0
pin(P_SI4689_CS)=1
pin(P_PAM8407_ENAB)=0
pin(P_PAM8407_UP)=1
pin(P_PAM8407_DN)=1
pin(P_REG)=0
setpin P_SI4689_SMODE,dout
setpin P_SI4689_RES,dout
setpin P_SI4689_CS,dout
setpin P_Flash_SPI_MISO,din
setpin P_Flash_SPI_MOSI,din
setpin P_Flash_SPI_CLK,din
setpin P_Flash_SPI_CS,din
setpin P_PAM8407_ENAB,dout
setpin P_PAM8407_UP,dout
setpin P_PAM8407_DN,dout
setpin P_REG,dout
setpin P_HEADPHONE,din
setpin P_MUX_0,dout
setpin P_MUX_1,dout
if(IrLed>0)then
pin(P_IR_ACK_LED)=1
setpin P_IR_ACK_LED,dout
endif
pin(P_LED_YELLOW)=1
pin(P_LED_RED)=1
setpin P_LED_YELLOW,dout
setpin P_LED_RED,dout
dim integer WM8804_State=1
sub ResetWM8804
if(WM8804_State=0)then exit sub
WM8804_State=0
on error skip
spi close
pin(P_WM8804_RST)=0
pin(P_WM8804_SPI_MOSI)=1
pin(P_WM8804_IFM)=1
pin(P_WM8804_CSB)=1
pin(P_WM8804_RST)=1
spi open SPIrate,0,8
if(D>0)then print"Reset WM8804 Toslink framer and SPI bus"
end sub
ResetWM8804
sub WriteWM8804(reg as integer,v as integer)
pin(P_WM8804_CSB)=0
spi write 2,reg,v
pin(P_WM8804_CSB)=1
if(D>2)then print"*WM8804: " hex$(reg,2)"=" hex$(v,2)
end sub
sub InitWM8804
if(WM8804_State<>0)then exit sub
WM8804_State=1
WriteWM8804(&H06,&H08)
WriteWM8804(&H03,&HBA)
WriteWM8804(&H04,&H49)
WriteWM8804(&H05,&H0C)
WriteWM8804(&H08,&H38)
WriteWM8804(&H1E,&H3F)
WriteWM8804(&H1E,&H02)
WriteWM8804(&H1B,&H0A)
WriteWM8804(&H1C,&HCA)
if(D>0)then print"Sent WM8804 initialisation"
end sub
dim integer MuteDowncount=0,Muted=1,AudioOutMode=-1,WM8804=-1
sub SetMux(auto_mute as integer,man_mute as integer)
local integer nextmute
nextmute=Muted and 3
if(auto_mute>0)then
nextmute=nextmute or 1
elseif(auto_mute=0)then
nextmute=nextmute and 2
endif
if(man_mute>0)then
nextmute=nextmute or 2
elseif(man_mute=0)then
nextmute=nextmute and 1
endif
if((Muted=nextmute)and(AudioOutMode<>AUDIO_DIG))then exit sub
if((D>0)and(Muted<>nextmute))then
print"AudioMux HWmute=" auto_mute ", SWmute=" man_mute ", WM8804=" WM8804 ", Prev mute state=" Muted ", Next state=" nextmute
endif
if(nextmute=0)then
if(CtrlVal(Sswap)=0)then
pin(P_MUX_1)=0
pin(P_MUX_0)=1
if(D>1)then print"AudioMux set to Si4689 stereo normal"
else
pin(P_MUX_1)=1
pin(P_MUX_0)=0
if(D>1)then print"AudioMux set to Si4689 stereo reverse"
endif
if((AudioOutMode=AUDIO_DIG)and(WM8804_State=0))then InitWM8804
else
pin(P_MUX_1)=0
pin(P_MUX_0)=0
MuteDowncount=0
if(D>1)then print"AudioMux set to mute"
endif
Muted=nextmute
end sub
dim integer DoPowerAlarm=0
if(Pv>0)then setpin P_POWER_ALARM,INTB,PowerAlarmInt,PULLUP
sub PowerAlarmInt
if(D>0)then print"Power Alarm Int:" pin(P_POWER_ALARM)
if(pin(P_POWER_ALARM)=0)then
MuteDowncount=MUTE_RELEASE<<1
else
SetMux(1,-1)
DoPowerAlarm=1
endif
end sub
const HP_PULSE_WIDTH=16
dim integer SpiWait=0,PollWait=0,CapWait=0,DABwait=0,IRwait=-1,IRnum=-1,Dwait=0
dim integer Pwait=0,Reboot=0,GuiCounter=0,UpTime=0,HP_removed=0
SetTick 5,TickInterrupt
sub TickInterrupt
UpTime=UpTime+1
GuiCounter=GuiCounter+1
SpiWait=SpiWait+1
PollWait=PollWait+1
CapWait=CapWait+1
if(Dwait>0)then Dwait=Dwait+1
if(DABwait>0)then DABwait=DABwait+1
if(Pwait>0)then Pwait=Pwait+1
if(IRwait>=0)then
IRwait=IRwait+1
if(IRwait>2000)then
IRnum=-1
IRwait=-1
CtrlVal(RLN8)=""
CtrlVal(RLN9)=""
endif
endif
if(Reboot>0)then
Reboot=Reboot-1
if(Reboot=0)then
if(Pwait>0)then WritePresetFile
if(Dwait>0)then WriteDefaultFile
cpu restart
endif
endif
if(MuteDowncount>0)then
MuteDowncount=MuteDowncount-1
if((CapSearch<=0)and(MuteDowncount=0))then
SetMux(0,-1)
if((Smode=Xconsole)or(Smode=XstatusE)or(Smode=XmainE)or(Smode=XScanE))then Change_Smode=Xstatus
endif
endif
if(pin(P_HEADPHONE)=0)then
if(HP_removed<>0)then
if(Muted=0)then SetMux(1,-1)
HP_removed=0
endif
elseif(HP_removed=0)then
HP_removed=1
endif
end sub
dim integer IrDev=0,IrButton=0,IrTest=0
ir IrDev,IrButton,IrInt
sub IrInt
local S as string length 50
if(D>0)or(IrTest<>0)then S="IR Device Code="+hex$(IrDev)+" Button="+hex$(IrButton)
if(D>0)then print S
if(IrTest<>0)then
WriteMsg(S)
IrDev=0
endif
end sub
const BOOT_TITLE=1,LN1=2,LN2=3,LN3=4,LN4=5,LN5=6,LN6=7,LN7=8,LN8=9,LN9=10
const LN10=11,LN11=12,LN12=13,LN13=14,RLN1=15,RLN2=16,RLN3=17,RLN4=18,RLN5=19
const RLN6=20,RLN7=21,RLN8=22,RLN9=23,RLN10=24,ERR1=25,ERR2=26,Ename=27,F1=28
const F2=29,F3=30,F4=31,F5=32,F6=33,Efreq=34,Eclr=35,Eband=36,EkHz=37,Edata=38
const Eframe=39,Eindex=40,Eactive=41,Efav=42,Eantcap=43,Ebandwidth=44,BCancel=45
const BSetup=46,BPreset=47,BEdit=48,BVolume=49,BScan=50,BCap=51,BRemote=52
const BLight=53,Bdown=54,Bup=55,BSeekDn=56,BSeekUp=57,BRotate=58,BDisp=59,Ram=60
const Rfm=61,Rdab=62,Rdigital=63,Rrca=64,Rspeaker=65,Sswap=66,Vvolume=67,VLight=68
const Vaudio=69,Vswap=70,Vantcap=71,Vbandwidth=72,Vfav=73,Vactive=74,Vgui=75
const Sgui=76,BMute=77,AR1=78,AR2=79
const NameLen=16
const MAX_SET=4
dim integer Smode=0,Change_Smode=Xconsole,RadioMode=-1,DoScan=0,CapSearch=0
dim integer Frequency=-1,NewFrequency=DefaultChannel,ServiceID=-1,CompID=-1
dim integer NewServiceID=-1,NewCompID=-1,Seeking=0,SeekStart=0,NumDabFreqs=-1
dim integer DabFreqIndex=-1,NumDabServices=0,DabID=-1,DabFreqs(MAX_DAB_FREQS-1)
dim integer NumPresets=0,NumActivePresets=-1,Pfirst=-1,Plast=-1,Pprev,Pnext
dim integer PbPrev=-1,PbNext=-1,PbCan=-1,NumFavs=0,ActiveProgData=-1,CLine=LN1
dim integer Pfreq(MAX_PRESETS-1),Pid(MAX_PRESETS-1),Pcomp(MAX_PRESETS-1)
dim integer Pbw(MAX_PRESETS-1),Pflags(MAX_PRESETS-1),Pcap(MAX_PRESETS-1)
dim integer Pfav(MAX_FAVS-1)
dim string Pname(MAX_PRESETS-1)length NameLen,ProgName(3)length 2
dim string ProgData(31)length 4,RdsNameSet(MAX_SET)length 8
dim integer RdsNames=0
dim integer i,j
cls
gui hide all
gui delete all
colour ConsoleTextColour,rgb(black)
gui setup 1
font 3
gui frame BOOT_TITLE,"Stefan"+chr$(39)+"s Covid-19 Radio Project",0,MM.FontHeight>>1,MM.HRes,MM.VRes-(MM.FontHeight>>1),ConsoleOutlineColour
i=0
for j=LN1 to LN13
i=i+(MM.FontHeight*1.4)
gui caption j,"",9,i,"lt"
next
gui area AR1,0,0,mm.hres,mm.vres
sub WriteMsg(msg as string)
local integer i
if(CLine>LN13)then
for i=LN1 to LN12
CtrlVal(i)=CtrlVal(i+1)
next
CLine=LN13
endif
CtrlVal(CLine)=msg
CLine=CLine+1
print msg
end sub
sub ClearConsole
local integer i
for i=LN1 to LN13
CtrlVal(i)=""
next
CLine=LN1
end sub
function RotateAndOpen(base as string,ext as string,do_open as integer)as integer
local integer i
on error ignore
kill base+"9"+ext
for i=8 to 0 step-1
S1=base+str$(i)+ext
S2=base+str$(i+1)+ext
name S1 as S2
next
if(do_open<>0)then
Open base+"0"+ext for output As 1
endif
on error abort
if(MM.Errno<>0)then
WriteErr "SD Card or write err"
name S2 as base+"0"+ext
RotateAndOpen=0
else
RotateAndOpen=1
endif
end function
S1=""
on error skip
S1=dir$("Radio0.bas",FILE)
if(S1<>"")then
if(RotateAndOpen("Radio",".bas",0)=1)then
WriteMsg("LOADING NEW SOFTWARE")
pause 100
on error skip
load "Radio1.bas",r
endif
endif
sub ClearStatus
local integer i
for i=RLN1 to RLN10
CtrlVal(i)=""
next
end sub
sub DefineTouch(mode as integer)
gui setup 31
on error skip
gui delete AR2
if(mode=0)then
gui area AR2,0,0,mm.hres,mm.vres
else
gui area AR2,0,0,mm.hres,334
endif
end sub
gui setup 2
font 5,1.4
gui caption RLN1,"",mm.hres>>1,1,"ct"
font 3
gui caption RLN2,"",mm.hres>>1,42,"ct"
font 2
gui caption RLN3,"",mm.hres>>1,75,"ct"
font 3
i=108
for j=RLN4 to RLN10
gui caption j,"",mm.hres>>1,i,"ct"
i=i+32
next
DefineTouch(0)
gui setup 3
font 4
gui button BPreset,"Tune to Preset",0,410,245,70,ButtonTextColour,ButtonColour
gui button BEdit,"Edit Presets",250,410,245,70
gui button BSetup,"Setup",500,410,190,70
font 3
gui button Bdown,"<",195,28,60,50,ConsoleTextColour,rgb(black)
gui button Bup,">",540,28,60,50
gui setup 4
gui button BSeekDn,"<<",125,28,60,50
gui button BSeekUp,">>",610,28,60,50
gui setup 5
font 2
gui frame Vvolume,"Analogue Volume",135,335,210,68,OtherGadgetColour
gui spinbox BVolume,135,350,205,45,OtherGadgetColour,rgb(black),1,0,63
CtrlVal(BVolume)=20
gui setup 6
font 3
gui radio Ram,"AM",720,360,12,AmColour
gui radio Rfm,"FM",720,408,12,FmColour
gui radio Rdab,"DAB",720,456,12,DabColour
font 4
gui button BMute,"Mute",1,335,130,70,ButtonTextColour,BMuteBackgrounddColour
sub FetchPresetDetails
local integer i,j
CtrlVal(Edata)=""
i=CtrlVal(Eindex)-1
if(i>=NumPresets)then
CtrlVal(Ename)="##type station identifier"
CtrlVal(Efreq)="##freq"
CtrlVal(Eband)="--"
CtrlVal(Eantcap)=0
CtrlVal(Eactive)=0
CtrlVal(Efav)=0
exit sub
endif
if(Pname(i)="")then
CtrlVal(Ename)="##type station identifier"
else
CtrlVal(Ename)=Pname(i)
endif
j=Pfreq(i)
CtrlVal(Efreq)=j
if((j>=AmMIN)and(j<=AmMAX))then
CtrlVal(Eband)="AM"
gui hide Vantcap,Eantcap
gui show Vbandwidth,Ebandwidth
elseif((j>=FmMIN)and(j<=FmMAX))then
CtrlVal(Eband)="FM"
gui hide Vbandwidth,Ebandwidth
gui show Vantcap,Eantcap
elseif((j>=DabMIN)and(j<=DabMAX))then
CtrlVal(Eband)="DAB"
CtrlVal(Edata)="Service ID:"+hex$(Pid(i))+" Component ID:"+hex$(Pcomp(i))
gui hide Vbandwidth,Ebandwidth
gui show Vantcap,Eantcap
else
CtrlVal(Efreq)="##freq"
CtrlVal(Eband)="--"
endif
CtrlVal(Eantcap)=Pcap(i)
CtrlVal(Ebandwidth)=Pbw(i)
CtrlVal(Eactive)=Pflags(i)and 1
if((Pflags(i)and 4)<>0)then CtrlVal(Efav)=1 else CtrlVal(Efav)=0
end sub
gui setup 7
gui button F1,"",0,400,4,4,rgb(black),rgb(black)
gui setup 8
font 2
gui frame Eframe,"Preset Index",265,300,250,70,OtherGadgetColour
gui frame Vantcap,"AntCap Setting",0,300,250,70
gui frame Vbandwidth,"AM audio bandwidth",0,300,250,70
gui frame Vfav,"Favourites",530,300,240,70
gui frame Vactive,"Preset list",530,410,240,65
gui caption Edata,"",MM.HRes*.5,160,"cm"
font 4
gui textbox Ename,mm.hres*.2,26,mm.hres*.6,38,OtherGadgetColour,rgb(black)
gui numberbox Efreq,mm.hres*.42,96,mm.hres*.15,38
gui caption Eband,"AM",mm.hres*.38,104,"ct"
gui caption EkHz,"kHz",mm.hres*.58,104,"lt"
gui button Eclr,"Clear",10,410,180,65,ButtonTextColour,ButtonColour
gui spinbox Eindex,275,313,230,50,OtherGadgetColour,rgb(black),1,1,MAX_PRESETS
gui spinbox Ebandwidth,10,313,230,50,OtherGadgetColour,rgb(black),500,BWmin,BWmax
gui spinbox Eantcap,10,313,230,50,OtherGadgetColour,rgb(black),1,0,128
font 2
gui switch Efav,"Normal|Favourite",535,315,230,45,rgb(black),OtherGadgetColour
gui switch Eactive,"Hide|Show",535,425,230,40
CtrlVal(Eantcap)=0
CtrlVal(Ebandwidth)=BWdef
gui hide Vantcap,Vbandwidth,Eantcap,Ebandwidth
gui redraw BOOT_TITLE
sub ClearGuiPresets
local integer n,numbuttons
if((Pfirst<0)or(Plast<0))then exit sub
numbuttons=Plast-Pfirst+2
if(Pnext>0)then numbuttons=numbuttons+1
if(Pprev>=0)then numbuttons=numbuttons+1
for n=0 to(numbuttons-1)
gui delete Rad1+n
next
Plast=-1
end sub
function ChooseColour(f as integer)as integer
if((f>=AmMIN)and(f<=AmMAX))then
ChooseColour=AmColour
elseif((f>=FmMIN)and(f<=FmMAX))then
ChooseColour=FmColour
elseif((f>=DabMIN)and(f<=DabMAX))then
ChooseColour=DabColour
else
ChooseColour=NonBandColour
endif
end function
sub Define_Radio_Button(i as integer,x as integer,y as integer,f as integer,n as string)
local integer col,j
S2=n
if(S2="")then S2=str$(f)+" kHz"
col=ChooseColour(f)
if(len(S2)>12)then
font 2
else
font 3
endif
colour ConsoleTextColour,rgb(black)
gui radio Rad1+i,S2,x,y,RADIO_RADIUS,col
j=Pfirst+i
if((Frequency=f)and((Frequency<DabMIN)or((ServiceID=Pid(j))and(CompID=Pcomp(j)))))then
CtrlVal(Rad1+i)=1
else
CtrlVal(Rad1+i)=0
endif
end sub
sub SetupGuiPresets
local integer n,x,y,z,spacing
Pprev=-1
Pnext=-1
PbPrev=-1
PbNext=-1
if(NumActivePresets<=0)then
Pfirst=-1
exit sub
endif
if(NumActivePresets<MAX_RADIO)then
Pfirst=0
Plast=NumActivePresets-1
else
z=1
if(Pfirst<0)then Pfirst=0
if(Pfirst>0)then
Pprev=Pfirst-(MAX_RADIO-1)
if(Pprev<0)then Pprev=0
z=2
endif
n=NumActivePresets-Pfirst
if(n>(MAX_RADIO-z))then
z=z+1
n=MAX_RADIO-z
endif
Plast=Pfirst+n-1
if(NumActivePresets>(Plast+1))then Pnext=Plast+1
endif
gui setup 9
spacing=int((MM.VRes-(RADIO_RADIUS<<1))/(NUM_PRESET_ROWS-1))
for n=0 to(MAX_RADIO-1)
if(n<NUM_PRESET_ROWS)then
x=RADIO_RADIUS
y=RADIO_RADIUS+(spacing*n)
elseif(n<(NUM_PRESET_ROWS<<1))then
x=275
y=RADIO_RADIUS+(spacing*(n-NUM_PRESET_ROWS))
else
x=535
y=RADIO_RADIUS+(spacing*(n-(NUM_PRESET_ROWS<<1)))
endif
if((Pfirst+n)>Plast)then
if((Pprev>=0)and(PbPrev<0))then
Define_Radio_Button(n,x,y,0,"Previous Page")
PbPrev=n
continue for
endif
if((Pnext>0)and(PbNext<-0))then
Define_Radio_Button(n,x,y,0,"Next Page")
PbNext=n
continue for
endif
Define_Radio_Button(n,x,y,0,"Cancel")
PbCan=n
exit for
endif
Define_Radio_Button(n,x,y,Pfreq(Pfirst+n),Pname(Pfirst+n))
next
end sub
gui setup 10
font 4
gui button BRemote,"IR Remote Test",0,300,255,65,ButtonTextColour,ButtonColour
gui button BCap,"AntCap Scan",265,300,255,65
gui button BScan,"Station Scan",530,300,255,65
gui button BRotate,"New Error Log",0,410,255,65
gui button BDisp,"Disp Error Log",530,410,255,65
font 2
gui frame Vlight,"Backlight",0,180,200,75,OtherGadgetColour
font 3
gui spinbox BLight,0,195,200,50,OtherGadgetColour,rgb(black),1,10,100
CtrlVal(BLight)=50
font 2
gui frame Vaudio,"Audio Output Port Selection",120,15,620,140,OtherGadgetColour
gui radio Rdigital,"Optical or coax digital output [or headphones]",145,45,15,DigitalColour
gui radio Rrca,"Analogue output via RCA [or headphones]",145,90,15,RCAColour
gui radio Rspeaker,"Analogue output via speakers [or headphones]",145,135,15,SpeakerColour
gui frame Vswap,"Analogue Channels",265,180,255,75,OtherGadgetColour
gui switch Sswap,"Normal|Swapped",280,195,230,50,rgb(black),OtherGadgetColour
gui frame Vgui,"Show Fav Buttons",530,180,255,75,OtherGadgetColour
gui switch Sgui,"No|Yes",543,195,230,50,rgb(black),OtherGadgetColour
CtrlVal(Sswap)=0
CtrlVal(Sgui)=0
gui setup 11
font 5,1.5
i=mm.fontheight
gui caption ERR1,"Muting due to",mm.hres>>1,275,"ct",rgb(red)
font 5
gui caption ERR2,"",mm.hres>>1,275+i,"ct",rgb(red)
gui setup 32
font 5
gui button BCancel,"X",0,0,60,60,CancelTextColour,CancelBackgroundColour
sub WriteErr(msg as string)
CtrlVal(ERR2)=msg
WriteMsg(msg)
select case Smode
case Xstatus
Change_Smode=XstatusE
case Xmain,Xedit,Xselect,Xsetup
Change_Smode=XmainE
case Xscan
Change_Smode=XscanE
case Xcap
Change_Smode=XcapE
case Xdisp
Change_Smode=XdispE
case 0
Change_Smode=Xconsole
end select
end sub
sub SetRadioModeColour
if(RadioMode=MODE_AM)then CtrlVal(Ram)=1 else CtrlVal(Ram)=0
if(RadioMode=MODE_FM)then CtrlVal(Rfm)=1 else CtrlVal(Rfm)=0
if(RadioMode=MODE_DAB)then CtrlVal(Rdab)=1 else CtrlVal(Rdab)=0
end sub
sub SetupPageSeven
local integer i,f,x,y,z,col
local string s,t
gui setup 7
on error skip
gui delete F1,F2,F3,F4,F5,F6
if(NumFavs>0)then
if(NumFavs<5)then
x=0
y=410
else
x=350
y=335
endif
for i=0 to(NumFavs-1)
f=Pfreq(Pfav(i))
col=ChooseColour(f)
s=Pname(Pfav(i))
if(s="")then s=str$(f)+" kHz"
font 4
z=len(s)
if(z>10)then
for f=z to 2 step-1
if(mid$(s,f,1)=" ")then exit for
next
if((f<14)and((z-f)<14))then
t=left$(s,f-1)+"~"+mid$(s,f+1)
s=t
if((f>10)or((z-f)>10))then font 2
else
font 1
endif
endif
gui button F1+i,s,x,y,170,70,rgb(black),col
x=x+175
if(x>=700)then
x=0
y=410
endif
next
endif
end sub
dim integer ExitTimer=0
sub ProcessScreenChange
if(Smode=Change_Smode)then exit sub
if(Smode=Xedit)then
gui textbox cancel
gui numberbox cancel
elseif(Smode=Xselect)then
ClearGuiPresets
elseif((Smode=XIRTest)or(Smode=Xcap))then
ClearConsole
else
CtrlVal(RLN8)=""
CtrlVal(RLN9)=""
CtrlVal(RLN10)=""
endif
select case Change_Smode
case Xconsole,XIRTest,Xcap,Xdisp
page 1
ExitTimer=0
case Xstatus
DefineTouch(CtrlVal(Sgui))
if(CtrlVal(Sgui)=0)then
page 2,31
else
SetupPageSeven
if(AudioOutMode<>AUDIO_SPKR)then
page 2,6,7,31
else
page 2,5,6,7,31
endif
endif
ExitTimer=0
case Xmain
SetRadioModeColour
DefineTouch(CtrlVal(Sgui))
if(RadioMode<>MODE_DAB)then
if(AudioOutMode<>AUDIO_SPKR)then
page 2,3,4,6,32
else
page 2,3,4,5,6,32
endif
else
if(AudioOutMode<>AUDIO_SPKR)then
page 2,3,6,32
else
page 2,3,5,6,32
endif
endif
ExitTimer=2000
case Xedit
page 8,32
ExitTimer=12000
case Xselect
SetupGuiPresets
page 9
ExitTimer=3000
case Xsetup
page 10,32
ExitTimer=2000
case Xscan
page 2
ExitTimer=0
case XstatusE,XscanE,XcapE,XdispE
page 2,12
ExitTimer=2000
case XmainE
DefineTouch(CtrlVal(Sgui))
if(RadioMode<>MODE_DAB)then
if(AudioOutMode<>AUDIO_SPKR)then
page 2,3,4,6,11,32
else
page 2,3,4,5,6,11,32
endif
else
if(AudioOutMode<>AUDIO_SPKR)then
page 2,3,6,11,32
else
page 2,3,5,6,11,32
endif
endif
ExitTimer=1000
case else
S1="Unknown screen mode "+str$(Change_Smode)
error S1
end select
if(D>1)then print"Changing Screen Mode from " Smode " to " Change_Smode " ExitTimer=" ExitTimer
Smode=Change_Smode
Change_Smode=0
GuiCounter=0
if(Pwait>0)then
WritePresetFile
ReadPresetFile
SetFavs
endif
if(Dwait>0)then WriteDefaultFile
end sub
dim integer ButtonDn=0,ButtonUp=0
gui Interrupt TouchDown,TouchUp
sub TouchDown
ButtonDn=Touch(REF)
if(D>1)then print"Touch down:" ButtonDn " Smode=" Smode
GuiCounter=0
select case ButtonDn
case AR1
if(CapSearch=2)then
CapSearch=3
elseif((Smode=XIRTest)or(CapSearch=10))then
Change_Smode=Xsetup
CapSearch=0
IrTest=0
elseif(DispErrors=1)then
DispErrors=2
endif
case AR2
Change_Smode=Xmain
end select
end sub
sub TouchUp
ButtonUp=Touch(LASTREF)
if(D>1)then print"Touch up:" ButtonUp
GuiCounter=0
end sub
function DabFreqToIndex(freq as integer)as integer
for DabFreqToIndex=0 to(NumDabFreqs-1)
if(DabFreqs(DabFreqToIndex)=freq)then exit for
next
if(DabFreqToIndex>=NumDabFreqs)then
if(D>0)then Print "DAB frequency not in DabFreqs table:" freq
DabFreqToIndex=0
endif
end function
sub ProcessExitTimer
select case Smode
case Xmain
Change_Smode=Xstatus
case Xedit,Xsetup,Xselect
Change_Smode=Xmain
case XstatusE
Change_Smode=Xstatus
case XmainE
Change_Smode=Xmain
case XscanE
Change_Smode=Xscan
case XcapE
Change_Smode=Xcap
case Xdisp
on error skip
close 2
DispErrors=0
Change_Smode=Xsetup
case XdispE
Change_Smode=Xdisp
end select
ExitTimer=0
end sub
dim integer BDvalue=0,DispErrors=0
dim integer DirtyPresets=0
const DEFAULT_WAIT_TIME=6000
sub ProcessButtonDown
local integer i,j=-1,k
if(D>0)then print"Button Down:" ButtonDn " State=" State ", Smode=" Smode
GuiCounter=0
BDvalue=ButtonDn
select case ButtonDn
case BEdit
Change_Smode=Xedit
if(Pwait>0)then Pwait=1
FetchPresetDetails
case BPreset
if(NumActivePresets<=0)then
CtrlVal(RLN9)="Presets not yet defined"
else
Change_Smode=Xselect
endif
case BSetup
Change_Smode=Xsetup
case BLight
backlight CtrlVal(BLight)
Dwait=DEFAULT_WAIT_TIME*0.9
case Ram
for i=0 to(NumActivePresets-1)
if((Pfreq(i)>=AmMIN)and(Pfreq(i)<=AmMAX))then
if(j<0)then j=i
k=i
endif
next
NewFrequency=((AmMIN+AmMAX)>>1)/AmDELTA
NewFrequency=NewFrequency*AmDELTA
goto JUMP_MIDDLE
case Rfm
for i=0 to(NumActivePresets-1)
if((Pfreq(i)>=FmMIN)and(Pfreq(i)<=FmMAX))then
if(j<0)then j=i
k=i
endif
next
NewFrequency=((AFmMIN+FmMAX)>>1)/FmDELTA
NewFrequency=NewFrequency*FmDELTA
goto JUMP_MIDDLE
case Rdab
for i=0 to(NumActivePresets-1)
if((Pfreq(i)>=DabMIN)and(Pfreq(i)<=DabMAX))then
if(j<0)then j=i
k=i
endif
next
NewFrequency=206352
JUMP_MIDDLE:
if(j>=0)then NewFrequency=Pfreq((j+k)>>1)
goto RETUNE
case Rdigital
if(WM8804=0)then
ReadDefaultFile
else
Dwait=DEFAULT_WAIT_TIME*0.9
endif
case Rrca,Rspeaker,BVolume,Sswap
Dwait=DEFAULT_WAIT_TIME*0.9
case Bdown
if((Frequency>AmMIN)and(Frequency<=AmMAX))then NewFrequency=Frequency-AmDELTA
if((Frequency>FmMIN)and(Frequency<=FmMAX))then NewFrequency=Frequency-FmDELTA
if((Frequency>DabMIN)and(Frequency<=DabMAX))then
DabID=DabFreqToIndex(Frequency)
if(DabID>0)then
DabID=DabID-1
NewFrequency=DabFreqs(DabID)
endif
endif
goto RETUNE
case Bup
if((Frequency>=AmMIN)and(Frequency<AmMAX))then NewFrequency=Frequency+AmDELTA
if((Frequency>=FmMIN)and(Frequency<FmMAX))then NewFrequency=Frequency+FmDELTA
if((Frequency>=DabMIN)and(Frequency<DabMAX))then
DabID=DabFreqToIndex(Frequency)
if(DabID<(NumDabFreqs-1))then
DabID=DabID+1
NewFrequency=DabFreqs(DabID)
endif
endif
goto RETUNE
case BSeekDn
if(((RadioMode=MODE_AM)and(Frequency>AmMIN))or((RadioMode=MODE_FM)and(Frequency>FmMIN)))then
Seeking=&H80
goto SEEK_SET
endif
case BSeekUp
if(((RadioMode=MODE_AM)and(Frequency<AmMAX))or((RadioMode=MODE_FM)and(Frequency<FmMAX)))then
Seeking=&H81
SEEK_SET:
if(RadioMode=MODE_AM)then State=1000
if(RadioMode=MODE_FM)then State=1100
RETUNE:
ServiceID=-1
CompID=-1
NewServiceID=-1
NewCompID=-1
LastDabServList=-1
Dwait=1
AntCap=0
ClearStatus
endif
case BMute
if((Muted and 2)=0)then
SetMux(-1,1)
SetRadioMute
gui bcolour rgb(red),BVolume,RLN1,RLN2
else
SetMux(-1,0)
SetRadioMute
gui bcolour rgb(black),BVolume,RLN1,RLN2
State=452
endif
case BScan
DoScan=1
case BCap
CapSearch=1
case BRotate
S1=""
on error skip
S1=dir$("Error0.csv",FILE)
i=0
if(S1<>"")then i=RotateAndOpen("Error",".csv",1)
if(i=0)then
gui beep 700
else
on error ignore
print #1,DATE$ "," TIME$ ",Created new error file"
print #1,"Date Time UpTime Type State Status Freq Serv Comp"
Close 1
on error abort
endif
case BDisp
if(DispErrors=0)then
on error skip
Open "Error0.csv" for input As 2
if(MM.Errno<>0)then
gui beep 700
else
DispErrors=2
Change_Smode=Xdisp
endif
endif
case BCancel
ProcessExitTimer
case BRemote
Change_Smode=XIRTest
ClearConsole
WriteMsg("Infrared remote test mode")
WriteMsg("**Touch screen to exit this mode**")
IrTest=1
case F1
if(NumFavs>0)then
i=0
goto B_FAV
endif
case F2
if(NumFavs>1)then
i=1
goto B_FAV
endif
case F3
if(NumFavs>2)then
i=2
goto B_FAV
endif
case F4
if(NumFavs>3)then
i=3
goto B_FAV
endif
case F5
if(NumFavs>4)then
i=4
goto B_FAV
endif
case F6
if(NumFavs>5)then
i=5
B_FAV:
if(D>0)then print"Choosing favourite: " i+1 ", Name=" Pname(Pfav(i))" Freq=" Pfreq(Pfav(i))
ExitTimer=300
NewFrequency=Pfreq(Pfav(i))
NewServiceID=Pid(Pfav(i))
NewCompID=Pcomp(Pfav(i))
AntCap=Pcap(Pfav(i))
CtrlVal(Ebandwidth)=Pbw(Pfav(i))
Dwait=1
endif
case Sgui
Dwait=1
case Ename,Efreq
i=CtrlVal(Eindex)
CtrlVal(Ename)=Pname(i-1)
CtrlVal(Efreq)=Pfreq(i-1)
case Eclr
i=CtrlVal(Eindex)
if((Pname(i-1)<>"")or(Pfreq(i-1)>=AmMIN))then
Pwait=1
DirtyPresets=1
endif
Pname(i-1)=""
Pfreq(i-1)=0
Pid(i-1)=-1
Pcomp(i-1)=-1
Pcap(i-1)=-1
Pbw(i-1)=BWdef
Pflags(i-1)=0
FetchPresetDetails
case Eindex
FetchPresetDetails
case Eantcap
i=CtrlVal(Eindex)
Pcap(i-1)=CtrlVal(Eantcap)
Pwait=1
case Ebandwidth
i=CtrlVal(Eindex)
Pbw(i-1)=CtrlVal(Ebandwidth)
if(Frequency=Pfreq(i-1))then
State=50
endif
NewFrequency=Pfreq(i-1)
AntCap=-1
Pwait=1
case Efav
i=CtrlVal(Eindex)
Pflags(i-1)=Pflags(i-1)and &HFB
if(CtrlVal(Efav)<>0)then Pflags(i-1)=Pflags(i-1)or 4
Pwait=1
case Eactive
i=CtrlVal(Eindex)
Pflags(i-1)=(Pflags(i-1)and &HFE)or(CtrlVal(Eactive)and 1)
Pwait=1
case is >=Rad1
i=ButtonDn-Rad1
if(PbPrev=i)then
if(D>0)then print"Previous preset screen"
ClearGuiPresets
Pfirst=Pprev
SetupGuiPresets
ExitTimer=2000
elseif(PbNext=i)then
if(D>0)then print"Next preset screen"
ClearGuiPresets
Pfirst=Pnext
SetupGuiPresets
ExitTimer=2000
elseif(PbCan=i)then
if(D>0)then print"Cancel preset screen"
ProcessExitTimer
else
i=i+Pfirst
if(D>0)then print"Choosing preset: Name=" Pname(i)" Freq=" Pfreq(i)
NewFrequency=Pfreq(i)
NewServiceID=Pid(i)
NewCompID=Pcomp(i)
AntCap=Pcap(i)
CtrlVal(Ebandwidth)=Pbw(i)
Dwait=1
ExitTimer=300
endif
end select
ButtonDn=0
end sub
sub ProcessButtonUp
local integer i
if(D>0)then print"Button Up:" ButtonUp
GuiCounter=0
select case ButtonUp
case Ename
i=CtrlVal(Eindex)
if(i>NumPresets)then NumPresets=i
if(Pname(i-1)<>CtrlVal(Ename))then
Pname(i-1)=left$(CtrlVal(Ename),NameLen)
Pwait=1
endif
if(CtrlVal(Ename)<>"")then
Pflags(i-1)=Pflags(i-1)or 2
else
Pflags(i-1)=Pflags(i-1)and 5
endif
if(D>1)then print"Name change:" CtrlVal(Ename)" index:" i
DirtyPresets=1
case Efreq
i=CtrlVal(Eindex)
if(i>NumPresets)then NumPresets=i
if(Pfreq(i-1)<>CtrlVal(Efreq))then
Pfreq(i-1)=CtrlVal(Efreq)
if((Pflags(i-1)and 1)=0)then Pflags(i-1)=Pflags(i-1)or 1
FetchPresetDetails
if(CtrlVal(Eband)<>"--")then Pwait=1
endif
if(D>1)then print"Freq change:" CtrlVal(Efreq)" index:" i
DirtyPresets=1
case Eindex
FetchPresetDetails
case else
if(ButtonUp<>BDvalue)then
ButtonDn=ButtonUp
if(D>0)then print"Button down interrupt missed? " ButtonUp
ProcessButtonDown
endif
end select
ButtonUp=0
BDvalue=0
end sub
function ValidFreq(f as integer)as integer
if(((f>=AmMIN)and(f<=AmMAX))or((f>=FmMIN)and(f<=FmMAX))or((f>=DabMIN)and(f<=DabMAX)))then
ValidFreq=1
else
ValidFreq=0
endif
end function
function MatchName(freq as integer,defname as string,sid as integer,cid as integer,SetAntcap as integer)as string
local integer i,kludge
for i=0 to(NumPresets-1)
if((sid>=0)and(sid<>Pid(i)))then continue for
if((cid>=0)and(cid<>Pcomp(i)))then continue for
if(Pfreq(i)=freq)then exit for
next
kludge=1
if(i<NumPresets)then
kludge=(sid<>Pid(i))or(cid<>Pcomp(i))
endif
if((defname="")or((freq>=DabMIN)and(kludge>0)))then
MatchName=str$(freq)+" kHz"
else
MatchName=defname
endif
if(i<NumPresets)then
if(((Pflags(i)and 2)=0)and(len(defname)>len(Pname(i)))and(right$(defname,3)<>"kHz"))then
Pname(i)=defname
Pwait=1
endif
if(((Pflags(i)and 2)=0)and(right$(Pname(i),3)="kHz")and(defname<>"")and(right$(defname,3)<>"kHz"))then
Pname(i)=defname
Pwait=1
endif
if((Pname(i)<>"")and((freq<=FmMAX)or((sid=Pid(i))and(cid=Pcomp(i)))))then MatchName=Pname(i)
if((SetAntcap<>0)and(Pcap(i)<>AntCap)and(AntCap=0))then
NewFrequency=Pfreq(i)
NewServiceID=Pid(i)
NewCompID=Pcomp(i)
AntCap=Pcap(i)
CtrlVal(Ebandwidth)=Pbw(i)
if(D>1)then print"Retuning because antcap has changed"
endif
elseif((ValidFreq(freq)<>0)and(defname<>"")and(right$(defname,3)<>"kHz")and(NumPresets<MAX_PRESETS))then
Pfreq(NumPresets)=freq
Pname(NumPresets)=defname
Pid(NumPresets)=sid
Pcomp(NumPresets)=cid
Pcap(NumPresets)=0
Pbw(NumPresets)=-1
Pflags(NumPresets)=1
NumPresets=NumPresets+1
Pwait=1
endif
end function
sub DispIRnum
local integer f=0,p=0
local string s=""
if((IRnum>0)and(IRnum<=NumFavs))then
f=Pfreq(Pfav(IRnum-1))
s="Fav "+str$(IRnum)+"="
if(Pname(Pfav(IRnum-1))<>"")then
s=s+chr$(39)+Pname(Pfav(IRnum-1))+chr$(39)
else
s=s+str$(f)+" kHz"
if((f>=DabMIN)and(f<=DabMAX))then s=s+"("+str$(Pid(Pfav(IRnum-1)))+"/"+str$(Pcomp(Pfav(IRnum-1)))+")"
endif
endif
if((IRnum>0)and(IRnum<=NumPresets))then
p=Pfreq(IRnum)
if(f>0)then s=s+", "
s=s+"Preset "+str$(IRnum)+"="
if(Pname(IRnum)<>"")then
s=s+chr$(39)+Pname(IRnum-1)+chr$(39)
else
s=s+str$(p)+" kHz"
if((p>=DabMIN)and(p<=DabMAX))then s=s+"("+str$(Pid(IRnum-1))+"/"+str$(Pcomp(IRnum-1))+")"
endif
endif
if((f<=0)and(p<=0))then s=MatchName(IRnum,"",-1,-1,0)
CtrlVal(RLN8)=s
if(f>0)then
CtrlVal(RLN9)="Press Ok to select preset or F for favourite"
elseif(p>0)then
CtrlVal(RLN9)="Press Ok to select preset"
else
CtrlVal(RLN9)="Press Ok or F to select frequency"
endif
end sub
sub ChooseNext(x as integer)
local integer i
if((IRnum<=0)or(IRnum>NumPresets))then
IRnum=NumPresets>>1
if(NumPresets>0)then
for i=0 to NumPresets-1
if((Frequency=Pfreq(i))and((Frequency<DabMIN)or((ServiceID=Pid(i))and(CompID=Pcomp(i)))))then exit for
next
if(i<NumPresets)then IRnum=i+1
endif
endif
IRnum=IRnum+x
if(IRnum>NumPresets)then IRnum=1
if(IRnum<=0)then IRnum=NumPresets
DispIRnum
end sub
const Ivolup=0,Ivoldn=1,Imute=2,Ichanup=3,Ichandn=4,Iscanup=5,Iscandn=6
const Iam=7,Ifm=8,Idab=9,I0=10,I1=11,I2=12,I3=13,I4=14,I5=15,I6=16,I7=17
const I8=18,I9=19,Iok=20,IF0=21,IF1=22,IF2=23,IF3=24,IF4=25,IF5=26,Ifavourite=27
const Icancel=28,Ialtcancel=29,Ibackspace=30,I_NUM=31
dim integer Idev(I_NUM-1),Icmd(I_NUM-1)
sub ReadIRCodesFile
local integer i
S2="InfraRed.csv"
on error ignore
Open S2 for input As 1
if(MM.Errno<>0)then
WriteErr "SD card or open IR err"
else
WriteMsg("Reading "+S2)
S1=""
Do While((Not Eof(1))and(mid$(S1,2,6)<>"Label"))
Input #1,S1,S2,S3
if(MM.Errno<>0)then
WriteErr("Read error prior to IR data")
exit do
endif
loop
if(MM.Errno=0)then
for i=0 to(I_NUM-1)
Input #1,S1,S2,S3
if(MM.Errno<>0)then
WriteErr("IR read error at button "+str$(i+1))
exit for
endif
Idev(i)=val(S2)
Icmd(i)=val(S3)
if(D>0)then print str$(i+1)": Device Code=" S2 ", Cmd=" S3
next
endif
endif
Close 1
on error abort
end sub
sub ProcessIR
local integer n=0
if(CapSearch>0)then
n=-2
elseif((IrDev=Idev(Ivolup))and(IrButton=Icmd(Ivolup)))then
if(AudioOutMode=AUDIO_SPKR)then
if(CtrlVal(BVolume)<63)then
CtrlVal(BVolume)=CtrlVal(BVolume)+1
State=452
endif
else
n=-2
endif
elseif((IrDev=Idev(Ivoldn))and(IrButton=Icmd(Ivoldn)))then
if(AudioOutMode=AUDIO_SPKR)then
if(CtrlVal(BVolume)>0)then
CtrlVal(BVolume)=CtrlVal(BVolume)-1
State=452
endif
else
n=-2
endif
elseif((IrDev=Idev(Imute))and(IrButton=Icmd(Imute)))then
ButtonDn=BMute
elseif((IrDev=Idev(Ichanup))and(IrButton=Icmd(Ichanup)))then
ChooseNext(1)
elseif((IrDev=Idev(Ichandn))and(IrButton=Icmd(Ichandn)))then
ChooseNext(-1)
elseif((IrDev=Idev(Iscanup))and(IrButton=Icmd(Iscanup)))then
ButtonDn=BSeekUp
elseif((IrDev=Idev(Iscandn))and(IrButton=Icmd(Iscandn)))then
ButtonDn=BSeekDn
elseif((IrDev=Idev(Iam))and(IrButton=Icmd(Iam)))then
ButtonDn=Ram
elseif((IrDev=Idev(Ifm))and(IrButton=Icmd(Ifm)))then
ButtonDn=Rfm
elseif((IrDev=Idev(Idab))and(IrButton=Icmd(Idab)))then
ButtonDn=Rdab
elseif((IrDev=Idev(I0))and(IrButton=Icmd(I0)))then
n=0
goto NEXT_IR_NUM
elseif((IrDev=Idev(I1))and(IrButton=Icmd(I1)))then
n=1
goto NEXT_IR_NUM
elseif((IrDev=Idev(I2))and(IrButton=Icmd(I2)))then
n=2
goto NEXT_IR_NUM
elseif((IrDev=Idev(I3))and(IrButton=Icmd(I3)))then
n=3
goto NEXT_IR_NUM
elseif((IrDev=Idev(I4))and(IrButton=Icmd(I4)))then
n=4
goto NEXT_IR_NUM
elseif((IrDev=Idev(I5))and(IrButton=Icmd(I5)))then
n=5
goto NEXT_IR_NUM
elseif((IrDev=Idev(I6))and(IrButton=Icmd(I6)))then
n=6
goto NEXT_IR_NUM
elseif((IrDev=Idev(I7))and(IrButton=Icmd(I7)))then
n=7
goto NEXT_IR_NUM
elseif((IrDev=Idev(I8))and(IrButton=Icmd(I8)))then
n=8
goto NEXT_IR_NUM
elseif((IrDev=Idev(I9))and(IrButton=Icmd(I9)))then
n=9
NEXT_IR_NUM:
if(IRnum<0)then IRnum=0
IRnum=(IRnum*10)+n
DispIRnum
n=1
elseif((IrDev=Idev(Ibackspace))and(IrButton=Icmd(Ibackspace))and(IRnum>=0))then
IRnum=int(IRnum/10)
DispIRnum
n=1
elseif((IrDev=Idev(IF0))and(IrButton=Icmd(IF0))and(NumFavs>0))then
n=0
goto IR_FAV
elseif((IrDev=Idev(IF1))and(IrButton=Icmd(IF1))and(NumFavs>1))then
n=1
goto IR_FAV
elseif((IrDev=Idev(IF2))and(IrButton=Icmd(IF2))and(NumFavs>2))then
n=2
goto IR_FAV
elseif((IrDev=Idev(IF3))and(IrButton=Icmd(IF3))and(NumFavs>3))then
n=3
goto IR_FAV
elseif((IrDev=Idev(IF4))and(IrButton=Icmd(IF4))and(NumFavs>4))then
n=4
goto IR_FAV
elseif((IrDev=Idev(IF5))and(IrButton=Icmd(IF5))and(NumFavs>5))then
n=5
IR_FAV:
if(D>0)then print"IR favourite selected: " n+1
NewFrequency=Pfreq(Pfav(n))
NewServiceID=Pid(Pfav(n))
NewCompID=Pcomp(Pfav(n))
AntCap=Pcap(Pfav(n))
CtrlVal(Ebandwidth)=Pbw(Pfav(n))
n=0
goto IR_CANCEL
elseif((IrDev=Idev(Ifavourite))and(IrButton=Icmd(Ifavourite)))then
if((IRnum<=0)or(IRnum>NumFavs))then goto IR_FREQUENCY
if(D>0)then print"IR favourite selected: " IRnum ", " Pname(Pfav(IRnum-1))
NewFrequency=Pfreq(Pfav(IRnum-1))
NewServiceID=Pid(Pfav(IRnum-1))
NewCompID=Pcomp(Pfav(IRnum-1))
AntCap=Pcap(Pfav(IRnum-1))
CtrlVal(Ebandwidth)=Pbw(Pfav(IRnum-1))
n=0
goto IR_CANCEL
elseif((IrDev=Idev(Iok))and(IrButton=Icmd(Iok)))then
IR_FREQUENCY:
if((IRnum>0)and(IRnum<=NumPresets))then
if(D>0)then print"IR preset selected: " IRnum ", " Pname(IRnum-1)
NewFrequency=Pfreq(IRnum-1)
NewServiceID=Pid(IRnum-1)
NewCompID=Pcomp(IRnum-1)
AntCap=Pcap(IRnum-1)
CtrlVal(Ebandwidth)=Pbw(IRnum-1)
n=0
elseif(ValidFreq(IRnum)<>0)then
NewFrequency=IRnum
else
n=-1
endif
goto IR_CANCEL
elseif(((IrDev=Idev(Icancel))and(IrButton=Icmd(Icancel)))or((IrDev=Idev(Ialtcancel))and(IrButton=Icmd(Ialtcancel))))then
n=0
IR_CANCEL:
CtrlVal(RLN8)=""
CtrlVal(RLN9)=""
IRnum=-1
IRwait=-1
else
n=-2
endif
if(IrBuzz>0)then
if(n>=0)then
gui beep 50
elseif(n=-1)then
gui beep 700
elseif(n=-2)then
gui beep 150
endif
endif
if(IrLed>0)then pulse P_IR_ACK_LED,20
pulse P_LED_YELLOW,20
IrDev=0
IrButton=0
IRwait=0
end sub
dim integer Dvolume=20,Dbacklight=50,Daudio=AUDIO_DIG,Dswap=0,Dgui=0
sub SetDefaultValues
CtrlVal(BVolume)=Dvolume
CtrlVal(BLight)=Dbacklight
Backlight Dbacklight
CtrlVal(Sswap)=Dswap
CtrlVal(Sgui)=Dgui
if(Daudio=AUDIO_DIG)then CtrlVal(Rdigital)=1 else CtrlVal(Rdigital)=0
if(Daudio=AUDIO_RCA)then CtrlVal(Rrca)=1 else CtrlVal(Rrca)=0
if(Daudio=AUDIO_SPKR)then CtrlVal(Rspeaker)=1 else CtrlVal(Rspeaker)=0
if(AudioOutMode<>Daudio)then AudioOutMode=-1
DefineTouch(CtrlVal(Sgui))
WriteMsg("Vol="+str$(Dvolume)+", BackLight="+str$(Dbacklight)+", Audio Output Mode="+str$(Daudio))
WriteMsg("Swap="+str$(Dswap)+", Fav On Status Screen="+str$(Dgui))
WriteMsg("Frequency="+str$(NewFrequency)+", Service="+str$(NewServiceID)+", Component="+str$(NewCompID))
end sub
sub ReadDefaultFile
local integer i
on error ignore
S1=dir$("Config?.csv",FILE)
if(S1<>"")then
for i=0 to 9
S2="Config"+str$(i)+".csv"
Open S2 for input As 1
if(MM.Errno<>0)then
WriteErr("File open error "+S2)
continue for
endif
WriteMsg("Reading "+S2)
S1=""
Do While((Not Eof(1))and(left$(S1,5)<>"Don"+chr$(39)+"t"))
Input #1,S1
if(MM.Errno<>0)then
WriteErr("Read error prior to first record")
exit do
endif
loop
if(MM.Errno<>0)then
Close 1
WriteErr("Read error "+S2)
continue for
else
Input #1,S1,Dvolume
if((Dvolume<0)or(Dvolume>63))then Dvolume=20
Input #1,S1,Dbacklight
if((Dbacklight<10)or(Dbacklight>100))then Dbacklight=50
Input #1,S1,Daudio
if((Daudio<AUDIO_DIG)or(Daudio>AUDIO_SPKR))then Daudio=AUDIO_DIG
if((WM8804=0)and(Daudio=AUDIO_DIG))then Daudio=AUDIO_SPKR
Input #1,S1,NewFrequency
if(ValidFreq(NewFrequency))=0)then NewFrequency=DefaultChannel
Input #1,S1,NewServiceID
Input #1,S1,NewCompID
if(NewFrequency<DabMIN)then
NewServiceID=-1
NewCompID=-1
endif
Input #1,S1,Dswap
if((Dswap<0)or(Dswap>1))then Dswap=0
Input #1,S1,Dgui
if((Dgui<0)or(Dgui>1))then Dgui=0
if(MM.Errno<>0)then
Close 1
WriteErr("Unintelligible defaults "+S2)
continue for
endif
Close 1
SetDefaultValues
if(i<>0)then
Frequency=NewFrequency
ServiceID=NewServiceID
CompID=NewCompID
WriteDefaultFile
Frequency=Frequency+1
endif
on error abort
exit sub
endif
Close 1
next
endif
on error abort
SetDefaultValues
AudioOutMode=AUDIO_SPKR
NewFrequency=DefaultChannel
Dwait=DEFAULT_WAIT_TIME*0.9
end sub
sub WriteDefaultFile
local integer audio_out,sid,cid
audio_out=AUDIO_RCA
if(CtrlVal(Rdigital)<>0)then audio_out=AUDIO_DIG
if(CtrlVal(Rspeaker)<>0)then audio_out=AUDIO_SPKR
sid=ServiceID
cid=CompID
if((sid<0)or(cid<0))then
sid=NewServiceID
cid=NewCompID
endif
if(RotateAndOpen("Config",".csv",1)=1)then
on error ignore
print #1,chr$(34)"Don" chr$(39)"t change the order of the following rows" chr$(34)
print #1,chr$(34)"Volume" chr$(34)"," CtrlVal(BVolume)
print #1,chr$(34)"BackLight" chr$(34)"," CtrlVal(BLight)
print #1,chr$(34)"0=Dig 1=RCA 2=Spkr" chr$(34)"," audio_out
print #1,chr$(34)"Frequency(kHz)" chr$(34)"," Frequency
print #1,chr$(34)"DAB Service ID" chr$(34)"," sid
print #1,chr$(34)"DAB Component ID" chr$(34)"," cid
print #1,chr$(34)"Swap Left-Right" chr$(34)"," CtrlVal(Sswap)
print #1,chr$(34)"Show Fav Buttons" chr$(34)"," CtrlVal(Sgui)
Close 1
on error abort
if(D>0)then
print"Wrote config file:"
print"  Volume=" CtrlVal(BVolume)
print"  Backlight=" CtrlVal(BLight)
print"  Audio output mode=" audio_out
print"  Frequency=" Frequency
print"  Service ID=" sid
print"  Component ID=" cid
print"  Swap analogue outputs=" CtrlVal(Sswap)
print"  Display Favourite Buttons=" CtrlVal(Sgui)
endif
endif
Dwait=0
end sub
dim integer pf,px,pc,pa,plen
function compare(a as integer)as integer
local integer r=-1
if((Pfreq(a)<AmMIN)and(pf>=AmMIN))then
compare=1
exit function
endif
if((pf<AmMIN)and(Pfreq(a)>=AmMIN))then
compare=-1
exit function
endif
if((pf<AmMIN)and(Pfreq(a)<AmMIN))then
compare=0
exit function
endif
if(Pfreq(a)<pf)then goto rec_before_piv
if(Pfreq(a)>pf)then goto rec_after_piv
if((pf>=DabMIN)and(pf<=DabMAX))then
if(Pid(a)<px)then goto rec_before_piv
if(Pid(a)>px)then goto rec_after_piv
if(Pcomp(a)<pc)then goto rec_before_piv
if(Pcomp(a)>pc)then goto rec_after_piv
endif
if(len(Pname(a))<plen)then goto rec_before_piv
if(len(Pname(a))>plen)then goto rec_after_piv
r=0
goto rec_before_piv
rec_after_piv:
r=1
rec_before_piv:
if((Pflags(a)and 1)>pa))then
r=-1
elseif((Pflags(a)and 1)<pa))then
r=1
endif
compare=r
end function
sub quicksort(lower as integer,upper as integer)
local integer i,j,k,pivot
local string s
i=lower
j=upper
k=(lower+upper)>>1
pf=Pfreq(k)
px=Pid(k)
pc=Pcomp(k)
pa=Pflags(k)and 1
plen=len(Pname(k))
do while(i<=j)
do while(compare(i)<0)
i=i+1
loop
do while(compare(j)>0)
j=j-1
loop
if(i<j)then
k=Pfreq(i)
Pfreq(i)=Pfreq(j)
Pfreq(j)=k
k=Pid(i)
Pid(i)=Pid(j)
Pid(j)=k
k=Pcomp(i)
Pcomp(i)=Pcomp(j)
Pcomp(j)=k
k=Pflags(i)
Pflags(i)=Pflags(j)
Pflags(j)=k
k=Pcap(i)
Pcap(i)=Pcap(j)
Pcap(j)=k
k=Pbw(i)
Pbw(i)=Pbw(j)
Pbw(j)=k
s=Pname(i)
Pname(i)=Pname(j)
Pname(j)=s
endif
if(i<=j)then
i=i+1
j=j-1
endif
loop
if(lower<j)then quicksort(lower,j)
if(i<upper)then quicksort(i,upper)
end sub
sub PrintPreset(n as integer)
print n+1 ": Freq=" Pfreq(n)" Name=" chr$(39)Pname(n)chr$(39)" ID=" Pid(n)" Comp=" Pcomp(n);
print" AntCap=" Pcap(n)" Flags=" Pflags(n)" BW=" Pbw(n)
end sub
sub CompactPresets
local integer i,j,diff
if((NumPresets<2)or(DirtyPresets=0))then exit sub
if(D>0)then print"Sorting Presets"
quicksort(0,NumPresets-1)
DirtyPresets=0
if(D>0)then
print"Sorted..."
for j=0 to(NumPresets-1)
PrintPreset(j)
next
endif
NumActivePresets=0
i=0
for j=1 to(NumPresets-1)
if((Pfreq(j)<AmMIN)or(Pfreq(j)>DabMAX))then continue for
diff=0
if(Pfreq(i)<>Pfreq(j))then diff=1
if((diff=0)and(Pfreq(i)>=DabMIN)and((Pid(i)<>Pid(j))or(Pcomp(i)<>Pcomp(j))))then diff=1
if(diff<>0)then
i=i+1
if(i<j)then
Pfreq(i)=Pfreq(j)
Pid(i)=Pid(j)
Pcomp(i)=Pcomp(j)
Pcap(i)=Pcap(j)
Pbw(i)=Pbw(j)
Pflags(i)=Pflags(j)
Pname(i)=Pname(j)
endif
if((Pflags(i)and 1)<>0)then NumActivePresets=i+1
else
if(D>0)then
print"Record " j " is the same as record at " i ". Deleting " j
print" Keeping " Pfreq(i)", " Pname(i)", " Pflags(i)
print" Discarding " Pfreq(j)", " Pname(j)", " Pflags(j)
endif
if((Pflags(i)and 1)=0)then Pflags(i)=Pflags(i)or(Pflags(j)and 1)
if((Pflags(i)and 4)=0)then Pflags(i)=Pflags(i)or(Pflags(j)and 4)
if(Pname(i)="")then
Pname(i)=Pname(j)
Pflags(i)=Pflags(i)or(Pflags(j)and 2)
elseif(((Pflags(i)and 2)=0)and((Pflags(j)and 2)<>0))then
Pname(i)=Pname(j)
Pflags(i)=Pflags(i)or 2
endif
Pwait=DEFAULT_WAIT_TIME*.8
endif
next
NumPresets=i+1
for i=NumPresets to MAX_PRESETS-1
Pname(i)=""
Pfreq(i)=0
Pid(i)=-1
Pcomp(i)=-1
Pcap(i)=0
Pbw(i)=-1
Pflags(i)=0
next
if(D>1)then print"Compacted. #Presets=" NumPresets ", #Active Presets=" NumActivePresets : print
end sub
sub WritePresetFile
local integer i,bw,ac,id,comp
CompactPresets
if(RotateAndOpen("Preset",".csv",1)=1)then
on error ignore
print #1,"Band,Frequency(kHz),Station Name,DAB Service ID,DAB Component ID,AntCap,Bit2=Favourite|Bit1=Manually Specified Name|Bit0=Preset Active,AM Audio Bandwidth(Hz)"
for i=0 to NumPresets-1
bw=0
ac=0
id=-1
comp=-1
if((Pfreq(i)>=AmMIN)and(Pfreq(i)<=AmMAX))then
S1="AM,"
bw=Pbw(i)
elseif((Pfreq(i)>=FmMIN)and(Pfreq(i)<=FmMAX))then
S1="FM,"
ac=Pcap(i)
elseif((Pfreq(i)>=DabMIN)and(Pfreq(i)<=DabMAX))then
S1="DAB,"
ac=Pcap(i)
id=Pid(i)
comp=Pcomp(i)
else
continue for
endif
S1=S1+str$(Pfreq(i))+","+chr$(34)+Pname(i)+chr$(34)
S1=S1+","+str$(id)+","+str$(comp)+","+str$(ac)
S1=S1+","+str$(Pflags(i))+","+str$(bw)
print #1,S1
if(D>0)then PrintPreset(i)
next
Close 1
on error abort
WriteMsg("Wrote Preset0.csv")
endif
Pwait=0
end sub
sub SetFavs
local integer i
NumFavs=0
for i=0 to(NumPresets-1)
if((NumFavs<MAX_FAVS)and((Pflags(i)and 4)<>0))then
Pfav(NumFavs)=i
NumFavs=NumFavs+1
endif
next
end sub
sub ReadPresetFile
local integer i
if(Pwait>0)then WritePresetFile
NumPresets=0
on error ignore
S1=dir$("Preset?.csv",FILE)
if(S1<>"")then
for i=0 to 9
NumPresets=0
S2="Preset"+str$(i)+".csv"
Open S2 for input As 1
if(MM.Errno<>0)then
WriteErr("Open error "+S2)
continue for
endif
WriteMsg("Reading "+S2)
Input #1,S1
if(MM.Errno<>0)then
Close 1
WriteErr("Read error "+S2)
continue for
endif
Do While((Not Eof(1))and(NumPresets<MAX_PRESETS))
Input #1,S1,Pfreq(NumPresets),S3,Pid(NumPresets),Pcomp(NumPresets),Pcap(NumPresets),Pflags(NumPresets),Pbw(NumPresets)
if(S1="")then exit do
if(ValidFreq(Pfreq(NumPresets))=0)then
WriteMsg(S2+" entry "+str$(NumPresets+1)+" "+S3+" BadFreq="+str$(Pfreq(NumPresets)))
continue do
endif
if(Pfreq(NumPresets)>AmMAX)then
Pbw(NumPresets)=-1
elseif(Pbw(NumPresets)<BWmin)or(Pbw(NumPresets)>BWmax))then
Pbw(NumPresets)=BWdef
endif
Pname(NumPresets)=left$(S3,NameLen)
Pflags(NumPresets)=Pflags(NumPresets)and 7
if(D>0)then PrintPreset(NumPresets)
NumPresets=NumPresets+1
Loop
Close 1
WriteMsg("(Read "+str$(NumPresets)+" presets)")
if(NumPresets>0)then
if(i>0)then WritePresetFile
exit for
endif
next
endif
on error abort
end sub
dim integer SpiBuf(READ_REPLY_BUFSIZE)
sub Read_Radio_Reply(len as integer)
if(len>READ_REPLY_BUFSIZE)then len=READ_REPLY_BUFSIZE
pin(P_SI4689_CS)=0
spi write 1,0
Pause .1
spi read len,SpiBuf()
pin(P_SI4689_CS)=1
end sub
sub Issue_LOAD_INIT
pin(P_SI4689_CS)=0
spi write 2,&H06,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*06,00 Load Init"
end sub
sub SetProperty(mp AS integer,lp AS integer,mv AS integer,lv AS integer)
pin(P_SI4689_CS)=0
spi write 6,&H13,&H00,lp,mp,lv,mv
pin(P_SI4689_CS)=1
if(D>2)then print"*13,00 Property " hex$(mp,2)hex$(lp,2)"=" hex$(mv,2)hex$(lv,2)
CTSwait=9
SpiWait=1
end sub
sub SetRadioMute
local integer m=0
if(Muted<>0)then m=3
SetProperty(&h03,&h01,0,m)
end sub
function CleanChr(c as integer)as string
if((c<32)or(c>127))then
CleanChr=" "
else
CleanChr=chr$(c)
endif
end function
function TruncStr(s as string)as string
local integer i,n,f,l
TruncStr=s
n=len(s)
if(n=0)then exit function
f=0
l=0
for i=1 to n
if(mid$(s,i,1)<>" ")then
if(f=0)then f=i
l=i
endif
next
if(f=0)then
TruncStr=""
exit function
endif
TruncStr=mid$(s,f,l-f+1)
end function
function DispString(s as string,first as integer,last as integer,lx as integer,blank as integer)as integer
local integer i,j,l=first
local s3 as string
i=len(s)
if((D>0)and(i>0))then print"Displaying string:" s
do while((i>0)and(l<=last))
if(i<=lx)then
s3=""
else
for j=lx to 1 step-1
if(mid$(s,j,1)=" ")then exit for
next
if(j>1)then
s3=right$(s,i-j)
s=left$(s,j-1)
else
s3=right$(s,i-lx)
s=left$(s,lx)
endif
endif
if(CtrlVal(l)<>s)then CtrlVal(l)=s
s=s3
i=len(s)
l=l+1
loop
DispString=l
if(blank<>0)then
do while(l<=last)
CtrlVal(l)=""
l=l+1
loop
endif
end function
sub TryToDispRDS(blank as integer)
local integer n
S1=""
S2=""
for n=0 to 15
S1=S1+ProgData(n)
S2=S2+ProgData(16+n)
if(blank<>0)then ProgData(blank-1+n)=""
next
if(len(S1)=64)then S1=TruncStr(S1)else S1=""
if(len(S2)=64)then S2=TruncStr(S2)else S2=""
if((S1="")and(S2=""))then exit sub
if(S1="")then
n=DispString(S2,RLN4,RLN7,50,1)
exit sub
endif
if((S2<>"")and(S1<>S2))then S1=S1+"/"+S2
n=DispString(S1,RLN4,RLN7,50,1)
end sub
sub AppendErrFile(err as string)
S2=err+","+str$(State)+","+hex$(SpiBuf(0),2)+hex$(SpiBuf(1),2)+hex$(SpiBuf(3),2)
WriteErr(S2)
on error ignore
open "Error0.csv" for append as #1
print #1,DATE$ "," TIME$ "," str$(UpTime/200,0,1)"," S2 "," str$(Frequency)"," hex$(ServiceID)"," hex$(CompID)
close #1
on error abort
end sub
function Conv8bitSignedInt(x as integer)as integer
if(x>127)then
Conv8bitSignedInt=x-256
else
Conv8bitSignedInt=x
endif
end function
function ChooseAudioOutMode(x as integer)as integer
if((pin(P_HEADPHONE)=0)or(CtrlVal(Rspeaker)<>0))then
ChooseAudioOutMode=AUDIO_SPKR
elseif((WM8804>0)and(CtrlVal(Rdigital)<>0))then
ChooseAudioOutMode=AUDIO_DIG
else
ChooseAudioOutMode=AUDIO_RCA
endif
end function
dim integer State=1,Rstate=Runtuned,Address,Reply_Size=4,StatusBits=0,AntCap=0
dim integer ReadAntCap,Radio_Running=-1,NewStatus=0,ExpectTune=0,NumProp
dim integer PropID,IntMask=0,CTSwait=0,LastDabServList=-1,AudioOut=0
dim integer DabServiceID(MAX_DAB_SERVICES-1),DabComponentID(MAX_DAB_SERVICES-1)
dim integer ReadFreq,SNR,CNR,M,FibErr,Quality,SigStrength,FreqOffset,Stereo
dim integer NumServices,Min_SNR,Min_SigStren,DispRefresh=0
dim string Status length 11,Band length 3,DabServiceName(MAX_DAB_SERVICES-1)length NameLen
dim float SigLevel,maSNR,maCNR,maSig,maQual
Band=""
function AddPreset(freq as integer,defname as string,sid as integer,cid as integer,ac as integer)as integer
local integer i,j
AddPreset=0
for i=0 to(NumPresets-1)
if((sid<>Pid(i))and(Pid(i)>=0))then continue for
if((cid<>Pcomp(i))and(Pcomp(i)>=0))then continue for
if(Pfreq(i)=freq)then exit for
next
if(i<NumPresets)then
if(ac=0)then
for j=0 to(NumPresets-1)
if((Pfreq(j)=freq)and(Pcap(j)>0))then
ac=Pcap(j)
exit for
endif
next
endif
if((Pid(i)<>sid)or(Pcomp(i)<>cid))then
Pid(i)=sid
Pcomp(i)=cid
Pname(i)=""
AddPreset=1
endif
if((Pname(i)="")and(defname<>""))then
Pname(i)=defname
AddPreset=1
endif
if(Pcap(i)<>ac)then
Pcap(i)=ac
AddPreset=1
endif
if(AddPreset>0)then
Pwait=1
Pflags(i)=1
DirtyPresets=1
endif
exit function
endif
if(NumPresets>=MAX_PRESETS)then
WriteErr("Preset Table Full")
exit function
endif
Pname(i)=defname
Pfreq(i)=freq
Pid(i)=sid
Pcomp(i)=cid
Pcap(i)=ac
Pbw(i)=BWdef
Pflags(i)=1
NumPresets=NumPresets+1
AddPreset=1
end function
Sub CheckSpi
local integer next_state,i,a,b,c,e,n,id,comp
static integer IntState=0
SpiWait=0
if(ValidFreq(NewFrequency))then
i=RadioMode
if(NewFrequency<=AmMAX)then
i=MODE_AM
Min_SNR=AmSNR
Min_SigStren=AmMinStren
ServiceID=-1
CompID=-1
NewServiceID=-1
NewCompID=-1
elseif((NewFrequency>=FmMIN)and(NewFrequency<=FmMAX))then
i=MODE_FM
Min_SNR=FmSNR
Min_SigStren=FmMinStren
ServiceID=-1
CompID=-1
NewServiceID=-1
NewCompID=-1
elseif((NewFrequency>=DabMIN)and(NewFrequency<=DabMAX))then
i=MODE_DAB
Min_SNR=DabCNR
Min_SigStren=DabMinStren
else
AppendErrFile("Reboot:Can"+chr$(39)+"t scan to freq "+str$(NewFrequency))
if(D=0)then
Reboot=1
else
Reboot=2000
endif
exit sub
endif
if((i>=0)and(i<>RadioMode))then
State=1
RadioMode=i
SetRadioModeColour
goto BLANKIT
elseif(State=0)then
State=300
ServiceID=-1
CompID=-1
LastDabServList=-1
BLANKIT:
ActiveProgData=-1
IntMask=0
Frequency=NewFrequency
NewFrequency=-1
Rstate=Runtuned
maSNR=-99
maCNR=-99
maSig=-1
maQual=-1
AudioOut=0
RdsNames=0
for n=0 to 3
ProgName(n)=""
next
for n=0 to 31
ProgData(n)=""
next
for n=0 to(MAX_SET-1)
RdsNameSet(n)=""
next
AntCap=0
for n=0 to(NumPresets-1)
if(Frequency=Pfreq(n))then
AntCap=Pcap(n)
exit for
endif
next
ClearStatus
if((NewServiceID>=0)and(SA<>0))then
ServiceID=NewServiceID
CompID=NewCompID
NewServiceID=-1
NewCompID=-1
endif
endif
endif
if((Radio_Running>0)and(SA=0))then
if(Reply_Size<4)THEN Reply_Size=4
Read_Radio_Reply(Reply_Size)
if((State<20)and(SpiBuf(0)=255))then
S1="SPI com err"
goto DO_REBOOT
endif
if((SpiBuf(0)and 64)<>0)then
if((Reboot<=0)and(D>0))then
S1="Non fatal:Cmd err"
if(Reply_Size<6)then Read_Radio_Reply(6)
S1=S1+"[4]="+hex$(SpiBuf(4),2)+" [5]="+hex$(SpiBuf(5),2)
AppendErrFile(S1)
endif
pin(P_SI4689_CS)=0
spi write 2,&H09,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*09,00 Get Sys State-clear error"
CTSwait=9
SpiWait=1
exit sub
endif
if((SpiBuf(3)and 63)<>0)then
S1="fatal err"
goto DO_REBOOT
endif
if(RadioMode=MODE_DAB)then
if((SpiBuf(0)and 16)<>0)then IntMask=IntMask or 1
if((SpiBuf(1)and 32)<>0)then IntMask=IntMask or 4
elseif(RadioMode=MODE_FM)then
if((SpiBuf(0)and 4)<>0)then IntMask=IntMask or 2
endif
if(IntMask<>0)then
if(D>0)then
print"Int:" State "," hex$(SpiBuf(0),2)hex$(SpiBuf(1),2)hex$(SpiBuf(3),2)
endif
IntState=60000
endif
endif
if((CTSwait>0)and(SA=0))then
if(((SpiBuf(0)and 128)=128)and((SpiBuf(0)and StatusBits)=StatusBits))then
CTSwait=0
StatusBits=0
else
CTSwait=CTSwait-1
if(CTSwait=0)then
S1="CTS timeout"
DO_REBOOT:
if(Reboot<=0)then
SetMux(1,-1)
ResetWM8804
AppendErrFile("Reboot:"+S1)
if(D=0)then
Reboot=1
else
Reboot=2000
endif
endif
endif
exit sub
endif
endif
if(State=0)then
if(IntState=0)then exit sub
State=IntState
endif
next_state=State+1
if(D>1)then print"State:" State " IntState:" IntState " IntMask:" hex$(IntMask,2)" Freq: " Frequency " SID: " ServiceID " NewSID: " NewServiceID
Reply_Size=4
select case State
case 1
SetMux(1,-1)
ResetWM8804
AudioOutMode=-1
pin(P_SI4689_CS)=1
pin(P_SI4689_RES)=1
case 2
pin(P_SI4689_RES)=0
case 3
pin(P_SI4689_RES)=1
case 4
pin(P_SI4689_CS)=0
spi write 16,&H01,&H00,&H17,&H20,&H00,&HF8,&H24,&H01,&H10,&H10,&H00,&H00,&H00,&H10,&H00,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*01,00,17,20,00,f8,24,01,10,10,00,00,00,10,00,00 Power Up"
Radio_Running=1
CTSwait=9
case 5
Issue_LOAD_INIT
WriteMsg("Loading bootloader")
CTSwait=9
case 6,7
Address=PEEK(CFUNADDR LOADERBIN)
if(State=6)then
a=0 : b=4092
else
a=4096 : b=5792
endif
pin(P_SI4689_CS)=0
spi write 4,&H04,&H00,&H00,&H00
if(D>2)then print"*04,00,00,00 Host Load"
FOR i=a TO b step 4
spi write 4,PEEK(BYTE i+Address),PEEK(BYTE i+Address+1),PEEK(BYTE i+Address+2),PEEK(BYTE i+Address+3)
next i
pin(P_SI4689_CS)=1
CTSwait=9
case 8
CTSwait=0
case 9
Issue_LOAD_INIT
pin(P_SI4689_CS)=0
spi write 4,&H05,&H00,&H00,&H00
if(RadioMode=MODE_AM)then
spi write 4,&H00,&HE0,&H11,&H00
Band="AM"
elseif(RadioMode=MODE_FM)then
spi write 4,&H00,&H60,&H00,&H00
Band="FM"
else
spi write 4,&H00,&H20,&H09,&H00
Band="DAB"
endif
spi write 4,&H00,&H00,&H00,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*05,00,00,00, ... Flash Load " Band
WriteMsg("Loading "+Band+" firmware")
CTSwait=100
case 10
pin(P_SI4689_CS)=0
spi write 2,&H07,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*07,00 Boot"
WriteMsg("Booting "+Band+" firmware")
CTSwait=60
case 11
InitWM8804
pin(P_WM8804_CSB)=0
spi write 1,&H80
spi read 1,SpiBuf()
pin(P_WM8804_CSB)=1
a=SpiBuf(0)<<8
pin(P_WM8804_CSB)=0
spi write 1,&H81
spi read 1,SpiBuf()
pin(P_WM8804_CSB)=1
a=a+SpiBuf(0)
if((a=1416)or(SA<>0))then
WM8804=1
WriteMsg("Found WM8804 device")
else
WM8804=0
WriteMsg("Failed to find WM8804 device")
if(D>0)then print"Read WM8804 DeviceID:" hex$(a,4)
if(SA=0)then gui hide Rdigital
endif
SetRadioMute
AudioOutMode=ChooseAudioOutMode(0)
if(RadioMode=MODE_AM)then
next_state=50
elseif(RadioMode=MODE_FM)then
next_state=100
else
next_state=200
endif
case 50
SetProperty(&h42,&h00,0,75)
case 51
SetProperty(&h42,&h01,0,8)
case 52
SetProperty(&h42,&h02,0,35)
case 53
SetProperty(&h42,&h03,0,SnrSettle)
case 54
SetProperty(&h42,&h04,0,AmSNR)
case 55
SetProperty(&h41,&h00,AmMIN>>8,AmMIN and 255)
case 56
SetProperty(&h41,&h01,AmMAX>>8,AmMAX and 255)
case 57
SetProperty(&h41,&h02,0,AmDELTA and 255)
case 58
SetProperty(&h22,&h00,29,15)
case 59
a=CtrlVal(Ebandwidth)/100
b=a>>1
if(b<(BWmin/100))then b=BWmin/100
SetProperty(&h22,&h01,a,b)
case 60
SetProperty(&h22,&h02,8,0)
case 61
SetProperty(&h22,&h03,0,16)
next_state=300
case 100
SetProperty(&h37,&h04,&h18,&h0f)
case 101
SetProperty(&h37,&h00,&h20,&h10)
case 102
SetProperty(&H17,&H10,FmSlope>>8,FmSlope and 255)
case 103
SetProperty(&H17,&H11,FmIntercept>>8,FmIntercept and 255)
case 104
SetProperty(&H17,&H12,&H00,FmSwitch)
case 105
i=FmMIN/10
SetProperty(&h31,&h00,i>>8,i and 255)
case 106
i=FmMAX/10
SetProperty(&h31,&h01,i>>8,i and 255)
case 107
SetProperty(&h31,&h02,0,(FmDELTA\10)and 255)
case 108
SetProperty(&h32,&h01,0,114)
case 109
SetProperty(&h32,&h01,0,25)
case 110
SetProperty(&h32,&h02,0,17)
case 111
SetProperty(&h32,&h03,0,SnrSettle)
case 112
SetProperty(&h32,&h04,0,FmSNR)
case 113
if(CapSearch>0)then goto RETRY_TUNE
SetProperty(&h3c,&h00,&h00,&h01)
case 114
SetProperty(&h3c,&h01,&h00,8)
case 115
SetProperty(&h3c,&h02,&h00,&h01)
next_state=300
case 200
SetProperty(&H17,&H10,DabSlope>>8,DabSlope and 255)
case 201
SetProperty(&H17,&H11,DabIntercept>>8,DabIntercept and 255)
case 202
SetProperty(&H17,&H12,&H00,DabSwitch)
case 203
SetProperty(&HB4,&H00,&H00,&H05)
case 204
SetProperty(&hB2,&h00,0,200)
case 205
SetProperty(&hB2,&h01,0,30)
case 206
SetProperty(&hB2,&h02,7,255)
case 207
SetProperty(&hB2,&h03,5,0)
case 208
SetProperty(&hB2,&h04,0,70)
case 209
if(CapSearch>0)then goto PARSE_DAB_TABLE
SetProperty(&hB3,&h00,0,&H01)
case 210
SetProperty(&h81,&h00,0,1)
case 211
SetProperty(&h81,&h01,8,0)
case 212
SetProperty(&hB3,&h01,0,15)
case 213
SetProperty(&hB3,&h02,0,5)
case 214
SetProperty(&hB5,&h01,0,30)
case 215
SetProperty(&hB5,&h07,&he2,&hc4)
case 216
i=&h100
SetProperty(&hB5,&h08,i>>8,i and 255)
case 217
PARSE_DAB_TABLE:
pin(P_SI4689_CS)=0
spi write 2,&HB9,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*B9,00 DAB get freq list"
Reply_Size=5
CTSwait=9
SpiWait=1
case 218
NumDabFreqs=SpiBuf(4)
if(NumDabFreqs>MAX_DAB_FREQS)then
if(D>0)then print"Limiting NumDabFreqs from:" NumDabFreqs
NumDabFreqs=MAX_DAB_FREQS
endif
Read_Radio_Reply(8+(NumDabFreqs<<2))
for i=0 to(NumDabFreqs-1)
a=8+(i<<2)
DabFreqs(i)=(SpiBuf(a+2)<<16)+(SpiBuf(a+1)<<8)+SpiBuf(a)
if(D>1)then print"DAB Frequency[" i "]=" DabFreqs(i)
next
if(D>1)then print"Num DAB frequencies:" NumDabFreqs
next_state=300
case 300
RETRY_TUNE: next_state=301
i=1
if(AudioOutMode=AUDIO_DIG)then i=2
if(i=AudioOut)then goto DOTUNE
AudioOut=i
SetProperty(&h08,&h00,&h80,i)
case 301
DOTUNE:
SetMux(1,-1)
SetRadioMute
next_state=302
case 302
pin(P_SI4689_CS)=0
if(RadioMode=MODE_AM)then
spi write 6,&H40,&H00,Frequency and 255,Frequency>>8,AntCap and 255,AntCap>>8
if(D>2)then print"*40,00," Frequency "," AntCap " AM tune"
elseif(RadioMode=MODE_FM)then
i=Frequency/10
spi write 6,&H30,&H00,i and 255,i>>8,AntCap and 255,AntCap>>8
if(D>2)then print"*30,00," Frequency "," AntCap " FM tune"
else
i=DabFreqToIndex(Frequency)
spi write 6,&HB0,&H00,i,0,AntCap and 255,AntCap>>8
if(D>2)then print"*B0,00," Frequency ",0," AntCap " DAB tune"
NumDabServices=0
LastDabServList=-1
endif
pin(P_SI4689_CS)=1
CTSwait=500
StatusBits=1
if(D>0)then print"Tuning to " str$(Frequency)" kHz(" str$(NewServiceID)"," str$(NewCompID)")"
ExpectTune=1
if(RadioMode<>MODE_DAB)then next_state=400
if(CapSearch>0)then next_state=400
case 303
SetProperty(&HB4,&H00,&H00,&H05)
next_state=400
case 400
PollWait=0
if(ExpectTune<>0)then
ExpectTune=0
if((SpiBuf(0)and 1)=1)then
if((Seeking and 128)<>0)then Seeking=(Seeking and 3)or 64
else
if((Seeking and 128)<>0)then
if(RadioMode=MODE_AM)then goto AM_SEEK
if(RadioMode=MODE_FM)then goto FM_SEEK
endif
if(D>0)then print"Failed seek/tune. Retrying"
goto RETRY_TUNE
endif
if((MuteDowncount<=0)and(RadioMode<>MODE_DAB))then MuteDowncount=MUTE_RELEASE
endif
if(CapSearch=0)then
pin(P_SI4689_CS)=0
if(RadioMode=MODE_AM)then
spi write 2,&H42,&H03
if(D>2)then print"*42,03 AM Status"
Reply_Size=17
next_state=410
elseif(RadioMode=MODE_FM)then
spi write 2,&H32,&H03
if(D>2)then print"*32,03 FM Status"
Reply_Size=22
next_state=430
else
spi write 2,&HB2,&H01
if(D>2)then print"*B2,01 DAB status"
Reply_Size=23
next_state=450
endif
pin(P_SI4689_CS)=1
CTSwait=30
SpiWait=1
else
next_state=IntState
endif
case 410
ReadFreq=(SpiBuf(7)<<8)+SpiBuf(6)
FreqOffset=2*Conv8bitSignedInt(SpiBuf(8))
SigStrength=Conv8bitSignedInt(SpiBuf(9))
SNR=Conv8bitSignedInt(SpiBuf(10))
M=Conv8bitSignedInt(SpiBuf(11))
ReadAntCap=(SpiBuf(13)<<8)+SpiBuf(12)
NewStatus=1
Stereo=0
Quality=-1
FibErr=-1
CNR=-1
if((SigStrength>AmMinStren)and(SNR>AmSNR))then
Rstate=Rplaying
else
Rstate=Rtuned
endif
goto SET_VOLUME
case 430
ReadFreq=(SpiBuf(7)*2560)+(SpiBuf(6)*10)
FreqOffset=2*Conv8bitSignedInt(SpiBuf(8))
SigStrength=Conv8bitSignedInt(SpiBuf(9))
SNR=Conv8bitSignedInt(SpiBuf(10))
M=Conv8bitSignedInt(SpiBuf(11))
ReadAntCap=(SpiBuf(13)<<8)+SpiBuf(12)
if((SigStrength>FmMinStren)and(SNR>FmSNR))then
Rstate=Rplaying
else
Rstate=Rtuned
endif
pin(P_SI4689_CS)=0
spi write 2,&H33,&H01
pin(P_SI4689_CS)=1
if(D>2)then print"*33,01 FM ACF status"
Reply_Size=11
CTSwait=9
SpiWait=1
case 431
Stereo=0
if((SpiBuf(8)and 128)<>0)then Stereo=1
NewStatus=1
Quality=-1
FibErr=-1
CNR=-1
goto SET_VOLUME
case 450
SigStrength=Conv8bitSignedInt(SpiBuf(6))
SNR=Conv8bitSignedInt(SpiBuf(7))
Quality=Conv8bitSignedInt(SpiBuf(8))
CNR=Conv8bitSignedInt(SpiBuf(9))
FibErr=(SpiBuf(11)<<8)+SpiBuf(10)
ReadFreq=(SpiBuf(14)<<16)+(SpiBuf(13)<<8)+SpiBuf(12)
FreqOffset=Conv8bitSignedInt(SpiBuf(17))
M=Conv8bitSignedInt(SpiBuf(22))
ReadAntCap=(SpiBuf(19)<<8)+SpiBuf(18)
NewStatus=1
if((SpiBuf(5)and 1)=0)then
Status="No signal"
Stereo=0
if((Seeking and 128)<>0)then Seeking=(Seeking and 3)or 64
Rstate=Runtuned
goto Exit_State_Machine
endif
Stereo=1
if(Rstate=Runtuned)then Rstate=Rtuned
if(Quality<25)then
if(D>1)then print"Low DAB signal quality:" Quality
Status="Poor Signal"
elseif((SpiBuf(5)and 13)=13)then
Status="Errors"
elseif((SpiBuf(5)and 13)=5)then
Status="Signal OK"
endif
if((ServiceID<0)or(Rstate<>Rplaying))then
next_state=IntState
else
pin(P_SI4689_CS)=0
spi write 2,&HBC,0
pin(P_SI4689_CS)=1
if(D>2)then print"*BC,00 DAB get time"
Reply_Size=11
CTSwait=9
SpiWait=1
endif
case 451
a=(SpiBuf(5)<<8)+SpiBuf(4)
b=SpiBuf(6)
c=SpiBuf(7)
e=SpiBuf(8)
n=SpiBuf(9)
if((c>0)and(c<32)and(b>0)and(b<13)and(a>2019)and(a<2100))then
S2=str$(c,2,0,"0")+"/"+str$(b,2,0,"0")+"/"+str$(a)
else
S2=""
endif
if((e>=0)and(e<24)and(n>=0)and(n<60))then
S3=str$(e,2,0,"0")+":"+str$(n,2,0,"0")
S1=S3
if(S2<>"")then S1=S2+" "+S3
else
S3=""
S1=S2
endif
if(D>2)then print S1
if(CtrlVal(RLN10)<>S1)then
CtrlVal(RLN10)=S1
if(S2<>"")then DATE$=S2
if(S3<>"")then TIME$=S3
if((RtcInstalled<>0)and(S2<>"")and(S3<>""))then rtc settime a,b,c,e,n,0
endif
goto SET_VOLUME
case 452
SET_VOLUME:
if(AudioOutMode=AUDIO_DIG)then goto DO_UNMUTE
i=CtrlVal(BVolume)
if(HP_removed=0)then
i=i>>1
elseif(AudioOutMode=AUDIO_RCA))then
i=63
endif
SetProperty(&h03,&h00,0,i)
if(D>1)then print"Analogue volume set to " i
next_state=453
case 453
DO_UNMUTE:
SetMux(0,-1)
SetRadioMute
next_state=IntState
case 1000
if(D>0)then print"Initiating AM seek"
if(((Seeking and 1)=0)and(Frequency<=AmMIN))then goto NO_SEEK
if(((Seeking and 1)=1)and(Frequency>=AmMAX))then goto NO_SEEK
AM_SEEK:
SetMux(1,-1)
SetRadioMute
pin(P_SI4689_CS)=0
spi write 6,&H41,&H00,(Seeking and 1)<<1,0,0,0
pin(P_SI4689_CS)=1
if(D>2)then print"*41,00," hex$((Seeking and 1)<<1,2)",0,0,0 AM seek start"
CTSwait=2000
StatusBits=1
ExpectTune=1
SeekStart=Frequency
next_state=400
case 1100
if(D>0)then print"Initiating FM seek"
if(((Seeking and 1)=0)and(Frequency<=FmMIN))then goto NO_SEEK
if(((Seeking and 1)=1)and(Frequency>=FmMAX))then
NO_SEEK:
Seeking=64
goto Exit_State_Machine
endif
FM_SEEK:
SetMux(1,-1)
SetRadioMute
pin(P_SI4689_CS)=0
spi write 6,&H31,&H00,(Seeking and 1)<<1,0,0,0
pin(P_SI4689_CS)=1
if(D>2)then print"*31,00," hex$((Seeking and 1)<<1,2)",0 FM seek start"
CTSwait=2000
StatusBits=1
ExpectTune=1
SeekStart=Frequency
next_state=400
case 10000
if(RadioMode=MODE_FM)then
i=FmSwitch
else
i=DabSwitch
endif
SetProperty(&H17,&H12,&H00,i)
case 10001
SetMux(1,-1)
SetRadioMute
next_state=IntState
case 11000
pin(P_SI4689_CS)=0
spi write 2,&HE5,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*E5,00 Test Get RSSI"
Reply_Size=6
CTSwait=9
SpiWait=1
case 11001
SigLevel=Conv8bitSignedInt(SpiBuf(5))+(SpiBuf(4)/256.0)
if(D>1)then print"Signal Level:" SigLevel "dBuV at " Frequency "kHz"
next_state=IntState
case 20000
pin(P_SI4689_CS)=0
spi write 4,&H14,NumProp,PropID and 255,PropID>>8
pin(P_SI4689_CS)=1
if(D>2)then print"*14," hex$(NumProp,2)"," hex$(PropID,4)" Get Property"
Reply_Size=4+(NumProp<<1)
CTSwait=9
SpiWait=1
case 20001
if(D>1)then
for i=0 to(NumProp-1)
print"Property " hex$(PropID+i,4)"==" hex$(SpiBuf(5+(i<<1)),2)hex$(SpiBuf(4+(i<<1)),2)
next
endif
Exit_State_Machine: next_state=IntState
case 60000
IntState=0
if((IntMask and 1)<>0)then
pin(P_SI4689_CS)=0
spi write 2,&H84,1
pin(P_SI4689_CS)=1
if(D>2)then print"*84,01 DAB get digital service data"
Reply_Size=24
CTSwait=9
SpiWait=1
IntMask=IntMask and &HFE
else
goto RdsInt
endif
case 60001
i=(SpiBuf(19)<<8)+SpiBuf(18)
a=(SpiBuf(21)<<8)+SpiBuf(20)
b=(SpiBuf(23)<<8)+SpiBuf(22)
c=(SpiBuf(11)<<24)+(SpiBuf(10)<<16)+(SpiBuf(9)<<8)+SpiBuf(8)
e=(SpiBuf(15)<<24)+(SpiBuf(14)<<16)+(SpiBuf(13)<<8)+SpiBuf(12)
if(D>1)then
print"Digital Service Interrupt"
print" Service ID:" c "/" hex$(c,8)
print" Component ID:" e "/" hex$(e,8)
print" Buf Count:" SpiBuf(5)
print" Service State:" hex$(SpiBuf(6),2)
print" Byte 7:" hex$(SpiBuf(7),2)
print" UA type:" hex$(SpiBuf(17),2)hex$(SpiBuf(16),2)
print" Byte Count:" i
print" Seg Num:" a
print" Num Segs:" b
endif
S1=""
Read_Radio_Reply(24+i)
Rstate=Rplaying
a=0
if((SpiBuf(7)and 192)=128)then
if(D>1)then print" Selected via byte 7"
a=1
elseif(((SpiBuf(24)=0)or(SpiBuf(24)=128))and(SpiBuf(25)=0))then
if(D>1)then print" Selected via initial bytes"
a=1
endif
if(a<>0)then
if(i>256)then i=256
S1=""
for c=24 to 23+i
S1=S1+CleanChr(SpiBuf(c))
next
S1=TruncStr(S1)
if(D>1)then print"Dab data: " S1
c=DispString(S1,RLN4,RLN9,50,1)
endif
goto RdsInt
case 60100
RdsInt:
if((IntMask and 2)<>0)then
DECODE_MORE:
pin(P_SI4689_CS)=0
spi write 2,&H34,1
pin(P_SI4689_CS)=1
if(D>2)then print"*34,01 FM RDS Status"
Reply_Size=20
CTSwait=9
SpiWait=1
IntMask=IntMask and &HFD
next_state=60101
else
goto DigEvInt
endif
case 60101
if(D>0)then
print"--------------------------------"
print"FM RDS interrupt"
print"0, 1, 3->" hex$(SpiBuf(0),2)" " hex$(SpiBuf(1),2)" " hex$(SpiBuf(3),2)
print"4, 5, 6, 10->" hex$(SpiBuf(4),2)" " hex$(SpiBuf(5),2)" " hex$(SpiBuf(6),2)" " hex$(SpiBuf(10),2)
endif
if(SpiBuf(10)>0)then
id=SpiBuf(15)>>4
e=SpiBuf(14)and 31
if(D>0)then
if((SpiBuf(5)and 1)<>0)then print" RDS FIFO overrun"
if((SpiBuf(5)and 2)<>0)then print" RDS in sync"
print" Rx Error flags=" hex$(SpiBuf(11),2)
if((SpiBuf(5)and 16)<>0)then
print" TP="(SpiBuf(6)>>5)and 1
print" PTY=" hex$(SpiBuf(6)and 31,2)
endif
if((SpiBuf(5)and 8)<>0)then
print" PI=" hex$((SpiBuf(9)<<8)+SpiBuf(8),4)
endif
print" Group=" hex$(id,2)
print" Addr=" hex$(e,2)
print" Block A: " hex$(SpiBuf(13),2)hex$(SpiBuf(12),2)
print" Block B: " hex$(SpiBuf(15),2)hex$(SpiBuf(14),2)
print" Block C: " hex$(SpiBuf(17),2)hex$(SpiBuf(16),2)" " chr$(39)CleanChr(SpiBuf(17))CleanChr(SpiBuf(16))chr$(39)
print" Block D: " hex$(SpiBuf(19),2)hex$(SpiBuf(18),2)" " chr$(39)CleanChr(SpiBuf(19))CleanChr(SpiBuf(18))chr$(39)
endif
if((id=0)and((SpiBuf(11)and &H33)=0))then
S1=CleanChr(SpiBuf(19))+CleanChr(SpiBuf(18))
if((ProgName(e and 3)<>"")and(ProgName(e and 3)<>S1))then
if(D>0)then print" RDS group 0 snippet " e and 3 " change"
for i=0 to 3
ProgName(i)=""
next
endif
ProgName(e and 3)=S1
if(D>0)then print" RDS group 0 snippet " e and 3 "=" chr$(39)S1 chr$(39)
S1=ProgName(0)+ProgName(1)+ProgName(2)+ProgName(3)
if(len(S1)=8)then
S1=TruncStr(S1)
if(D>0)then print" RDS station name:" S1
for i=0 to(MAX_SET-1)
if(RdsNameSet(i)=S1)then exit for
next
if(i>=MAX_SET)then
if(RdsNames<MAX_SET)then
RdsNameSet(RdsNames)=S1
RdsNames=RdsNames+1
endif
endif
for i=0 to(MAX_SET-1)
if((len(RdsNameSet(i))>=2)and(lcase$(right$(RdsNameSet(i),2))="fm"))then exit for
next
S1=""
j=0
if(i<MAX_SET)then j=i+1
for i=0 to(MAX_SET-1)
if(RdsNameSet((i+j)mod MAX_SET)<>"")then
if(S1<>"")then S1=S1+" "
S1=S1+RdsNameSet((i+j)mod MAX_SET)
endif
next
S1=left$(S1,NameLen)
S2=MatchName(Frequency,S1,-1,-1,0)
if(CtrlVal(RLN1)<>S2)then CtrlVal(RLN1)=S2
if((S1<>S2)and(CtrlVal(RLN9)<>S1))then
CtrlVal(RLN9)=S1
endif
endif
elseif((id=2)and((SpiBuf(11)and &H15)=0))then
i=e and 16
if(i<>ActiveProgData)then
TryToDispRDS(i+1)
ActiveProgData=i
endif
S1=CleanChr(SpiBuf(17))+CleanChr(SpiBuf(16))+CleanChr(SpiBuf(19))+CleanChr(SpiBuf(18))
ProgData(e)=S1
if(D>0)then print" RDS group 2 snippet " e "=" chr$(39)S1 chr$(39)
elseif((id=4)and((e and 16)=0)and((SpiBuf(11)and &H3f)=0))then
j=((SpiBuf(16)and 1)<<4)+((SpiBuf(19)and &hf0)>>4)
n=((SpiBuf(19)and 15)<<2)+((SpiBuf(18)and &Hc0)>>6)
c=SpiBuf(18)and 31
if((SpiBuf(18)and 32)<>0)then c=-c
id=(j*60)+n+(c*30)
if(id<0)then
id=id+1440
c=-1
elseif(id>=1440)then
id=id-1440
c=1
else
c=0
endif
e=id/60
n=id mod 60
if((e>=0)and(e<24)and(n>=0)and(n<60))then
S3=str$(e,2,0,"0")+":"+str$(n,2,0,"0")
else
S3=""
endif
j=((SpiBuf(14)and 3)<<15)+(SpiBuf(17)<<7)+(SpiBuf(16)>>1)+c
b=int((j-15078.2)/365.25)
comp=int((j-14956.1-int(b*365.25))/30.6001)
c=j-14956-int(b*365.25)-int(comp*30.6001)
id=0
if((comp=14)or(comp=15))then id=1
a=b+id+1900
b=comp-1-(id*12)
S1=""
if((c>0)and(c<32)and(b>0)and(b<13)and(a>2019)and(a<2100))then
S2=str$(c,2,0,"0")+"/"+str$(b,2,0,"0")+"/"+str$(a)
S1=S2
if(S3<>"")then S1=S2+" "+S3
endif
if(D>0)then print" RDS group 4A. Julian Day=" j ", Time=" S1
if(CtrlVal(RLN10)<>S1)then
CtrlVal(RLN10)=S1
if(S2<>"")then DATE$=S2
if(S3<>"")then TIME$=S3
if((RtcInstalled<>0)and(S2<>"")and(S3<>""))then rtc settime a,b,c,e,n,0
endif
endif
if(SpiBuf(10)>1)then goto DECODE_MORE
TryToDispRDS(0)
endif
goto DigEvInt
case 60200
DigEvInt:
if((IntMask and 4)<>0)then
pin(P_SI4689_CS)=0
spi write 2,&HB3,&H01
pin(P_SI4689_CS)=1
if(D>2)then print"*B3,01 DAB get event status"
if(D>1)then print"Waiting for DAB service list"
Reply_Size=8
CTSwait=9
SpiWait=1
IntMask=IntMask and &HFB
next_state=60201
else
next_state=IntState
endif
case 60201
i=(SpiBuf(7)<<8)+SpiBuf(6)
if(((SpiBuf(5)and 1)=0)or(LastDabServList=i))then
if(D>1)then print"No new service list"
goto Exit_State_Machine
endif
if(D>1)then print"Received DabServList=" i "(Last was " LastDabServList ")"
LastDabServList=i
pin(P_SI4689_CS)=0
spi write 2,&H80,&H00
pin(P_SI4689_CS)=1
if(D>2)then print"*80,00 Get audio service list"
Reply_Size=6
CTSwait=9
SpiWait=1
case 60202
i=6+(SpiBuf(5)<<8)+SpiBuf(4)
if(i>=READ_REPLY_BUFSIZE)then
if(D>1)then print"Digital service list string size:" i
cpu restart
endif
Read_Radio_Reply(i)
n=SpiBuf(8)
if(D>1)then print"Num Dab Services in list:" n
a=12
NumDabServices=0
for i=0 to(n-1)
id=SpiBuf(a)+(SpiBuf(a+1)<<8)+(SpiBuf(a+2)<<16)+(SpiBuf(a+3)<<24)
e=SpiBuf(a+4)
b=SpiBuf(a+5)and 15
S3=""
for c=8 to 23
if((SpiBuf(a+c)<32)or(SpiBuf(a+c)>127))then exit for
S3=S3+CHR$(SpiBuf(a+c))
next
S3=TruncStr(S3)
if(D>1)then
print i ": Service ID:" id "/0x" hex$(id)"=" chr$(34)S3 chr$(34)
print"    Conditional Access:" SpiBuf(a+5)>>4
print"    # Components:" b
print"    Service Info 1:0x" hex$(e,2)
print"    Service Info 3:0x" hex$(SpiBuf(a+6),2)
endif
a=a+24
for c=1 to b
comp=SpiBuf(a)+(SpiBuf(a+1)<<8)
if(D>1)then
print"    Component ID[" c "]:" comp "/0x" hex$(comp)
print"    Component info[" c "]:0x" hex$(SpiBuf(a+2),2)hex$(SpiBuf(a+3),2)
endif
a=a+4
if(((e and 1)=0)and(S3<>"")and(NumDabServices<MAX_DAB_SERVICES))then
S2=S3
if(b>1)then
S2=left$(S3,NameLen-1)+str$(c)
endif
DabServiceName(NumDabServices)=S2
DabServiceID(NumDabServices)=id
DabComponentID(NumDabServices)=comp
NumDabServices=NumDabServices+1
S1=MatchName(Frequency,S2,id,comp,0)
endif
next
next
if(D>1)then print"Keeping " NumDabServices " service descriptions"
if((NewServiceID>=0)and(NewCompID>=0))then
for i=0 to(NumDabServices-1)
if((NewServiceID=DabServiceID(i))and(NewCompID=DabComponentID(i)))then exit for
next
if(i<NumDabServices)then
DabID=i
if(D>0)then print"Starting digital service ID=" NewServiceID " component=" NewCompID
ServiceID=NewServiceID
CompID=NewCompID
NewServiceID=-1
NewCompID=-1
id=ServiceID and 255
a=(ServiceID>>8)and 255
b=(ServiceID>>16)and 255
c=(ServiceID>>24)and 255
comp=CompID and 255
e=(CompID>>8)and 255
n=(CompID>>16)and 255
i=(CompID>>24)and 255
pin(P_SI4689_CS)=0
spi write 12,&H81,0,0,0,id,a,b,c,comp,e,n,i
pin(P_SI4689_CS)=1
if(D>2)then print"*81,0,0,0," hex$(ServiceID,8)"," hex$(CompID,8)" DAB start digital service"
CTSwait=9
SpiWait=1
Rstate=Rselected
MuteDowncount=MUTE_RELEASE
State=452
exit sub
endif
endif
next_state=IntState
end select
State=next_state
end sub
sub ProcessScan
local integer i,x
if((D>0)and(DABwait=0))then
print"Seek ack Freq:" ReadFreq " SNR:" SNR " SigStrength:" SigStrength " min:" Min_SigStren " CNR:" CNR " Qual:" Quality
endif
Frequency=ReadFreq
if((Seeking and 2)=0)then
Seeking=0
exit sub
endif
if((SigStrength>=Min_SigStren)and((RadioMode=MODE_DAB)or(SNR>Min_SNR)))then
if(RadioMode=MODE_DAB)then
if(DABwait<=0)then
DABwait=1
exit sub
elseif(DABwait<2000)then
exit sub
endif
DABwait=0
if(NumDabServices>0)then
for i=0 to(NumDabServices-1)
x=AddPreset(Frequency,DabServiceName(i),DabServiceID(i),DabComponentID(i),0)
next
endif
else
x=AddPreset(Frequency,"",-1,-1,0)
endif
endif
Seeking=&H83
AntCap=0
if(RadioMode=MODE_AM)then State=1000
if(RadioMode=MODE_FM)then State=1100
if(Frequency=AmMAX)then
NewFrequency=AFmMIN
CapWait=0
elseif(Frequency=FmMAX)then
NewFrequency=ADabMIN
CapWait=0
State=300
elseif((NumDabFreqs>0)and(Frequency>=DabFreqs(0)))then
DabFreqIndex=DabFreqToIndex(Frequency)+1
if(DabFreqIndex>=NumDabFreqs)then goto FINSCAN
Frequency=DabFreqs(DabFreqIndex)
if(Frequency>ADabMAX)then
FINSCAN:
WritePresetFile
ReadPresetFile
SetFavs
if(D>0)then print"Scan complete. " NumServices " services in preset table"
Seeking=0
CapWait=0
Change_Smode=Xstatus
NewFrequency=Pfreq(0)
NewServiceID=Pid(0)
NewCompID=Pcomp(0)
AntCap=Pcap(0)
CtrlVal(Ebandwidth)=Pbw(0)
State=0
else
NewFrequency=DabFreqs(DabFreqIndex)
DABwait=0
CapWait=0
State=300
endif
else
MuteDowncount=MUTE_RELEASE<<1
endif
end sub
const MAX_SAMPLES=20
dim integer highest_antcap
function What_Cap(x as integer)as float
if(RadioMode=MODE_AM)then
What_Cap=(x-1)*142.0/1000.0
else
What_Cap=(x-1)*250.0/1000.0
endif
end function
sub ProcessCap
static integer i,bestcap,of,oi,oc
static float bin,maxsig,f1,f2,f3,f4
PollWait=0
select case CapSearch
case 1
Change_Smode=Xcap
ClearConsole
CtrlVal(LN1)="Antenna Capacitance Search: "+str$(Frequency)+" kHz"
CtrlVal(LN2)="Refer to Silicon Labs App Note AN851 Appendix A"
CtrlVal(LN3)="for more details about the algorithm."
CtrlVal(LN5)="Run this function for a range of stations"
CtrlVal(LN6)="across the FM and DAB bands and note results."
CtrlVal(LN7)="The optimal AntCap values will be automatically"
CtrlVal(LN8)="saved to the presets. Edit the presets and"
CtrlVal(LN9)="interpolate any missing AntCap values."
CtrlVal(LN11)="Scanning will take several minutes to complete."
CtrlVal(LN13)="Touch screen to start."
CapSearch=2
case 3
ClearConsole
WriteMsg("Commencing AntCap search...")
if(RadioMode=MODE_AM)then
highest_antcap=4096
else
highest_antcap=128
endif
maxsig=-1
bestcap=-1
of=Frequency
oi=ServiceID
oc=CompID
f1=0
f2=0
f3=0
f4=0
NewFrequency=of
NewServiceID=-1
NewCompID=-1
RadioMode=-1
CapSearch=4
case 4
State=10000
AntCap=1
CapSearch=5
case 5
do_setcap:
bin=0.0
i=0
CapWait=-200
CapSearch=6
State=300
case 6
do_wait:
if(CapWait>30)then
State=11000
CapSearch=7
endif
case 7
bin=bin+SigLevel
i=i+1
if(i<MAX_SAMPLES)then
CapWait=0
CapSearch=6
goto do_wait
endif
bin=bin/MAX_SAMPLES
S1="AntCap="+str$(AntCap)+"("+str$(What_Cap(AntCap),0,2)+"pF), Av SigStren="+str$(bin,0,1)+"dBuV"
WriteMsg(S1)
f1=(bin+f1+f2+f3+f4)/5
if(f1>maxsig)then
maxsig=f1
bestcap=AntCap-3
endif
if(AntCap<highest_antcap)then
f1=f2
f2=f3
f3=f4
f4=bin
AntCap=AntCap+1
goto do_setcap
endif
AntCap=bestcap+1
for i=0 to(NumPresets-1)
if(Pfreq(i)=of)then
Pcap(i)=AntCap
Pwait=1
endif
next
if((Pwait<1)and(NumPresets<MAX_PRESETS))then
Pwait=AddPreset(of,"",oi,oc,AntCap)
DirtyPresets=1
endif
CapSearch=10
ClearConsole
WriteMsg("Antenna Capacitance Search: "+str$(of)+" kHz")
WriteMsg("")
WriteMsg("Optimal AntCap value="+str$(AntCap))
WriteMsg("Optimal Capacitance="+str$(What_Cap(bestcap),0,2)+" pF")
WriteMsg("Optimal Signal Strength="+str$(maxsig,0,1)+" dBuV")
CtrlVal(LN13)="Touch screen to return to setup."
NewFrequency=of
NewServiceID=oi
NewCompID=oc
RadioMode=-1
end select
end sub
sub DispErrFile
local integer l=LN1
local string s3 length 32,s4 length 32,s5 length 32,s6 length 32,s7 length 32,s8 length 32,s9 length 32
ClearConsole
on error ignore
Do While((Not Eof(2))and(l<=LN12))
Input #2,S1,S2,s3,s4,s5,s6,s7,s8,s9
S1=TruncStr(S1+" "+S2+" "+s3+" "+s4+" "+s5+" "+s6+" "+s7+" "+s8+" "+s9)
l=DispString(S1,l,LN13,49,0)
Loop
if(Eof(2)and(l=LN1))then
Close 2
DispErrors=0
Change_Smode=Xsetup
else
DispErrors=1
endif
on error abort
end sub
if(RtcInstalled<>0)then
rtc gettime
S1="Initialising at "+DATE$+" "+TIME$
WriteMsg(S1)
endif
ReadDefaultFile
ReadPresetFile
ReadIRCodesFile
if(MM.WATCHDOG<>0)then
AppendErrFile("Reboot:Watchdog restart")
endif
DO
watchdog 10000
if(DoPowerAlarm>0)then
if(Pwait>0)then WritePresetFile
if(Dwait>0)then WriteDefaultFile
WriteErr("Power Drop")
DoPowerAlarm=0
endif
if(Change_Smode>0)then ProcessScreenChange
if((ExitTimer>0)and(GuiCounter>ExitTimer))then ProcessExitTimer
if((SA<>0)and((GuiCounter and 255)=255))then
NewStatus=1
ReadFreq=Frequency
endif
if(NewStatus<>0)then
S3=CtrlVal(RLN1)
if(right$(S3,4)=" kHz")then S3=""
S1=MatchName(ReadFreq,S3,ServiceID,CompID,1)
if(CtrlVal(RLN1)<>S1)then CtrlVal(RLN1)=S1
if(ValidFreq(ReadFreq)<>0)then
S1=str$(ReadFreq)+" kHz"
if(CtrlVal(RLN2)<>S1)then CtrlVal(RLN2)=S1
endif
if(maSNR<-90)then maSNR=SNR else maSNR=(MA_MULT!*maSNR)+(MA_INV_MULT!*SNR)
if(maCNR<-90)then maCNR=CNR else maCNR=(MA_MULT!*maCNR)+(MA_INV_MULT!*CNR)
if(maSig<0)then maSig=SigStrength else maSig=(MA_MULT!*maSig)+(MA_INV_MULT!*SigStrength)
if(maQual<0)then maQual=Quality else maQual=(MA_MULT!*maQual)+(MA_INV_MULT!*Quality)
S1="Signal:"+str$(maSig,-1,1)
if(RadioMode=MODE_DAB)then
S1=S1+"dBuV    CNR:"+str$(maCNR,-1,1)+"dB    Quality:"+str$(maQual,0,0)
else
S1=S1+"dBuV    SNR:"+str$(maSNR,-1,1)+"dB"
endif
if(((Rstate<>Rplaying)or(DispRefresh>8))and(CtrlVal(RLN3)<>S1))then
CtrlVal(RLN3)=S1
DispRefresh=0
else
DispRefresh=DispRefresh+1
endif
if(D>1)then
print
print"Freq:" ReadFreq ", SNR:" SNR ", SigStrength:" SigStrength ", CNR:" CNR ", Qual:" Quality ", Foffset:" FreqOffset;
print", DAB Status:" Status ", DAB Err:" FibErr ", M:" M ", Stereo:" Stereo ", AntCap:" ReadAntCap ", Seeking:" Seeking
endif
NewStatus=0
if(Smode=Xconsole)then Change_Smode=Xstatus
endif
if(Dwait>DEFAULT_WAIT_TIME)then WriteDefaultFile
if(Pwait>DEFAULT_WAIT_TIME)then
WritePresetFile
ReadPresetFile
SetFavs
endif
if(SpiWait>0)then CheckSpi
if(State<>0)then continue do
if(IrDev<>0)then ProcessIR
if(ButtonDn<>0)then ProcessButtonDown
if(ButtonUp<>0)then ProcessButtonUp
if((Seeking and 64)=64)then ProcessScan
if(CapSearch<>0)then
ProcessCap
elseif(PollWait>50)then
State=400
endif
if((Seeking=0)and(DoScan>0))then
if(D>0)then print"Scan commencing"
DoScan=0
NumServices=0
NewFrequency=AmMIN
Seeking=&H83
ServiceID=-1
CompID=-1
Change_Smode=Xscan
DABwait=0
AntCap=0
ClearStatus
endif
i=ChooseAudioOutMode(0)
if(AudioOutMode<>i)then
if(D>0)then print"AudioOutMode was " AudioOutMode ", has changed to " i
if((Smode=Xstatus)or(Smode=Xmain))then
Change_Smode=Smode
Smode=0
endif
if(((AudioOutMode=AUDIO_DIG)or(i=AUDIO_DIG))and(NewFrequency<AmMIN))then
NewFrequency=Frequency
if(NewServiceID<0)then NewServiceID=ServiceID
if(NewCompID<0)then NewCompID=CompID
if(D>1)then print"Retuning to force an audio output mode change"
endif
AudioOutMode=i
if(D>0)then
print"Changed audio output mode to " AudioOutMode "=";
if(AudioOutMode=AUDIO_DIG)then
print"Digital"
elseif(AudioOutMode=AUDIO_RCA)then
print"RCA"
elseif(AudioOutMode=AUDIO_SPKR)then
print"Speaker"
else
print"Unknown"
endif
endif
endif
if((AudioOutMode=AUDIO_SPKR)and(HP_removed<>0))then
pin(P_PAM8407_ENAB)=1
else
pin(P_PAM8407_ENAB)=0
endif
if(NumActivePresets<0)then
DirtyPresets=1
CompactPresets
SetFavs
Change_Smode=Smode
Smode=0
endif
if(DispErrors>1)then DispErrFile
LOOP
end
CFunction LOADERBIN
00000000
FF000010 00000000 00000000 12345678 00000000 00000000 6CCB84FD 00000001
DEADBEEF 00001648 00000004 00000004 00000000 50200544 00000000 00000000
00000000 00000000 00000000 00000000 00000000 076FCF88 8100006F 5000D800
5000E048 5000E150 50002A00 502867AC 5028656C A0002E00 50002A80 502896A0
FFF0FF0C A0001E00 4FFFFF80 502895E8 50000040 502892F8 50000050 50000060
FFFF0000 00001003 502008A8 502008C8 50200874 502007E0 502009F0 50200660
5000FE00 90200403 502008FC 50286778 50002A50 50002200 501FFFFF 50260000
A0000E00 502897D4 50008E00 A003F300 FFFFEFFF A002BE00 50002534 500027E0
5000E134 5000E130 502860A8 50285198 000FFFFF FFF00000 50286594 5000E050
0000ED0C 0000DEC0 0000C0DE 50286658 5000E000 00000BB7 0000C350 A000BE00
5000E0B0 5028A570 03000000 9FFFFE00 00001000 A00020C0 000F00F3 A00020D0
A00020E0 A00020F0 A0001004 00000800 A000C080 5000E0A8 A000C090 0000FFFF
A000C0F0 A000C010 A000C070 50201544 A000C100 A00010F0 A0001044 A0003100
A0001060 A0001080 A00011F0 00C00000 00400000 00004E20 5028A6A4 C3500000
00008808 0001FFE3 A0001008 EFFC37FF EFFC3FFF A000C0E0 00060000 00040000
A000C110 A000C120 A000C060 00020000 5028A580 02000000 5000E020 50284C50
5000E030 5000E140 A003DE00 000103F7 000103E7 00001017 00001037 81000011
5000E000 030361A8 004B000B 00042002 000040C7 500E0000 00000000 00000000
00000000 4649423C 5244485F 4345535F 0A3E4E54 49422F3C 44485F46 45535F52
3E4E5443 0000000A 21000042 5000E048 8000050A 50200400 21004136 20C03202
15229200 820020C0 98971422 0020C00E C01522B2 22A20020 F01AB714 C6000065
0000FFF6 21004136 20C03202 14223200 C0A03320 23520020 0005521A 420020C0
441B1A23 0C0020C0 321B0C4A 03811E23 30930B32 08E09339 2B452600 26465526
75265065 6085265A 1587980C 6A952664 1597B90C CFA0A26E 811D15A7 1A0C3204
0C0008E0 0002C61A 228203BD E004AD23 0A0C0008 1D004E25 8203BDF0 04AD2B22
060008E0 03BDFFF7 AD242282 0008E004 BDFFF3C6 25228203 08E004AD FFF08600
E0262282 EE460008 272282FF 060008E0 2282FFEC 0008E028 82FFE9C6 08E02922
FFE78600 E02A2282 E5460008 000000FF A2004136 052180A0 0020C032 A0C42292
20C02099 32068100 82C46292 88AC0808 20C01A0C CC229200 C02099A0 62920020
320781CC 08E0DA0C C0EC7C00 22B20020 10BBC0CC B20020C0 F01DCC62 0C004136
3203814A 08E00B0C 41170C00 09313208 32065132 92F2A062 05210805 C0F99C32
22B20020 20BB70CC B20020C0 20C0CC62 9023A200 6010AA40 20C020AA 9063A200
C10111E5 0CC2320A 35EC3789 B250A0A2 0B8104A0 320CC132 A10008E0 0D81320C
320EB132 A20008E0 A0B260A0 320B8104 E0320CC1 0CA10008 320D8132 E0320FB1
0A4C0008 0B814B0C 320CC132 C10008E0 11A13210 3202B132 920020C0 99C08422
2099A010 A10020C0 16C13217 3215D132 F13214E1 62923213 32128184 F2286B82
6BE22B6B 236BD225 A2246BC2 0592266B C0F99C08 22E20020 20EE70CC E20020C0
20C0CC62 9023D200 6010DD40 20C020DD 9063D200 C1321AB1 18A1321C 32199132
92321B81 4A0C5C6A 0C0008E0 3203814A 08E01B0C 00F01D00 81004136 20C03205
D8288200 66348080 0FA50238 00006500 0000F01D 0C006136 3205B115 820020C0
1D31D82B 34808032 0C2E3826 3203814A 08E00B0C 32048100 08E01A0C 3202A100
520020C0 090C166A 0C0020C0 186A921B 0C320381 0008E04A 020CF01D 42D22392
23C2CD23 321EF1D1 0C094CF6 90620CED 0106832D 904E0C00 BF47932E 321F8105
5002B847 AEE22022 3220910F D20020C0 DDE0D82B 0020C010 C2D86BD2 20C0F0A1
D82BA200 C020AAC0 6BA20020 0020C0D8 C09E6952 69520020 0020C096 65966952
0AF10009 890FF232 8105EF57 08E03221 814A0C00 0B0C3203 C80008E0 A201B811
2291D023 9D098D32 F2043D0A FF8002A5 86A0E211 FF40FFEA EAA1E211 0FA0FFEA
00F01D00 81004136 0882320A 471A0C89 2D0C3D68 C03220B1 2BC20020 20CCD098
C20020C0 20C0986B 982B9200 C02099A0 07810020 986B9232 820008E0 23F100A1
0020C032 80201FE2 20C020EE 205FE200 0000F01D 21004136 2481320A 89022232
27322541 20C00EE2 8C243200 C0103380 64320020 00F01D8C 7C004136 32054105
320533B6 0086FDC3 00A03200 820020C0 8080D824 33286634 C220D330 26A103C2
3227B132 1600DC25 20C004BA D824B200 C010BB50 64B20020 C03A0CD8 24920020
2099A0D8 920020C0 F01DD864 B20020C0 BB50D824 0020C010 0CD864B2 0020C07A
A0D82492 20C02099 D8649200 0C320481 0008E01A 1DC1F01D F32CC232 81FF4C16
1A0C3204 1D0008E0 000000F0 B6004136 02821433 FFA0A200 920B98A7 02B20102
0299A702 81151BA7 28A1322A 3229B132 0B99090C 03BD0A99 08E002AD 00F01D00
31004136 05213202 0020C032 20D82222 22803420 0020C011 1D306322 000000F0
0C008136 269387F8 0C60A0A2 320B814B 08E001CD 8101AD00 C1B2320D 0008E010
90904198 8169CCF4 02AD322B 1D0008E0 000000F0 A8004136 201D0C12 6B98A0BA
923205C1 20C00009 982C8200 89F48080 E8BA1BAB 660A0C52 42D90479 26000106
32D90149 AD01BBE7 322CE10B 98A09A20 322DB169 C01099E0 2C820020 1088B080
C0208890 6C820020 A942F880 B8AFDC12 A732C802 190C069B 004622D9 26229800
1C260819 322E8105 0C0008E0 3203814A 08E01B0C 00F01D00 0C004136 3203814A
08E00B0C 31040C00 20C03202 1423B200 20C0BB1B 1463B200 A20020C0 20C01923
14239200 C00539A7 63420020 0020C014 9C1723C2 2212663C C0FFB365 63420020
0020C017 06166342 20C00004 1623D200 B1E57D8C 0020C0FF 0C166342 3203814A
08E01B0C 00F01D00 B6004136 2FA17033 00686532 410002A2 3A163202 023AE606
82371AE6 7816F0CA EFCA9216 B2169916 2BA7F3A0 F0A0C205 D255AAC7 DAD0F4A0
16CD16C0 E0FEA0E2 4E16C0EA FFA0F20D 16C0FAF0 020C113F 0C000506 0DB837E8
C3C2B23B 0016A5FD A20020C0 120C3064 56007BE5 04810082 01A0A232 1D0008E0
37A90CF0 B23BE7B9 65FDC3C2 F7060014 02B3F6FF C1002146 02B23230 0102D202
D011BB80 9BC720BB 0FC2B273 92090282 02F20402 F1C3D205 E20E02C2 CC800D02
20CCE011 800C02E2 CCE011CC 0B02E220 E011CC80 CCD020CC 0602E263 D010AFD2
EE8080DA 20EEF011 F211EE80 EE900A02 03029220 8011FF80 FF8011EE 08028220
9011FF80 FF8020EE 07028220 8011FF80 AFF020FF 00296520 D4860A2D 46120CFF
73B6FFD3 3231E13F F20202D2 DD800102 20DDF011 A22D9DE7 02B20602 11AA8005
B220AAB0 AA800402 20AAB011 800302B2 AAB011AA 003B2520 ABA01B0C 460A2D93
0000FFC3 46120C00 32D1FFC1 0202C232 800102E2 CCE011CC 0F9CD720 0C003365
93ADA01D B9860A2D 000000FF B786120C E5A23BFF B5060017 0202A2FF 800102B2
AAB011AA 00102520 A20020C0 AF063064 FDC3C2FF 0E0C0D0C B20202A2 AA800102
20AAB011 AA40B23B 001E2511 00FFA786 BD006136 7C04CD03 0C32CCFA 0003464D
C208A0D2 C3B2FCC4 0061A204 2F510368 AD01A932 00706505 7A2505AD 41030C00
20C0321D B6D5C800 2146023C 08235600 56F324D2 05AD07CD 16008425 0578FE3A
01ADD28C 81A0C750 5CB83233 08E09CC8 5622F600 503226A1 27B1A0D7 052DC232
65092DD2 3AA0009A 0CAAAC20 C0E5B91B 05F10020 D82F9232 99A00A7C 0020C010
C0D86F92 2FE20020 80380CD8 20C020EE D86FE200 C20004C6 DC16F324 01A0A200
8101A092 E5993204 AD0008E0 00822505 A8FFDB86 A7B28C01 04810916 E01A0C32
01A80008 F01D0A2D BC004136 32345102 26341226 B34C3622 42361237 124701A1
02A18235 92341287 129701A2 02A2A233 B23212A7 12B703A2 04A2C231 0C0312C7
22F01D02 F01D0C05 1D001522 020522F0 1522F01D 22F01D03 F01D0305 1D040522
080522F0 0522F01D 22F01D09 F01D0515 0C004136 81BA4C17 A1B23234 3235D101
E201A2C2 A2F202A2 52B90C03 45160012 01126207 1516224B 551526FF 97442526
15A73B15 2615B72F E71D15C7 15F71415 04A2320B 62439537 F3460C48 055862FF
62FFF1C6 F0460948 084862FF 62FFEEC6 ED460348 643060FF 06035832 4862FFEB
FFE98604 620546F6 E7460248 06070CFF BD67FFE6 32364105 0C04B467 FFE28607
06005862 072DFFE1 0000F01D 0C008136 810B0CDA 61293203 032D5169 043D6178
4DF8C262 E0025D05 31490008 41292169 06BD14AC 01AD2169 F97CC38B 99323381
0008E001 6A1731A8 B851C80B 041BC701 2C46020C 32376100 0C068316 FFA08204
52000522 128701C5 01A0A250 C1001665 0CC23234 0020C008 C2322F91 B0705849
0020C0F5 705949B2 20C041A8 5A49A200 720020C0 20C05B49 5C492200 E505A0A2
20C00044 CC26D200 C0086D07 26E20020 F6EE07CC 070014E5 771BF9EA 1BFFA082
9B934744 68073188 BD61A83B E541C803 20C0001B CC269200 C0086907 26A20020
F6EA07CC C38B21B8 F97CA14B 99323381 0008E011 11C81A0C 020C01B8 B0C0BBC0
0046832A 0C120C00 320381DA 08E01B0C 00F01D00 E5004136 1A0C000E 0C000B65
0013252A A0000DE5 288C7480 F01D020C 0A251A0C 32349100 92322FA1 20C00C09
584A9200 3A651A0C 32379100 B20020C0 6B07CC29 0020C008 07CC29C2 0A65F6EC
F9EA0700 F01D120C A5004136 1A0C0009 0C000625 000DE52A A00008A5 288C7480
F01D020C 04E51A0C 3234C100 C2322F91 20C0090C 5849C200 C0F5B020 49B20020
41A82059 A20020C0 20C05A49 5B492200 33A54A0C 32379100 D20020C0 6D07CC29
0020C008 07CC29E2 03A5F6EE F9EA0700 F01D120C 0C004136 91480C6A 8A20322F
0020C093 49821A0C 00302558 C0323791 29B20020 086B07CC C20020C0 EC07CC29
00F01DF6 21004136 2CB13237 32383132 B0322DC1 20C010B3 8022A200 B010AAC0
20C020AA 8062A200 0CA0C392 0020C058 1B0C1A0C 65584982 20C0002E CC22C200
C0086C07 22D20020 F6ED07CC 220020C0 F01D0003 0C004136 322F8119 920020C0
20C05848 222A0C00 28255948 32379100 B20020C0 6B07CC29 0020C008 07CC29C2
F825F6EC F9EA07FF 0000F01D A1004136 03BD3234 C1040A92 C9CC322F C0030A82
4C820020 C64A0C58 20C00003 584C9200 20C00A0C 5C4CA200 80205A0C 3237D1F5
820020C0 F820594C 0020C041 C05A4CF2 4C220020 322CE15B E0322DF1 20C010E4
802DC200 E010CCF0 20C020CC 806DC200 1D0022A5 000000F0 0C004136 318C5C0B
3981322F E003AD32 3AB10008 323BC132 910020C0 6CB2323C B13A0CA2 A0C2323E
9932A9F2 323DA142 A1004F25 3EB1323F F2A0C232 A1004E65 3EB13240 F2A0C232
A1004DA5 3EB13241 F1A0C232 A5004CE5 42A10006 3243B132 A1004E25 2CB13244
3245C132 A1004B65 47B13246 E57C0C32 48A1004A 0C3B0C32 004A251C B23248A1
0C0C70A0 A1004965 42C83249 0B3247B1 0048A5CC B2324AA1 1C0C73A0 CD0047E5
81DA0C03 4BB1321B 0008E032 1C324CA1 A50C0CCB F01D0046 A1004136 10B1324D
A50C0C32 4EA10045 3243B132 310046E5 13823223 32342120 A1376887 A4B2324F
00A4C200 81004365 A3A23207 0008E0E8 B13250A1 43C13243 00422532 3C324FA1
A50C1C0B 51A10041 0CCB0C32 0040E50C A1001586 53B13252 3254C132 B2003FE5
55C10012 B71A0C32 AAF00B3C 11BBF011 46F6BCB7 1A0C0000 0B325681 0E42929A
E03257A1 DAB20008 41BCB008 B211BBF0 A2C20D42 74B0B000 C020BBC0 53B20020
3258A190 A20020C0 4CA18053 3259B132 D20202C2 E1C00E02 11DD2004 F004C0C0
DDE011EE 20CCD020 1D003925 000000F0 A1004136 3EB1323D 258C0C32 40A10038
323EB132 37658C0C 3241A100 0C323EB1 0036A58C B1323FA1 8C0C323E A10035E5
43B1325A 00376532 0381DA0C E00B0C32 5BB10008 3220A132 B20020C0 5C91886A
0020C032 1D886A92 000000F0 A1004136 47B1325D 650C0C32 4CA10032 325EB132
A5325FC1 02CD0031 7C3260A1 0030E5FB 0C3261A1 651C0C1B F01D0030 A1004136
47B1325D 650C0C32 62A1002F 3247B132 2EA50C0C 324CA100 C1325EB1 2DE53263
3260A100 C280FB7C 20C3C001 A1002CE5 1B0C3261 2C651C0C 00F01D00 61004136
A0823238 0D384780 06AD03BD CD326481 0008E004 0E0C063D 0ECD02DD 390020C0
E9E2E9F2 0020C0D2 C0106242 62E20020 0020C012 C01362E2 62E20020 1562E214
0C3202A1 1AA97649 B20020C0 AA4B1A2A F8071367 C0FF50F2 1B051BF7 4B5DB9CC
C9F03DDD C102E932 42C9323C C03237A1 42B80020 BB0B12E9 B03210C1 20C0F4B0
842A9200 B01099C0 20C02099 921B0C00 0381846A E0DA0C32 F01D0008 C0004136
D2880020 6856E298 0A39560A A20020C0 2A561222 0020C004 881022B2 378BB6F2
20C00888 11628200 1FF8F2F8 E80020C0 1262F2F2 F2E9EE8B D20020C0 CDD21022
0020C0F8 C01062D2 22C20020 917CCC12 20C03265 12629200 A20020C0 1C0C1222
C004EA16 22820020 0020C012 12C84238 20633380 5CC8A0CC A20020C0 03BD1122
C0FFC0A5 22B20020 C0BB3A11 62B20020 0020C011 301222A2 20C0C0AA 1262A200
920020C0 991B1322 920020C0 F01D1362 20C0F01D 1DD2C900 000000F0 C0004136
D2880020 0C0338B6 0CF01D02 320381DA 08E00B0C C0130C00 12A80020 99A70298
0020C009 0B0C22C8 0C833BC0 320381DA 08E01B0C C063CC00 D2980020 C0CB29B6
D2A80020 3AB6120C 1D020C03 00F01DF0 0C004136 920B0CDA 03811522 92991B32
08E01562 A8030C00 1B32B802 B702A9AA 0239013A B80020C0 A19B8C22 EBE5322F
0020C0FF DA0C2239 0C320381 0008E01B 20C03A0C B8D29800 2429F6E2 20C01BAC
1322D200 C20020C0 BCD71422 0020C00E C01322F2 22E20020 F03EF714 A90020C0
0020C0D2 1866D288 0020C015 C01322B2 22920020 B72C0C14 20C00439 C0D2C900
D2D80020 C0102D66 22F20020 1522E214 C0043EF7 D2A90020 0000F01D D1004136
3BE1323A 0020C032 C0A26ED2 12B80020 203237C1 20C0A0DB 982CC200 C0C00A0C
889DC9F4 87BB1B32 0BAD01BB A90020C0 0020C012 02F81288 9F87190C 0020C007
01462299 322FA100 C0FFDF25 22A20020 C0AA1B14 62A20020 00F01D14 40004136
F77C1063 C0307370 02580020 60105570 20C02055 1D025900 000000F0 C0004136
02390020 0000F01D 29006136 AC013911 326631F5 E2322971 C7C210C3 0C079810
26E9AC06 29667F19 A805DD15 8101B811 04CD3267 E10008E0 69C13268 56050C32
11A8FDA5 2AA2190C A2020C27 29A0F8CA D8F01D83 3A0F0C17 E2B6572D 0BFDFF56
B29DCA55 02820004 1B441B00 B2DD1B22 17D90049 A81F1B87 8101B811 69C13267
0008E032 C13268E1 290C3269 1F0C0799 17D90D0C 26000086 661B04BD 0CFFEE46
C607A91A 0F0CFFF9 060C17D8 B6572DEA F8AF568D 661B550B 820002B2 441B0004
2D081B87 D90D0C0E 00040617 191C221B 17D9DD1B 0C059D97 A92A0C1F FFF34607
41004136 0482320A 04848089 C216D816 052C0FAE 6A31023C 3205A132 B20020C0
BBC0D82A 0020C010 C0D86AB2 2A920020 209920D8 920020C0 20C0D86A 88635200
1C320781 0008E0EA 220020C0 07818863 E0EA1C32 A2920008 0020C030 81886392
EA1C3207 920008E0 20C030A3 88639200 1C320781 0008E0EA C0326B91 63920020
32078184 08E0EA1C 326C9100 920020C0 07818463 E0EA1C32 A1920008 0020C030
81886392 EA1C3207 910008E0 2321326D 0020C032 81385292 EA1C3207 910008E0
20C0326E 38529200 1C320781 0008E0EA C03FA392 52920020 32078130 08E0EA1C
1CA19200 920020C0 07812052 E0EA1C32 A1920008 0020C010 81886392 EA1C3207
C00008E0 52520020 32078120 08E0EA1C 08A19200 920020C0 07816852 E0EA1C32
991C0008 920020C0 07815852 2CA1A232 920008E0 A1B28A04 A2A9CC00 20C01BA1
7052A200 B0000206 20C020B9 7052B200 1C320781 0008E0EA 20A1DD7C 0020C032
D0982AC2 20C010CC 986AC200 20C0EB7C 982A9200 C01099B0 6A920020 00F01D98
00000000
End CFunction
