#!/bin/bash -noprofile
#
# This is a shell script that will run under MacOS or Linux to crunch an MMBASIC programme
# (It assumes dosutils has been installed, which includes unix2dos)

if [[ -z "${1}" ]] || [[ -z "${2}" ]] || [[ "${1}" == "${2}" ]] ; then
  echo "Usage: `basename ${0}` <source> <destination>"
  echo "CRUNCH source file and write back as destination file"
  exit 1
fi

cat "${1}" | \
    sed -e "s/'.*$//g" | \
    sed -e '/^[[:space:]]*$/d' | \
    sed -e 's/^[[:space:]]*//g' | \
    sed -e 's/[[:space:]]*$//g' | \
    sed -e 's/[[:space:]]*\([<=][=>]\)[[:space:]]*/\1/g' | \
    sed -e 's/)[[:space:]]*and[[:space:]]*(/)and(/g' | \
    sed -e 's/)[[:space:]]*or[[:space:]]*(/)or(/g' | \
    sed -e 's/if[[:space:]]*(/if(/g' | \
    sed -e 's/)[[:space:]]*then/)then/g' | \
    sed -e 's/[[:space:]]*\([=><+*\/()-]\)[[:space:]]*/\1/g' | \
    sed -e 's/is\([><]\)/is \1/g' | \
    sed -e 's/print[[:space:]]*"/print"/g' | \
    awk 'BEGIN {FS = OFS = "\""} \
      /^[[:blank:]]*$/ {next} \
      {for (i=1; i<=NF; i+=2) gsub(/,[[:space:]]*/,",",$i)} \
      1' | \
    unix2dos > "${2}"
