'Colour Organ by Dan Amos. CFunctions courtesy of Peter Mather, www.thebackshed.com
'Licenses under Attribution-NonCommercial-ShareAlike 3.0 Australia license
'http://creativecommons.org/licenses/by-nc-sa/3.0/au/

SetPin 4,dout
Dim mode = 3
VAR restore
Dim lastmode = mode
Dim i As integer
For i = 1 To 3
  mode = i
  VAR save mode
  Pin(4)=1
  Pause 700
  Pin(4)=0
  Pause 300
Next i
mode = lastmode
VAR save mode

Dim n As integer
Dim sc As float
n = 64
Dim a(n-1)
Dim v(1,n-1)
Dim c(1),z(1)
Dim q(8), w(5)

WS2812.INIT(16,8)
SetPin 2,ain
Do
  For i = 0 To n-1:a(i)=Pin(2):Next i
  For i = 0 To n-1:v(0,i)=a(i):v(1,i)=0: Next i
  fft n,v()

  For i=1 To n/2-1
    c(0) = v(0,i)
    c(1) = v(1,i)
    cmag c(),z()
    a(i) = z(0)
  Next i

  q(0) = a(1)       '0-62
  q(1) = a(2)       '625-188
  q(2) = a(3)       '188-250
  q(3) = a(4)       '250-437
  q(4) = avg(5,7)   '437-750
  q(5) = avg(8,12)   '65750-1.3k
  q(6) = avg(13,20) * 1.5 '870-1.3k - brightness boosted
  q(7) = avg(21,31) * 2 '1.3k-2k
  w(0) = a(1)       '0-62
  w(1) = avg(2,3)   '62-188
  w(2) = avg(4,6)   '188-375
  w(3) = avg(7,14) * 1.5 '375-938
  w(4) = avg(15,31) * 2 '938-2k
  For i = 0 To 7
    q(i) = Cint(q(i) * 8)
    If q(i) > 255 Then q(i) = 255
  Next i
  For i = 0 To 4
    w(i) = Cint(w(i) * 10)
    If i<3 And w(i) < 2 Then w(i) = 0
    If w(i) > 100 Then w(i) = 100
  Next i
If mode > 1 Then
  PWM 1,1000,w(0),w(1),w(2)
  PWM 2,1000,w(3),w(4)
EndIf

If mode =1 Or mode = 3 Then
  ws2812.setcolour(0,q(0),0,0)
  ws2812.setcolour(1,q(1),q(1)/10,0)
  ws2812.setcolour(2,q(2)*.9,q(2)/5,0)
  ws2812.setcolour(3,q(3)*.6,q(3)/2,0)
  ws2812.setcolour(4,0,q(4),0)
  ws2812.setcolour(5,0,q(5)/2,q(5)/2)
  ws2812.setcolour(6,0,0,q(6))
  ws2812.setcolour(7,q(7),0,q(7)/2)
  outputleds
EndIf
Loop
End

Function avg(f, t)
Local n = 0
Local i = 0
For i = f To t
n = n + a(i)
Next i
avg = n / (t-f)
End Function

CSub FFT 'In place FFT for 2^n datasets
    00000028
    'cos
    27BDFFE0 3C039D00 AFB20018 8C62009C 00809021 3C043FC9 AFBF001C AFB10014
    AFB00010 24840FDB 8C70006C 0040F809 8C710060 00402021 0220F809 02402821
    00402021 0200C821 8FBF001C 8FB20018 8FB10014 8FB00010 03200008 27BD0020
    'Re
    000420C0 00A42021 03E00008 8C820000
    'Im
    000420C0 00A42021 03E00008 8C820004
    'setRe
    000420C0 00C42021 03E00008 AC850000
    'setIm
    000420C0 00C42021 03E00008 AC850004
    'main
    27BDFF88 AFB40060 AFB3005C 8C940000 3C139D00 8E620040 AFBF0074 001420C0
    AFBE0070 AFB7006C AFB60068 AFB50064 AFB20058 AFB10054 AFB00050 0040F809
    00A08021 00408821 00141880 02231821 8E62009C 3C044049 AFA30034 0040F809
    24840FDB 00409021 8E620080 00142FC3 02802021 8E770070 8E760064 8E74007C
    0040F809 8E75005C 02E0F809 00402021 0040B821 8E62009C 3C044000 0040F809
    8E7E0070 03C0F809 00402021 00402821 02C0F809 02E02021 0040B021 3C043EFF
    8E62009C 0040F809 3484F2E5 00402821 02A0F809 02C02021 0280F809 00402021
    2444FFFF 1880017D AFA20040 00001021 24130002 24420001 0044182A 1460FFFD
    00139840 8FA20040 00131843 000227C2 00822021 00042043 00446823 00133083
    25A5FFFF AFA30038 18A00170 AFA60018 24020002 AFA20010 00001021 8FA60010
    24420001 00063040 0045182A 1460FFFB AFA60010 2484FFFF 18800162 00001021
    24160002 24420001 0044182A 1460FFFD 0016B040 19A0001F AE200000 8FA50010
    24090001 240C0001 00055FC2 01655821 8FA30010 000B5843 006B5023 014B102A
    1440000E 000B1080 01652021 00053080 02201821 02221021 8C680000 00852021
    00853823 01284021 0147382A AC480000 00661821 10E0FFF8 00461021 258C0001
    01AC102A 14400003 00094840 1000FFE6 01602821 3C149D00 8E82009C 3C044000
    8E950064 0040F809 8E970058 00402821 02E0F809 02402021 00409021 8E820080
    02602021 0040F809 00132FC3 00402821 02A0F809 02402021 8FA40018 0480002B
    0040A821 00009021 3C139D00 8E620080 02402021 00122FC3 0040F809 8E740058
    00402021 0280F809 02A02821 00402021 0411FF3B 00000000 8FA50034 00121880
    0040A021 00A31821 8E620060 00002021 02802821 0040F809 AC740000 8FA60038
    8FA30034 00D22023 00042080 00642021 8E630060 02802821 AC820000 0060F809
    00002021 8FA50038 8FA60034 02452021 8FA50018 00042080 26520001 00C42021
    00B2182A 1060FFD9 AC820000 0220F021 0000B821 AFA00014 0220A821 10000004
    00009021 0256102A 10400034 26B50004 8EB40000 8FC20000 72D41802 02F29821
    0062A021 0274102A 1040FFF6 26520001 02802021 02002821 0411FF21 00000000
    02602021 02002821 AFA20048 0411FF1C 00000000 00402821 02802021 02003021
    0411FF1F 00000000 8FA30048 02003021 00602821 02602021 0411FF19 00000000
    02802021 02002821 0411FF11 00000000 02602021 02002821 AFA20048 0411FF0C
    00000000 00402821 02802021 02003021 0411FF0F 00000000 8FA30048 02602021
    00602821 02003021 0411FF09 00000000 0256102A 1440FFCE 26B50004 8FA40014
    8FA50010 24840001 0085102A AFA40014 02F6B821 1440FFC0 27DE0004 8FA60040
    18C000AA 8FA30018 8FA50034 00031080 24040001 00A21021 AFA0003C AFA40020
    AFA20044 3C119D00 8FA30038 8FA40020 8FA60034 0064001A 008001F4 8FA20044
    00042840 AFA50028 AFA60018 AFA2001C AFA0002C 00001812 AFA30024 00031880
    AFA30030 8FA40024 1880007B 8FA3002C 8FB2002C 0000A021 02402021 02002821
    0411FECF 00000000 8FA60020 02402021 02002821 02469821 AFA20010 0411FECC
    00000000 0040B821 8FA20018 02602021 8C560000 02002821 8E350058 0411FEC0
    00000000 00402821 02A0F809 02C02021 8FA3001C 02602021 8C760000 02002821
    0040F021 8E350058 0411FEB9 00000000 00402821 02A0F809 02C02021 8FA4001C
    02002821 8C960000 02602021 8E350058 AFA20014 0411FEAA 00000000 00402821
    02A0F809 02C02021 8FA50018 02602021 8CA30000 02002821 8E350058 0040B021
    AFA30048 0411FEA2 00000000 8FA30048 00402821 02A0F809 00602021 8E230060
    0040A821 8FA40010 8E22005C 03C02821 0040F809 AFA30048 8FA30048 8FA50014
    0060F809 00402021 00402821 02003021 02402021 0411FE92 00000000 8E23005C
    02E02021 02C02821 0060F809 AFA30048 8FA30048 00402021 0060F809 02A02821
    00402821 02003021 02402021 0411FE88 00000000 8E230060 8E22005C 8FA40010
    8FA50014 0040F809 AFA30048 8FA30048 03C02821 0060F809 00402021 00402821
    02003021 02602021 0411FE75 00000000 8E3E0060 02E02021 03C0F809 02C02821
    00402021 03C0F809 02A02821 00402821 02003021 02602021 0411FE6D 00000000
    8FA60028 8FA20024 26940001 1682FF8A 02469021 8FA3002C 8FA40020 24630001
    8FA50018 8FA60030 AFA3002C 0064102A 8FA3001C 00A62821 00661821 AFA50018
    1440FF78 AFA3001C 8FA4003C 8FA50040 24840001 0085102A 10400004 AFA4003C
    8FA60028 1000FF60 AFA60020 8FBF0074 8FBE0070 8FB7006C 8FB60068 8FB50064
    8FB40060 8FB3005C 8FB20058 8FB10054 8FB00050 03E00008 27BD0078 1000FE89
    24130002 1000FEA3 24160002 24020002 1000FE98 AFA20010
End CSub

CSub cmag
    00000000
    27BDFFD0 AFB10018 AFB00014 00808821 3C109D00 8C840000 8E020058 AFBF002C
    AFB50028 AFB40024 AFB30020 AFB2001C 00A09021 00802821 8E130074 0040F809
    8E14005C 8E240004 0040A821 8E020058 0040F809 00802821 00402821 0280F809
    02A02021 00408821 8E02009C 0040F809 3C043F00 00402821 0260F809 02202021
    8FBF002C AE420000 8FB50028 8FB40024 8FB30020 8FB2001C 8FB10018 8FB00014
    03E00008 27BD0030
End CSub

Sub OutputLeds
  Local integer i
  i= WS2812.pulses(NUMLEDS,portnum,pinnum,colours(),buffer())
End Sub

CFunction WS2812.Pulses
     00000000
     8fa30010 24020001 8ccc0000 01826004 8ca60000 14c20003 8ca50004 10a00009
     3c0ebf88 24020002 14c20003 3c0ebf88 50a00007 25cd6234 25cd6034 10000005
     25ce6038 25cd6134 10000002 25ce6138 25ce6238 34058000 3c02bf80 ac450600
     8c820004 1c400005 8c880000 14400025 00000000 11000023 00000000 0060c021
     00007821 1000001c 240bffff 30490020 8ce80004 00085040 00022827 00aa5004
     8ce50000 00452806 01452825 00484007 0109280b 30a50001 a0c50000 2442ffff
     144bfff2 24c60001 25ef0001 8c880000 8c820004 27180018 000f2fc3 00a2302a
     14c00005 24e70008 14450006 01e8482b 11200004 00000000 03003021 1000ffe3
     24020017 5c400006 3c02bf80 1440000b 3c05bf80 2d08001d 15000008 3c02bf80
     8c460c00 3c05ffff 24a57fff 00c52824 ac450c00 10000006 8c820000 8ca20c10
     2c420065 1040fffd 00000000 8c820000 000228c0 00021140 00453823 10e00025
     00001021 3c05bf80 00623021 90c60000 10c0000f 00000000 adcc0000 aca00610
     8ca60610 2cc60019 14c0fffd 00000000 adac0000 aca00610 8ca60610 2cc6000d
     14c0fffd 00000000 1000000e 24420001 adcc0000 aca00610 8ca60610 2cc60005
     14c0fffd 00000000 adac0000 aca00610 8ca60610 2cc60014 14c0fffd 00000000
     24420001 1447ffe1 00623021 10000003 8c830004 00e01021 8c830004 5c600008
     3c03bf80 14600009 00000000 8c830000 2c63001d 14600005 00000000 3c03bf80
     8c640c00 34848000 ac640c00 adac0000 03e00008 00001821
End CFunction

Sub WS2812.setcolour(led As integer, red As integer, green As integer, blue As integer)
  Local integer r, g, b
  r = red / 3
  g = green / 1.5
  b = blue
  colours(led)= ((g And &HFF)<<16) + ((r And &HFF)<<8) + (b And &HFF)
End Sub

Function WS2812.getpin(MMpin As integer,portnum As integer,pinnum As integer) As integer
  Const  P28$="N/AA00A01B00B01B02B03N/AA02A03B04A04N/AB05B06B07B08B09 N/AN/AB10B11B12B13B14B15N/AN/A"
   Const  P40$="B09C06C07C08C09N/AN/AB10B11B12B13A10A07B14B15N/AN/AN/A A00A01B00B01B02B03C00C01C02N/AN/AA02A03A08B04A04A09C03C04C05 N/AN/AB05B06B07B08"
  Local integer i
  Local a$ length 3
  i=(MMpin-1)*3 +1
  If (Peek(word &HBF80F220) And &HFFFFFFF) = &H6610053 Then
    If MMpin>=1 And MMpin<=28 Then
      a$=Mid$(p28$,i,3)
    Else
      a$="N/A"
    EndIf
  Else
    If MMpin>=1 And MMpin<=40 Then
      a$=Mid$(p40$,i,3)
    Else
      a$="N/A"
    EndIf
  EndIf
  If a$="N/A" Then
     WS2812.getpin=0
  Else
     portnum=Asc(Left$(a$,1))-65
     pinnum=Val(Right$(a$,2))
     WS2812.getpin=1
  EndIf
End Function

Sub WS2812.INIT(LED_PIN As integer,nLEDs As INTEGER)
  CPU 48
  Dim INTEGER NUMLEDS=nLEDS
  Dim integer buffer(NUMLEDS*3-1)
  Dim INTEGER colours(NUMLEDS)
  Dim integer portnum,pinnum
  SetPin LED_PIN,dout
  Local INTEGER i;
  For i = 0 To numleds: colours(i)=0: Next i
  i=WS2812.getpin(LED_PIN,portnum,pinnum)
  outputleds
End Sub                                                                                                           