#include "uart.h"

char debugOn=0;

char* scanSerial(void){
    static char b[SCAN_LEN]="";
    static int p=0;
	char d;
	if(p==0){b[p]=0;} //if data has been read out, reset
	while(uartAvailable()){
		d=uartReceive();
        if(d=='~'){        //instant action
            d=0;           //reset
        }
        if(d=='\\'){        //instant action
            if(debugOn){
                debugOn=0;
            }else{
                debugOn=1;
            }
            d=0;           //reset
        }
        if(d>=' '){
          if(p<SCAN_LEN-2){
            b[p]=d;
            p++;
            b[p]=0; //null term
            uartSend(d);
          }
        }else{
          if(d==BACKSPACE){  //backspace
            if(p){
              p--;
              b[p]=0; //delete last
              uartSend(BACKSPACE);    //back up
              uartSend(' ');  		 //blank
              uartSend(BACKSPACE);    //back up again
            }
          }
          if(d==13){
              //uartSends(b);
              uartSends("\r\n");
              p=0;
              return b;
          }
		}
	}
  return 0;
}

void uartDeInit(void){
    TX1STA=0;           //reset    
    RC1STA=0;           //reset
    anselbits.UART_TX_PIN=0;
    trisbits.UART_TX_PIN=1;    //input, should be pulled low by inactive module
    anselbits.UART_RX_PIN=0;
    trisbits.UART_RX_PIN=1;
    wpubits.UART_RX_PIN=0;    //input, should be pulled low by inactive module
}

void uartInit(unsigned int b){  //b=baud rate constant
    rx_head=0;
    rx_tail=0;
    rx_head=0;
    rx_tail=0;         
    //PPS: UART_TX_PIN and UART_RX_PIN
    unsigned char iflag;
    iflag=INTCON;               //save interrupt flags
    INTCONbits.GIE=0;           //disable interrupts globally
    PPSLOCK=0x55;
    PPSLOCK=0xAA;
    PPSLOCKED=0;
    pps.UART_TX_PIN=0x13;   //TX1
    RX1PPS=UART_RX_PIN;     //RX1
    PPSLOCKED=1;
    INTCON=iflag;               //restore interrupts    
    //PINS
    anselbits.UART_TX_PIN=0;
    trisbits.UART_TX_PIN=0;
    anselbits.UART_RX_PIN=0;
    trisbits.UART_RX_PIN=1;
    wpubits.UART_RX_PIN=1;
    //TX
    TX1STA=0;           //reset, async mode
    //TX1STAbits.SYNC=0;  //async mode
    TX1STAbits.TXEN=1;  //TX on
    //BAUD/COMMON
    BAUD1CON=8;         //16bit BRG, low speed
    TX1STAbits.BRGH=1;  //high speed
    SP1BRG=b;           //8e6/b=>baudrate assuming 8MHz
    //RX
    RC1STA=0;           //reset
    RC1STAbits.CREN=1;  //enable receive
    RC1STAbits.SPEN=1;  //enable serial port
    //INTERRUPTS
    RC1IE=1;
    PEIE=1;         //allow interrupts, GIE set in main
    //TXIE is set when there is data in buffer
}

void uartSend(char c){      //add to txbuf
    //implementation could possibly write directly to output, but not tested working
    while(((tx_head+1)%BUFSIZE)==tx_tail){} //blocking till buffer free
    TX1IE=0;                                //disable while we add to avoid buffer corruption
    txbuf[tx_head]=c;                       //add to queue
    tx_head=(tx_head+1)%BUFSIZE;            //increment pointer
    TX1IE=1;                                //enable interrupts again (or any time there is data)
}

void uartSends(char* c){    //char array
    while(*c){
        uartSend(*c);
        c++;
    }
}

unsigned char uartAvailable(void){   //bytes to receive in rxbuf
    return (unsigned char)((rx_head+BUFSIZE-rx_tail)%BUFSIZE);    
}

char uartReceive(void){     //take from rxbuf
  char c;
  if(rx_head==rx_tail){
      return 0xFF;    //empty
  }
  c=rxbuf[rx_tail];
  rx_tail=(rx_tail+1)%BUFSIZE;
  return c;    
}

void uartISR(void){
    char d;
    if(RC1IF && RC1IE){
        if(RC1STAbits.OERR){RC1STAbits.CREN=0;RC1STAbits.CREN=1;}   //reset overflow error (serious, but better than locking up)
        RC1IF=0;           //clear flag
        d=RC1REG;        //do read
        if(((rx_head+1)%BUFSIZE)!=rx_tail){ //avoid overflow by dropping
            rxbuf[rx_head]=d;
            rx_head=(rx_head+1)%BUFSIZE;
        }
    }
    if(TX1IF && TX1IE){
       if(tx_head!=tx_tail){    //data in buffer
           TX1REG=txbuf[tx_tail];
           tx_tail=(tx_tail+1)%BUFSIZE;
       }else{
           TX1IE=0;              //no more data, shut down
       }
    }
    
}