#ifndef TIMEDATE_H
#define	TIMEDATE_H
//time and date utilites based on day serial unsigned int d, where 1= 1/1/2000
//Should work until year 2179 (GPS etc will probably fail before then), when 16-bit serials overflow

#include <xc.h> // include processor files - each processor file is guarded.  
typedef enum {
    SUNDAY=0,
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    REPEAT,
    ALARM_ON
} dayOfWeek_t;

typedef enum {
    JANUARY=0,  //NB months are zero-based
    FEBRUARY,
    MARCH,
    APRIL,
    MAY,
    JUNE,
    JULY,
    AUGUST,
    SEPTEMBER,
    OCTOBER,
    NOVEMBER,
    DECEMBER            
} monthOfYear_t;

typedef enum{
    DST_END=0,
    DST_START
} DSTeventType_t;

typedef enum{
    DST_ACTIVE=1,
    DST_ENDS,
    DST_INACTIVE,
    DST_STARTS
} DSTstatus_t;

typedef struct {
    unsigned char year;   //2000=0
    monthOfYear_t month;  //Jan=0
    unsigned char date;   //1st =1 (ie 1/1/2000=1)
    //unsigned char day;    //SUN = 0
    dayOfWeek_t day;    //SUN = 0
} calDate_t;

typedef struct {
    unsigned char hour;
    unsigned char minute;
    unsigned char second;
} timeOfDay_t;

typedef struct{
    unsigned int serial;
    timeOfDay_t time;
} timeAndDate_t;

typedef struct{
    calDate_t      date;    //note that year is usually ignored and thus day does not match; see getNextDOW()
    dayOfWeek_t     day;    //SUN = 0
} DSTevent_t;

typedef struct{
    unsigned char hour;     //eg 2 for 2am
    signed char dstAdjust; //blocks of 15min, can handle +-31 hours eg +4 for 1 hour
    DSTevent_t start;
    DSTevent_t end;    
} tzDST_t;          //DST settings associated with a timezone

typedef struct{
    signed char offset;    
    tzDST_t* dst;   //or null for no DST
} timeZone_t;

typedef struct{
    unsigned char sun;
    unsigned char mon;
    unsigned char tue;
    unsigned char wed;
    unsigned char thu;
    unsigned char fri;
    unsigned char sat;
    unsigned char repeat;
    unsigned char on;
    timeOfDay_t time;
} alarm_t;

typedef union{      //union to allow serial access
    alarm_t a;
    char c[11];
} alarmU_t;

extern const char daysOfWeek[9][4]; //tdDay => zero = Sunday, extras align with alarm settings
extern const char daysInMonth[12];
extern const char daysInMonthLY[12];
extern const char monthsOfYear[12][4];

calDate_t getYMD(unsigned int n);      //put values into tdYear,tdMonth,tdDate,tdDay
unsigned int getSerial(calDate_t d);   //return serial based on tdYear,tdMonth,tdDate,tdDay
char isLeapYear(char n);                //1 for leap year, 0 for not
timeAndDate_t fixTOD(timeAndDate_t t);      //adjust overflows
timeOfDay_t timeFromGPS(const char* s); //get time from GPS HHMMSS.000 string
calDate_t datefromGPS(const char* s);  //get date from GPS DDMMYY string
void setDayOfWeek(calDate_t* t);       //update day of week from DD/MM/YY
timeAndDate_t fixTZoffset(timeAndDate_t in, signed char min15);   //adjust in by 15min blocks
char countDowncdTimer(void);        //fixed version for cdTimer, avoids pointer etc
char countDown(timeOfDay_t* t);     //take one second off and handle borrow, returns true on expiry (0:0:0)
calDate_t getNextDOW(calDate_t t0, dayOfWeek_t d);    //find next date matching the day-of-week d on/after t0, eg 0=> Fri 1st becomes Sun 3rd
unsigned int getDSTevent(calDate_t t0, DSTevent_t e);   //find next DSTevent_t after t0
DSTstatus_t getDSTstatus(unsigned int d, DSTevent_t start, DSTevent_t end); //check date d against start and end

#endif	/* TIMEDATE_H */

