//SSD1306/SH1106 OLED implementation for 8-bit PICs
//uses horizontal scanning of fonts and bitmaps to match output order

#ifndef OLED_H
#define OLED_H
#include <xc.h>
#include "portbits.h"

#define I2C_SDA c1
#define I2C_SCL c2
#define OLEDPWR b4

#define USE_EEPROM_X_OFFSET

#ifdef USE_EEPROM_X_OFFSET
extern __eeprom signed char oledXoffset;
#define X_OFFSET_MIN (-10)
#define X_OFFSET_MAX (10)
#endif

#define OLED_ADDRESS 0x78   //8bit write address, read address is +1
//#define OLED_ADDRESS 0x7A   //8bit write address, read address is +1

//for flippable text display
#define TEXT_RH 1
#define TEXT_LH 2
#define OLED_CONNECTOR_AT_TOP 1
#define OLED_CONNECTOR_AT_BOTTOM 2

extern unsigned char col,page; //column variable
extern unsigned char dbuf[11];  //for numeric displays

//soft I2C:
void I2Cstop(void);
void I2Cstart(void);        //assume in valid state
void I2Cinit(void);
void I2Cdeinit(void);         //power off, not much point unless OLEDPWR is defined
void I2Cbyte(unsigned char n);  //send byte, unrolled inline version is slightly faster
void I2Cbitdelay(void); //adjust to suit processor speed, bus speed etc
//OLED
void OLEDsendCommand(unsigned char c);
void OLEDsendData(unsigned char c);
void OLEDbrightness(unsigned char b);
void OLEDclear(unsigned char c);        //bit pattern c
void OLEDinit(void);
void OLEDsetpage(unsigned char p);
void OLEDsetcolumn(unsigned char c);
void OLEDflip(char c);      //to suit flip orientation according to textFlip
void OLEDchar(const char c,const char* f);//single character, col/page handled internally
void OLEDcharRev(const char c,const char* f);   //reversed
void OLEDchararray(const char* c, const char* f);    //char array version of above
void OLEDbitmap(const char* b); //show bitmap at current column/row
void OLEDscanlong(unsigned long n);
void OLEDscanshort(unsigned int n);     //converts an unsigned int into a decimal
void OLEDsetpos(unsigned char p,unsigned char c);   //set page and column to streamline, needs to occur after address write

#endif  //OLED_H

