#ifndef IO_H
#define	IO_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"

#define FVRBUF1 0b111110 
extern unsigned int adcref,dacref;

//revD
#define S1 c6
#define S2 c0
#define S3 b5
#define S4 b6

#define SPKR_P a2
//#define SPKR_M c6
#define LDRSENSE b7
#define MOD2PWR c7
#define PRESSED(x) (portbits.x==0)


#define DOWN_BUTTON S1
#define UP_BUTTON S2
#define OK_BUTTON S3
#define MODE_BUTTON S4

//sleep modes
//silicon errata say don't use sleep modes
#define SLEEP_DEEP (0)
#define SLEEP_IDLE (0x80)

//DOZEN, recover on int, x256
#define SLEEP_DOZE (0x67)

//PWM tone enable=1, off=0
#define TONE(x) PWM1CONbits.EN=x

void deInitTone(void);
void initTone(void);
void ioInit(void);
void t0init(void);
void initADC(void);
unsigned int getADC(char c);
unsigned int getVCC(void);  //in mV
unsigned int readNVM(unsigned int add);
unsigned int adjust(unsigned int v,unsigned int m);

#endif	/* IO_H */

