#ifndef UART_H
#define	UART_H

#include <xc.h> 
#include "portbits.h"

#define UART_TX_PIN c4
#define UART_RX_PIN c5

#define BRG_9600 (833)
#define BRG_38400 (208)
#define BRG_115200 (69)

//assume main oscillator at 32MHz
#define BUFSIZE 256
char txbuf[BUFSIZE]="";
char rxbuf[BUFSIZE]="";
volatile unsigned char tx_head,tx_tail;
volatile unsigned char rx_head,rx_tail;

extern char debugOn;

#define SCAN_LEN (30)
#define BACKSPACE (8)

char* scanSerial(void);
void uartDeInit(void);          //off
void uartInit(unsigned int b);  //b=baud rate constant
void uartSend(char c);      //add to txbuf
void uartSends(char* c);    //char array
unsigned char uartAvailable(void);   //bytes to receive in rxbuf
char uartReceive(void);     //take from rxbuf
void uartISR(void);         //call from main ISR

#endif	/* UART_H */

