
#ifndef TIMEZONES_H
#define	TIMEZONES_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "timedate.h"
#define FLAG_TZ (-1)
#define CUSTOM_TZ (-2)

extern const char timeZoneNames[][14];
//saved custom set in EEPROM
extern __eeprom timeZone_t EEcustomZone;
extern __eeprom tzDST_t EEdstCustom;
//a usable custom set in RAM, to be copied from EEPROM when necessary
extern timeZone_t customZone;
extern tzDST_t dstCustom;
//fixed TZs
extern const timeZone_t timeZones[];
extern const tzDST_t dstList[];

signed char getOffset(timeAndDate_t t, timeZone_t z, tzDST_t d);   //work out offset based on UTC t and timezone z/rules d   
void saveCust(void);    //back up RAM versions of custom DST settings to EEPROM

#endif	/* TIMEZONES_H */

