#include "timezones.h"

timeZone_t customZone;
tzDST_t dstCustom;

const char timeZoneNames[][14]={
    "SYDNEY       ",
    "BRISBANE     ",
    "ADELAIDE     ",
    "DARWIN       ",
    "PERTH        ",
    "NORFOLK ISL  ",
    "CHRISTMAS ISL",
    "COCOS ISL    ",
    "EUCLA (SA/WA)",
    "NEW ZEALAND  ",
    "CHATHAM ISL  ",
    "CUSTOM       "
};

//__eeprom timeZone_t EEcustomZone={.offset=0,.dst=0}; //set .dst to &dstCustom to use DST custom rules
__eeprom timeZone_t EEcustomZone={.offset=0,.dst=&dstCustom}; //set .dst to 0 to not use DST

__eeprom tzDST_t EEdstCustom={       //a custom set of rules
    .start.date.month=MARCH,       //default to northern hemisphere, eg Europe
    .start.date.date=25,
    .start.day=SUNDAY,
    .end.date.month=OCTOBER,
    .end.date.date=25,
    .end.day=SUNDAY,
    .hour=2,
    .dstAdjust=4
};

const timeZone_t timeZones[]={
    {.offset=40,.dst=&dstList[0]},  //AU Eastern with DST, eg Sydney
    {.offset=40,.dst=0},            //AU Eastern without DST, eg Brisbane
    {.offset=38,.dst=&dstList[0]},  //AU Central with DST, eg Adelaide
    {.offset=38,.dst=0},            //AU Central without DST, eg Darwin
    {.offset=32,.dst=0},            //AU Western without DST, eg Perth
    {.offset=44,.dst=&dstList[0]},  //AU Norfolk Island with DST, eg Kingston
    {.offset=28,.dst=0},            //AU Christmas Island without DST
    {.offset=26,.dst=0},            //AU Cocos Island without DST
    {.offset=35,.dst=0},            //AU Eucla without DST (not officially recognised)        
    {.offset=48,.dst=&dstList[1]},  //NZ with DST, eg Wellington, Auckland, Christchurch
    {.offset=51,.dst=&dstList[1]},  //Chatham Is, NZ with DST, eg Waitangi    
    {.offset=CUSTOM_TZ,.dst=0} ,    //use custom TZ instead
    {.offset=FLAG_TZ,.dst=0}        //EOL marker
};

const tzDST_t dstList[]={       //list of DST rules, don't put first to avoid inadvertent null pointer
    {       //AU rules
    .start.date.month=OCTOBER,
    .start.date.date=1,
    .start.day=SUNDAY,          //1st Sunday in October
    .end.date.month=APRIL,
    .end.date.date=1,
    .end.day=SUNDAY,            //1st Sunday in April
    .hour=2,                    //at 2am UTC
    .dstAdjust=4                //go forward 1hr
    },
    {       //NZ rules
    .start.date.month=SEPTEMBER,
    .start.date.date=24,
    .start.day=SUNDAY,          //last Sunday in September
    .end.date.month=APRIL,
    .end.date.date=1,
    .end.day=SUNDAY,            //1st Sunday in April
    .hour=2,                    //at 2am UTC
    .dstAdjust=4                //go forward 1hr
    }    
};

signed char getOffset(timeAndDate_t t, timeZone_t z, tzDST_t d){   //work out offset based on UTC t and timezone z/rules d   
    signed char r=z.offset;
    t=fixTZoffset(t,r);     //adjust UTC to standard time in this TZ
    if(z.dst){
        switch(getDSTstatus(t.serial,d.start,d.end)){
            case DST_ACTIVE: r=r+d.dstAdjust; break;
            case DST_STARTS:
                if(t.time.hour>=d.hour){r=r+d.dstAdjust;}               
                break;
            case DST_ENDS:
                if(t.time.hour<d.hour){r=r+d.dstAdjust;}               
                break;
            case DST_INACTIVE:
            default:
                break;
        }
    }    
    return r;
}

void saveCust(void){    //back up RAM versions of custom DST settings to EEPROM
    if(customZone.dst){     //make sure pointer points to right place
        customZone.dst=&dstCustom;
    }
    EEcustomZone=customZone;
    EEdstCustom=dstCustom;    
}