//Clock/timer with OLED and 32.768kHz crystal
//See .h files for most pins

#include "config.h"
#include <xc.h>
#include "portbits.h"
#include "io.h"
#include "oled.h"
#include "arial.h"
#include "uart.h"
#include "gps.h"
#include "timedate.h"
#include "timezones.h"
#include "util.h"

//see Properties for _XTAL_FREQ (compiler/preprocessing/define macros) _XTAL_FREQ=(32000000UL)
//globals in util.h/util.c

void main(void) {
    unsigned char i;
    OSCCON3bits.SOSCPWR=0;  //low drive crystal
    OSCENbits.SOSCEN=1;     //SOSC on
    ioInit();
    initADC();
    t0init();       //running from SOSC
    OLEDset(1);
    currentFont=fonts[currentFontN];
    customZone=EEcustomZone;
    dstCustom=EEdstCustom;
    loadTZfromIndex();
    if(timeZones[homeTZindex].offset==CUSTOM_TZ){
        homeTZ=customZone;
    }else{
        homeTZ=timeZones[homeTZindex];
    }                                                    
    if(homeTZ.dst){homeDST=*homeTZ.dst;}
    alarmTone=tonePatterns[alarmToneIndex];
    cdTone=tonePatterns[cdToneIndex];    
    trimSeconds=trimSecondsEEPROM;
    GIE=1;
    CPUDOZE=SLEEP_DEEP;
    //CPUDOZE=SLEEP_IDLE;
    gpsTimer=gpsTimeout;
    gpsCheck(); //check for GPS at boot
    while(1){   //main loop
        vcc=getVCC();           //do this every cycle so we can check it if needed
        i=getADC(LDRSENSE)>>4;  //map to OLED brightness
        if(i>tgtOLEDb){
            tgtOLEDb=tgtOLEDb+5;
            OLEDbrightness(tgtOLEDb);
        }
        if(i<tgtOLEDb){
            tgtOLEDb=tgtOLEDb-5;
            OLEDbrightness(tgtOLEDb);
        }
        if(gpsUpdateNeeded){    //react to flag
            gpsUpdateNeeded=0;
            gpsAsync();
        }
        if(gpsActive){processGPSasync();}
        if(settingsMode){       //settings active
            switch(settingsMode){
                case SETTINGS_START:
                    settingsMode=SETTINGS_DISPLAY; 
                    OLEDclear(0);
                    col=0;
                    page=0;
                    OLEDchararray(settingName[settingsMode],arial);                                                                                
                    break;
                case SETTINGS_DISPLAY:  //font and x-offset
                    if(okClick()){
                        currentFontN=currentFontN+1;
                        if(fonts[currentFontN]==0){currentFontN=0;}
                        currentFont=fonts[currentFontN];                        
                    }     
                    if(upClick()){
                        oledXoffset=oledXoffset+1;
                        if(oledXoffset>X_OFFSET_MAX){
                            oledXoffset=X_OFFSET_MAX;
                        }
                        OLEDclear(0);                    
                    }
                    if(downClick()){
                        oledXoffset=oledXoffset-1;
                        if(oledXoffset<X_OFFSET_MIN){
                            oledXoffset=X_OFFSET_MIN;
                        }
                        OLEDclear(0);                    
                    }
                    col=0;
                    page=0;
                    OLEDchararray(settingName[settingsMode],arial);                                                                                
                    col=10;
                    page=2;
                    OLEDchararray("OK: FONT",arial);
                    col=10;
                    page=4;
                    OLEDchararray("DOWN/UP:",arial);
                    col=10;
                    page=6;
                    OLEDchararray("X-OFFSET",arial);
                    col=0;
                    page=7;
                    OLEDbitmap(pixelsBM);
                    col=88;
                    OLEDchararray("< ",smallFont);
                    OLEDbitmap(pixelsBM);
                    OLEDchararray(" >",smallFont);
                    col=121;
                    OLEDbitmap(pixelsBM);                    
                    col=90;
                    page=2;
                    OLEDscanshort(UTC.time.second);
                    OLEDchar(dbuf[8],currentFont);
                    OLEDchar(dbuf[9],currentFont);
                    break;
                case SETTINGS_GPS:
                    col=65;
                    page=0;
                    OLEDchararray(DOWN_ICON_ESC UP_ICON_ESC ":",arial);                    
                    OLEDscanshort(gpsTimeout);
                    lzBlank(dbuf);
                    OLEDchar(dbuf[7],arial);
                    OLEDchar(dbuf[8],arial);
                    OLEDchar(dbuf[9],arial);                                            
                    page=1;
                    OLEDchar('S',smallFont);                                            
                    col=0;
                    page=2;
                    OLEDchararray("UTC SET TO: ",smallFont);
                    dDisp=getYMD(UTC.serial);                
                    OLEDscanshort(UTC.time.hour);
                    OLEDchar(dbuf[8],smallFont);
                    OLEDchar(dbuf[9],smallFont);                        
                    OLEDchar(':',smallFont);                        
                    OLEDscanshort(UTC.time.minute);
                    OLEDchar(dbuf[8],smallFont);
                    OLEDchar(dbuf[9],smallFont);
                    OLEDchar(':',smallFont);                        
                    OLEDscanshort(UTC.time.second);
                    OLEDchar(dbuf[8],smallFont);
                    OLEDchar(dbuf[9],smallFont);
                    col=0;
                    page=3;
                    OLEDchar(daysOfWeek[dDisp.day][0],smallFont);
                    OLEDchar(daysOfWeek[dDisp.day][1],smallFont);
                    OLEDchar(daysOfWeek[dDisp.day][2],smallFont);
                    OLEDchar(' ',smallFont);                        
                    OLEDscanshort(dDisp.date);
                    OLEDchar(dbuf[8],smallFont);
                    OLEDchar(dbuf[9],smallFont);
                    OLEDchar(' ',smallFont);                        
                    OLEDchar(monthsOfYear[dDisp.month][0],smallFont);
                    OLEDchar(monthsOfYear[dDisp.month][1],smallFont);
                    OLEDchar(monthsOfYear[dDisp.month][2],smallFont);
                    OLEDscanshort(dDisp.year+2000);
                    OLEDchar(' ',smallFont);                        
                    OLEDchar(dbuf[6],smallFont);
                    OLEDchar(dbuf[7],smallFont);            
                    OLEDchar(dbuf[8],smallFont);
                    OLEDchar(dbuf[9],smallFont);            
                    col=22;
                    page=4;
                    OLEDchararray("TRIM: ",arial);                
                    if(trimSeconds<0){
                        OLEDchar('-',arial);
                        OLEDscanshort(-trimSeconds);
                    }else{
                        OLEDchar(' ',arial);
                        OLEDscanshort(trimSeconds);                        
                    }
                    lzBlank(dbuf);
                    OLEDchar(dbuf[8],arial);
                    OLEDchar(dbuf[9],arial);                                
                    col=9;
                    page=6;
                    OLEDchararray("<OK>: GET GPS",arial);                
                    if(okClick()){
                        OLEDclear(0);
                        gpsOK=0;
                        gpsTimer=gpsTimeout;
                        gpsCheck();
                        OLEDclear(0);
                        col=0;
                        page=0;
                        OLEDchararray(settingName[settingsMode],arial);
                    }
                    if(downClick()){
                        if(gpsTimeout>14){
                            gpsTimeout=gpsTimeout-15;
                        }else{
                            gpsTimeout=0;
                        }
                    }
                    if(upClick()){
                        if(gpsTimeout<241){
                            gpsTimeout=gpsTimeout+15;
                        }else{
                            gpsTimeout=255;
                        }
                    }
                    break;                    
                case SETTINGS_TONES:
                    setTone(1);
                    if(okClick()){
                        subSetIndex=subSetIndex^1;  //only two                        
                    }
                    col=0;
                    page=2;
                    OLEDchararray("OK TO SELECT",smallFont);
                    col=0;
                    page=3;
                    OLEDchararray("UP/DOWN TO EDIT",smallFont);
                    col=0;
                    page=4;
                    switch(subSetIndex){
                        case 0: 
                            if(upClick()){
                                if(cdToneIndex<(TONE_PATTERN_COUNT-1)){cdToneIndex=cdToneIndex+1;}
                            }
                            if(downClick()){
                                if(cdToneIndex>0){cdToneIndex=cdToneIndex-1;}
                            }                            
                            OLEDchararray("TIMER TONE",arial);
                            col=0;
                            page=6;
                            OLEDchararray(toneNames[cdToneIndex],arial);
                            cdTone=tonePatterns[cdToneIndex];    
                            nextTone=cdTone;
                            break;
                        case 1: 
                            if(upClick()){
                                if(alarmToneIndex<(TONE_PATTERN_COUNT-1)){alarmToneIndex=alarmToneIndex+1;}
                            }
                            if(downClick()){
                                if(alarmToneIndex>0){alarmToneIndex=alarmToneIndex-1;}
                            }                            
                            OLEDchararray("ALARM TONE",arial);
                            col=0;
                            page=6;
                            OLEDchararray(toneNames[alarmToneIndex],arial);
                            alarmTone=tonePatterns[alarmToneIndex];
                            nextTone=alarmTone;
                            break;
                        default:
                            subSetIndex=0;  //out of range, reset
                            break;
                    }
                    break;
                case SETTINGS_CUSTTZ:
                    col=0;
                    page=2;
                    OLEDchararray("OK TO SELECT",smallFont);
                    col=0;
                    page=3;
                    OLEDchararray("UP/DOWN TO EDIT",smallFont);
                    if(okClick()){
                        subSetIndex=subSetIndex+1;
                        if(subSetIndex==TZSET_DUMMY){subSetIndex=0;}
                        saveCust();     //keep EEPROM up to date
                    }
                    col=0;
                    page=4;
                    OLEDchararray(tzSettingNames[subSetIndex],arial);
                    col=0;
                    page=6;
                    switch(subSetIndex){
                        case TZSET_HOME:
                            if(downClick()){
                                if(homeTZindex>0){
                                    homeTZindex=homeTZindex-1;
                                    if(timeZones[homeTZindex].offset==CUSTOM_TZ){
                                        homeTZ=customZone;
                                    }else{
                                        homeTZ=timeZones[homeTZindex];
                                    }                                                    
                                    if(homeTZ.dst){homeDST=*homeTZ.dst;}
                                }
                            }
                            if(upClick()){
                                homeTZindex=homeTZindex+1;
                                if(timeZones[homeTZindex].offset==FLAG_TZ){homeTZindex=homeTZindex-1;}
                                if(timeZones[homeTZindex].offset==CUSTOM_TZ){
                                    homeTZ=customZone;
                                }else{
                                    homeTZ=timeZones[homeTZindex];
                                }                        
                                if(homeTZ.dst){homeDST=*homeTZ.dst;}
                            }
                            OLEDchararray(timeZoneNames[homeTZindex],smallFont);
                            OLEDchararray("      ",smallFont);                            
                            col=0;
                            page=7;
                            OLEDchararray("UTC",smallFont);
                            tzScan(homeTZ.offset);                            
                            OLEDchararray((char*)(dbuf+4),smallFont);                               
                            if(homeTZ.dst){
                                OLEDchararray(" DST       ",smallFont);
                            }else{
                                OLEDchararray(" NO DST    ",smallFont);
                            }                            
                            break;
                        case TZSET_OFFSET:
                            if(upClick()){
                                customZone.offset=customZone.offset+1;
                                if(customZone.offset>60){customZone.offset=60;}
                            }
                            if(downClick()){
                                customZone.offset=customZone.offset-1;
                                if(customZone.offset<-60){customZone.offset=-60;}
                            }
                            OLEDchararray("UTC",arial);
                            tzScan(customZone.offset);                            
                            OLEDchararray((char*)(dbuf+4),arial);   
                            OLEDchararray("    ",arial);                            
                            break;
                        case TZSET_DST_TRUE:
                            if(customZone.dst==0){
                                if(upClick()){customZone.dst=&dstCustom;}                                
                                OLEDchararray("NO " "          ",arial);    //splitting calls doesn't save flash in this case
                            }else{
                                if(downClick()){customZone.dst=0;}
                                OLEDchararray("YES" "          ",arial);
                            }
                            break;
                        case TZSET_START_M:
                            setCustTZmonth(&dstCustom.start);
                            break;
                        case TZSET_START_D:
                            setCustTZday(&dstCustom.start);
                            break;
                        case TZSET_END_M:
                            setCustTZmonth(&dstCustom.end);
                            break;
                        case TZSET_END_D:
                            setCustTZday(&dstCustom.end);
                            break;
                        default:
                            subSetIndex=0;
                            break;
                    }
                    break;
                case SETTINGS_EXIT:
                    col=1;
                    page=2;
                    if(trisbits.MOD2PWR){
                        OLEDchararray("GPS: " DOWN_ICON_ESC "TURN OFF",arial);                                        
                    }else{
                        OLEDchararray("GPS: " UP_ICON_ESC "TURN ON ",arial);                                        
                    }
                    col=14;
                    page=4;
                    OLEDchararray("PRESS OK TO",arial);                
                    col=5;
                    page=6;
                    OLEDchararray("EXIT SETTINGS",arial);                
                    if(okClick()){
                        settingsMode=SETTINGS_OFF;
                        OLEDclear(0);
                        if(gpsActive==0){trisbits.MOD2PWR=0;}   //turn off if not running
                        setTone(0); //shut off if running
                    }
                    if(downClick()){trisbits.MOD2PWR=0;}    //force off
                    if(upClick()){trisbits.MOD2PWR=1;}    //let run
                    break; 
                case SETTINGS_OFF:
                case SETTINGS_DUMMY:
                default:
                    break;  //these aren't used for interaction
            }            
            if(PRESSED(MODE_BUTTON)){   //this works globally within settings
                settingsMode=settingsMode+1;
                if(settingsMode==SETTINGS_DUMMY){settingsMode=1;}                
                OLEDclear(0);
                col=0;
                page=0;
                OLEDchararray(settingName[settingsMode],arial);                                                                                
                while(PRESSED(MODE_BUTTON)){}
                __delay_ms(10); //debouncing
                subSetIndex=0;
                setTone(0); //shut off if running
            }
        }else{                      //normal operations
            if(PRESSED(MODE_BUTTON)){   //this works globally within normal operation
                mode=mode+1;
                if(mode==MODE_DUMMY){
                    mode=0;
                }                
                OLEDclear(0);
                while(PRESSED(MODE_BUTTON)){
                    if(modeHold>SETTINGS_TIME){
                        settingsMode=SETTINGS_START;
                        col=0;
                        page=0;
                        OLEDchararray("SETTINGS",arial);                                                                                
                        mode=0; //go back to clock on exit
                    }
                }
                __delay_ms(10); //debouncing
                subSetIndex=0;
            }else{
                modeHold=0;
            }
            switch(mode){
                case CLOCK:                    
                    if(PRESSED(OK_BUTTON)){
                        __delay_ms(300); //detect long press
                        if(PRESSED(OK_BUTTON)){  
                            OLEDclear(0);
                            col=28;
                            page=3;
                            OLEDchararray("SLEEPING",arial);                                                                                
                            while(PRESSED(OK_BUTTON)){} //wait for release
                            alarmSounding=0;    //clear alerts on sleep entry
                            cdDone=0;
                            setTone(0);         //shut down
                            screenOff();
                        }else{
                            if(alarmSounding){  //shut off alarm
                                alarmSounding=0;
                            }else{              //otherwise, toggle 24hr clock
                                tFlag=1;
                                if(clock24==CLOCK_12){
                                    clock24=CLOCK_24;
                                }else{
                                    clock24=CLOCK_12;                            
                                }                            
                            }
                        }
                        __delay_ms(10); //debouncing
                    }
                    if(downClick()){
                        tFlag=1;
                        if(tzIndex>0){
                            tzIndex=tzIndex-1;
                            loadTZfromIndex();
                        }
                    }
                    if(upClick()){
                        tFlag=1;
                        tzIndex=tzIndex+1;
                        if(timeZones[tzIndex].offset==FLAG_TZ){tzIndex=tzIndex-1;}
                        loadTZfromIndex();
                    }
                    if(tFlag){
                        tFlag=0;
                        while(UTC.time.hour>23){
                            UTC.time.hour=UTC.time.hour-24;
                            UTC.serial=UTC.serial+1;
                        }
                        tzOffset=getOffset(UTC,currentTZ,currentDST);
                        local=fixTZoffset(UTC,tzOffset);
                        dDisp=getYMD(local.serial);                
                        col=0;
                        page=0;
                        if(timeZones[tzIndex].offset==CUSTOM_TZ){
                            OLEDchararray("UTC ",smallFont);   
                            tzScan(tzOffset);
                            OLEDchararray((char*)(dbuf+4),smallFont);   
                            OLEDchararray("   ",smallFont);   
                        }else{
                            OLEDchararray(timeZoneNames[tzIndex],smallFont);
                        }      
                        col=84;
                        page=0;
                        if(gpsTimer){   //if GPS running, show status
                            if(gpsOK){
                                OLEDchararray(" LOCK ",smallFont);
                            }else{
                                OLEDchararray(" GPS  ",smallFont);                                
                            }
                        }else{          //otherwise battery
                            if(vcc>4399){       //assume USB power if VCC above 4.4V
                                OLEDchararray(" USB  ",smallFont);
                            }else{
                                OLEDscanshort(vcc);
                                OLEDchar('B',smallFont);
                                OLEDchar('=',smallFont);
                                OLEDchar(dbuf[6],smallFont);
                                OLEDchar('.',smallFont);
                                OLEDchar(dbuf[7],smallFont);
                                OLEDchar('V',smallFont);
                            }
                        }
                        col=0;
                        page=1;
                        if(clock24==CLOCK_24){
                            OLEDscanshort(local.time.hour);
                        }else{
                            OLEDscanshort(((local.time.hour+11)%12)+1);
                        }
                        if(dbuf[8]=='0'){dbuf[8]=SPACE_40;}
                        OLEDchar(dbuf[8],currentFont);
                        OLEDchar(dbuf[9],currentFont);                        
                        OLEDbitmap(colonBM);
                        OLEDscanshort(local.time.minute);
                        OLEDchar(dbuf[8],currentFont);
                        OLEDchar(dbuf[9],currentFont);
                        OLEDbitmap(colonBM);
                        OLEDscanshort(local.time.second);
                        OLEDchar(dbuf[8],currentFont);
                        OLEDchar(dbuf[9],currentFont);
                        col=120;
                        page=3;
                        if(clock24==CLOCK_24){
                            OLEDchar(' ',arial);
                        }else{
                            if(local.time.hour<12){
                                OLEDchar('A',arial);
                            }else{
                                OLEDchar('P',arial);                            
                            }
                        }
                        col=0;
                        page=6;
                        //setDayOfWeek(&dUTC);
                        OLEDchar(daysOfWeek[dDisp.day][0],arial);
                        OLEDchar(daysOfWeek[dDisp.day][1],arial);
                        OLEDchar(daysOfWeek[dDisp.day][2],arial);
                        col=34;
                        OLEDscanshort(dDisp.date);
                        lzBlank(dbuf);
                        OLEDchar(dbuf[8],arial);
                        OLEDchar(dbuf[9],arial);
                        col=58;
                        OLEDchar(monthsOfYear[dDisp.month][0],arial);
                        OLEDchar(monthsOfYear[dDisp.month][1],arial);
                        OLEDchar(monthsOfYear[dDisp.month][2],arial);
                        col=91;
                        OLEDscanshort(dDisp.year+2000);
                        OLEDchar(dbuf[6],arial);
                        OLEDchar(dbuf[7],arial);            
                        OLEDchar(dbuf[8],arial);
                        OLEDchar(dbuf[9],arial);            

                    }
                    break;
                case TIMER:
                    switch(cdMode){
                        case CD_TIME:
                            if(okClick()){cdMode=CD_SETH;}
                            col=0;
                            page=2;
                            OLEDscanshort(cdTimer.hour);
                            OLEDchar(dbuf[8],currentFont);
                            OLEDchar(dbuf[9],currentFont);                        
                            OLEDbitmap(colonBM);
                            OLEDscanshort(cdTimer.minute);
                            OLEDchar(dbuf[8],currentFont);
                            OLEDchar(dbuf[9],currentFont);
                            OLEDbitmap(colonBM);
                            OLEDscanshort(cdTimer.second);
                            OLEDchar(dbuf[8],currentFont);
                            OLEDchar(dbuf[9],currentFont);
                            col=0;
                            page=0;
                            if(cdDone){
                                cdTimerRunning=0;
                                OLEDchararray(DOWN_ICON_ESC "RESET       ",arial);                                                        
                                col=0;
                                page=7;
                                OLEDchararray("TIMER ",smallFont);                                                        
                                OLEDchararray("FINISHED",smallFont);                                                        
                                if(downClick()){
                                    cdDone=0;
                                    cdTimer=cdPreset;
                                }
                            }else{
                                if(cdTimerRunning){
                                    if(upClick()){cdTimerRunning=0;}                                
                                    OLEDchararray("       " UP_ICON_ESC "PAUSE",arial);                                                            
                                }else{
                                    if(upClick()){cdTimerRunning=1;}                                
                                    if(downClick()){cdTimer=cdPreset;}                                
                                    OLEDchararray(DOWN_ICON_ESC "RESET " UP_ICON_ESC "RUN  ",arial);                            
                                }
                                col=0;
                                page=7;
                                OLEDchararray("TIMER ",smallFont);                                                        
                                if(cdTimerRunning){
                                    OLEDchararray("RUNNING ",smallFont);                                                        
                                }else{
                                    OLEDchararray("PAUSED  ",smallFont);                                                        
                                }
                            }
                            break;
                        case CD_SETH:
                            if(okClick()){cdMode=CD_SETM;}
                            while(PRESSED(UP_BUTTON)){
                                if(cdPreset.hour<99){
                                    cdPreset.hour=cdPreset.hour+1;
                                    cdTimerSetDisp();
                                }
                                __delay_ms(BUTTON_REPEAT_DELAY);                                
                            }
                            while(PRESSED(DOWN_BUTTON)){
                                if(cdPreset.hour>0){
                                    cdPreset.hour=cdPreset.hour-1;
                                    cdTimerSetDisp();
                                }
                                __delay_ms(BUTTON_REPEAT_DELAY);                                
                            }
                            cdTimerSetDisp();
                            break;
                        case CD_SETM:
                            if(okClick()){cdMode=CD_SETS;}
                            while(PRESSED(UP_BUTTON)){
                                if(cdPreset.minute<59){
                                    cdPreset.minute=cdPreset.minute+1;
                                    cdTimerSetDisp();
                                }
                                __delay_ms(BUTTON_REPEAT_DELAY);                                
                            }
                            while(PRESSED(DOWN_BUTTON)){
                                if(cdPreset.minute>0){
                                    cdPreset.minute=cdPreset.minute-1;
                                    cdTimerSetDisp();
                                }
                                __delay_ms(BUTTON_REPEAT_DELAY);                                
                            }
                            cdTimerSetDisp();
                            break;
                        case CD_SETS:
                            if(okClick()){cdMode=CD_TIME;}
                            while(PRESSED(UP_BUTTON)){
                                if(cdPreset.second<59){
                                    cdPreset.second=cdPreset.second+1;
                                    cdTimerSetDisp();
                                }
                                __delay_ms(BUTTON_REPEAT_DELAY);                                
                            }
                            while(PRESSED(DOWN_BUTTON)){
                                if(cdPreset.second>0){
                                    cdPreset.second=cdPreset.second-1;
                                    cdTimerSetDisp();
                                }
                                __delay_ms(BUTTON_REPEAT_DELAY);                                
                            }
                            cdTimerSetDisp();
                            break;
                        default:
                            cdMode=CD_TIME;
                            break;
                    }
                    break;
                case STOPWATCH:
                    col=0;
                    page=7;
                    OLEDchararray("STOPWATCH ",smallFont);                                                        
                    if(swRunning){
                        OLEDchararray("RUNNING ",smallFont);                                                        
                        col=0;
                        page=0;
                        OLEDchararray("       " UP_ICON_ESC "PAUSE",arial);                                                            
                        if(upClick()){swRunning=0;}                                
                    }else{
                        OLEDchararray("PAUSED  ",smallFont);                                                        
                        col=0;
                        page=0;
                        OLEDchararray(DOWN_ICON_ESC "RESET " UP_ICON_ESC "RUN  ",arial);                                                        
                        if(upClick()){swRunning=1;}                                
                        if(downClick()){
                            swTimer.hour=0;
                            swTimer.minute=0;
                            swTimer.second=0;
                        }
                    }
                    col=0;
                    page=2;
                    while(swTimer.hour>99){swTimer.hour=swTimer.hour-100;}
                    OLEDscanshort(swTimer.hour);
                    OLEDchar(dbuf[8],currentFont);
                    OLEDchar(dbuf[9],currentFont);                        
                    OLEDbitmap(colonBM);
                    OLEDscanshort(swTimer.minute);
                    OLEDchar(dbuf[8],currentFont);
                    OLEDchar(dbuf[9],currentFont);
                    OLEDbitmap(colonBM);
                    OLEDscanshort(swTimer.second);
                    OLEDchar(dbuf[8],currentFont);
                    OLEDchar(dbuf[9],currentFont);
                    break;
                case ALARM:
                    col=0;
                    page=0;
                    OLEDchararray("ALARM:",arial);                                                        
                    if(alarm.a.on){
                        OLEDchararray("ON ",arial);                                                        
                    }else{
                        OLEDchararray("OFF",arial);                                                                                
                    }
                    if(alarm.a.repeat){
                        OLEDchararray(",RPT",arial);                                                        
                    }else{
                        OLEDchararray("    ",arial);                                                                                
                    }
                    col=0;
                    page=2;
                    for(i=0;i<7;i++){
                        col=i*17;
                        if(alarm.c[i]){
                            OLEDbitmap(solid0916);
                            OLEDcharRev(daysOfWeek[i][0],arial);
                            OLEDbitmap(solid0916);
                        }else{
                            OLEDbitmap(blank0916);
                            OLEDchar(daysOfWeek[i][0],arial);                            
                            OLEDbitmap(blank0916);
                        }
                    }                
                    col=0;
                    page=4;                    
                    if(subSetIndex<9){
                        OLEDchararray(daysOfWeek[subSetIndex],arial);    
                        OLEDchar(':',arial);  
                        if(alarm.c[subSetIndex]){
                            OLEDchararray("<ON> ",arial);    
                        }else{
                            OLEDchararray("<OFF>",arial);    
                        }
                    }else{
                        OLEDchararray("SET TIME:",arial);     
                    }
                    col=0;
                    page=6;                    
                    if(clock24==CLOCK_24){
                        OLEDscanshort(alarm.a.time.hour);
                    }else{
                        OLEDscanshort(((alarm.a.time.hour+11)%12)+1);
                    }
                    if(subSetIndex==9){
                        OLEDcharRev(dbuf[8],arial);
                        OLEDcharRev(dbuf[9],arial);                                                
                    }else{
                        OLEDchar(dbuf[8],arial);
                        OLEDchar(dbuf[9],arial);                                                                    
                    }
                    OLEDchar(':',arial);                                                                    
                    OLEDscanshort(alarm.a.time.minute);
                    if(subSetIndex==10){
                        OLEDcharRev(dbuf[8],arial);
                        OLEDcharRev(dbuf[9],arial);                                                
                    }else{
                        OLEDchar(dbuf[8],arial);
                        OLEDchar(dbuf[9],arial);                                                                                        
                    }      
                    if(clock24==CLOCK_24){
                        OLEDchar(' ',arial);
                    }else{
                        if(alarm.a.time.hour<12){
                            OLEDchar('A',arial);
                        }else{
                            OLEDchar('P',arial);                            
                        }                        
                    }                    
                    if(okClick()){
                        subSetIndex=subSetIndex+1;
                        if(subSetIndex>10){subSetIndex=0;}
                    }
                    if(downClick()){
                        if(subSetIndex==10){
                            if(alarm.a.time.minute>0){
                                alarm.a.time.minute=alarm.a.time.minute-1;
                            }else{
                                alarm.a.time.minute=59;  //loop around
                            }
                        }else if(subSetIndex==9){
                            if(alarm.a.time.hour>0){
                                alarm.a.time.hour=alarm.a.time.hour-1;
                            }else{
                                alarm.a.time.hour=23;    //loop around
                            }
                        }else{
                            alarm.c[subSetIndex]=0; //down = off
                            if(subSetIndex==ALARM_ON){alarmSounding=0;}  //shut off alarm if sounding
                        }
                    }
                    if(upClick()){
                        if(subSetIndex==10){
                            if(alarm.a.time.minute<59){
                                alarm.a.time.minute=alarm.a.time.minute+1;
                            }else{
                                alarm.a.time.minute=0;  //loop around
                            }
                        }else if(subSetIndex==9){
                            if(alarm.a.time.hour<23){
                                alarm.a.time.hour=alarm.a.time.hour+1;
                            }else{
                                alarm.a.time.hour=0;    //loop around
                            }
                        }else{
                            alarm.c[subSetIndex]=1; //up = on
                        }
                    }
                    
                    break;                
                default:
                    break;
            }
            col=119;    //top right corner
            page=0;    
            if(cdDone){
                if(alarmSounding){  //both, need to alternate
                    if(UTC.time.second&1){
                        nextTone=cdTone;
                    }else{
                        nextTone=alarmTone;
                    }
                }else{              //cd only
                    nextTone=cdTone;
                }
                setTone(1);
            }else{
                if(alarmSounding){  //alarm only
                    nextTone=alarmTone;
                    setTone(1);
                }else{              //neither
                    setTone(0);
                }                
            }
            if(UTC.time.second&1){
                //OLEDchar(cdDone?HOURGLASS_ICON:' ',arial);
                if(cdDone){
                    OLEDchar(HOURGLASS_ICON,arial);
                }else{
                    OLEDchar(' ',arial);
                }
            }else{
                //OLEDchar(alarmSounding?RING_BELL_ICON:' ',arial);                
                if(alarmSounding){
                    OLEDchar(RING_BELL_ICON,arial);
                }else{
                    OLEDchar(' ',arial);
                }
            }
            doSleep();            
        }
    }
}

void __interrupt() isr(){
    static unsigned int lastSerial=0;
    static unsigned char lastHour=0;
    PIE0bits.IOCIE=0;   //use IOC to 'wake up' but don't need to respond, clear enable to deactivate
    CPUDOZE=0;
    if(PIR0bits.TMR0IF && PIE0bits.TMR0IE){     //once per second        
        PIR0bits.TMR0IF=0;        
        UTC.time.second++;   
        if(UTC.time.minute==5){             //avoid near hour rollover
            if(UTC.serial!=lastSerial){     //flag on day rollover
                lastSerial=UTC.serial;
                gpsUpdateNeeded=1;
            }
            if(UTC.time.hour!=lastHour){
                lastHour=UTC.time.hour;
                hoursAdjust++;
                if(hoursAdjust>TRIM_HOURS_MAX){hoursAdjust=TRIM_HOURS_MAX;} //avoid adjusting trim if no fix for a long time
                trimOffset=trimOffset+trimSeconds;
                if(trimOffset>12){
                    trimOffset=trimOffset-24;
                    UTC.time.second++;
                }
                if(trimOffset<-12){
                    trimOffset=trimOffset+24;
                    UTC.time.second--;  //with increment above, second should never go below 0
                }
            }
        }
        UTC=fixTOD(UTC);        //do this in ISR for atomicity
        if(cdTimerRunning){
            cdDone=countDowncdTimer();
        }
        if(swRunning){
            swTimer.second++;
            while(swTimer.second>59){
                swTimer.second=swTimer.second-60;
                swTimer.minute=swTimer.minute+1;
            }
            while(swTimer.minute>59){
                swTimer.minute=swTimer.minute-60;
                swTimer.hour=swTimer.hour+1;                
            }
        }
        tFlag=1;
        modeHold++;
        if(gpsTimer){gpsTimer--;}        
        if(TX2IF){TX2REG=nextTone;}
    }
    uartISR();    
}
