#ifndef UTIL_H
#define	UTIL_H
//assorted helpers etc
#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"
#include "io.h"
#include "oled.h"
#include "arial.h"
#include "uart.h"
#include "gps.h"
#include "timedate.h"
#include "timezones.h"

#define BUTTON_REPEAT_DELAY (150)
#define SETTINGS_TIME (1)
#define TONE_PATTERN_COUNT 6
#define TRIM_HOURS_MAX 100

extern const char tonePatterns[TONE_PATTERN_COUNT];
extern const char toneNames[TONE_PATTERN_COUNT][11];

typedef enum{
    SETTINGS_START=-1,
    SETTINGS_OFF=0,
    SETTINGS_DISPLAY,
    SETTINGS_GPS,
    SETTINGS_TONES,
    SETTINGS_CUSTTZ,
    SETTINGS_EXIT,
    SETTINGS_DUMMY            
} settingsMode_t;

extern const char settingName[][8];
extern const char tzSettingNames[][14];

typedef enum {
    CLOCK=0,
    TIMER,
    STOPWATCH,
    ALARM,
    MODE_DUMMY
} screenMode_t;

typedef enum{
    CLOCK_12=0,
    CLOCK_24=1
} clock24_t;

typedef enum{
    CD_TIME=0,
    CD_SETH,
    CD_SETM,
    CD_SETS,
    CD_DUMMY
} cdMode_t;

typedef enum{
    TZSET_HOME,
    TZSET_OFFSET,            
    TZSET_DST_TRUE,
    TZSET_START_M,
    TZSET_START_D,
    TZSET_END_M,
    TZSET_END_D,
    TZSET_DUMMY
} tzSet_t;

extern unsigned char tFlag;
extern calDate_t dDisp;        //for display
extern timeAndDate_t UTC;
extern timeAndDate_t local;
extern unsigned char gpsOK,gpsOn;
extern unsigned char gpsTimer;
extern timeOfDay_t swTimer;        //stopwatch
extern char swRunning;
extern timeOfDay_t cdTimer;
extern char cdTimerRunning;
extern char cdDone;
extern cdMode_t cdMode;
extern screenMode_t mode;
extern char modeHold;
extern settingsMode_t settingsMode;
extern const char* currentFont;
extern char alarmSounding;
extern timeZone_t currentTZ;
extern tzDST_t currentDST;
extern char subSetIndex;
extern unsigned int vcc;
extern char gpsActive;
extern char progDisp[4];
extern char gpsUpdateNeeded;
extern signed char tzOffset;       //in 15 minute blocks, used wherever needed

//for EEPROM:
extern __eeprom timeOfDay_t cdPreset;
extern __eeprom clock24_t clock24;
extern __eeprom char currentFontN;
extern __eeprom char tzIndex;
extern __eeprom char gpsTimeout;
extern __eeprom alarmU_t alarm;
extern __eeprom char alarmToneIndex;
extern __eeprom char cdToneIndex;
extern char alarmTone;
extern char cdTone;
extern char toneOn;
extern char nextTone;
extern char testToneIndex;
extern unsigned char tgtOLEDb;

//home settings for clock/alarm
extern __eeprom char homeTZindex;
extern timeZone_t homeTZ;
extern tzDST_t homeDST;
extern timeAndDate_t home;

//for clock trim
extern __eeprom signed char trimSecondsEEPROM; //seconds+- needed to trim per day
extern signed char trimSeconds; //seconds+- needed to trim per day, need copy in RAM to work in ISR
extern timeAndDate_t tempUTC;            //temp for calculations
extern signed char trimOffset;           //to work out whether to trim
extern char hoursAdjust;                 //hours since last adjust

void updateTrim(void);  //check drift and update trimSeconds
void loadTZfromIndex(void); //this is repeated in a few  places
void demoTone(unsigned char c);//play a single sample
void setTone(char c);      //enable tone generator
void cdTimerSetDisp(void);  //used in a few places, so set up as function
void doSleep(void);     //sleep and wake on interrupt (inc IOC on buttons)
void doGPS(void);       //feed GPS and use time if valid; check gpsOK
void OLEDset(char s);   //turn on/off OLED
void MOD2set(char s);   //turn on/off inc UART
char downClick(void);   //check and wait for release
char upClick(void);     //check and wait for release
char okClick(void);     //check and wait for release
void gpsAsync(void);    //start GPS module in background
void processGPSasync(void);
void gpsCheck(void);    //startup check
void lzBlank(unsigned char *d);  //assumed to be dbuf[10]
void tzScan(signed char tzo);   //convert TZ offset to UTC+-xx:xx for display
void setCustTZday(DSTevent_t* e); //wrapper because this is repeated in a few spots
void setCustTZmonth(DSTevent_t* e); //wrapper because this is repeated in a few spots
void screenOff(void);   //and wait for button press to resume
void checkAlarm(void);      //check if alarm needs to be sounded

#endif	/* UTIL_H */

