#include "io.h"

unsigned int adcref,dacref;

void initTone(void){
    //PWM1S1 for speaker tone
    PWM1CON=0;          //reset
    PWM1ERS=0;
    //PWM1CLK=2;          //FOSC (FOSC/4 not available)
    PWM1CLK=7;          //SOSC at 32768Hz
    PWM1LDS=0;
    PWM1PR=36;          //short period
    PWM1CPRE=0;         //no prescale
    PWM1S1CFG=0;        //left aligned, normal polarity
    PWM1S1P1=18;        //duty
    PWM1GIE=0;          //no ints    
    PWM1CONbits.LD=1;   //load
    PWM1CONbits.EN=1;   //on    
    //CLC to combine as pattern with another peripheral
    CLCSELECT=0;    //use CLC1
    //CLCSELECT=1;    //use CLC2
    CLCnCON=0;  //off, no interrupts, AND-OR
    CLCnCONbits.MODE=2; //4-in AND
    CLCnPOL=0xF;  //
    CLCnGLS0=0x55;  //and,no inversions
    CLCnGLS1=0x55;  //and,no inversions
    CLCnGLS2=0x55;  //and,no inversions
    CLCnGLS3=0x55;  //and,no inversions
    CLCnSEL0=22; //PWM1S1P1_OUT
    CLCnSEL1=22; //PWM1S1P1_OUT
    CLCnSEL2=22; //PWM1S1P1_OUT
    //CLCnSEL3=22; //PWM1S1P1_OUT
    CLCnSEL3=40; //TX2
    CLCnCONbits.EN=1;
    //UART TX for pattern sending
    TX2STA=0;           //reset, async mode
    TX2STAbits.TXEN=1;  //TX on
    RC2STAbits.SPEN=1;  //enable serial port
    //BAUD/COMMON
    BAUD2CON=0x18;         //16bit BRG, low speed, idle low
    SP2BRG=65535;           //lowest baudrate, about 32baud
    //will now output if data fed to TX2REG
}

void deInitTone(void){
    TX2STA=0;           //reset, async mode
    RC2STAbits.SPEN=0;  //disable serial port
    PWM1CONbits.EN=0;   //off
    CLCSELECT=0;    //use CLC1
    CLCnCONbits.EN=0;   //off
}

void ioInit(void){
    unsigned char iflag;        //store INTCON
    adcref=readNVM(DIA_FVRA2X);
    dacref=readNVM(DIA_FVRC2X);
    anselbits.S1=0; //digital inputs with pullups
    anselbits.S2=0;
    anselbits.S3=0;
    anselbits.S4=0;
    trisbits.S1=1;
    trisbits.S2=1;
    trisbits.S3=1;
    trisbits.S4=1;
    wpubits.S1=1;
    wpubits.S2=1;
    wpubits.S3=1;
    wpubits.S4=1;
    anselbits.LDRSENSE=1;   //analog input    
    trisbits.MOD2PWR=0;     //keep off at boot
    anselbits.MOD2PWR=0;
    latbits.MOD2PWR=0;      //off for now, can release by setting TRIS hi
    anselbits.SPKR_P=0;
    trisbits.SPKR_P=0;
    latbits.SPKR_P=0;
    //PPS for speaker
    iflag=INTCON;               //save interrupt flags
    INTCONbits.GIE=0; //Suspend interrupts
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 0; //clear PPSLOCKED bit
    pps.SPKR_P=0x1;     //CLC1
    //pps.SPKR_P=0x16;    //TX2
    PPSLOCK = 0x55; //Required sequence
    PPSLOCK = 0xAA; //Required sequence
    PPSLOCKbits.PPSLOCKED = 1; //set PPSLOCKED bit           
    INTCON=iflag;               //restore interrupts    
}

void t0init(void){
    T0CON0=0;               //reset, 8-bit, 1:1
    T0CON1bits.CS=6;        //SOSC
    T0CON1bits.ASYNC=1;     //ASYNC
    T0CON1bits.T0CKPS=7;    //1:128
    TMR0H=255;              //full period
    T0CON0bits.EN=1;        //on
    PIR0bits.TMR0IF=0;      //clear
    PIE0bits.TMR0IE=1;      //enable
}

void initADC(void){
    ADCON0=0;           //reset ADC, single ended
    ADCON1=0;
    ADCON2=0;           //legacy mode
    ADCON3=0;
    ADPRE=0;
    ADACQ=0;
    ADCAP=0;            //extra capacitance
    ADCON0bits.CS=1;    //ADCRC
    ADCON0bits.ADFM0=1; //right justify
    ADCON2=0;           //legacy mode
    ADREF=0;            //VDD    
    ADCON0bits.ADON=1;  //turn on, ready
    //FVR
    FVRCONbits.ADFVR=2;    //2.048V nominal
    FVRCONbits.EN=1;        //on    
}

unsigned int getADC(char c){
    ADPCH=c;
    ADCON0bits.GO=1;
    while(ADCON0bits.GO){}    
    return ADRES;
}

unsigned int getVCC(void){  //in mV
    unsigned long r;
    r=getADC(FVRBUF1);
    if(r<(1000)){return 9000;}    //possible overflow/error
    return (unsigned int)(((unsigned long)adcref)*(4096UL)/r);
}

unsigned int readNVM(unsigned int add){ //maps top bit to NVMREGS
    NVMREGS=0;
    if(add&0x8000){NVMREGS=1;}
    NVMADR=add;
    NVMCON1bits.RD=1;   //start read
    return NVMDAT;    
}

unsigned int adjust(unsigned int v,unsigned int m){
    unsigned long t;
    t=((unsigned long)v) * ((unsigned long)m);
    t=t/(4096UL);
    return (unsigned int)t;
}
