
#ifndef GPS_H
#define	GPS_H

#include <xc.h> // include processor files - each processor file is guarded.  

#define GPS_FIELD_LEN 16
#define GPS_FIELD_COUNT 20
#define RMC_FIELD_COUNT 9
#define GPS_CXSUM_FIELD (GPS_FIELD_COUNT-1)

extern const char hex[];

typedef enum {
    GPS_OFF=0,
    GPS_BUSY=1,
    GPS_DATA_READY=2,
    GPS_ERROR=3,
    GPS_OVERFLOW=4,
    GPS_DATA_RECEIVED=5
} gps_state_t;

extern char gpsFields[GPS_FIELD_COUNT][GPS_FIELD_LEN];
extern char RMCFields[RMC_FIELD_COUNT][GPS_FIELD_LEN];
gps_state_t gpsState;
extern unsigned char bodyCxsum,endCxsum;
extern char satState;

void initGPS(void);     //reset all
void clearGPS(void);    //clear pointers/buffers etc
gps_state_t feedGPS(char c);   //supply data to GPS
unsigned char unhex(char c);    //turn hex digit into value
void parseSentence(void);   //extract data

#endif	/* GPS_H */

