#include "gps.h"

char gpsFields[GPS_FIELD_COUNT][GPS_FIELD_LEN];
char RMCFields[RMC_FIELD_COUNT][GPS_FIELD_LEN];
unsigned char fieldPtr,charPtr;
unsigned char bodyCxsum=0;
unsigned char endCxsum=0;
gps_state_t gpsState=GPS_OFF;
char satState=0;     //from GSA sentence
const char hex[]="0123456789ABCDEF";

void initGPS(void){
    clearGPS();
}

void clearGPS(void){
    unsigned int i;
    fieldPtr=0;
    charPtr=0;
    bodyCxsum=0;
    endCxsum=0;
    for(i=0;i<(GPS_FIELD_COUNT*GPS_FIELD_LEN);i++){
        gpsFields[0][i]=0;
    }
}

gps_state_t feedGPS(char c){
    if((c=='$')||(c==13)||(c==10)){
        fieldPtr=0;
        charPtr=0;
        bodyCxsum=0;
        if(c=='$'){     //start of packet
            if(gpsState==GPS_OFF){gpsState=GPS_BUSY;}
            if(gpsState==GPS_DATA_RECEIVED){gpsState=GPS_BUSY;}
        }
    }else{
        if(fieldPtr<GPS_CXSUM_FIELD){
            bodyCxsum=bodyCxsum^c;
        }
        if(c=='*'){
           fieldPtr=GPS_CXSUM_FIELD;
           charPtr=0;
        }else if(c==','){
            charPtr=0;
            fieldPtr=fieldPtr+1;
            if(fieldPtr>GPS_CXSUM_FIELD){fieldPtr=GPS_CXSUM_FIELD;}
        }else{
            if((c>=' ')&&(c<='~')){
                if(charPtr<(GPS_FIELD_LEN-2)){
                    gpsFields[fieldPtr][charPtr]=c;
                    charPtr=charPtr+1;
                    if(charPtr>(GPS_FIELD_LEN-2)){charPtr=GPS_FIELD_LEN-2;}
                }
                if(fieldPtr==GPS_CXSUM_FIELD){
                    if(charPtr==2){
                        endCxsum=(unsigned char)((unhex(gpsFields[GPS_CXSUM_FIELD][0])<<4)|unhex(gpsFields[GPS_CXSUM_FIELD][1]));
                        bodyCxsum=bodyCxsum^'*';    //since it is included but shouldn't be
                        if(endCxsum==bodyCxsum){                            
                            parseSentence();
                        }else{
                            gpsState=GPS_ERROR; //checksum error
                        }
                    }
                }
            }
        }        
    }
    return gpsState;
}

unsigned char unhex(char c){    //turn hex digit into value
    if((c>='0')&&(c<='9')){return c-'0';}
    if((c>='a')&&(c<='f')){return c+10-'a';}
    if((c>='A')&&(c<='F')){return c+10-'A';}
    return 0xFF;
}

void parseSentence(void){
    unsigned int i;
    if((gpsFields[0][2]=='R')&&(gpsFields[0][3]=='M')&&(gpsFields[0][4]=='C')){
        for(i=0;i<(RMC_FIELD_COUNT*GPS_FIELD_LEN);i++){
            RMCFields[0][i]=gpsFields[1][i];
        }
        clearGPS();
        if(gpsState==GPS_OVERFLOW){return;}     //still overflowed
        if(gpsState==GPS_DATA_READY){
            gpsState=GPS_OVERFLOW;
        }else{
            gpsState=GPS_DATA_READY;
        }
    }else if((gpsFields[0][2]=='G')&&(gpsFields[0][3]=='S')&&(gpsFields[0][4]=='A')){
        satState=gpsFields[2][0];   //mode 2 fix type, but WiFi GPS source reports this as status (3=time good, ie times LED flashes)
        clearGPS();
    }else{
        clearGPS();
    }
}