#include "util.h"

unsigned char tFlag=0;
calDate_t dDisp;        //for display
timeAndDate_t UTC={.serial=8402,.time.hour=0,.time.minute=0,.time.second=0};
timeAndDate_t local;
unsigned char gpsOK=0,gpsOn=0;
unsigned char gpsTimer=0;
timeOfDay_t swTimer;        //stopwatch
char swRunning=0;
timeOfDay_t cdTimer={.second=10};   //countdown
char cdTimerRunning=0;
char cdDone=0;
cdMode_t cdMode=CD_TIME;
screenMode_t mode=CLOCK;
char modeHold=0;
settingsMode_t settingsMode=SETTINGS_OFF;
const char* currentFont;        //load this via index at boot
char alarmSounding=0;
timeZone_t currentTZ;
tzDST_t currentDST;
char subSetIndex=0;
unsigned int vcc=0;
char gpsActive=0;
char progDisp[4]={'<','>','<','>'}; //simple animation
char gpsUpdateNeeded=0;
unsigned char tgtOLEDb=255;

//for EEPROM:
signed char tzOffset=44;       //in 15 minute blocks, used wherever needed
__eeprom timeOfDay_t cdPreset={.second=10};  //useful default
__eeprom clock24_t clock24=CLOCK_12;
__eeprom char currentFontN=0;
__eeprom char tzIndex=0;
__eeprom char gpsTimeout=60;
__eeprom alarmU_t alarm = {.a.on=0};
__eeprom char alarmToneIndex=0;
__eeprom char cdToneIndex=0;
char alarmTone=0;
char cdTone=0;
char toneOn=0;
char nextTone=0;
char testToneIndex=0;
//home settings for clock/alarm
__eeprom char homeTZindex=0;
timeZone_t homeTZ;
tzDST_t homeDST;
timeAndDate_t home;
//for clock trim
__eeprom signed char trimSecondsEEPROM=0; //seconds+- needed to trim per day
signed char trimSeconds=0; //seconds+- needed to trim per day, need copy in RAM to work in ISR
timeAndDate_t tempUTC;            //temp for calculations
signed char trimOffset=0;         //to work out whether to trim
char hoursAdjust=0;               //hours since last adjust

const char tonePatterns[TONE_PATTERN_COUNT]={
    0x00,   //solid, long
    //0xFE,   //single short
    0x08,   //two long
    0x1C,    //two short
    0x92,   //three
    0xD5,   //four
    0x55    //five
    //0x50,   //trill pattern (long, short, short)
};

const char toneNames[TONE_PATTERN_COUNT][11]={
    "ONE BEEP  ",
    //"ONE PIP   ",
    "TWO BEEPS ",
    "TWO PIPS  ",
    "THREE PIPS",
    "FOUR PIPS ",
    "FIVE PIPS "
    //"TRILL     ",
};

const char settingName[][8]={
    "       ",
    "DISPLAY",
    "GPS T/O",
    "TONES  ",
    "CUST TZ",
    "EXIT   "
};

const char tzSettingNames[][14]={
    "HOME TIMEZONE",
    "STD OFFSET   ",
    "USE DST?     ",
    "DST START MTH",
    "DST START DAY",
    "DST END MONTH",
    "DST END DAY  ",
};

void updateTrim(void){  //check drift and update trimSeconds
    unsigned char iflag;        //store INTCON, need to keep value of UTC atomic
    int t1,t2,trim;
    if(hoursAdjust>=TRIM_HOURS_MAX){hoursAdjust=0;return;}  //got a good fix, can look at adjusting trim again
    if(hoursAdjust>19){             //only update if there's about a day of monitoring
        iflag=INTCON;               //save interrupt flags
        INTCONbits.GIE=0;           //Suspend interrupts
        if(tempUTC.serial==UTC.serial){         //only adjust trim 
            if(tempUTC.time.hour==UTC.time.hour){   //if times are already close
                t1=tempUTC.time.minute*60+tempUTC.time.second;  
                t2=UTC.time.minute*60+UTC.time.second;  
                trim=t1-t2;                
                if((trim>-25)&&(trim<25)){
                    trim=(trim*20)/hoursAdjust; //scale to hours, use 20 instead of 24 to avoid overshoot
                    trimSeconds=trimSeconds+trim; 
                    if(trimSeconds<-24){trimSeconds=-24;}   //algorithm won't work with >24 or <-24
                    if(trimSeconds>24){trimSeconds=24;}
                    trimSecondsEEPROM=trimSeconds;  //save to EEPROM
                }              
            }
        }
        hoursAdjust=0;                  //reset        
        INTCON=iflag;                   //restore interrupts    
    }
}

void loadTZfromIndex(void){ //this is repeated in a few  places
    if(timeZones[tzIndex].offset==CUSTOM_TZ){
        currentTZ=customZone;
    }else{
        currentTZ=timeZones[tzIndex];
    }                                                    
    if(currentTZ.dst){currentDST=*currentTZ.dst;}    
}

void demoTone(unsigned char c){//play a single sample    
    if(TX2IF){
        TX2REG=c;
        __delay_ms(500);
    }
}

void setTone(char c){   //enable tone generator
    if(c){
        if(toneOn==0){
            toneOn=1;
            initTone();
        }
    }else{
        if(toneOn){
            toneOn=0;
            deInitTone();            
        }
    }
}

void cdTimerSetDisp(void){
    col=0;
    page=0;
    if(cdMode==CD_SETH){
        OLEDchararray("SET HOUR     ",arial);                                                        
    }else if(cdMode==CD_SETM){
        OLEDchararray("SET MINUTE   ",arial);                                                        
    }else if(cdMode==CD_SETS){
        OLEDchararray("SET SECOND   ",arial);                                                        
    }
    col=0;
    page=2;
    OLEDscanshort(cdPreset.hour);
    if(cdMode==CD_SETH){
        OLEDcharRev(dbuf[8],currentFont);
        OLEDcharRev(dbuf[9],currentFont);                                        
    }else{
        OLEDchar(dbuf[8],currentFont);
        OLEDchar(dbuf[9],currentFont);                                                        
    }
    OLEDbitmap(colonBM);
    OLEDscanshort(cdPreset.minute);
    if(cdMode==CD_SETM){
        OLEDcharRev(dbuf[8],currentFont);
        OLEDcharRev(dbuf[9],currentFont);                                        
    }else{
        OLEDchar(dbuf[8],currentFont);
        OLEDchar(dbuf[9],currentFont);                                                        
    }
    OLEDbitmap(colonBM);
    OLEDscanshort(cdPreset.second);
    if(cdMode==CD_SETS){
        OLEDcharRev(dbuf[8],currentFont);
        OLEDcharRev(dbuf[9],currentFont);                                        
    }else{
        OLEDchar(dbuf[8],currentFont);
        OLEDchar(dbuf[9],currentFont);                                                        
    }
}

void doSleep(void){     //sleep and wake on interrupt (inc IOC on buttons)
    //IOC:        
    //GIE=0;
    iocxfbits.S1=0;
    iocxfbits.S2=0;
    iocxfbits.S3=0;
    iocxfbits.S4=0;
    iocxpbits.S1=1;
    iocxpbits.S2=1;
    iocxpbits.S3=1;
    iocxpbits.S4=1;
    iocxnbits.S1=1;
    iocxnbits.S2=1;
    iocxnbits.S3=1;
    iocxnbits.S4=1;
    PIE0bits.IOCIE=1;
    //SLEEP();      //silicon errata => SLEEP is not to be used
    CPUDOZE=SLEEP_DOZE;
    while(CPUDOZEbits.DOZEN){  //this is cleared by an interrupt occurring    
        if(alarm.a.on){ //only check if alarm active
            tzOffset=getOffset(UTC,homeTZ,homeDST);
            home=fixTZoffset(UTC,tzOffset);
            checkAlarm();
        }
        //check timer
        if(gpsUpdateNeeded){    //react to flag
            gpsUpdateNeeded=0;
            gpsAsync();
        }
    }
}

void doGPS(void){
    while(uartAvailable()){
        feedGPS(uartReceive());
        if(gpsState==GPS_DATA_READY){
            gpsState=GPS_DATA_RECEIVED;
            if(RMCFields[1][0]=='A'){
                gpsOK=1;
                tempUTC.time=timeFromGPS(&RMCFields[0][0]);
                tempUTC.serial=getSerial(datefromGPS(&RMCFields[8][0]));
                updateTrim();                
                UTC=tempUTC;   //update             
            }                
        }
    }    
}

void OLEDset(char s){
    if(s){
        I2Cinit();
        OLEDinit();  
        OLEDflip(OLED_CONNECTOR_AT_TOP);
        OLEDclear(0);
    }else{
        OLEDsendCommand(0xAE);  //display off
        I2Cdeinit();        
    }    
}

void MOD2set(char s){
    if(s){    
        trisbits.MOD2PWR=1;
        uartInit(BRG_9600);
        initGPS();
    }else{
        trisbits.MOD2PWR=0; //force 3V3EN off
        uartDeInit();
    }
}

char downClick(void){
    if(PRESSED(DOWN_BUTTON)){
        while(PRESSED(DOWN_BUTTON)){}
        __delay_ms(10); //debouncing
        return 1;
    }
    return 0;    
}

char upClick(void){
    if(PRESSED(UP_BUTTON)){
        while(PRESSED(UP_BUTTON)){}
        __delay_ms(10); //debouncing
        return 1;
    }
    return 0;    
}

char okClick(void){
    if(PRESSED(OK_BUTTON)){
        while(PRESSED(OK_BUTTON)){}
        __delay_ms(10); //debouncing
        return 1;
    }
    return 0;    
}

void gpsAsync(void){    //start GPS module in background    
    if(gpsActive){      //just reset timer if already on
        gpsTimer=gpsTimeout;
    }else{
        gpsActive=1;
        gpsTimer=gpsTimeout;
        MOD2set(1);        
        gpsOK=0;        
    }
}

void gpsAbort(void){    //cancel
    if(gpsActive){      //do nothing if off already
        MOD2set(0);
        if(gpsTimer>2){gpsTimer=2;}    
        gpsActive=0;
    }
}

void processGPSasync(void){
    if(gpsTimer){
        doGPS();
        if(gpsOK){gpsAbort();}  //shutdown if successful              
    }else{
        if(gpsActive==1){    //check flag
            MOD2set(0);
            gpsActive=0;
        }
    }    
}

void gpsCheck(void){    //manual check using async helpers
    gpsAsync();
    col=0;
    page=0;
    OLEDchararray("CHECKING GPS",arial);                                                        
    col=0;
    page=7;
    OLEDchararray("<OK> TO CANCEL",smallFont);                                                            
    while(gpsTimer){
        processGPSasync();
        if(gpsOK){  //gives us time to see the message
            col=0;
            page=7;
            OLEDchararray("TIME UPDATED  ",smallFont);                                                                    
        }
        if(okClick()){
            gpsAbort();
        }
        col=84;
        page=4;
        OLEDscanshort(gpsTimer);
        lzBlank(dbuf);
        OLEDchar(dbuf[7],arial);
        OLEDchar(dbuf[8],arial);
        OLEDchar(dbuf[9],arial);     
        page=5;
        OLEDchar('S',smallFont);     
        col=0;
        page=3;
        switch(satState){
            case '1': OLEDchararray("NO LOCK",arial); break;     
            case '2':
            case '3': OLEDchararray("LOCK OK",arial); break;                     
            default:  OLEDchararray("NO DATA",arial); break;                     
        }
    }    
    OLEDclear(0);    
}

void lzBlank(unsigned char *d){      //assumed to be dbuf[10]
    char n=0;
    while(n<9){ //don't do last position
        if(d[n]=='0'){
            d[n]=' ';
            n=n+1;            
        }else{
            return;
        }
    }    
}

void tzScan(signed char tzo){   //convert TZ offset to UTC+-xx:xx for display
    char t;
    char h1,h2; //temp for hours
    t=(char)abs(tzo);
    OLEDscanshort(t>>2);
    h1=dbuf[8];
    h2=dbuf[9];
    OLEDscanshort((t&3)*15);    //minutes now in [8..9]
    dbuf[5]=h1;
    dbuf[6]=h2;
    dbuf[7]=':';
    if(tzo==0){
            dbuf[4]=' ';
    }else if(tzo>0){
            dbuf[4]='+';
    }else{
            dbuf[4]='-';
    }                            
    //now in dbuf[4..9], print with &dbuf[4]
}

void setCustTZday(DSTevent_t* e){ //wrapper because this is repeated in a few spots
    if(e->date.date<8){
        OLEDchararray(" FIRST ",arial);
        if(upClick()){e->date.date=8;} //move to second
    }else if(e->date.date<15){
        OLEDchararray("SECOND ",arial);
        if(downClick()){e->date.date=1;} //move to first
        if(upClick()){e->date.date=15;} //move to third
    }else if(e->date.date<22){
        OLEDchararray(" THIRD ",arial);
        if(downClick()){e->date.date=8;} //move to second
        if(upClick()){e->date.date=daysInMonth[e->date.month]-6;} //move to last
    }else{
        OLEDchararray("  LAST ",arial);
        if(downClick()){e->date.date=15;} //move to third
    }
    OLEDchararray(daysOfWeek[e->day],arial);
    OLEDchararray("   ",arial);                                
}

void setCustTZmonth(DSTevent_t* e){ //wrapper because this is repeated in a few spots
    OLEDchararray(monthsOfYear[e->date.month],arial);
    OLEDchararray("          ",arial);
    if(upClick()){
        if(e->date.month<11){
            e->date.month=e->date.month+1;
        }
    }
    if(downClick()){
        if(e->date.month>0){
            e->date.month=e->date.month-1;
        }
    }    
}

void screenOff(void){   //and wait for button press to resume
    __delay_ms(300);
    //everything off
    OLEDset(0);      
    while((okClick()==0)&&(alarmSounding==0)&&(cdDone==0)){       //wake up on alarm
        doSleep();  //checks timers and alarms
        if(gpsActive){processGPSasync();}        
    }
    if(cdDone){mode=TIMER;}         //jump into a useful mode
    if(alarmSounding){mode=CLOCK;}
    //resume
    OLEDset(1);
    
}

void checkAlarm(void){      //check if alarm needs to be sounded
    if(alarmSounding){return;}   //don't bother if already sounding
    dDisp=getYMD(home.serial);                
    if(home.time.hour==alarm.a.time.hour){  //hour matches
        if(home.time.minute==alarm.a.time.minute){ //minutes matches
            if(home.time.second<6){        //to avoid retriggering
                if(alarm.c[dDisp.day]){                 //day matches and is set
                    alarmSounding=1;
                    tzIndex=homeTZindex;        //show home zone on alarm
                    loadTZfromIndex();
                    if(alarm.a.repeat==0){
                        alarm.c[dDisp.day]=0;       //clear day if repeat not set
                    }
                }
            }
        }
    }
}