//period in seconds, less than ~10s is too fast
#define PERIOD 60

//use this one if you want it to go anticlockwise instead
//#define ANTICLOCKWISE
#define CLOCKWISE

//set this to 1 to allowing free-running at power on
char isRunning=0;

//this depends on the motor
#define STEPS 2048
unsigned long p=(PERIOD*1000000L)/STEPS;
char ph=0;

#define PH1 2
#define PH2 3
#define PH3 4
#define PH4 5

#define BUTTON_START 8
#define BUTTON_STOP 9
#define BUTTON_RESET 10
#define BUTTON_TRIM_PLUS 11
#define BUTTON_TRIM_MINUS 12
#define MINIMUM_DELAY 2000
#define TRIM_DELAY 10000
#define RAMP_STEPS 8

unsigned long us0=0;    //zero offset for micros()
unsigned int pos=0;     //keep track for resetting

void setup() {
  pinMode(PH1,OUTPUT);
  pinMode(PH2,OUTPUT);
  pinMode(PH3,OUTPUT);
  pinMode(PH4,OUTPUT);
  setOff();
  pinMode(BUTTON_START,INPUT_PULLUP);
  pinMode(BUTTON_STOP,INPUT_PULLUP);
  pinMode(BUTTON_RESET,INPUT_PULLUP);
  pinMode(BUTTON_TRIM_PLUS,INPUT_PULLUP);
  pinMode(BUTTON_TRIM_MINUS,INPUT_PULLUP);
}

void loop() {  
  unsigned long t;
  unsigned int r;
  if((digitalRead(BUTTON_START)==0)&&(isRunning==0)){
    isRunning=1;
    us0=micros();
  }
  if((digitalRead(BUTTON_STOP)==0)){
    isRunning=0;
    setOff();   //power down
  }
  if((digitalRead(BUTTON_RESET)==0)&&(isRunning==0)){   //staged rewind to allow acceleration
    r=RAMP_STEPS;
    while((pos>0)&&(r>0)){  
      delayMicroseconds(TRIM_DELAY);     
      setSeq(ph);
      ph=(ph+3)%4;  //same as -1
      pos--;      
      r--;
    }
    while(pos>RAMP_STEPS){
      delayMicroseconds(MINIMUM_DELAY);     
      setSeq(ph);
      ph=(ph+3)%4;  //same as -1
      pos--;      
    }
    while(pos>0){
      delayMicroseconds(TRIM_DELAY);     
      setSeq(ph);
      ph=(ph+3)%4;  //same as -1
      pos--;      
    }
    ph=0;
    setOff();
  }
  if(isRunning==0){ //if stopped
    while(digitalRead(BUTTON_TRIM_MINUS)==0){
      delayMicroseconds(TRIM_DELAY);     
      setSeq(ph);
      ph=(ph+3)%4;  //same as -1
      pos=0;        //since we're trying to reset
    }
    while(digitalRead(BUTTON_TRIM_PLUS)==0){
      delayMicroseconds(TRIM_DELAY);     
      setSeq(ph);
      ph=(ph+1)%4;
      pos=0;        //since we're trying to reset
    }
    setOff();
  }
  if(isRunning){
    t=micros()-us0;
    if(t>p){    
      us0=us0+p;
      ph=(ph+1)%4;
      pos=(pos+1)%STEPS;
      setSeq(ph);
    }
  }
}

void setSeq(int n){
#ifdef ANTICLOCKWISE  
  if(n==0){digitalWrite(PH1,HIGH);}else{digitalWrite(PH1,LOW);}
  if(n==1){digitalWrite(PH2,HIGH);}else{digitalWrite(PH2,LOW);}
  if(n==2){digitalWrite(PH3,HIGH);}else{digitalWrite(PH3,LOW);}
  if(n==3){digitalWrite(PH4,HIGH);}else{digitalWrite(PH4,LOW);}
#else
  if(n==0){digitalWrite(PH1,HIGH);}else{digitalWrite(PH1,LOW);}
  if(n==1){digitalWrite(PH4,HIGH);}else{digitalWrite(PH4,LOW);}
  if(n==2){digitalWrite(PH3,HIGH);}else{digitalWrite(PH3,LOW);}
  if(n==3){digitalWrite(PH2,HIGH);}else{digitalWrite(PH2,LOW);}
#endif
}

void setOff(void){
  digitalWrite(PH1,LOW);  
  digitalWrite(PH2,LOW);  
  digitalWrite(PH3,LOW);  
  digitalWrite(PH4,LOW);  
}