/*
 * File:   io.h
 * Author: Tim Blythman
 * Demo code for ATtiny816 on breakout board
 * Some simple digital IO APIs
 * Created on 15 October 2018, 10:29 AM
 */

#ifndef ATTINY_IO_H
#define	ATTINY_IO_H

#include <xc.h> // include processor files - each processor file is guarded.  

//handy defines for port <-> analog mux mapping
#define ANALOG_PORTA0 0
#define ANALOG_PORTA1 1
#define ANALOG_PORTA2 2
#define ANALOG_PORTA3 3
#define ANALOG_PORTA4 4
#define ANALOG_PORTA5 5
#define ANALOG_PORTA6 6
#define ANALOG_PORTA7 7
#define ANALOG_PORTB5 8
#define ANALOG_PORTB4 9
#define ANALOG_PORTB1 10
#define ANALOG_PORTB0 11
#define ANALOG_TEMP 0x1E
#define ANALOG_GND 0x1F

//arduino like defines
#define INPUT 0
#define OUTPUT 1
#define HIGH 1
#define LOW 0

void setDir(PORT_t* port, unsigned char bt, unsigned char v);       //set port.bt as input/output
void setPin(PORT_t* port, unsigned char bt, unsigned char v);       //set port.bt to v
unsigned char getPin(PORT_t* port, unsigned char bt);               //read back port.bt
void setPullup(PORT_t* port, unsigned char bt, unsigned char v);    //set pullup on port.bt to v
int getADC(unsigned char chan);                                     //get value on ADC channel
PORT_t* getPortFromAnalog(unsigned char chan);                      //get port from analog channel
unsigned char getBitFromAnalog(unsigned char chan);                 //get bit from analog channel

#endif	/* ATTINY_IO_H */

